/* darkstat 3
 * copyright (c) 2006, 2007 Emil Mikulic.
 *
 * graph.js: graph renderer
 *
 * You may use, modify and redistribute this file under the terms of the
 * GNU General Public License version 2. (see COPYING.GPL)
 *
 * ---------------------------------------------------------------------
 * In my testing, this script worked correctly in:
 *  - Firefox 1.5.0.4, 2.0.0.1
 *  - IE 6.0
 *  - Opera 8.53
 */

/* need:
 *  - graph_width
 *  - graph_height
 *  - bar_gap
 *
 *  - graphs [ {id, name, title} ]
 *  - graphs_uri
 *
 *  - window.onload = graph_loader
 *
 * in CSS:
 *  - div.graph
 *  - div.graph div.bar_in
 *  - div.graph div.bar_out
 *  - div.graphtitle
 */

function killChildren(elem) {
 while (elem.childNodes.length > 0)
  elem.removeChild( elem.childNodes.item(0) );
}

function thousands(n) {
 var s = String(n);
 var out = "";
 while (s.length > 3) {
  out = "," + s.substr(-3) + out;
  s = s.substr(0, s.length - 3);
 }
 return s+out;
}

var xh;

function graph_loader() {
 for (var i=0; i<graphs.length; i++) {
  graphs[i].graph = document.getElementById( graphs[i].id );
  killChildren(graphs[i].graph);
  graphs[i].graph.appendChild(
   document.createTextNode("Loading..."));
 }

 /* create buttons */
 var b_reload = document.createElement("a");
 b_reload.setAttribute("id", "graph_reload");
 b_reload.setAttribute("href", "javascript:graph_reload()");
 b_reload.appendChild(
  document.createTextNode("reload graphs"));
 document.getElementById("graph_buttons").appendChild(b_reload);

 graph_reload();
}

function graph_reload() {
 document.getElementById("graph_reload").innerHTML = "loading...";
 xh = (window.ActiveXObject)
  ? new ActiveXObject("Microsoft.XMLHTTP")
  : new XMLHttpRequest();
 var asyncFlag = true;
 xh.open("GET", graphs_uri, asyncFlag);
 // try to nerf caching:
 xh.setRequestHeader("If-Modified-Since", "Sat, 1 Jan 2000 00:00:00 GMT");
 xh.onreadystatechange = poll;
 xh.send(null);
}

function poll() {
 var STATE_COMPLETE = 4;
 if (xh && xh.readyState == STATE_COMPLETE) {
  for (var i=0; i<graphs.length; i++)
  {
   g = xh.responseXML.getElementsByTagName(graphs[i].name);
   buildGraph(graphs[i].graph, graphs[i].title,
    g[0].getElementsByTagName("e"));
  }
  document.getElementById("graph_reload").innerHTML = "reload graphs";
  head = xh.responseXML.childNodes[0];
  document.getElementById("tb").innerHTML = head.getAttribute("tb");
  document.getElementById("tp").innerHTML = head.getAttribute("tp");
  document.getElementById("rf").innerHTML = head.getAttribute("rf");
 }
}

function addBar(graph, title, barclass, width, height, left, bottom) {
 if (height == 0) return; /* not visible */
 var bar = document.createElement("div");
 bar.setAttribute("title", title);
 bar.setAttribute("class", barclass);
 bar.setAttribute("className", barclass); //IE
 bar.style.cssText =
  "width:"+width+"px; "+
  "height:"+height+"px; "+
  "position: absolute; "+
  "left:"+left+"px; "+
  "bottom:"+bottom+"px;";
 bar.setAttribute("style", bar.style.cssText);
 graph.appendChild(bar);
}

function buildGraph(graph, title, elems) {
 var total_max = 0;
 var data = []; /* list of [in, out] */
 for (var i=0; i<elems.length; i++) {
   var elem = elems.item(i);
   var b_pos = Number( elem.getAttribute("p") );
   var b_in = Number( elem.getAttribute("i") );
   var b_out = Number( elem.getAttribute("o") );
   var b_total = b_in + b_out;
/* FIXME: what happens when a bar's value is >4G? */
   if (b_total > total_max)
    total_max = b_total;
   data.push( [b_pos, b_in, b_out] );
 }

 var igraph = document.createElement("div"); // inner graph
 igraph.setAttribute("class", "graph");
 igraph.setAttribute("className", "graph"); //IE
 igraph.style.cssText =
  "width:"+graph_width+"px; "+
  "height:"+graph_height+"px; "+
  "position:relative;";
 igraph.setAttribute("style", igraph.style.cssText);

 var nbars = data.length;
 var b_width = (graph_width - bar_gap * (nbars-1)) / nbars;
 var next_xofs = 0;

 for (var i=0; i<nbars; i++) {
  var b_p = data[i][0];
  var b_i = data[i][1];
  var b_o = data[i][2];

  var xofs = next_xofs;

  next_xofs = Math.round((b_width + bar_gap) * (i+1));
  var curr_w = next_xofs - xofs - bar_gap;

  var h_i = Math.round( b_i * graph_height / total_max );
  var h_o = Math.round( b_o * graph_height / total_max );

  var label = b_p+": "+thousands(b_i)+" bytes in, "+
   thousands(b_o)+" bytes out";
  addBar(igraph, label, "bar_in", curr_w, h_i, xofs, 0);
  addBar(igraph, label, "bar_out", curr_w, h_o, xofs, h_i);
 }

 var gtitle = document.createElement("div");
 gtitle.setAttribute("class", "graphtitle");
 gtitle.setAttribute("className", "graphtitle"); //IE
 gtitle.style.cssText =
  "width:"+graph_width+"px;";
 gtitle.setAttribute("style", gtitle.style.cssText);
 gtitle.appendChild(document.createTextNode(title));

 killChildren(graph);
 graph.appendChild(igraph);
 graph.appendChild(gtitle);
}
