/* darkstat 3
 * copyright (c) 2001-2006 Emil Mikulic.
 *
 * hosts_db.h: database of hosts, ports, protocols.
 *
 * You may use, modify and redistribute this file under the terms of the
 * GNU General Public License version 2. (see COPYING.GPL)
 */

#include <sys/types.h>
#include <netinet/in.h>
#include "str.h"

struct hashtable;

struct host {
   in_addr_t ip;
   char *dns;
   struct hashtable *ports_tcp, *ports_udp, *ip_protos;
};

struct port_tcp {
   uint16_t port;
   uint64_t syn;
};

struct port_udp {
   uint16_t port;
};

struct ip_proto {
   uint16_t proto;
};

struct bucket {
   struct bucket *next;
   uint64_t in, out, total;
   union {
      struct host host;
      struct port_tcp port_tcp;
      struct port_udp port_udp;
      struct ip_proto ip_proto;
   } u;
};

enum sort_dir { IN, OUT, TOTAL };

void hosts_db_init(void);
void hosts_db_reduce(void);
void hosts_db_free(void);

struct bucket *host_find(const in_addr_t ip); /* can return NULL */
struct bucket *host_get(const in_addr_t ip);
struct bucket *host_get_port_tcp(struct bucket *host, const uint16_t port);
struct bucket *host_get_port_udp(struct bucket *host, const uint16_t port);
struct bucket *host_get_ip_proto(struct bucket *host, const uint16_t proto);

/* Web pages. */
struct str *html_hosts(const char *uri);

/* From hosts_sort */
void qsort_buckets(const struct bucket **a, size_t n,
   size_t left, size_t right, const enum sort_dir d);

/* vim:set ts=3 sw=3 tw=78 expandtab: */
