/* darkstat 3
 * copyright (c) 2001-2006 Emil Mikulic.
 *
 * err.c: BSD-like err() and warn() functions
 *
 * Permission to use, copy, modify, and distribute this file for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include "err.h"

#ifndef HAVE_ERR_H
#include <errno.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void
err(const int code, const char *format, ...)
{
   va_list va;

   fprintf(stderr, "error: ");
   va_start(va, format);
   vfprintf(stderr, format, va);
   va_end(va);
   fprintf(stderr, ": %s\n", strerror(errno));
   exit(code);
}

void
errx(const int code, const char *format, ...)
{
   va_list va;

   fprintf(stderr, "error: ");
   va_start(va, format);
   vfprintf(stderr, format, va);
   va_end(va);
   fprintf(stderr, "\n");
   exit(code);
}

void
warn(const char *format, ...)
{
   va_list va;

   fprintf(stderr, "warning: ");
   va_start(va, format);
   vfprintf(stderr, format, va);
   va_end(va);
   fprintf(stderr, ": %s\n", strerror(errno));
}

void
warnx(const char *format, ...)
{
   va_list va;

   fprintf(stderr, "warning: ");
   va_start(va, format);
   vfprintf(stderr, format, va);
   va_end(va);
   fprintf(stderr, "\n");
}

#endif /* HAVE_ERR_H */

/* vim:set ts=3 sw=3 tw=78 expandtab: */
