#!/usr/bin/env perl

# Some tests for 'darcs tag' 

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use strict;
use warnings;

init_tmp_repo();
touch 'one';
darcs 'add one';
darcs "record --patch-name 'uno' --all ";
my $tag_out = darcs "tag  soup";
unlike($tag_out, qr/failed/i, 'tagging with tag name on the command line avoids failure');
like($tag_out, qr/TAG/,      'tagging reports success with TAG');

my $changes_out = darcs 'changes --last 1';

like($changes_out,qr/tagged/, 'tagging includes "tagged" in tag name.');
