#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>
#include "umask.h"

int
set_umask(char *mask_string)
{
    int rc;
    unsigned mask;
    char *end;

    mask = strtoul(mask_string, &end, 8);
    if(!end || *end != '\0') {
        errno = EINVAL;
        return -1;
    }

    rc = umask(mask);
    return rc;
}

int
reset_umask(int old_mask)
{
    umask(old_mask);
    return 1;
}
