% Various utility functions for building a graphical interface

\begin{code}
module GuiUtils where
#ifdef HAVEWX

import Data.Bits ((.|.))

import Graphics.UI.WX hiding ( when, text )
import Graphics.UI.WXCore hiding ( when )

import Patch ( Patch )
\end{code}

\begin{code}
type PatchViewer = TreeCtrl ()

-- | Displays a list of patches.  The current implementation is to 
-- display them as a tree of widgets
patchViewer :: Window a  -- ^ parent window
            -> IO PatchViewer 
patchViewer f =
 do t   <- treeCtrl f [ style :~ (.|.) (wxTR_HIDE_ROOT .|. wxTR_EXTENDED) ]
    top <- treeCtrlAddRoot t "" (-1) (-1) objectNull
    treeCtrlExpand t top
    return t

-- | Make a tree widget show a completely different set of patches. 
updatePatchViewer :: PatchViewer 
                  -> [Patch]
                  -> IO ()
updatePatchViewer t patches =
 do top <- treeCtrlGetRootItem t
    treeCtrlDeleteChildren t top
    mapM (appendToPatchViewer t) patches
    return ()

appendToPatchViewer :: PatchViewer 
                    -> Patch       
                    -> IO ()
appendToPatchViewer t patch =
 do top <- treeCtrlGetRootItem t
    let miniTxt = (head.lines.show) patch
        fullTxt = show patch
    node <- treeCtrlAppendItem t top miniTxt (-1) (-1) objectNull
    -- FIXME: what I really what is to have tree nodes which span
    -- multiple lines; our hacky workaround is to add each line of
    -- the patch as a tree node.
    let appLine l = treeCtrlAppendItem t node l (-1) (-1) objectNull
    mapM appLine $ tail $ lines fullTxt
    return ()
#endif
\end{code}

