#!/usr/bin/env perl

# Some tests for 'darcs printer (the output formating)'

use lib qw(lib/perl);

use Test::More qw/no_plan/;

use Test::Darcs;
use Shell::Command;

use strict;

rm_rf  'temp1';
mkpath 'temp1';
chdir  'temp1';
darcs 'init';

touch 'a';
darcs 'add a';
darcs 'rec -a -A a -m add';


# clear all output formating environment variables

delete $ENV{DARCS_DONT_ESCAPE_ANYTHING};
delete $ENV{DARCS_DONT_ESCAPE_ISPRINT};
delete $ENV{DARCS_USE_ISPRINT};
delete $ENV{DARCS_DONT_ESCAPE_8BIT};
delete $ENV{DARCS_DONT_ESCAPE_EXTRA};
delete $ENV{DARCS_ESCAPE_EXTRA};
delete $ENV{DARCS_DONT_ESCAPE_TRAILING_SPACES};
delete $ENV{DARCS_DONT_COLOR};
delete $ENV{DARCS_ALWAYS_COLOR};
delete $ENV{DARCS_ALTERNATIVE_COLOR};


# make sure the locale is c

$ENV{LANG} = "C";


sub test_line {
    my ($test_name, $instr, $outstr) = @_;

    rm_f 'a';
    open(STUPIDFILE, ">:encoding(iso-8859-1)", "a");
    print STUPIDFILE "$instr";
    close(STUPIDFILE);
    like(darcs('whatsnew'), $outstr, $test_name);
}


# First check escaping and coloring.  Use whatsnew, since that is the
# most common use of escapes.

# test the defaults
# - no color to pipe
# - don't escape 7-bit ASCII printables, \n,\t and space (we can't test \n)
# - escape control chars with ^
# - escape other chars with \xXX

test_line('tab, space and ascii printables are not escaped (1/4)',
          " !#%&',-0123456789:;<=>",
          qr/ !#%&',-0123456789:;<=>/
         );
test_line('tab, space and ascii printables are not escaped (2/4)',
          "ABCDEFGHIJKLMNOPQRSTUVWXYZ_",
          qr/ABCDEFGHIJKLMNOPQRSTUVWXYZ_/
         );
test_line('space and ascii printables are not escaped (3/4)',
          "`abcdefghijklmnopqrstuvwxyz",
          qr/`abcdefghijklmnopqrstuvwxyz/
         );
test_line('tab, space and ascii printables are not escaped (4/4)',
          "\t\"\$()*+./?\@[\\]^{|}",
          qr/\t"\$\(\)\*\+\.\/\?\@\[\\\]\^\{\|\}/
         );

# skip ^@ and ^Z since they make darcs treat the file as binary
# don't put any space control chars at end of line

test_line('ascii control chars are escaped with ^ (1/3)',
          "\x01\x02\x03\x04\x05\x06\x07\x08\x0B\x0C\x0D\x0E",
          qr/\^A\^B\^C\^D\^E\^F\^G\^H\^K\^L\^M\^N/
         );
test_line('ascii control chars are escaped with ^ (2/3)',
          "\x0F\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19",
          qr/\^O\^P\^Q\^R\^S\^T\^U\^V\^W\^X\^Y/
         );

test_line('ascii control chars are escaped with ^ (3/3)',
          "\x1B\x1C\x1D\x1E\x1F\x7F",
          qr/\^\[\^\\\^\]\^\^\^_\^\?/
         );

test_line('other chars are escaped with \xXX (1/8)',
          "\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8A\x8B\x8C\x8D\x8E\x8F",
          qr/\\80\\81\\82\\83\\84\\85\\86\\87\\88\\89\\8a\\8b\\8c\\8d\\8e\\8f/
         );
test_line('other chars are escaped with \xXX (2/8)',
          "\x90\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9A\x9B\x9C\x9D\x9E\x9F",
          qr/\\90\\91\\92\\93\\94\\95\\96\\97\\98\\99\\9a\\9b\\9c\\9d\\9e\\9f/
         );
test_line('other chars are escaped with \xXX (3/8)',
          "\xA0\xA1\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\xAA\xAB\xAC\xAD\xAE\xAF",
          qr/\\a0\\a1\\a2\\a3\\a4\\a5\\a6\\a7\\a8\\a9\\aa\\ab\\ac\\ad\\ae\\af/
         );
test_line('other chars are escaped with \xXX (4/8)',
          "\xB0\xB1\xB2\xB3\xB4\xB5\xB6\xB7\xB8\xB9\xBA\xBB\xBC\xBD\xBE\xBF",
          qr/\\b0\\b1\\b2\\b3\\b4\\b5\\b6\\b7\\b8\\b9\\ba\\bb\\bc\\bd\\be\\bf/
         );
test_line('other chars are escaped with \xXX (5/8)',
          "\xC0\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xCA\xCB\xCC\xCD\xCE\xCF",
          qr/\\c0\\c1\\c2\\c3\\c4\\c5\\c6\\c7\\c8\\c9\\ca\\cb\\cc\\cd\\ce\\cf/
         );
test_line('other chars are escaped with \xXX (6/8)',
          "\xD0\xD1\xD2\xD3\xD4\xD5\xD6\xD7\xD8\xD9\xDA\xDB\xDC\xDD\xDE\xDF",
          qr/\\d0\\d1\\d2\\d3\\d4\\d5\\d6\\d7\\d8\\d9\\da\\db\\dc\\dd\\de\\df/
         );
test_line('other chars are escaped with \xXX (7/8)',
          "\xE0\xE1\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\xEA\xEB\xEC\xED\xEE\xEF",
          qr/\\e0\\e1\\e2\\e3\\e4\\e5\\e6\\e7\\e8\\e9\\ea\\eb\\ec\\ed\\ee\\ef/
         );
test_line('other chars are escaped with \xXX (8/8)',
          "\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\xFA\xFB\xFC\xFD\xFE\xFF",
          qr/\\f0\\f1\\f2\\f3\\f4\\f5\\f6\\f7\\f8\\f9\\fa\\fb\\fc\\fd\\fe\\ff/
         );


chdir '../';
rm_rf 'temp1';
ok((!-d 'temp1'), 'temp1 directory was deleted');
