#!/bin/sh
set -ev

uname | grep "MINGW" > /dev/null && exit 0

test $DARCS || DARCS=$PWD/../darcs
rm -rf temp1 temp2
mkdir temp1
cd temp1
$DARCS init
echo record author me > _darcs/prefs/defaults
echo ALL all >> _darcs/prefs/defaults
echo ALL verbose >> _darcs/prefs/defaults
echo ALL ignore-times >> _darcs/prefs/defaults
touch foo
$DARCS add foo
$DARCS record -m add_foo
echo hello >> foo
$DARCS record -m mod_foo
cd ..
$DARCS get --repo-name temp2 temp1
cd temp2
cp ../temp1/_darcs/prefs/defaults _darcs/prefs
echo -e "y\nd\ny" | $DARCS unpull
test -e foo -a ! -s foo
chmod +x foo
test -x foo
$DARCS pull ../temp1
test -x foo
cd ..
rm -rf temp1 temp2

