#!/usr/bin/env perl

# Some tests for 'darcs pull' 

use Test::More tests => 11;
use strict;
use Cwd;
use vars qw/$DARCS/;

die 'darcs not found' unless $ENV{DARCS} || (-x "$ENV{PWD}/../darcs");
$DARCS = $ENV{DARCS} || "$ENV{PWD}/../darcs";

`rm -rf temp1 temp2`;
`mkdir -p temp1 temp2/one/two`;
chdir 'temp1';
`$DARCS init`;
chdir '../temp2';
`$DARCS init`;
chdir 'one/two';

{
    my $test_name = 'darcs pull should work relative to the current directory';
    my $pull_out = `$DARCS pull -a ../../../temp1 2>&1`;
    like($pull_out, qr/No remote changes to pull in/i, $test_name);
}

my $test_name = 'darcs pull should pull into repo specified with --repo';
chdir '../../';  # now in temp2
`$DARCS add one`;
`$DARCS record --patch-name 'uno' --all --author foo\@bar`;
chdir '../';     # now outside of any repo
like(`$DARCS pull --repodir temp1 --all ../temp2`, # temp2 is relative to temp1
	qr/Finished pulling./i, $test_name);

TAKE_LOCK: {
    # set up server repo
    `date >>temp2/one/date.t`;
    `$DARCS add --repodir ./temp2 one/date.t`;
    `$DARCS record --repodir ./temp2 --author foo\@far.com -a -m 'foo'`;

    # set up client repo for failure
    `chmod -w ./temp1/one/`;
    my $out = `$DARCS pull --repodir ./temp1 -a 2>&1`;
    like($out, qr/Fail.*takeFile date.t-0 in .*one:/i, 'expect takeFile error');
};


SELF_PULL: {
    chdir './temp1'; 

    my $default_repo_pre_test = 'Before trying to pull from self, defaultrepo is something else';
    open(DEFAULT_REPO,'<./_darcs/prefs/defaultrepo') || die "Couldn't open defaultrepo";
    my $default_repo = (<DEFAULT_REPO>);
    close(DEFAULT_REPO);

    unlike($default_repo,qr/temp1/,$default_repo_pre_test);

    my $test_name = 'return special message when you try to pull from yourself';
    my $abs_path = cwd();
    like(`$DARCS pull -a $abs_path 2>&1`, qr/Can't pull from current repo!/i, $test_name);

    my $set_default_repo_test = "and don't update the default repo to be the current dir";
    open(DEFAULT_REPO,'<./_darcs/prefs/defaultrepo') || die "Couldn't open defaultrepo";
    my $new_default_repo = (<DEFAULT_REPO>);
    close(DEFAULT_REPO);

    unlike($new_default_repo,qr/temp1/,$set_default_repo_test);

    chdir '../';     # now outside of any repo
}

ROLLBACK_PULL: {
    TODO: {
        local $TODO = "waiting for code to fix pull/rollback bug.";
        use File::Path;
        chdir 'temp1';
        `echo a > foo`;
        `darcs record -lam A --author foo\@bar`;
        `echo b > foo`;
        `darcs record --ignore-times -lam B --author foo\@bar`;
        `echo c > foo`;
        `darcs record --ignore-times -lam C --author foo\@bar`;
        `echo -n y | darcs rollback -p C`;
        chdir '../';
        rmtree('temp2/');
        `darcs get --to-patch B temp1 temp2`;
        chdir('temp2');
        `echo -n y | darcs rollback -p B`;
        `echo y | darcs revert -a`;
        my $pull_out = `darcs pull -a ../temp1 2>&1`;
        unlike($pull_out,qr/error applying patch/i, 'pull after rollback avoids failure');
        chdir '../';
    }
};



ok(-d 'temp1', "temp1 exists here");
`rm -rf temp1`;
ok((!-d 'temp1'), 'temp1 directory was deleted');

ok(-d 'temp2', "temp1 exists here");
`rm -rf temp2`;
ok((!-d 'temp2'), 'temp1 directory was deleted');




