#!/bin/sh
set -ev

test $DARCS || DARCS=$PWD/../darcs
rm -rf temp
mkdir temp
cd temp
$DARCS init
echo ALL ignore-times > _darcs/prefs/defaults
echo a > foo
$DARCS add foo
$DARCS record -a -m a -A test
echo b > foo
echo y | $DARCS revert -a
echo y/d/y | tr / \\012 | $DARCS unrecord
# since the unrevert is impossible, we should fail if it succeeds...
! echo y | $DARCS unrevert

# now let's try a possible unrevert, just for fun...
echo b >> foo
$DARCS record -a -m b -A test
echo f/b | tr / \\012 > foo
$DARCS record -a -m 'aaa becomes f' -A test
date >> foo
echo y | $DARCS revert -a
echo y/d/y | tr / \\012 | $DARCS unpull
# Now add the date back on at the end:
echo y | $DARCS unrevert
echo 'M ./foo +1' > correct_summary
$DARCS whatsnew --dont-look-for-adds --summary > actual_summary
diff -u correct_summary actual_summary

cd ..
rm -rf temp
