#!/usr/bin/env perl

# A start on testing amend-record. Please add more tests for amend here!

use Test::More qw/no_plan/;
use strict;
use vars qw/$DARCS/;

die 'darcs not found' unless $ENV{DARCS} || (-x "$ENV{PWD}/../darcs");
$DARCS = $ENV{DARCS} || "$ENV{PWD}/../darcs";

`rm -rf temp1`;
`mkdir temp1`;
chdir 'temp1';
like(`$DARCS init`, qr/^$/i, 'initialized repo');
`echo "Tester" > _darcs/prefs/author`;

# Plain amend-record
`date > foo`;
`$DARCS add foo`;
like(`$DARCS record -a -m add_foo`, qr/finished recording/i, 'added patch');
`date >> foo`;

like(`echo 'y' | $DARCS amend-record -a foo`, qr/amending changes/i, 'amend-record -a');
is($?,0, " return code == 0");


# Special case: patch is empty after amend
`cp foo foo.old`;
`date >> foo`;
like(`$DARCS record -a -m add_line foo`, qr/finished recording/i, 'record');
`mv foo.old foo`;
like(`echo 'y' | $DARCS amend -a foo`, qr/amending changes/i,
     'amend makes empty patch');
is($?,0, "  return code == 0");
chdir '../';
`rm -rf temp1`;




