import System
import Data.FiniteMap ( FiniteMap, emptyFM, addToFM, fmToList, lookupFM )
import RegexString ( matchRegex, mkRegex, matchRegexAll )
import Monad ( liftM )
import System.Console.GetOpt( usageInfo )

import DarcsCommands
import DarcsArguments
import TheCommands ( the_commands )

type Vars = FiniteMap String String

main = do
  args <- getArgs
  if length args /= 1
     then exitWith $ ExitFailure 1
     else return ()
  c <- preproc emptyFM ["\\input{"++head args++"}"]
  putStr $ unlines c

preproc :: Vars -> [String] -> IO [String]
preproc v ("\\begin{code}":ss) = ignore v ss
preproc v (s:ss) = do
  rest <- preproc v ss
  case matchRegex (mkRegex "^\\\\input\\{(.+)\\}$") s of
    Just (fn:_) -> do cs <- readFile fn
                      this <- preproc (hstrings cs) $ lines cs
                      return $ this ++ rest
    _ -> case matchRegex (mkRegex "^(.*)\\\\haskell\\{(.+)\\}(.*)$") s of
         Just (before:var:after:_) ->
             case lookupFM v var of
             Just val -> return $ (before++val++after):rest
             Nothing -> return $ (before++"preproc couldn't find:"++var++after):rest
         _ -> case matchRegex (mkRegex "^(.*)\\\\options\\{(.+)\\}(.*)$") s of
              Just (before:comm:after:_) ->
                  return $ (before++get_options comm++after):rest
              _ ->  case matchRegex (mkRegex "^(.*)\\\\example\\{(.+)\\}(.*)$") s of
                    Just (before:fn:after:_) -> do
                        filecont <- readFile fn
                        return $ (before++"\\begin{verbatim}"++
                                  filecont++"\\end{verbatim}"
                                  ++after):rest
                    _ -> return $ s : rest
preproc v [] = return []

get_options comm = get_com_options $ get_c comm the_commands
get_c comm (c:cs) | command_name c == comm = c
                  | otherwise = get_c comm cs
get_com_options c = options_latex $ command_darcsoptions c

ignore :: Vars -> [String] -> IO [String]
ignore v ("\\end{code}":ss) = preproc v ss
ignore v (_:ss) = ignore v ss
ignore v [] = return []

var_regexp = mkRegex "([a-z_A-Z]+) +=[ \n\t]+\"([^\"]*)\""

hstrings :: String -> Vars
hstrings s = hstrings_helper emptyFM s
hstrings_helper m ('\n':s) = hstrings_helper m s
hstrings_helper m [] = m
hstrings_helper m s =
  case matchRegexAll var_regexp s of
  Just (_,_,rest,_,[var,val]) -> hstrings_helper (addToFM m var val) rest
  Nothing -> hstrings_helper m $ dropWhile (/='\n') s
