%  Copyright (C) 2002-2003 David Roundy
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2, or (at your option)
%  any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software Foundation,
%  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
\section{darcs inittree}
\begin{code}
module InitTree ( inittree ) where
import DarcsCommands
import DarcsArguments
import Directory
import IO
import System
import Monad

import RepoPrefs
import Repository
\end{code}

\options{inittree}

\haskell{inittree_description}

\begin{code}
inittree_description = "Initialize a new source tree as a darcs repository.
"
\end{code}
Generally you will only call inittree once for each project you work on,
and calling it is just about the first thing you do.  Just make sure you
are in the main directory of the project, and inittree will set up all the
directories and files darcs needs in order to start keeping track of
revisions for your project.

\begin{code}
inittree_help =
 "Generally you will only call inittree once for each project you work on,   \n"++
 "and you calling it is just about the first thing you do.  Just make sure   \n"++
 "you are in the main directory of the project, and inittree will set up all \n"++
 "the directories and files darcs needs in order to start keeping track of   \n"++
 "revisions for your project.\n"
\end{code}

\begin{code}
inittree = DarcsCommand {command_name = "inittree",
                         command_help = inittree_help,
                         command_description = inittree_description,
                         command_extra_args = 0,
                         command_prereq = liftM not $ am_in_repo,
                         command_command = inittree_cmd,
                         command_get_arg_possibilities = return [],
                         command_argdefaults = nodefaults,
                         command_darcsoptions = [verbose]}
\end{code}

{\tt inittree} actually follows a very simple procedure.  It simply creates
the directories {\tt \_darcs}, {\tt \_darcs/current} and {\tt
\_darcs/patches}, and then creates an empty file, {\tt \_darcs/inventory}.
However, it is strongly recommended that you use {\tt darcs inittree} to do
this, as this procedure may change in a future version of darcs.

\begin{code}
inittree_cmd _ _ = do
    createDirectory "_darcs" `catch`
        (\e-> do if isAlreadyExistsError e
                     then putStr "Tree has already been initialized!\n"
                     else putStr "Error creating directory `_darcs'.\n"
                 exitWith $ ExitFailure 2)
    createDirectory "_darcs/current"
    createDirectory "_darcs/patches"
    createDirectory "_darcs/prefs"
    write_default_prefs
    write_inventory "." [[]]
    putStr "Successfully initialized tree!\n"
\end{code}
