module Curl ( readUrl, readUrlPS ) where

import Foreign.C.String
import IO
import GHC.Handle ( openFd )
import Monad ( liftM )

import Autoconf ( have_libcurl )
import FastPackedString

readUrl :: String -> IO String
readUrl u =
#ifdef HAVE_CURL
  if have_libcurl then do h <- openUrl u
                          hGetContents h
                  else error "There is no libcurl!"
#else
  error "There is no libcurl!"
#endif

readUrlPS :: String -> IO PackedString
readUrlPS u =
#ifdef HAVE_CURL
  if have_libcurl then do h <- openUrl u
  -- the following is stupidly inefficient:
                          packString `liftM` hGetContents h
                  else error "There is no libcurl!"
#else
  error "There is no libcurl!"
#endif

openUrl :: String -> IO Handle
openUrl s = do
  cs <- newCString s
  fd <- get_curl cs
  openFd fd Nothing s ReadMode False False

initCurl :: IO ()
initCurl = do
  curl_init
  return ()

foreign import ccall "hscurl.h get_curl"
  get_curl :: CString -> IO Int

foreign import ccall "hscurl.h curl_init"
  curl_init :: IO Int
