/*-
 * EGA/VGA raw screen fonts converter, alt->koi8-r
 *
 * Copyright (C) 1993-98 by Andrey A. Chernov, Moscow, Russia
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifdef MSDOS
#define __MSDOS__
#endif

#include <stdio.h>
#include <ctype.h>
#if defined(__MSDOS__) || defined(__OS2__)
#define RB "rb"
#define WB "wb"
#else
#define RB "r"
#define WB "w"
#endif

#define MAXHEIGHT 19

unsigned char font[256][MAXHEIGHT];

#include "koi82alt.h"

logo()
{
	fprintf(stderr, "Freeware a2kfcnv v1.1\n\
Copyright (C) 1993-1994 by Andrew A. Chernov, Moscow, Russia\n");
}

main(ac, av)
char *av[];
{
	register i, j, n;
	FILE *af, *kf;
	long size;

	while (   ac > 1
#if defined(__MSDOS__) || defined(__OS2__)
	       && (av[1][0] == '-' || av[1][0] == '/')
#else
	       && av[1][0] == '-'
#endif
	      ) {
		switch (tolower(av[1][1])) {
		case 'h':
		case '?':
			logo();
usage:
			fprintf(stderr, "\nUsage:\n\
    a2kfcnv EGA/VGA_alt_screen_font  EGA/VGA_koi8-r_screen_font\n\
    a2kfcnv [-h|-%s?]\n",
#ifdef unix
				"\\"
#else
				""
#endif
			       );
			fprintf(stderr,
"Options:\n\
    -h or -%s?:\tshort help (you see it)\n",
#ifdef unix
				"\\"
#else
				""
#endif
			       );
#if defined(__MSDOS__) || defined(__OS2__)
			fprintf(stderr,
"You can use '/' to indicate an option instead of '-' sign\n");
#endif
			return 1;
		default:
			logo();
			fprintf(stderr, "\n%s: unknown option\n", av[1]);
			goto usage;
		}
	}
	if (ac != 3) {
		logo();
		fprintf(stderr, "\nIncorrect argument count\n");
		goto usage;
	}

	if ((af = fopen(av[1], RB)) == NULL) {
		logo();
		fputc('\n', stderr);
		perror(av[1]);
		goto usage;
	}
	fseek(af, 0L, 2);
	size = ftell(af);
	if (size % 256) {
		fprintf(stderr, "%s: %ld - incorrect font file size, must be X*256\n",
				av[1], size);
		return 1;
	}
	size /= 256;
	if (size > MAXHEIGHT) {
		fprintf(stderr, "%s: %ld - font height too big, maximum %ld\n",
				av[1], size, MAXHEIGHT);
		return 1;
	}

	rewind(af);
	for (i = 0; i < 256; i ++) {
		for (j = 0; j < size; j++) {
			if ((n = getc(af)) == EOF) {
				perror(av[1]);
				return 1;
			}
			font[i][j] = n;
		}
	}
	fclose(af);

	if ((kf = fopen(av[2], WB)) == NULL) {
		logo();
		fputc('\n', stderr);
		perror(av[2]);
		goto usage;
	}

	for (i = 0; i < 256; i ++) {
		n = i > 127 ? (unsigned char) *koi82alt[i&0x7F] : i;
		for (j = 0; j < size; j++)
			putc(font[n][j], kf);
	}
	fclose(kf);

	return 0;
}
