/* $Id: telnet_gw.c,v 1.8 1997/05/03 09:37:07 lexa Exp $ */

/* 
    (C) Vadim Kurland, 1994
    vadim@gu.kiev.ua

    modified for cyrproxy program by Alex Tutubalin, lexa@lexa.ru
    
    */


#include <arpa/telnet.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include "policy.h"
#include "readconf.h"
#include "gateway.h"


static int wait_for_se[2] = { 0 , 0 };
static int cm_stage[2] = { 1 , 1 };

unsigned char  bnr[]={ 255 , 255 };


int nindex(unsigned char *str, int s, int n)
{
  unsigned char *cp;
  if ( (cp = (unsigned char*)memchr(str,s,n))==NULL) return(-1);
  return( (int)(cp-str) );
}

/* telnet gateway */

static enum GWerrors 
telnetPipe(int  in, int out , enum Direction fclient,encoding* enc)
{
  unsigned char *bp, *cp;
  int            n, no, nse, i;

  if ((n = read(in, buf, cpBSIZE-2 )) > 0) 
    {
      bp=buf;
      bp[n]=0;

      cp=bp; 
      while ( n ) {
	if (wait_for_se[fclient]) goto wse;
	if ( cm_stage[fclient] &&  *cp==IAC ) {
	  switch (cp[1]) 
	  {
          case DONT:
          case DO:
          case WONT:
          case WILL: no=3;
	    break;

	  wse:
	  case SB:   
	    nse=nindex(cp,SE,n);
	    if (nse<0) 
	      {
		no=n;
		wait_for_se[fclient]=1; 
	      }
	    else 
	      {
		no=nse+1; 
		wait_for_se[fclient]=0; 
	      }
	    break;
          default:   no=2;   break;
	  }
	  if (write(out, cp, no) < no) 
	    return ERR_WRTERR;
	  cp+=no; n-=no;
        } 
	else 
	  {
	    cm_stage[fclient]=0;
	    no=n;
	    TranslateBuf(cp,no,fclient==FROM_CLIENT?enc->tablefrom:enc->tableto);
	    /*
	            255 (IAC),   
	           IAC IAC
	      */
	    for (i=0; i<no; ++i,++cp) {
	      if (*cp==IAC) { if(2!=write(out, bnr, 2)) return ERR_WRTERR; }
	      else          { if(1!=write(out, cp, 1)) return  ERR_WRTERR; }
	    }
	    n=0;
	  }
      }
      return ERR_NOERROR;
    } 
  return ERR_RDERR;
}

static enum GWerrors
telnetFromClient(int netfd, encoding *enc)
{
  return telnetPipe(0,netfd,FROM_CLIENT,enc);
} 

static enum GWerrors
telnetToClient(int netfd,encoding *enc)
{
  return telnetPipe(netfd,1,TO_CLIENT,enc);
}

void 
TelnetGW (int netfd, encoding *enc, int timeout)
{
  simple_gw(netfd,telnetFromClient,telnetToClient,enc,timeout);
}

