/* $Id: spy.c,v 1.5 1997/05/06 21:18:02 lexa Exp $ */

/* spy - logger for TCP connections */
/* (C) Alex Tutubalin, 1996, lexa@lexa.ru       */


#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <pwd.h>
#include <sys/socket.h>
#include <signal.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <syslog.h>
#include <string.h>
#include <errno.h>
#ifdef _AIX
#include <fcntl.h>
#else
#include <sys/fcntl.h>
#endif
#include <sys/stat.h>

#include "policy.h"
#include "readconf.h"
#include "gateway.h"

extern int ConnectTo(char*, char*);

static char targethost[256]="\0";
static char targetport[256]="\0";
static char outfile[256]="";
static int  timeout = TIMEOUT;
int outf=0,inf=0;

static void 
usage(char *name)
{
  printf("usage:\n%s  -p port -h host -f outfile-base\n",name);
}

static int 
processCLOptions(int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int ch;
  while ((ch = getopt(argc, argv, "p:h:f:")) != EOF)
   switch(ch) {
    case 'p':
      strcpy(targetport,optarg);
      break; 
    case 'h':
      strcpy(targethost,optarg);
      break;
    case 'f':
      strcpy(outfile,optarg);
      break;
    case '?':
    default: 
      usage(argv[0]);
    }
  argc -= optind;
  argv += optind;
  return ERR_NOERROR;
}

void 
sigfunc(int sig)
{
  closelog();
  exit(1);
}

void
setsig(void)
{
  signal(SIGHUP,sigfunc);
  signal(SIGINT,sigfunc);
  signal(SIGQUIT,sigfunc);
  signal(SIGILL,sigfunc);
  signal(SIGTRAP,sigfunc);
  signal(SIGTERM,sigfunc);
  signal(SIGALRM,sigfunc);
  signal(SIGBUS,sigfunc);
  signal(SIGSEGV,sigfunc);
  /* some peoples comlained that Linux /and other/ do not have SIGSYS signal */
  /* If you have this problem with other signals - comment this signal catching out */
  /* All signal handling in this program have diagnostic purpose only */
#ifdef SIGSYS
  signal(SIGSYS,sigfunc);
#endif
}


static int spyfile_in,spyfile_out;

static enum GWerrors
datapipe(int inf,int outf,int spyfile)
{
  char buf[cpBSIZE];
  int dsize;
  
  if((dsize=read(inf,buf,cpBSIZE))<=0) 
    return ERR_RDERR;
  write(spyfile,buf,dsize);
  if(dsize!=write(outf,buf,dsize)) return ERR_WRTERR;
  return ERR_NOERROR;
}

static enum GWerrors
dataFromClient(int netfd,encoding *enc)
{
 return  datapipe(0,netfd,spyfile_in);
}

static enum GWerrors
dataToClient(int netfd,encoding *enc)
{
 return  datapipe(netfd,1,spyfile_out);
}


void 
SpyGW (int netfd,int spy_in,int spy_out, int timeout)
{
  spyfile_in = spy_in;
  spyfile_out = spy_out;
  simple_gw(netfd,dataFromClient,dataToClient,NULL,timeout);
}


int 
main(int argc, char *argv[])
{
  int		outdata=0;
  char tmpbuf[256];
  if(ERR_NOERROR!=processCLOptions(argc,argv)) {usage(argv[0]);exit(1);}
  if(!*targethost || !*targetport) { usage(argv[0]);exit(1);}
  sprintf(tmpbuf,"%s.%d.in",outfile,(int)getpid());
  inf = open(tmpbuf,O_WRONLY|O_APPEND|O_CREAT,S_IREAD|S_IWRITE);
  sprintf(tmpbuf,"%s.%d.out",outfile,(int)getpid());
  outf = open(tmpbuf,O_WRONLY|O_APPEND|O_CREAT,S_IREAD|S_IWRITE);
  if(-1==(outdata = ConnectTo(targethost,targetport))) exit(1);
  SpyGW(outdata,inf,outf,timeout);
  close(inf);close(outf);
  exit(0);
}


