/* $Id: readconf.h,v 1.6 1997/05/03 11:57:22 lexa Exp $ */

/* (C) Alex Tutubalin, 1996, lexa@lexa.ru	*/



#ifndef __READCONF_H
#define __READCONF_H

#include <sys/param.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#ifndef MAXPATH
#define MAXPATH PATH_MAX
#endif

#define TOKDELIM " \t\n"
#define NOTABLE		"none"
#define TABLESIZE	256
#define ERR_NOCONFERROR	0 
#define ERR_CONFIG	1
#define ERR_UNSPEC	1024

#define P_GW_PREC       "TP"
#define P_ENC_PREC	"VP"

typedef struct in_addr host_addr;

typedef struct _enc 
{
  char name[32];
  char tablefromfile[MAXPATH],tabletofile[MAXPATH];
  unsigned char tablefrom[TABLESIZE],tableto[TABLESIZE];
  char *servercharset,*clientcharset;
  int changecharset; /* Charset field must be changed */
  struct _enc *chain;
} encoding;


typedef struct _peer 
{
  host_addr addr;
  encoding *encptr;
  struct _peer *chain;
} peer;

typedef struct _vhost 
{
  host_addr addr;
  encoding *encptr;
  struct _vhost *chain;
} virthost;

#ifdef TRANSPARENT_HOST
typedef struct _thlist
{
  host_addr addr;
  encoding  *encptr; /* For compatibility with EncodingByAddr */
  struct _thlist *chain;
} transphost;
#endif

enum tokens 
{   
  PARSEERR=-2,
  NOTOKEN=-1,
  TABLEDIR=1,
  ENCODING,
  ENCPRECEDENCE,
  GWPRECEDENCE,
  DEFAULT,
  OPTION,
  PEER,
  VIRTUALHOST,
  EMAILCHARSET
#ifdef TRANSPARENT_HOST
  ,TRANSPARENTHOST
#endif
};

struct keytoken {
  char 			token[32];
  enum tokens 	tok;
  unsigned int	nwords;
};

typedef char   tok_array[10][40];

typedef void (Gateway)(int netfd, encoding *,int timeout);

typedef struct _tos_options 
{
  char name[32];
  Gateway *gw;
  int	tos;
  struct _tos_options *chain;
} tos_options;

typedef struct _port_options 
{
  char	name[32];
  Gateway *gw;
  int	port;
  struct _port_options *chain;
} port_options;

struct conf
{
  encoding 	*enc;
  peer	       	*peers;
  virthost     	*vhosts;
  tos_options 	*to;
  port_options 	*po;
#ifdef TRANSPARENT_HOST
  transphost    *thl;
#endif
};

extern struct sockaddr_in local_addr,peer_addr;

extern encoding *DefaultEncoding;
Gateway TelnetGW;
Gateway DefaultGW;
Gateway HttpGW;
Gateway GopherGW;
Gateway SmtpGW;
Gateway PopGW;
#ifdef TRANSPARENT_HOST
Gateway transparentGW;
#endif

char* h_fgets(char *str, int size, int handle,int checkselect);
int h_checkerr(int handle);
int h_read(int handle_from,char *buf, int size);


int		ReadConfig (const char *cfileName);
void		ClearConfig(void);
int		InitTables(encoding*);
encoding*	EncodingByAddress(void);
encoding*	EncodingByName(const char *);
Gateway*	GatewayBySocket(int sock);
Gateway*	GatewayByName(const char*);
void		DebugLog(char *fmt,...);
void		NetworkDebug(char *fmt,...);
void		GetAddresses(int s);
#ifdef TRANSPARENT_HOST
Gateway*	IsTransparentAddr(int sock);
#endif

#endif






