/* $Id: policy.h,v 1.8 1997/10/11 16:29:08 lexa Exp $   */

/* 
 *  All tunable parameters for cyrproxy program		
 *
 * (C) 1996 by Alex Tutubalin, lexa@lexa.ru
 */


/* TCP timeout in seconds (default, may be overriden via commandline
   switch) 
*/
#define TIMEOUT	120

/*
* Encoding Chooser precedence. 
* Symbolic string, contains letters
* P - (peer)
* V - (virtualhost)
* Encoding chooser will check parameters of incoming connection
* in order, defined by this string. 
* For example, if you have strings
* >> peer koi8-client.your.domain koi8
* >> virtualhost win-gateway.your.domain windows
* in your config file, peer address is 'koi8-client', and local address
* is win-gateway, then:
* if PRECEDENCE= PV then koi8 encoding will be choosed
* if PRECEDENCE=VP  then windows encoding will be selected
* Simple, isn't it :) ?
* If you have TRANSPARENT_HOST defined and local address matches
* this value, then virtualhost and peer addresses will be ignored
* If ENCPRECEDENCE not defined in makefile, then default value is 'VP'
*/
#define ENCODING_PREC	"VP"

/*
* Gateway chooser precedence (see above)
* P - port
* T - TOS
* default value is "PT"
*/
#define GATEWAY_PREC	"PT"

/*
* Next line enables 'Transparent Host' feature -- VirtualHost addr for which
* No translation is guaranteed
*/
#define TRANSPARENT_HOST

/*
* Next line enables 'Transparent Exec' feature.
* I.e.: 
* 1) Transparent-host feature is enabled
* 2) '-R "string"' commandline option is specified
* and 3) client has choosed transparent-host address as server address,
* then "string" will be exec'ed, instead of transparent reconnection.
* 
* In this case client address in (for example) sendmail's log is 'True'
* address rather then localhost.
*/
#define TRANSPARENT_EXEC

/*
* DEBUG LOG FACILITY
* comment it out if you don't want  debug output
* You can change LOG_DEBUG to any facility known to your syslog()
*/
/*#define DEBUGLOG	LOG_DEBUG */


/* NETWORK_DEBUG facility  */
/*  uncommenting next line will result to *VERY* verbose debugging of */
/*  network part (i.e. every read/write will produce several lines of */
/*  output */

//#define NETWORK_DEBUG LOG_DEBUG 


/*
* Following enables client's and server's addresses logging
* with given syslog's facility
*/
#define ADDR_LOGGING LOG_INFO


/*
 * Compatibility options. 
 * TODO: MUST be moved in config.h *****
*/

/*
 * Uncomment next line if you are using Linux/Solaris/other unix w/o vsnprintf()
 */

/* #define NO_VSNPRINTF */

#if defined(_AIX) || !defined(NO_VSNPRINTF)
#define NO_VSNPRINTF
#endif

/*
 * Uncomment next line if you are using system without hstrerror() (systems with bind 4.9.2
 * or older resolver library)
 * On some systems you must add -lresolv to EXTRALIBS= string in Makefile
 */
/* #define NO_HSTRERROR */

#if defined(_AIX) || !defined(NO_HSTRERROR)
#define NO_HSTRERROR
#endif

#ifdef _AIX
#define NO_VSYSLOG
#endif



/* Some cleanups (default values) */
/* ============= DO NOT CHANGE BELOW THIS LINE ============ */
#ifndef TIMEOUT
#define TIMEOUT 3600
#endif

#ifndef ENCODING_PREC
#define ENCODING_PREC "VP"
#endif

#ifndef GATEWAY_PREC
#define GATEWAY_PREC "PT"
#endif


