/* $Id: main.c,v 1.18 1997/05/03 09:37:06 lexa Exp $ */

/*     cyrproxy */
/* (C) Alex Tutubalin, 1996, lexa@lexa.ru       */


#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <pwd.h>
#include <sys/socket.h>
#ifndef LINUX
#include <signal.h>
#else
#include <bsd/signal.h>
#endif
#include <unistd.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <syslog.h>
#include <string.h>
#include <assert.h>
#include <errno.h>

#include "policy.h"
#include "readconf.h"

extern int ConnectTo(char*, char*);

static char configFile[MAXPATH]=CONFIGFILE;
static char targethost[256]="\0";
static char targetport[256]="\0";
static char clencoding[256]="\0";
static char clgateway[256]="\0";
#ifdef TRANSPARENT_HOST
static int  cl_transpgw=0;
#ifdef TRANSPARENT_EXEC
static int  cl_transpexec=0;
static char *commandToRun; /* will be iniatilized to arvg[someindex] */
static char **commandArgs; /* will be initialized to &argv[someindex+1] */
#endif
#endif
#ifdef TIMEOUT
static int  timeout = TIMEOUT;
#else
static int  timeout = 3600;
#endif

static void 
usage(char *name)
{
#ifdef TRANSPARENT_HOST
#ifdef TRANSPARENT_EXEC
 printf("usage:\n\
%s [-c configfile] -p port -h host [-t timeout] [-g gwname]\n\t [-e encname] [-T] [-R string]\n",
	 name);
#else /* no transparent exec */
  printf("usage:\n\
%s [-c configfile] -p port -h host [-t timeout] [-g gwname]\n\t [-e encname] [-T]\n",
	 name);
#endif
#else
  printf("usage:\n\
%s [-c configfile] -p port -h host [-t timeout] [-g gwname] [-e encname]\n",
	 name);
#endif
  printf("Where:\n port - destination port number or service name\n");
  printf(" host - destination hostname or IP-address\n");
  printf(" timeout - connection timeout in seconds\n");
  printf(" gwname - gateway type, one of \'default\', \'telnet\', \'gopher\'\n");
  printf(" \'smtp\', \'pop\' or \'http\'\n");
  printf(" encname - one of encodings name, defined in configfile\n");
#ifdef TRANSPARENT_HOST
  printf(" -T - use transparent gateway, overrides over encoding and gateway settings\n");
#ifdef TRANSPARENT_EXEC
  printf(" -R \"command args..\" - execv(command,args) instead of transparent gateway\n");
  printf("   (only, if transparent host choosed by client or -T option is specified).\n");
  printf("    All characters after -R will be interpreted as a command and commandline\n");
#endif
#endif
}

static int 
processCLOptions(int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int ch;

#ifdef TRANSPARENT_HOST
#ifdef TRANSPARENT_EXEC
  while ((ch = getopt(argc, argv, "c:p:h:t:g:e:T:R:")) != EOF)
#else
  while ((ch = getopt(argc, argv, "c:p:h:t:g:e:T:")) != EOF)
#endif
#else
   while ((ch = getopt(argc, argv, "c:p:h:t:g:e:")) != EOF)
#endif
   switch(ch) {
    case 'c':
      strcpy(configFile,optarg);
      break;
    case 'p':
      strcpy(targetport,optarg);
      break; 
    case 't':
      timeout = atoi(optarg);
      if(timeout < 1) return ERR_CONFIG;
      break;
    case 'h':
      strcpy(targethost,optarg);
      break;
    case 'g':
      strcpy(clgateway,optarg);
      break;
    case 'e':
      strcpy(clencoding,optarg);
      break;
#ifdef TRANSPARENT_HOST
    case 'T':
      cl_transpgw=1;
      break;
#ifdef TRANSPARENT_EXEC
   case 'R':
     cl_transpexec = 1;
     commandToRun=argv[optind-1];
     commandArgs = &argv[optind];
     goto EOS;
#endif
#endif
    case '?':
    default: 
      usage(argv[0]);
    }
EOS:
  argc -= optind;
  argv += optind;
  return ERR_NOCONFERROR;
}

void 
sigfunc(int sig)
{
  DebugLog("Killed by signal %d",sig);
  ClearConfig();
  closelog();
  exit(1);
}

void
setsig(void)
{
  signal(SIGHUP,sigfunc);
  signal(SIGINT,sigfunc);
  signal(SIGQUIT,sigfunc);
  signal(SIGILL,sigfunc);
  signal(SIGTRAP,sigfunc);
  signal(SIGTERM,sigfunc);
  signal(SIGALRM,sigfunc);
  signal(SIGBUS,sigfunc);
  signal(SIGSEGV,sigfunc);
  /* some peoples comlained that Linux /and other/ do not have SIGSYS signal */
  /* If you have this problem with other signals - comment this signal catching out */
  /* All signal handling in this program have diagnostic purpose only */
#ifdef SIGSYS
  signal(SIGSYS,sigfunc);
#endif
}


int 
main(int argc, char *argv[])
{
  Gateway	*gw;
  encoding	*enc=NULL;
  int		outfile=0;
  
  setsig();
  openlog("cyrproxy",LOG_PID,LOG_USER);
  if(ERR_NOCONFERROR!=processCLOptions(argc,argv)) {usage(argv[0]);exit(1);}
  if(!*targethost || !*targetport) { usage(argv[0]);exit(1);}
  
  ReadConfig(configFile);
  GetAddresses(0);
#ifdef TRANSPARENT_HOST
  if(cl_transpgw || (NULL!=(gw = IsTransparentAddr(0))))
    {
#ifdef TRANSPARENT_EXEC
      if(cl_transpexec) 
	{
	  DebugLog("TransparentExec: %s",commandToRun);
	  execv(commandToRun,commandArgs); 
	}
#endif
      if(-1==(outfile = ConnectTo(targethost,targetport))) exit(1);
      transparentGW(outfile,NULL,timeout);
    }
  else
    {
#endif
      if(*clgateway)
	{
	if(NULL==(gw=GatewayByName(clgateway)))
	  {
	    syslog(LOG_ERR,"Incorrect gateway name specified in commandline,default choosed");
	    gw = DefaultGW;
	  }
	}
      else
	gw = GatewayBySocket(0);
      if(*clencoding)
	{
	if(NULL==(enc=EncodingByName(clencoding)))
	  {
	    syslog(LOG_ERR,"Incorrect encoding name specified, default chhosed");
	    enc = DefaultEncoding;
	  }
	}
      else 
	{
	enc = EncodingByAddress();
	DebugLog("main: Client requested %s encoding",enc->name?enc->name:"ZERO");
	}
      InitTables(enc);
      DebugLog("Tables Initialized");
      if(-1==(outfile = ConnectTo(targethost,targetport))) exit(1);
      gw(outfile,enc,timeout);
#ifdef TRANSPARENT_HOST
    }
#endif

  DebugLog("main: exiting");
  ClearConfig();
  closelog();  
  exit(0);
}


