/* $Id: gateway.h,v 1.8 1997/05/03 09:37:05 lexa Exp $ */

/* (C) Alex Tutubalin, 1996, lexa@lexa.ru       */

#ifndef __GATEWAY_H
#define __GATEWAY_H
#include "readconf.h"

#define cpBSIZE 12288
extern unsigned char buf[];

enum Direction	{ FROM_CLIENT=0,TO_CLIENT=1};
enum Dataset	{ FIRST_DATA=1,SECOND_DATA=2};

enum GWerrors {
  ERR_NOERROR = 0,
  ERR_RDERR,
  ERR_WRTERR,
  ERR_NODATA
};

/*  gateway pipes,   simple_gw  ,
 .  :
ERR_NOERROR -      
ERR_RDERR   -  
ERR_WRTERR  -  
ERR_NODATA  -    
*/


typedef enum GWerrors (GW_client)(
	int netfd, /* server file descriptor; */
	encoding *enc); /*   */
typedef enum GWerrors (GW_server)(
	int netfd,
	encoding *enc);


void TranslateBuf (unsigned char *buf, int len, unsigned char *table);

/* Simple and universal gateway implementation -- select/GW_func call driver */
void simple_gw(
	int netfd, /*      */
        GW_client  *client_pipe, /*   ->server */
	GW_server  *server_pipe, /*  server->client */
	encoding *enc,	/*    */
	int timeout	/* timeout  select */
);
#endif /*__GATEWAY_H */

















