/* $Id: discover.c,v 1.2 1996/03/25 20:11:34 lexa Exp $ */

/*
	This program creates encoding table from to arbitrary
	text files with different encoding and SAME contents
	(C) 1996 by Alex Tutubalin, lexa@lexa.ru
*/

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>


#define TSIZE 256
#define SKIPCHARS " \t\n\r"

unsigned char  
buf_from[TSIZE], /* result - encoding table from client to host */
  buf_to[TSIZE], /* result - encoding table from host to client */
  temp_from[TSIZE], /* temporary buffer for from_table */
  temp_to[TSIZE];   /* --"-- for to_table */


int 
next_char(FILE *f)
{
  int chr=fgetc(f);
  if(chr==EOF) return EOF;
  while(strchr(SKIPCHARS,chr))
    {
     if(EOF==(chr=fgetc(f))) return EOF;
    }
  return chr;
}

void
usage(void)
{
  fprintf(stderr,"Usage: discover client_side_sample_file server_side_sample_file\n");
  exit(1);
}
int
main (int av, char *ac[]) 
{
  FILE *f1,*f2;
  int clientchar,hostchar;
  int chtable,hctable,i;

  if(av!=3) usage();
  f1=fopen(ac[1],"r");
  f2=fopen(ac[2],"r");
  if(!f1 || !f2) usage();
  while(1)
    {
      clientchar=next_char(f1);
      hostchar=next_char(f2);
      if(clientchar==EOF || hostchar == EOF) break;
      /* Host->client encoding */
      if(temp_to[hostchar] == 0)
	temp_to[hostchar] = clientchar;
      else if(temp_to[hostchar] != clientchar)
	{
	  fprintf(stderr,"Error: cannot make correct Host->client table. Hostchar = %d, Clientchar = %d\n",
		  hostchar,clientchar);
	  exit(1);
	}
      /* Client->host encoding */
      if(temp_from[clientchar] == 0)
	temp_from[clientchar] = hostchar;
      else if(temp_from[clientchar] != hostchar)
	{
	  fprintf(stderr,"Error: cannot make correct Cilent->host table. Hostchar = %d, Clientchar = %d\n",
		  hostchar,clientchar);
	  exit(1);
	}
    }
  fclose(f1);
  fclose(f2);
  for(i = 0;i < TSIZE;i++)
    {
      if(temp_from[i] != 0) buf_from[i] = temp_from[i]; else buf_from[i] = i;
      if(temp_to[i] != 0) buf_to[i] = temp_to[i]; else buf_to[i] = i;
    }
  chtable=open("client-host",O_CREAT|O_WRONLY,S_IREAD|S_IWRITE);
  write(chtable,buf_from,TSIZE);
  close(chtable);
  hctable=open("host-client",O_CREAT|O_WRONLY,S_IREAD|S_IWRITE);
  write(hctable,buf_to,TSIZE);
  close(hctable);
  exit(0);
  return 0;
}

/*
 $Log: discover.c,v $
 Revision 1.2  1996/03/25 20:11:34  lexa
 1st edition (working)

 */


