/* $Id: gentables.c,v 1.1 1996/03/25 20:25:35 lexa Exp $ */

/*  Encoding tables generator */
/* (C) 1996 by Alex Tutubalin */
/*	lexa@lexa.ru	      */

#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <assert.h>

#define TSIZE 256
#define NNAMES 10

static char names[NNAMES][10];

void
genlist(FILE *out,int n) 
{
  int i,j;
  
  fprintf(out,
	  "static struct _tables\n"\
	  "{\n"\
	  " char name[32];\n"\
	  "unsigned char *table;"\
	  "\n} tables[] =\n"\
	  "{\n");
  for(i=0;i<n;i++)
    for(j=0;j<n;j++)
      if(j!=i)
	fprintf(out,"{\"%s-%s\",%s_%s}%s",
		names[i],names[j],names[i],names[j],
		(i==n-1)&&(j==n-2)?"\n};":",\n");
}


void 
gentable(FILE *out, int in, char *name)
{	
  unsigned char buf[TSIZE];
  int i;

  if(TSIZE!=read(in,buf,TSIZE)) exit(1);
  fprintf(out,"\n\nunsigned char %s[%d] = {\n",name,TSIZE);
  for(i=0;i<TSIZE;i++)
    fprintf(out,"%u%s",
	    buf[i],
	    (i==TSIZE-1)?"\n};\n":((i%16)&&(i))?",":",\n");
  fprintf(out,"\n");
}


int
main(int argc, char *argv[])
{
  int i,ncount=0,j,infile;
  char arrname[256],filename[256];
  for (i=1;i<argc;i++)
    strcpy(names[i-1],argv[i]),ncount++;
  for(i=0;i<ncount;i++)
    for(j=0;j<ncount;j++)
	if(i!=j)
	  {
	    sprintf(arrname,"%s_%s",names[i],names[j]);
	    sprintf(filename,"%s/%s-%s",TABLEDIR,names[i],names[j]);
	    printf("/*%s*/\n",filename);
	    infile=open(filename,O_RDONLY);
	    assert(infile>=0);
	    gentable(stdout,infile,arrname);
	    close(infile);
	  }
  genlist(stdout,ncount);
  exit(0);
}



