/* $Id: cyrwww.c,v 1.1 1996/04/17 18:53:38 lexa Exp $ */

/*

	  Cyrillic Encoding Translator (CGI-interface)
	  1996 by Alex Tutubalin		
	  lexa@lexa.ru			

*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "enctables.h"


static int ntables=sizeof(tables)/sizeof(tables[0]);
static char encname[32];



void
recode(unsigned char *string, unsigned char *table)
{

  unsigned char buf[1024];
  int i,n;
  while(n=read(0,buf,1024))
    { 
      if(n==-1) return;
      for(i=0;i<n;i++) buf[i]=table[buf[i]];
      write(1,buf,n);
    }
}

#define HTMLHEAD "Content-type: text/html \n\n<HTML>\
<TITLE>Cyrwww - cyrillic encoding translator</TITLE><BODY>\n"
#define HTMLEND  "<hr>Created by cyrwww, (C) 1996  Alex Tutubalin\
 (lexa@lexa.ru)</BODY></HTML>"


void
parse_env (char *env,char **enc,char **str)
{
  char *p,**ptr=&env;
  *enc = *str = NULL;
  p=strsep(ptr,"=");
  if(!p || strcmp(p,"encoding"))
    {
      return;
    }
  else
    {
      p=strsep(ptr,"&");
      if(p)
	*enc=strdup(p);
    }
  p=strsep(ptr,"=");
  if(!p || strcmp(p,"usertext"))
    return;
  else
    *str = strdup(*ptr);
  return;
}


void
create_form(unsigned char *encoding)
{
  int i;
  puts("<FORM METHOD=\"GET\">"); 
  puts("<center>Select recoding type: <select name = \"encoding\">");
  for(i=0;i<ntables;i++)
    {
      printf("<option %s> %s\n",(!encoding)||strcmp(encoding,tables[i].name)?"":"selected",
		tables[i].name);
    }
  printf("</select> and type your text into next field</center> <br>\
	<center>\
	<textarea name=\"usertext\" rows=\"10\" cols=\"55\"></textarea>\
	</center>");
  printf("<p><center><input type=\"submit\" value=\"Recode\">\
	<input type=\"reset\" value=\"Clear form\"></center></p>");
  printf("</form>\n");

}

void 
print_result(unsigned char **str,unsigned char *table) 
{
  unsigned char *res = strdup(*str),num[5]="0x00",**pp;
  int i,l=strlen(*str),k,chr;
  
  num[2] = 0;
  for(i=k=0;i<l;i++)
    {
      if((*str)[i]=='+')
	res[k++]=' ';
      else if((*str)[i]!='%') 
	res[k++]=(*str)[i];
      else
	{
	  num[2] = (*str)[++i];
	  num[3] = (*str)[++i];
	  num[4] = '\0';
	  res[k++] = (unsigned char) strtol(num,(char**)pp,16);
	}
    }
  res[k] = '\0';
   if(table)
    {
      l = strlen(res);
      for(i=0;i<l;i++)
	res[i] = table[res[i]];
    }
   
  printf("<center>Recoding result:</center><hr><PRE>%s</PRE>",res);
  free(*str);
  free(res);
}


unsigned char *
find_table (char *name)
{
  int i;
  for(i=0;i<ntables;i++)
    if(!strcmp(tables[i].name,name))
      return tables[i].table;
  return NULL;
}
      

int
main()  
{
  char *ptr = getenv("QUERY_STRING");
  char *enc,*str;
  unsigned char *table;
  puts (HTMLHEAD);

  if(ptr!=NULL)
    parse_env(ptr,&enc,&str); 
  create_form(enc);
  if(enc)
    table = find_table(enc);
  else
    table = NULL;
  if(str)
    print_result((unsigned char**)&str,table);
  puts (HTMLEND);
}
     


