/* $Id: cyrtrans.c,v 1.1 1996/03/07 19:42:46 lexa Exp $ */

/*

	  Cyrillic Encoding Translator	
	  1996 by Alex Tutubalin		
	  lexa@lexa.ru			

*/

#include <stdio.h>
#include "enctables.h"


static int ntables=sizeof(tables)/sizeof(tables[0]);
static char encname[32];

void 
usage(char *name)
{
  int i;
  fprintf(stderr,"Usage: %s -t translation-type\n"\
	  "Supported translation types are:\n",name);
  for(i=0;i<ntables;i++)  
    fprintf(stderr,"\t\t%s\n",tables[i].name);
  fprintf(stderr,"Note: this program is  stdin-to-stdout filter\n");
  exit(1);
}

void
recode(unsigned char *table)
{
  unsigned char buf[1024];
  int i,n;
  while(n=read(0,buf,1024))
    { 
      if(n==-1) return;
      for(i=0;i<n;i++) buf[i]=table[buf[i]];
      write(1,buf,n);
    }
}

int
main(int argc, char *argv[])  
{
  extern char *optarg;
  extern int optind;
  int ch, i;
  if(argc<2)
      usage(argv[0]);
  while((ch=getopt(argc,argv,"t:"))!=EOF)
    switch(ch)
      {
      case 't':
	strncpy(encname,optarg,31);
	encname[31]=0;
	break;
      default:
	usage(argv[0]);
      }
  for(i=0;i<ntables;i++)
    if(!strcmp(tables[i].name,encname)) break;
  if(i<ntables)
    recode(tables[i].table);
  else
    {
      fprintf(stderr,"Encoding type %s not supported\n",encname);
      usage(argv[0]);
    }
  exit(0);
}
     


