/* $Id: connect.c,v 1.7 1997/05/03 11:57:20 lexa Exp $ */

/* (C) Alex Tutubalin, 1996, lexa@lexa.ru       */


#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <syslog.h>
#include <stdlib.h>

#include "policy.h"

int
ConnectTo (char *host_name, char *port_name)
{
    int fd;
    struct sockaddr_in port;
    struct hostent *h;
    struct servent *serv;

    port.sin_family = AF_INET;
    if (*host_name>='0' && *host_name<='9') 
      {
	port.sin_addr.s_addr = inet_addr(host_name);
      } 
    else 
      {
	h = gethostbyname(host_name);
	if (!h) 
	  {
#ifndef NO_HSTRERROR
	    syslog(LOG_ERR,"gethostbyname: %s\n", hstrerror(h_errno));
#else
	    syslog(LOG_ERR,"gethostbyname: error %d\n",h_errno);
#endif
	    return -1; 
	  }
	port.sin_addr = *((struct in_addr *) h->h_addr);
      }
    if (*port_name>='0' && *port_name<='9')
      port.sin_port=htons (atoi(port_name));
    else 
      {	
	serv=getservbyname(port_name,(char*)0);
	if (serv)
	  port.sin_port=serv->s_port;
	else 
	  {
	    syslog(LOG_ERR,"unknown port %s",port_name);
	    return -1;
	  }
      }
    if((fd = socket (AF_INET, SOCK_STREAM, 0))<0) return -1;
    if (connect (fd, (struct sockaddr *) &port, sizeof port) < 0)
	return -1;
    return fd;
}



