/* $Id: com_gw.c,v 1.12 1997/05/03 11:57:20 lexa Exp $ */


/* (C) Alex Tutubalin, 1996, lexa@lexa.ru       */

#ifdef _AIX
#include <stdlib.h>
#include <stdio.h>
#endif
#include <sys/types.h>
#include <sys/time.h>
#include <sys/errno.h>
#include <unistd.h> 
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <ctype.h>
#ifdef _AIX
#include <sys/select.h>
#endif
#include "policy.h"
#include "readconf.h"
#include "gateway.h"


unsigned char buf[cpBSIZE];


void
TranslateBuf (unsigned char *buf, int len, unsigned char *table)
{
  int i;
  if(table==NULL) return;
  for(i=0;i<len;i++)
    if(table[buf[i]]!=0) buf[i] = table[buf[i]];
}



void 
simple_gw( int netfd, GW_client  *clipump, GW_server *srvpump
	   ,encoding *enc,int timeout)
{
  fd_set fd,fd_sav;
  struct timeval tv;
  int netretry,rr,file_bits=netfd+1,rr2;

  alarm(0);

  NetworkDebug("Entering simple_gw, network descriptor: %d",netfd);
  FD_ZERO(&fd_sav);
  FD_SET(0,&fd_sav);
  FD_SET(netfd,&fd_sav);
  netretry = 2;
  while (FD_ISSET(netfd,&fd_sav)) /* i.e. while server connection live */
    {
      memcpy(&fd,&fd_sav,sizeof(fd));
      tv.tv_sec = timeout;
      tv.tv_usec = 0;
      NetworkDebug("Before select() call");
      rr = select(file_bits, &fd, NULL, NULL, &tv);
      NetworkDebug("select() returns %d",rr);
      if ( rr < 0  && errno != EINTR) 
	{
	  /* read error */
	  close(netfd);
	  return;
	}
      if ( rr == 0 ) 
	{
	  /* timeout reading from network*/
	  if (!FD_ISSET(0,&fd_sav)) /* is stdin closed ? */
	    netretry--;
	  if(!netretry)
	    {
	      NetworkDebug("maximum netretry reached, exiting");
	      close(netfd);
	      return; /* timeout reading from server */
	    }
	}
      if(rr > 0 )
	{
	  /* something arrived. do datapumps, server->client first */
	  if (FD_ISSET(netfd,&fd))
	      {
		NetworkDebug("network data arrived; calling srv-pump");
		rr2 = srvpump(netfd,enc);
		NetworkDebug("end of srvpump, return value: %d",rr2);
		switch (rr2)
		  {
		  case ERR_NOERROR:
		    break; /* not continue, we must check stdin also */
		  case ERR_RDERR:
		  case ERR_NODATA:
		    /* no data was sent from server, net closed */
		    FD_CLR(netfd,&fd_sav); /* remove net socket from set */
		    break;
		  case ERR_WRTERR:
		    /* sorry, write errors no handled yet */
		    break;
		  }
		
	      }
	  if (FD_ISSET(0,&fd))
	    {
	      NetworkDebug("Client data ready, calling client-pump");
	      rr2=clipump(netfd,enc);
	      NetworkDebug("Client-pump returns: %d",rr2);
	      switch(rr2)
		{
		case ERR_NOERROR:
		  break;
		case ERR_RDERR:
		case ERR_NODATA:
		  FD_CLR(0,&fd_sav);
		  break;
		case ERR_WRTERR:
		  break;
		}
	    } /* if data from stdin arrives */
	} /* if select returns nonzero status */
    } /* while */
  close(netfd);
  NetworkDebug("Exiting simple_gw()");
  return;
}


static enum GWerrors
simpleClientPipe(int netfd,encoding* enc)
{
  int dsize;
  NetworkDebug("clientPipe: before read");
  dsize=read(0,buf,cpBSIZE);
  NetworkDebug("%d bytes readed from client",dsize);
  if(dsize<0) return ERR_RDERR;
  if(dsize==0) return ERR_NODATA;

  if(enc)
    TranslateBuf(buf,dsize,enc->tablefrom);
  if(dsize!=write(netfd,buf,dsize)) 
    return ERR_WRTERR;
  return ERR_NOERROR;
}

static enum GWerrors
simpleServerPipe(int netfd, encoding *enc)
{
  int dsize;
  
  dsize=read(netfd,buf,cpBSIZE);
  NetworkDebug("%d bytes readed from server",dsize);
  if(dsize<0) return ERR_RDERR;
  if(dsize==0) return ERR_NODATA;

    
  if(enc) 
    TranslateBuf(buf,dsize,enc->tableto);
  if(dsize!=write(1,buf,dsize)) 
    return ERR_WRTERR;
  return ERR_NOERROR;
}


#define ENTLEN 256
#define skipspc(str)  { while(*str && isspace(*str))  str++; if(!*str) return;}
#define copyword(to,from) \
{\
  int  cnt = 0; \
  while(cnt < ENTLEN && *from && *from!=';' && !isspace(*from)) \
     {\
	*to++=*str++;\
        cnt++;\
     }\
     *to='\0';\
}



void 
parseContentType(char *str, char *ctype,char *charset, char *garbage)
{
  *ctype=*charset=*garbage='\0';
  skipspc(str);

  copyword(ctype,str);
  
  if(*str==';')str++;

  skipspc(str);

  if(strncasecmp(str,"charset=",8))
    {
      copyword(garbage,str);
      return;
    }
  
  str+=8;
  skipspc(str);

  copyword(charset,str);
  if(*str==';') str++;
  skipspc(str);
  copyword(garbage,str);
  return;
}

static enum GWerrors
EmailGateway (int fromfile,int tofile, char *charset, char *table, int changecharset )
{
  int blen;
  char ctype[ENTLEN],ocharset[ENTLEN],garbage[ENTLEN];
  
  if(!h_fgets(buf,cpBSIZE-1,fromfile,0))
    return  h_checkerr(fromfile)?ERR_RDERR:ERR_NODATA;
 next_string:
  blen = strlen(buf);
  if (blen==0) return ERR_NODATA;
  NetworkDebug("E-mail gateway: %d chars, %s",blen,buf); 
  if (table) TranslateBuf(buf,blen,table);
  if(changecharset)
    if(!strncasecmp(buf,"Content-Type:",13))
      {
	parseContentType(buf+13,ctype,ocharset,garbage);
	fprintf(stderr,"Content: %s, charset: %s\n",ctype,ocharset);
	if(!strcasecmp(ctype,"text/plain") && strcasecmp(ocharset,"us-ascii")
	   && strlen(garbage)==0)
	  {
	    fprintf(stderr,"Content: %s, charset: %s\n",ctype,ocharset);
	    sprintf(buf,"Content-Type: text/plain; charset=%s\n",charset);
	    blen = strlen(buf);
	  }
      }
  if(write(tofile, buf,blen)!=blen) return ERR_WRTERR;
  if(h_fgets(buf,cpBSIZE,fromfile,1))
    goto next_string;
  return  ERR_NOERROR;
} 



static enum GWerrors
popToClient(int netfd, encoding *enc)
{
  return EmailGateway(netfd,1,enc->clientcharset,enc->tableto,
		      enc->changecharset);
}

void 
PopGW (int netfd, encoding *enc, int timeout)
{
  simple_gw(netfd,simpleClientPipe,popToClient,enc,timeout);
}

static enum GWerrors
smtpFromClient(int netfd, encoding *enc)
{
  return EmailGateway(0,netfd,enc->servercharset,enc->tablefrom,
		      enc->changecharset);
}

void 
SmtpGW (int netfd, encoding *enc, int timeout)
{
  simple_gw(netfd,smtpFromClient,simpleServerPipe,enc,timeout);
}


void 
DefaultGW (int netfd, encoding *enc, int timeout)
{
  simple_gw(netfd,simpleClientPipe,simpleServerPipe,enc,timeout);
}

#ifdef TRANSPARENT_HOST

void  transparentGW(int netfd,encoding *enc, int timeout)
{
  simple_gw(netfd,simpleClientPipe,simpleServerPipe,NULL,timeout);
}
#endif



