/* $Id: bufio.c,v 1.3 1997/05/03 11:57:20 lexa Exp $ */
/* (C) 1997 Mike Shoyher msh@lexa.ru, msh@alina.ru  */

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/time.h>

#define min(a,b) (((a)<(b))?(a):(b))

#define BUFIO_BSIZE 2048

typedef struct _h_fbuf 
{
  char *buf;
  int handle;
  int size; /* buffer size */
  int iserr; /* -1 if read() has returned -1 */
  int fill; /* number of bytes currently in buffer */
  int ptr; /* index for next byte */
  void *chain;
} fbuffer;

static fbuffer *fblist = NULL;

fbuffer * makebuf(int fd)
{
  fbuffer *ret = malloc(sizeof(fbuffer));
  memset(ret,0,sizeof(fbuffer));
  ret->handle = fd;
  ret->buf=malloc(ret->size=BUFIO_BSIZE);
  return ret;
}

fbuffer *fd2buffer(int fd)
{
  fbuffer *f;
  if((f=fblist)==NULL)
    return fblist = makebuf(fd);
  
  while(1)
    {
      if(f->handle==fd)
	return f;
      if(!f->chain)
	return f->chain=makebuf(fd);
      f=f->chain;
    }
  /* not reached */
  return NULL;
}


void h_checksize(fbuffer *f, int size)
{
  if(f->size < size)
    f->buf = realloc(f->buf,f->size=size);
}

void h_movebuf(fbuffer *f)
{
  if(f->ptr==0) return;
  if(f->ptr==f->fill)
    { /* no data */
      f->ptr=f->fill=0;
      return;
    }
  memmove(f->buf,f->buf+f->ptr,f->fill-f->ptr);
  f->fill-=f->ptr;
  f->ptr=0;
}


int data_waiting(int hdl)
{
  fd_set fd;
  struct timeval tv;

  FD_ZERO(&fd);
  FD_SET(hdl,&fd);
  /* emulate poll */
  tv.tv_sec = 0; 
  tv.tv_usec=0;
  return select(hdl+1,&fd,NULL,NULL,&tv);
}




/*
    ,  '\n', 
  ,    (  size chars 
   '\n'.    - NULL
  checkselect = 0 - if we're _sure_ that data waiting (1st call after 
  select), 1 - overwise
      fgets -   ,
   checkselect = 1;  ,    
    ,    ,  
  select     -  
    ,  -  .  ,  
  h_fgets  simpleGW    checkselect ==0 ..
    select    .
*/

char *h_fgets(char *str, int size, int fd,int checkselect)
{
  fbuffer *f = fd2buffer(fd);
  char *p;
  int rc;
  size--; /* number of characters to be copied */
  h_movebuf(f);
  h_checksize(f,size);
 try_again:
  /* if '\n'-terminated string already exists in buffer ? */
  p = (char*)memchr(f->buf,'\n',f->fill);
  
  if(p)
    {
      int len=p-f->buf+1;
      if(len > size) len = size;
      memcpy(str,f->buf,len);
      str[len]=0;
      f->ptr = len;
      h_movebuf(f);
      return str;
    }
  /* if buffer contains at least size characters ? */
  if(f->fill >= size)
    {
      int len=f->fill;
      if(len > size) len = size;
      memcpy(str,f->buf,len);
      str[len]=0;
      f->ptr = len;
      h_movebuf(f);
      return str;
    }
  /* we must read something into buffer */
  if(checkselect)
    {
      rc=data_waiting(f->handle);
      if(rc==-1) f->iserr = 1;
      if(rc <= 0) return NULL; /* no data ready */
    }
  rc = read(f->handle,f->buf+f->fill,f->size-f->fill);
  if(rc==-1) f->iserr = 1;
  if(rc <= 0) return NULL; /* no data readed */
  f->fill+=rc;
  checkselect = 1;
  goto try_again;
}

int h_checkerr(int handle)
{
  fbuffer *f=fd2buffer(handle);
  return f->iserr;
}

/* copy all buffered data to user level */
int 
h_read(int handle_from,char *buf, int size)
{
  int len;
  fbuffer *f = fd2buffer(handle_from);
  if(f->fill==0){ 
    return read(handle_from,buf,size);
  } 
  h_movebuf(f);
  len = min(f->fill,size);
  memcpy(buf,f->buf,len);
  f->ptr+=len;
  return len;
}






	
