#
# Copyright (c) 2000-2003 MAEKAWA Masahide <maekawa@cvsync.org>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. Neither the name of the author nor the names of its contributors
#    may be used to endorse or promote products derived from this software
#    without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

ifeq (${HOST_OS}, NetBSD)
ifeq ($(shell ${TEST} ${OSVER} -lt 106130000 && ${ECHO} yes), yes) # 1.6M
PTHREAD_TYPE   ?= none
endif # 1.6M
endif # NetBSD

PTHREAD_TYPE   ?= native

CFLAGS += -D_REENTRANT -D_THREAD_SAFE

ifeq (${PTHREAD_TYPE}, native) # native POSIX thread

ifeq (${HOST_OS}, AIX)
LIBS   += -lpthreads
endif # AIX

ifeq (${HOST_OS}, CYGWIN)
LIBS   += -lpthread
endif # CYGWIN

ifeq (${HOST_OS}, FreeBSD)
ifeq ($(shell ${TEST} ${OSVER} -lt 500016 && ${ECHO} yes), yes)
LDFLAGS+= -pthread
else # 500016
LIBS   += -lc_r
endif # 500016
endif # FreeBSD

ifeq (${HOST_OS}, Linux)
LIBS   += -lpthread
endif # Linux

ifeq (${HOST_OS}, NetBSD)
LIBS   += -lpthread
endif # NetBSD

ifeq (${HOST_OS}, OpenBSD)
CFLAGS += -pthread
LDFLAGS+= -pthread
endif # OpenBSD

ifeq (${HOST_OS}, SunOS)
LIBS   += -lpthread -lrt
endif # SunOS

endif # native POSIX thread

PTHREAD_PREFIX ?= ${PREFIX}

ifeq (${PTHREAD_TYPE}, pth) # GNU Pth
PTH_CFLAGS := $(shell ${PTHREAD_PREFIX}/bin/pthread-config --cflags)
PTH_LDFLAGS:= $(shell ${PTHREAD_PREFIX}/bin/pthread-config --ldflags)
PTH_LIBS   := $(shell ${PTHREAD_PREFIX}/bin/pthread-config --libs)

CFLAGS += ${PTH_CFLAGS}
LDFLAGS+= ${PTH_LDFLAGS}
LIBS   += ${PTH_LIBS}
endif # GNU Pth

ifeq (${PTHREAD_TYPE}, ptl) # PTL
CC	= ${PTHREAD_PREFIX}/bin/ptlgcc
CFLAGS += -I${PTHREAD_PREFIX}/PTL/include
LDFLAGS+= -L${PTHREAD_PREFIX}/lib
LIBS   += -lPTL
endif # PTL

ifeq (${PTHREAD_TYPE}, unproven) # unproven pthreads
CC	= ${PTHREAD_PREFIX}/pthreads/bin/pgcc
CFLAGS += -I${PTHREAD_PREFIX}/pthreads/include
LDFLAGS+= -L${PTHREAD_PREFIX}/pthreads/lib
LIBS   += -lpthread
endif # unproven pthreads

ifeq (${PTHREAD_TYPE}, none) # no POSIX threads support
pthread-error:
	@${ECHO} "WARNING! Please specify the PTHREAD_TYPE."
	@${ECHO} "The following types are available:"
	@${ECHO} "  native (default)"
	@${ECHO} "  pth"
	@${ECHO} "  ptl"
	@${ECHO} "  unproven"
	@exit 1;
endif # none
