/*-
 * Copyright (c) 2000-2003 MAEKAWA Masahide <maekawa@cvsync.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef CVSYNC_NAME_MAX
#if defined(__APPLE__) || defined(__FreeBSD__) || defined(__NetBSD__) || \
    defined(__OpenBSD__)
#define	CVSYNC_NAME_MAX		NAME_MAX
#else /* __APPLE__ || __FreeBSD__ || __NetBSD__ || __OpenBSD__ */
#define	CVSYNC_NAME_MAX		255
#endif /* __APPLE__ || __FreeBSD__ || __NetBSD__ || __OpenBSD__ */
#endif /* CVSYNC_NAME_MAX */

#ifndef CVSYNC_PATH_DEV_NULL
#if defined(__CYGWIN__)
#define	CVSYNC_PATH_DEV_NULL	NULL
#endif /* __CYGWIN__ */
#if defined(__sun)
#define	CVSYNC_PATH_DEV_NULL	"/dev/null"
#endif /* defined(__sun) */
#endif /* CVSYNC_PATH_DEV_NULL */
#ifndef CVSYNC_PATH_DEV_NULL
#include <paths.h>
#define	CVSYNC_PATH_DEV_NULL	_PATH_DEVNULL
#endif /* CVSYNC_PATH_DEV_NULL */

#ifndef DIRENT_NAMLEN
#if defined(_AIX) || defined(__APPLE__) || defined(__FreeBSD__) || \
    defined(__NetBSD__) || defined(__OpenBSD__)
#define	DIRENT_NAMLEN(p)	((p)->d_namlen)
#else /* _AIX || __APPLE__ ||  __FreeBSD__ || __NetBSD__ || __OpenBSD__ */
#define	DIRENT_NAMLEN(p)	(strlen((p)->d_name))
#endif /* _AIX || __APPLE__ || __FreeBSD__ || __NetBSD__ || __OpenBSD__ */
#endif /* DIRENT_NAMLEN */

#if defined(__bsdi__)
#ifdef SIG_IGN
#undef SIG_IGN
#define	SIG_IGN		((void (*)(int))1)
#endif /* SIG_IGN */
#endif /* defined(__bsdi__) */

#if defined(NO_PROTOTYPE_FCHMOD)
int fchmod(int, mode_t);
#endif /* defined(NO_PROTOTYPE_FCHMOD) */
#if defined(NO_PROTOTYPE_SETEGID)
int setegid(gid_t);
#endif /* defined(NO_PROTOTYPE_SETEGID) */
#if defined(NO_PROTOTYPE_SETEUID)
int seteuid(uid_t);
#endif /* defined(NO_PROTOTYPE_SETEUID) */
