#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifndef HAVE_LIBZ
/*
 * NEVER EVER edit this manually, fix the mkhelp.pl script instead!
 * Generation time: Mon Apr 26 08:08:53 2004
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef USE_MANUAL
#include "hugehelp.h"
#include <stdio.h>
void hugehelp(void)
{
   fputs(
"                                  _   _ ____  _     \n"
"  Project                     ___| | | |  _ \\| |    \n"
"                             / __| | | | |_) | |    \n"
"                            | (__| |_| |  _ <| |___ \n"
"                             \\___|\\___/|_| \\_\\_____|\n"
"\n"
"NAME\n"
"       curl - transfer a URL\n"
"\n"
"SYNOPSIS\n"
"       curl [options] [URL...]\n"
"\n"
"DESCRIPTION\n"
"       curl is a tool to transfer data from or to a server, using\n"
"       one of the supported protocols (HTTP,  HTTPS,  FTP,  FTPS,\n"
, stdout);
 fputs(
"       GOPHER,  DICT,  TELNET,  LDAP  or  FILE).  The  command is\n"
"       designed to work without user interaction.\n"
"\n"
"       curl offers a busload of useful tricks like proxy support,\n"
"       user  authentication,  ftp upload, HTTP post, SSL (https:)\n"
"       connections, cookies, file transfer resume  and  more.  As\n"
"       you  will see below, the amount of features will make your\n"
"       head spin!\n"
"\n"
"       curl is powered by libcurl for all  transfer-related  fea\n"
, stdout);
 fputs(
"       tures. See libcurl(3) for details.\n"
"\n"
"URL\n"
"       The  URL  syntax  is  protocol  dependent.  You'll  find a\n"
"       detailed description in RFC 2396.\n"
"\n"
"       You can specify multiple URLs or parts of URLs by  writing\n"
"       part sets within braces as in:\n"
"\n"
"        http://site.{one,two,three}.com\n"
"\n"
"       or  you  can get sequences of alphanumeric series by using\n"
"       [] as in:\n"
"\n"
"        ftp://ftp.numericals.com/file[1-100].txt\n"
"        ftp://ftp.numericals.com/file[001-100].txt    (with lead\n"
, stdout);
 fputs(
"       ing zeros)\n"
"        ftp://ftp.letters.com/file[a-z].txt\n"
"\n"
"       No nesting of the sequences is supported at the moment:\n"
"\n"
"        http://www.any.org/archive[1996-1999]/vol\n"
"       ume[1-4]part{a,b,c,index}.html\n"
"\n"
"       You can specify any amount of URLs on  the  command  line.\n"
"       They  will be fetched in a sequential manner in the speci\n"
"       fied order.\n"
"\n"
"       Curl will attempt to re-use connections for multiple  file\n"
, stdout);
 fputs(
"       transfers, so that getting many files from the same server\n"
"       will not do multiple connects / handshakes. This  improves\n"
"       speed. Of course this is only done on files specified on a\n"
"       single command line and cannot be  used  between  separate\n"
"       curl invokes.\n"
"\n"
"OPTIONS\n"
"       -a/--append\n"
"              (FTP)  When  used  in an FTP upload, this will tell\n"
"              curl to append to the target file instead of  over\n"
, stdout);
 fputs(
"              writing  it.  If the file doesn't exist, it will be\n"
"              created.\n"
"\n"
"              If this option is used twice, the second  one  will\n"
"              disable append mode again.\n"
"\n"
"       -A/--user-agent <agent string>\n"
"              (HTTP) Specify the User-Agent string to send to the\n"
"              HTTP server. Some badly done CGIs fail if  its  not\n"
"              set  to  \"Mozilla/4.0\".   To  encode  blanks in the\n"
"              string,  surround  the  string  with  single  quote\n"
, stdout);
 fputs(
"              marks.   This  can also be set with the -H/--header\n"
"              option of course.\n"
"\n"
"              If this option is set more than once, the last  one\n"
"              will be the one that's used.\n"
"\n"
"       --anyauth\n"
"              (HTTP)  Tells  curl  to  figure  out authentication\n"
"              method by itself, and use the most secure  one  the\n"
"              remote  site  claims  it  supports. This is done by\n"
"              first doing a request and  checking  the  response-\n"
, stdout);
 fputs(
"              headers, thus inducing an extra network round-trip.\n"
"              This is used instead of setting a specific  authen\n"
"              tication  method,  which  you  can do with --basic,\n"
"              --digest,  --ntlm,  and  --negotiate.   (Added   in\n"
"              7.10.6)\n"
"\n"
"              If this option is used several times, the following\n"
"              occurrences make no difference.\n"
"\n"
"       -b/--cookie <name=data>\n"
"              (HTTP) Pass the  data  to  the  HTTP  server  as  a\n"
, stdout);
 fputs(
"              cookie.   It  is  supposedly  the  data  previously\n"
"              received from the server in a  \"Set-Cookie:\"  line.\n"
"              The  data  should  be  in the format \"NAME1=VALUE1;\n"
"              NAME2=VALUE2\".\n"
"\n"
"              If no '=' letter is used in the line, it is treated\n"
"              as  a  filename  to  use  to read previously stored\n"
"              cookie lines from, which should  be  used  in  this\n"
"              session if they match. Using this method also acti\n"
, stdout);
 fputs(
"              vates the \"cookie  parser\"  which  will  make  curl\n"
"              record  incoming cookies too, which may be handy if\n"
"              you're  using  this   in   combination   with   the\n"
"              -L/--location  option.  The file format of the file\n"
"              to read cookies from should be plain  HTTP  headers\n"
"              or the Netscape/Mozilla cookie file format.\n"
"\n"
"              NOTE  that  the  file specified with -b/--cookie is\n"
, stdout);
 fputs(
"              only used as input. No cookies will  be  stored  in\n"
"              the file. To store cookies, use the -c/--cookie-jar\n"
"              option or you could even save the HTTP headers to a\n"
"              file using -D/--dump-header!\n"
"\n"
"              If  this option is set more than once, the last one\n"
"              will be the one that's used.\n"
"\n"
"       -B/--use-ascii\n"
"              Use ASCII transfer when getting an FTP file or LDAP\n"
, stdout);
 fputs(
"              info.  For  FTP, this can also be enforced by using\n"
"              an URL that ends with \";type=A\". This option causes\n"
"              data  sent  to  stdout to be in text mode for win32\n"
"              systems.\n"
"\n"
"              If this option is used twice, the second  one  will\n"
"              disable ASCII usage.\n"
"\n"
"       --basic\n"
"              (HTTP) Tells curl to use HTTP Basic authentication.\n"
"              This is the default  and  this  option  is  usually\n"
, stdout);
 fputs(
"              pointless,  unless  you use it to override a previ\n"
"              ously set option that sets a different  authentica\n"
"              tion method (such as --ntlm, --digest and --negoti\n"
"              ate). (Added in 7.10.6)\n"
"\n"
"              If this option is used several times, the following\n"
"              occurrences make no difference.\n"
"\n"
"       --ciphers <list of ciphers>\n"
"              (SSL) Specifies which ciphers to use in the connec\n"
, stdout);
 fputs(
"              tion. The list  of  ciphers  must  be  using  valid\n"
"              ciphers. Read up on SSL cipher list details on this\n"
"              URL: http://www.openssl.org/docs/apps/ciphers.html\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will override the others.\n"
"\n"
"       --compressed\n"
"              (HTTP)  Request  a compressed response using one of\n"
"              the algorithms libcurl  supports,  and  return  the\n"
, stdout);
 fputs(
"              uncompressed  document.  If this option is used and\n"
"              the server sends an unsupported encoding, Curl will\n"
"              report an error.\n"
"\n"
"              If  this  option is used several times, each occur\n"
"              rence will toggle it on/off.\n"
"\n"
"       --connect-timeout <seconds>\n"
"              Maximum time in seconds that you allow the  connec\n"
"              tion  to  the server to take.  This only limits the\n"
, stdout);
 fputs(
"              connection phase,  once  curl  has  connected  this\n"
"              option  is  of no more use. See also the --max-time\n"
"              option.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -c/--cookie-jar <file name>\n"
"              Specify  to  which  file you want curl to write all\n"
"              cookies after a completed  operation.  Curl  writes\n"
"              all  cookies  previously read from a specified file\n"
, stdout);
 fputs(
"              as  well  as  all  cookies  received  from   remote\n"
"              server(s). If no cookies are known, no file will be\n"
"              written.  The  file  will  be  written  using   the\n"
"              Netscape  cookie  file  format. If you set the file\n"
"              name to a single dash, \"-\",  the  cookies  will  be\n"
"              written to stdout.\n"
"\n"
"              NOTE  If the cookie jar can't be created or written\n"
"              to, the whole curl operation  won't  fail  or  even\n"
, stdout);
 fputs(
"              report  an error clearly. Using -v will get a warn\n"
"              ing displayed, but that is the only  visible  feed\n"
"              back  you get about this possibly lethal situation.\n"
"              If this option is  used  several  times,  the  last\n"
"              specfied file name will be used.\n"
"\n"
"       -C/--continue-at <offset>\n"
"              Continue/Resume  a  previous  file  transfer at the\n"
"              given offset. The given offset is the exact  number\n"
, stdout);
 fputs(
"              of  bytes  that  will  be  skipped counted from the\n"
"              beginning of the source file before  it  is  trans\n"
"              fered  to  the  destination.  If used with uploads,\n"
"              the ftp server command SIZE will  not  be  used  by\n"
"              curl.\n"
"\n"
"              Use  \"-C  -\" to tell curl to automatically find out\n"
"              where/how to resume the transfer. It then uses  the\n"
"              given output/input files to figure that out.\n"
"\n"
, stdout);
 fputs(
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"       --create-dirs\n"
"              When used in conjunction with the -o  option,  curl\n"
"              will create the necessary local directory hierarchy\n"
"              as needed.\n"
"\n"
"       --crlf (FTP) Convert LF to CRLF in upload. Useful for  MVS\n"
"              (OS/390).\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable crlf converting.\n"
"\n"
"       -d/--data <data>\n"
, stdout);
 fputs(
"              (HTTP) Sends the specified data in a  POST  request\n"
"              to the HTTP server, in a way that can emulate as if\n"
"              a user has filled in a HTML form  and  pressed  the\n"
"              submit  button.  Note that the data is sent exactly\n"
"              as specified with no  extra  processing  (with  all\n"
"              newlines  cut  off).   The  data  is expected to be\n"
"              \"url-encoded\". This will cause  curl  to  pass  the\n"
, stdout);
 fputs(
"              data  to the server using the content-type applica\n"
"              tion/x-www-form-urlencoded. Compare  to  -F/--form.\n"
"              If  this  option is used more than once on the same\n"
"              command line, the data  pieces  specified  will  be\n"
"              merged  together  with a separating &-letter. Thus,\n"
"              using '-d name=daniel -d skill=lousy' would  gener\n"
"              ate     a    post    chunk    that    looks    like\n"
, stdout);
 fputs(
"              'name=daniel&skill=lousy'.\n"
"\n"
"              If you start the data with the letter @,  the  rest\n"
"              should  be  a file name to read the data from, or -\n"
"              if you want curl to read the data from stdin.   The\n"
"              contents  of  the file must already be url-encoded.\n"
"              Multiple files can also be specified. Posting  data\n"
"              from  a file named 'foobar' would thus be done with\n"
"              --data @foobar\".\n"
"\n"
, stdout);
 fputs(
"              To post data purely binary, you should instead  use\n"
"              the --data-binary option.\n"
"\n"
"              -d/--data is the same as --data-ascii.\n"
"\n"
"              If this option is used several times, the ones fol\n"
"              lowing the first will append data.\n"
"\n"
"       --data-ascii <data>\n"
"              (HTTP) This is an alias for the -d/--data option.\n"
"\n"
"              If this option is used several times, the ones fol\n"
"              lowing the first will append data.\n"
"\n"
, stdout);
 fputs(
"       --data-binary <data>\n"
"              (HTTP)  This  posts  data  in  a  similar manner as\n"
"              --data-ascii does, although when using this  option\n"
"              the  entire  context of the posted data is kept as-\n"
"              is. If you want to post a binary file  without  the\n"
"              strip-newlines  feature of the --data-ascii option,\n"
"              this is for you.\n"
"\n"
"              If this option is used several times, the ones fol\n"
, stdout);
 fputs(
"              lowing the first will append data.\n"
"\n"
"       --digest\n"
"              (HTTP)  Enables HTTP Digest authentication. This is\n"
"              a authentication that prevents  the  password  from\n"
"              being sent over the wire in clear text. Use this in\n"
"              combination with the normal -u/--user option to set\n"
"              user  name and password. See also --ntlm, --negoti\n"
"              ate and --anyauth for related  options.  (Added  in\n"
"              curl 7.10.6)\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the following\n"
"              occurrences make no difference.\n"
"\n"
"       --disable-eprt\n"
"              (FTP) Tell curl to disable the use of the EPRT  and\n"
"              LPRT commands when doing active FTP transfers. Curl\n"
"              will normally always first  attempt  to  use  EPRT,\n"
"              then  LPRT before using PORT, but with this option,\n"
"              it will use PORT right  away.  EPRT  and  LPRT  are\n"
, stdout);
 fputs(
"              extensions  to  the  original FTP protocol, may not\n"
"              work on all servers but enable  more  functionality\n"
"              in  a better way than the traditional PORT command.\n"
"              (Aded in 7.10.5)\n"
"\n"
"              If this option is used several times,  each  occur\n"
"              rence will toggle this on/off.\n"
"\n"
"       --disable-epsv\n"
"              (FTP) Tell curl to disable the use of the EPSV com\n"
"              mand when doing passive FTP  transfers.  Curl  will\n"
, stdout);
 fputs(
"              normally  always  first  attempt to use EPSV before\n"
"              PASV, but with this option, it will not  try  using\n"
"              EPSV.\n"
"\n"
"              If  this  option is used several times, each occur\n"
"              rence will toggle this on/off.\n"
"\n"
"       -D/--dump-header <file>\n"
"              Write the protocol headers to the specified file.\n"
"\n"
"              This option is handy to use when you want to  store\n"
"              the  headers that a HTTP site sends to you. Cookies\n"
, stdout);
 fputs(
"              from the headers could then be  read  in  a  second\n"
"              curl  invoke  by  using the -b/--cookie option! The\n"
"              -c/--cookie-jar option is however a better  way  to\n"
"              store cookies.\n"
"\n"
"              When used on FTP, the ftp server response lines are\n"
"              considered  being  \"headers\"  and  thus  are  saved\n"
"              there.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
, stdout);
 fputs(
"       -e/--referer <URL>\n"
"              (HTTP) Sends the \"Referer Page\" information to  the\n"
"              HTTP   server.  This  can  also  be  set  with  the\n"
"              -H/--header  flag  of  course.   When   used   with\n"
"              -L/--location you can append \";auto\" to the referer\n"
"              URL to make curl automatically set the previous URL\n"
"              when  it  follows  a  Location: header. The \";auto\"\n"
"              string can be used alone, even if you don't set  an\n"
, stdout);
 fputs(
"              initial referer.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"       --environment\n"
"              (RISC OS ONLY) Sets a range  of  environment  vari\n"
"              ables,  using  the names the -w option supports, to\n"
"              easier allow extraction of useful information after\n"
"              having run curl.\n"
"\n"
"              If  this  option is used several times, each occur\n"
"              rence will toggle this on/off.\n"
"\n"
, stdout);
 fputs(
"       --egd-file <file>\n"
"              (HTTPS) Specify the path name to the Entropy  Gath\n"
"              ering Daemon socket. The socket is used to seed the\n"
"              random engine for SSL  connections.  See  also  the\n"
"              --random-file option.\n"
"\n"
"       -E/--cert <certificate[:password]>\n"
"              (HTTPS) Tells curl to use the specified certificate\n"
"              file when getting a file with HTTPS.  The  certifi\n"
"              cate  must be in PEM format.  If the optional pass\n"
, stdout);
 fputs(
"              word isn't specified, it will be queried for on the\n"
"              terminal. Note that this certificate is the private\n"
"              key and the private certificate concatenated!\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       --cert-type <type>\n"
"              (SSL) Tells curl what certificate type the provided\n"
"              certificate is in. PEM, DER and ENG are  recognized\n"
"              types.\n"
"\n"
, stdout);
 fputs(
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       --cacert <CA certificate>\n"
"              (HTTPS) Tells curl to use the specified certificate\n"
"              file  to verify the peer. The file may contain mul\n"
"              tiple CA certificates. The certificate(s)  must  be\n"
"              in PEM format.\n"
"\n"
"              curl  recognizes  the  environment  variable  named\n"
"              'CURL_CA_BUNDLE' if that is set, and uses the given\n"
, stdout);
 fputs(
"              path  as  a  path  to a CA cert bundle. This option\n"
"              overrides that variable.\n"
"\n"
"              The windows version of curl will automatically look\n"
"              for  a  CA  certs  file named curl-ca-bundle.crt,\n"
"              either in the same directory as curl.exe, or in the\n"
"              Current  Working  Directory, or in any folder along\n"
"              your PATH.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
, stdout);
 fputs(
"       --capath <CA certificate directory>\n"
"              (HTTPS) Tells curl to use the specified certificate\n"
"              directory to verify the peer. The certificates must\n"
"              be  in PEM format, and the directory must have been\n"
"              processed using the c_rehash utility supplied  with\n"
"              openssl.  Using  --capath  can  allow  curl to make\n"
"              https connections much more efficiently than  using\n"
, stdout);
 fputs(
"              --cacert if the --cacert file contains many CA cer\n"
"              tificates.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -f/--fail\n"
"              (HTTP)  Fail  silently (no output at all) on server\n"
"              errors. This is mostly done  like  this  to  better\n"
"              enable  scripts  etc  to  better  deal  with failed\n"
"              attempts. In normal cases when a HTTP server  fails\n"
, stdout);
 fputs(
"              to  deliver  a document, it returns a HTML document\n"
"              stating so (which  often  also  describes  why  and\n"
"              more).  This flag will prevent curl from outputting\n"
"              that and fail silently instead.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable silent failure.\n"
"\n"
"       --ftp-create-dirs\n"
"              (FTP)  When  an  FTP URL/operation uses a path that\n"
, stdout);
 fputs(
"              doesn't currently exist on the server, the standard\n"
"              behavior  of  curl  is  to fail. Using this option,\n"
"              curl will instead attempt to create missing  direc\n"
"              tories. (Added in 7.10.7)\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable silent failure.\n"
"\n"
"       --ftp-pasv\n"
"              (FTP) Use PASV when transfering. PASV is the inter\n"
"              nal  default behavior, but using this option can be\n"
, stdout);
 fputs(
"              used  to  override  a  previos  --ftp-port  option.\n"
"              (Added in 7.11.0)\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable silent failure.\n"
"\n"
"       --ftp-ssl\n"
"              (FTP)  Make  the  FTP  connection  switch  to   use\n"
"              SSL/TLS. (Added in 7.11.0)\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable silent failure.\n"
"\n"
"       -F/--form <name=content>\n"
, stdout);
 fputs(
"              (HTTP) This lets curl emulate a filled in  form  in\n"
"              which  a  user  has pressed the submit button. This\n"
"              causes curl to POST  data  using  the  content-type\n"
"              multipart/form-data   according  to  RFC1867.  This\n"
"              enables uploading of binary files etc. To force the\n"
"              'content'  part  to  be  be a file, prefix the file\n"
"              name with an @ sign. To just get the  content  part\n"
, stdout);
 fputs(
"              from  a  file, prefix the file name with the letter\n"
"              <. The difference between @ and < is  then  that  @\n"
"              makes  a  file  get  attached in the post as a file\n"
"              upload, while the < makes a text field and just get\n"
"              the contents for that text field from a file.\n"
"\n"
"              Example,  to send your password file to the server,\n"
"              where 'password' is the name of the  form-field  to\n"
, stdout);
 fputs(
"              which /etc/passwd will be the input:\n"
"\n"
"              curl -F password=@/etc/passwd www.mypasswords.com\n"
"\n"
"              To  read  the file's content from stdin insted of a\n"
"              file, use - where the  file  name  should've  been.\n"
"              This goes for both @ and < constructs.\n"
"\n"
"              You can also tell curl what Content-Type to use for\n"
"              the file upload part, by using 'type=', in a manner\n"
"              similar to:\n"
"\n"
, stdout);
 fputs(
"              curl -F \"web=@index.html;type=text/html\" url.com\n"
"\n"
"              See further examples and details in the MANUAL.\n"
"\n"
"              This option can be used multiple times.\n"
"\n"
"       -g/--globoff\n"
"              This option switches off the \"URL globbing parser\".\n"
"              When you set this option, you can specify URLs that\n"
"              contain  the letters {}[] without having them being\n"
"              interpreted by curl itself. Note that these letters\n"
, stdout);
 fputs(
"              are  not  normal legal URL contents but they should\n"
"              be encoded according to the URI standard.\n"
"\n"
"       -G/--get\n"
"              When used, this option will make all data specified\n"
"              with  -d/--data  or  --data-binary  to be used in a\n"
"              HTTP GET request instead of the POST  request  that\n"
"              otherwise  would be used. The data will be appended\n"
"              to the URL with a '?'  separator.\n"
"\n"
, stdout);
 fputs(
"              If used in combination with -I, the POST data  will\n"
"              instead be appended to the URL with a HEAD request.\n"
"\n"
"              If used multiple times, nothing special happens.\n"
"\n"
"       -h/--help\n"
"              Usage help.\n"
"\n"
"       -H/--header <header>\n"
"              (HTTP) Extra header to use when getting a web page.\n"
"              You  may  specify any number of extra headers. Note\n"
"              that if you should add a custom header that has the\n"
, stdout);
 fputs(
"              same  name  as  one of the internal ones curl would\n"
"              use,  your  externally  set  header  will  be  used\n"
"              instead  of  the  internal  one. This allows you to\n"
"              make even trickier stuff than curl  would  normally\n"
"              do.  You  should not replace internally set headers\n"
"              without knowing perfectly well what  you're  doing.\n"
"              Replacing  an internal header with one without con\n"
, stdout);
 fputs(
"              tent on the right side of the  colon  will  prevent\n"
"              that header from appearing.\n"
"\n"
"              See   also  the  -A/--user-agent  and  -e/--referer\n"
"              options.\n"
"\n"
"              This  option  can  be  used   multiple   times   to\n"
"              add/replace/remove multiple headers.\n"
"\n"
"       -i/--include\n"
"              (HTTP)  Include  the HTTP-header in the output. The\n"
"              HTTP-header includes things like server-name,  date\n"
, stdout);
 fputs(
"              of the document, HTTP-version and more...\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable header include.\n"
"\n"
"       --interface <name>\n"
"              Perform an operation using a  specified  interface.\n"
"              You  can  enter  interface name, IP address or host\n"
"              name. An example could look like:\n"
"\n"
"               curl --interface eth0:1 http://www.netscape.com/\n"
"\n"
"              If this option is used several times, the last  one\n"
, stdout);
 fputs(
"              will be used.\n"
"\n"
"       -I/--head\n"
"              (HTTP/FTP/FILE)  Fetch  the HTTP-header only! HTTP-\n"
"              servers feature the command HEAD which this uses to\n"
"              get nothing but the header of a document. When used\n"
"              on a FTP or FILE file, curl displays the file  size\n"
"              and last modification time only.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable header only.\n"
"\n"
"       -j/--junk-session-cookies\n"
, stdout);
 fputs(
"              (HTTP) When curl is told to  read  cookies  from  a\n"
"              given  file,  this  option will make it discard all\n"
"              \"session cookies\". This will basicly have the  same\n"
"              effect  as  if  a  new  session is started. Typical\n"
"              browsers  always  discard  session   cookies   when\n"
"              they're closed down. (Added in 7.9.7)\n"
"\n"
"              If  this  option is used several times, each occur\n"
"              rence will toggle this on/off.\n"
"\n"
, stdout);
 fputs(
"       -k/--insecure\n"
"              (SSL) This option explicitly allows curl to perform\n"
"              \"insecure\"  SSL connections and transfers. Starting\n"
"              with  curl  7.10,  all  SSL  connections  will   be\n"
"              attempted  to  be  made secure by using the CA cer\n"
"              tificate bundle installed by  default.  This  makes\n"
"              all   connections  considered  \"insecure\"  to  fail\n"
"              unless -k/--insecure is used.\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice, the second time  will\n"
"              again disable it.\n"
"\n"
"       --key <key>\n"
"              (SSL)  Private key file name. Allows you to provide\n"
"              your private key in this separate file.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       --key-type <type>\n"
"              (SSL)  Private  key  file  type. Specify which type\n"
"              your --key provided private key is.  DER,  PEM  and\n"
, stdout);
 fputs(
"              ENG are supported.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       --krb4 <level>\n"
"              (FTP) Enable kerberos4 authentication and use.  The\n"
"              level must be entered and should be one of 'clear',\n"
"              'safe', 'confidential' or 'private'. Should you use\n"
"              a  level  that  is not one of these, 'private' will\n"
"              instead be used.\n"
"\n"
, stdout);
 fputs(
"              This option requiures that the  library  was  built\n"
"              with  kerberos4  support.  This is not very common.\n"
"              Use -V/--version to see if your curl supports it.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -K/--config <config file>\n"
"              Specify  which  config  file to read curl arguments\n"
"              from. The config file is a text file in which  com\n"
, stdout);
 fputs(
"              mand  line arguments can be written which then will\n"
"              be used as if they were written on the actual  com\n"
"              mand  line.  Options  and  their parameters must be\n"
"              specified on the same  config  file  line.  If  the\n"
"              parameter is to contain white spaces, the parameter\n"
"              must be inclosed within quotes.  If the first  col\n"
"              umn  of  a config line is a '#' character, the rest\n"
, stdout);
 fputs(
"              of the line will be treated as a comment.\n"
"\n"
"              Specify the filename as '-' to make curl  read  the\n"
"              file from stdin.\n"
"\n"
"              Note that to be able to specify a URL in the config\n"
"              file, you  need  to  specify  it  using  the  --url\n"
"              option,  and  not  by simply writing the URL on its\n"
"              own line. So, it could look similar to this:\n"
"\n"
"              url = \"http://curl.haxx.se/docs/\"\n"
"\n"
, stdout);
 fputs(
"              This option can be used multiple times.\n"
"\n"
"       --limit-rate <speed>\n"
"              Specify the maximum transfer rate you want curl  to\n"
"              use.  This  feature is useful if you have a limited\n"
"              pipe and you'd like  your  transfer  not  use  your\n"
"              entire bandwidth.\n"
"\n"
"              The given speed is measured in bytes/second, unless\n"
"              a suffix is appended.  Appending 'k'  or  'K'  will\n"
, stdout);
 fputs(
"              count  the  number as kilobytes, 'm' or M' makes it\n"
"              megabytes while 'g'  or  'G'  makes  it  gigabytes.\n"
"              Examples: 200K, 3m and 1G.\n"
"\n"
"              If  you are also using the -Y/--speed-limit option,\n"
"              that option will take precedence and might  cripple\n"
"              the  rate-limiting  slightly,  to  help keeping the\n"
"              speed-limit logic working.\n"
"\n"
"              This option was introduced in curl 7.10.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -l/--list-only\n"
"              (FTP)  When  listing  an FTP directory, this switch\n"
"              forces a name-only view.  Especially useful if  you\n"
"              want to machine-parse the contents of an FTP direc\n"
"              tory since the normal directory view doesn't use  a\n"
"              standard look or format.\n"
"\n"
"              This  option causes an FTP NLST command to be sent.\n"
, stdout);
 fputs(
"              Some FTP servers list only files in their  response\n"
"              to  NLST;  they  do  not include subdirectories and\n"
"              symbolic links.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable list only.\n"
"\n"
"       -L/--location\n"
"              (HTTP/HTTPS)   If   the  server  reports  that  the\n"
"              requested page has a different location  (indicated\n"
"              with  the header line Location:) this flag will let\n"
, stdout);
 fputs(
"              curl attempt to reattempt the get on the new place.\n"
"              If  used  together  with -i/--include or -I/--head,\n"
"              headers from all requested pages will be shown.  If\n"
"              authentication  is  used,  curl  will only send its\n"
"              credentials to the initial host, so if  a  redirect\n"
"              takes  curl to a different host, it won't intercept\n"
"              the user+password. See also  --location-trusted  on\n"
"              how to change this.\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice, the second will again\n"
"              disable location following.\n"
"\n"
"       --location-trusted\n"
"              (HTTP/HTTPS) Like  -L/--location,  but  will  allow\n"
"              sending  the  name + password to all hosts that the\n"
"              site may redirect to. This may or may not introduce\n"
"              a  security  breach  if the site redirects you do a\n"
"              site to which you'll send your authentication  info\n"
, stdout);
 fputs(
"              (which  is  plaintext  in  the  case  of HTTP Basic\n"
"              authentication).\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable location following.\n"
"\n"
"       --max-filesize <bytes>\n"
"              Specify  the  maximum  size (in bytes) of a file to\n"
"              download. If the file requested is larger than this\n"
"              value,  the  transfer  will not start and curl will\n"
"              return with exit code 63.\n"
"\n"
, stdout);
 fputs(
"              NOTE: The file size is not always  known  prior  to\n"
"              download,  and  for  such  files this option has no\n"
"              effect even if the  file  transfer  ends  up  being\n"
"              larger  than  this  given limit. This concerns both\n"
"              FTP and HTTP transfers.\n"
"       -m/--max-time <seconds>\n"
"              Maximum time in seconds that you  allow  the  whole\n"
"              operation  to  take.  This is useful for preventing\n"
, stdout);
 fputs(
"              your batch jobs from hanging for hours due to  slow\n"
"              networks  or  links  going down.  This doesn't work\n"
"              fully in win32 systems.  See  also  the  --connect-\n"
"              timeout option.\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       -M/--manual\n"
"              Manual. Display the huge help text.\n"
"\n"
"       -n/--netrc\n"
"              Makes curl scan the .netrc file in the user's  home\n"
, stdout);
 fputs(
"              directory for login name and password. This is typ\n"
"              ically used for ftp on unix.  If  used  with  http,\n"
"              curl  will enable user authentication. See netrc(4)\n"
"              or ftp(1) for details on the file format. Curl will\n"
"              not  complain if that file hasn't the right permis\n"
"              sions (it should not be world nor group  readable).\n"
"              The environment variable \"HOME\" is used to find the\n"
"              home directory.\n"
"\n"
, stdout);
 fputs(
"              A quick and very simple example of how to  setup  a\n"
"              .netrc   to  allow  curl  to  ftp  to  the  machine\n"
"              host.domain.com with user name 'myself'  and  pass\n"
"              word\n"
"\n"
"              machine   host.domain.com   login  myself  password\n"
"              secret\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable netrc usage.\n"
"\n"
"       --netrc-optional\n"
"              Very  similar to --netrc, but this option makes the\n"
, stdout);
 fputs(
"              .netrc usage optional  and  not  mandatory  as  the\n"
"              --netrc does.\n"
"\n"
"       --negotiate\n"
"              (HTTP)  Enables  GSS-Negotiate  authentication. The\n"
"              GSS-Negotiate method was designed by Microsoft  and\n"
"              is  used  in their web aplications. It is primarily\n"
"              meant as a support for Kerberos5 authentication but\n"
"              may  be also used along with another authentication\n"
, stdout);
 fputs(
"              methods. For more information see IETF draft draft-\n"
"              brezak-spnego-http-04.txt. (Added in 7.10.6)\n"
"\n"
"              This  option  requiures  that the library was built\n"
"              with GSSAPI support. This is not very  common.  Use\n"
"              -V/--version  to  see if your version supports GSS-\n"
"              Negotiate.\n"
"\n"
"              If this option is used several times, the following\n"
"              occurrences make no difference.\n"
"\n"
"       -N/--no-buffer\n"
, stdout);
 fputs(
"              Disables  the  buffering  of  the output stream. In\n"
"              normal work situations, curl will  use  a  standard\n"
"              buffered  output  stream  that will have the effect\n"
"              that it will output the data in chunks, not  neces\n"
"              sarily  exactly  when the data arrives.  Using this\n"
"              option will disable that buffering.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              switch on buffering.\n"
"\n"
, stdout);
 fputs(
"       --ntlm (HTTP)   Enables   NTLM  authentication.  The  NTLM\n"
"              authentication method was designed by Microsoft and\n"
"              is  used  by  IIS  web servers. It is a proprietary\n"
"              protocol, reversed engineered by clever people  and\n"
"              implemented  in  curl  based on their efforts. This\n"
"              kind of behavior should not be endorsed, you should\n"
"              encourage  everyone  who  uses  NTLM to switch to a\n"
, stdout);
 fputs(
"              public   and   documented   authentication   method\n"
"              instead. Such as Digest. (Added in 7.10.6)\n"
"\n"
"              If you want to enable NTLM for your proxy authenti\n"
"              cation, then use --proxy-ntlm.\n"
"\n"
"              This option requiures that the  library  was  built\n"
"              with  SSL  support. Use -V/--version to see if your\n"
"              curl supports NTLM.\n"
"\n"
"              If this option is used several times, the following\n"
, stdout);
 fputs(
"              occurrences make no difference.\n"
"\n"
"       -o/--output <file>\n"
"              Write  output  to  <file> instead of stdout. If you\n"
"              are using {} or [] to fetch multiple documents, you\n"
"              can  use  '#'  followed  by  a number in the <file>\n"
"              specifier. That variable will be replaced with  the\n"
"              current string for the URL being fetched. Like in:\n"
"\n"
"                curl http://{one,two}.site.com -o \"file_#1.txt\"\n"
"\n"
, stdout);
 fputs(
"              or use several variables like:\n"
"\n"
"                curl http://{site,host}.host[1-5].com -o \"#1_#2\"\n"
"\n"
"              You  may  use this option as many times as you have\n"
"              number of URLs.\n"
"\n"
"              See also the --create-dirs  option  to  create  the\n"
"              local directories dynamically.\n"
"\n"
"       -O/--remote-name\n"
"              Write  output to a local file named like the remote\n"
"              file we get. (Only the file part of the remote file\n"
, stdout);
 fputs(
"              is used, the path is cut off.)\n"
"\n"
"              You  may  use this option as many times as you have\n"
"              number of URLs.\n"
"       --pass <phrase>\n"
"              (SSL) Pass phrase for the private key\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       --proxy-ntlm\n"
"              Tells curl to use NTLM authentication when communi\n"
"              cating  with  the  given  proxy.  Use  --ntlm   for\n"
, stdout);
 fputs(
"              enabling NTLM with a remote host.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable proxy NTLM.\n"
"\n"
"       -p/--proxytunnel\n"
"              When an  HTTP  proxy  is  used  (-x/--proxy),  this\n"
"              option  will cause non-HTTP protocols to attempt to\n"
"              tunnel through the proxy instead of merely using it\n"
"              to  do HTTP-like operations. The tunnel approach is\n"
, stdout);
 fputs(
"              made  with  the  HTTP  proxy  CONNECT  request  and\n"
"              requires  that  the  proxy allows direct connect to\n"
"              the remote port number curl wants to tunnel through\n"
"              to.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable proxy tunnel.\n"
"\n"
"       -P/--ftp-port <address>\n"
"              (FTP) Reverses the  initiator/listener  roles  when\n"
"              connecting with ftp. This switch makes Curl use the\n"
, stdout);
 fputs(
"              PORT command instead of  PASV.  In  practice,  PORT\n"
"              tells  the server to connect to the client's speci\n"
"              fied address and port, while PASV asks  the  server\n"
"              for an ip address and port to connect to. <address>\n"
"              should be one of:\n"
"\n"
"              interface\n"
"                     i.e \"eth0\" to specify which  interface's  IP\n"
"                     address you want to use  (Unix only)\n"
"\n"
"              IP address\n"
, stdout);
 fputs(
"                     i.e  \"192.168.10.1\" to specify exact IP num\n"
"                     ber\n"
"\n"
"              host name\n"
"                     i.e \"my.host.domain\" to specify machine\n"
"\n"
"              -      (any single-letter string) to make  it  pick\n"
"                     the machine's default\n"
"\n"
"       If this option is used several times, the last one will be\n"
"       used. Disable the use of PORT with --ftp-pasv. Disable the\n"
"       attempt  to  use the EPRT command instead of PORT by using\n"
, stdout);
 fputs(
"       --disable-eprt. EPRT is really PORT++.\n"
"\n"
"       -q     If used as the first parameter on the command line,\n"
"              the $HOME/.curlrc file will not be read and used as\n"
"              a config file.\n"
"\n"
"       -Q/--quote <comand>\n"
"              (FTP) Send an arbitrary command to the  remote  FTP\n"
"              server,  by  using the QUOTE command of the server.\n"
"              Not all servers support this command, and  the  set\n"
"              of  QUOTE  commands are server specific! Quote com\n"
, stdout);
 fputs(
"              mands are sent BEFORE the transfer is taking place.\n"
"              To  make  commands  take  place  after a successful\n"
"              transfer, prefix them with  a  dash  '-'.  You  may\n"
"              specify any amount of commands to be run before and\n"
"              after the transfer. If the server  returns  failure\n"
"              for  one of the commands, the entire operation will\n"
"              be aborted.\n"
"\n"
"              This option can be used multiple times.\n"
"\n"
, stdout);
 fputs(
"       --random-file <file>\n"
"              (HTTPS) Specify the path name  to  file  containing\n"
"              what will be considered as random data. The data is\n"
"              used to seed the random engine for SSL connections.\n"
"              See also the --egd-file option.\n"
"\n"
"       -r/--range <range>\n"
"              (HTTP/FTP)  Retrieve  a  byte  range (i.e a partial\n"
"              document) from a HTTP/1.1 or FTP server. Ranges can\n"
"              be specified in a number of ways.\n"
"\n"
, stdout);
 fputs(
"              0-499     specifies the first 500 bytes\n"
"\n"
"              500-999   specifies the second 500 bytes\n"
"\n"
"              -500      specifies the last 500 bytes\n"
"\n"
"              9500      specifies  the bytes from offset 9500 and\n"
"                        forward\n"
"\n"
"              0-0,-1    specifies  the  first   and   last   byte\n"
"                        only(*)(H)\n"
"\n"
"              500-700,600-799\n"
"                        specifies 300 bytes from offset 500(H)\n"
"\n"
"              100-199,500-599\n"
, stdout);
 fputs(
"                        specifies    two   separate   100   bytes\n"
"                        ranges(*)(H)\n"
"\n"
"       (*) = NOTE that this will cause the server to reply with a\n"
"       multipart response!\n"
"\n"
"       You should also be aware that many HTTP/1.1 servers do not\n"
"       have this feature enabled, so that when you attempt to get\n"
"       a range, you'll instead get the whole document.\n"
"\n"
"       FTP range downloads only support the simple syntax 'start-\n"
, stdout);
 fputs(
"       stop' (optionally with one of  the  numbers  omitted).  It\n"
"       depends on the non-RFC command SIZE.\n"
"\n"
"       If this option is used several times, the last one will be\n"
"       used.\n"
"\n"
"       -R/--remote-time\n"
"              When used, this will make libcurl attempt to figure\n"
"              out  the  timestamp of the remote file, and if that\n"
"              is available make the  local  file  get  that  same\n"
"              timestamp.\n"
"\n"
, stdout);
 fputs(
"              If  this option is used twice, the second time dis\n"
"              ables this again.\n"
"\n"
"       -s/--silent\n"
"              Silent mode. Don't show  progress  meter  or  error\n"
"              messages.  Makes Curl mute.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable mute.\n"
"\n"
"       -S/--show-error\n"
"              When used with -s it makes curl show error  message\n"
"              if it fails.\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice, the second will again\n"
"              disable show error.\n"
"\n"
"       --socks <host[:port]>\n"
"              Use the specified SOCKS5 proxy. If the port  number\n"
"              is  not  specified,  it  is  assumed  at port 1080.\n"
"              (Option added in 7.11.1)\n"
"\n"
"              This  option  overrides   any   previous   use   of\n"
"              -x/--proxy, as they are mutually exclusive.\n"
"\n"
"              If  this option is used several times, the last one\n"
, stdout);
 fputs(
"              will be used.\n"
"\n"
"       --stderr <file>\n"
"              Redirect all writes to stderr to the specified file\n"
"              instead.  If  the  file  name is a plain '-', it is\n"
"              instead written to stdout. This option has no point\n"
"              when  you're  using a shell with decent redirecting\n"
"              capabilities.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"       --tcp-nodelay\n"
, stdout);
 fputs(
"              Turn   on   the   TCP_NODELAY   option.   See   the\n"
"              curl_easy_setopt(3) man page for details about this\n"
"              option. (Added in 7.11.2)\n"
"\n"
"              If  this  option  is used several times, each occu\n"
"              rance toggles this on/off.\n"
"\n"
"       -t/--telnet-option <OPT=val>\n"
"              Pass options  to  the  telnet  protocol.  Supported\n"
"              options are:\n"
"\n"
"              TTYPE=<term> Sets the terminal type.\n"
"\n"
, stdout);
 fputs(
"              XDISPLOC=<X display> Sets the X display location.\n"
"\n"
"              NEW_ENV=<var,val> Sets an environment variable.\n"
"\n"
"       -T/--upload-file <file>\n"
"              This  transfers  the  specified  local  file to the\n"
"              remote URL. If there is no file part in the  speci\n"
"              fied  URL,  Curl  will  append the local file name.\n"
"              NOTE that you must use a trailing  /  on  the  last\n"
"              directory  to really prove to Curl that there is no\n"
, stdout);
 fputs(
"              file name or curl will think that your last  direc\n"
"              tory name is the remote file name to use. That will\n"
"              most likely cause the upload operation to fail.  If\n"
"              this  is  used on a http(s) server, the PUT command\n"
"              will be used.\n"
"\n"
"              Use the file name \"-\" (a single dash) to use  stdin\n"
"              instead of a given file.\n"
"\n"
"              Before  7.10.8,  when  this option was used several\n"
, stdout);
 fputs(
"              times, the last one was used.\n"
"\n"
"              In curl 7.10.8 and later, you can  specify  one  -T\n"
"              for  each  URL  on  the command line. Each -T + URL\n"
"              pair specifies what to upload and  to  where.  curl\n"
"              also  supports \"globbing\" of the -T argument, mean\n"
"              ing that you can upload multiple files to a  single\n"
"              URL  by using the same URL globbing style supported\n"
"              in the URL, like this:\n"
"\n"
, stdout);
 fputs(
"              curl    -T    \"{file1,file2}\"    http://www.upload\n"
"              tothissite.com\n"
"\n"
"              or even\n"
"\n"
"              curl   -T   \"img[1-1000].png\"  ftp://ftp.picturema\n"
"              nia.com/upload/\n"
"\n"
"       --trace <file>\n"
"              Enables a full trace dump of all incoming and  out\n"
"              going  data,  including descriptive information, to\n"
"              the given output file. Use \"-\" as filename to  have\n"
"              the output sent to stdout.\n"
"\n"
, stdout);
 fputs(
"              If  this option is used several times, the last one\n"
"              will be used. (Added in 7.9.7)\n"
"\n"
"       --trace-ascii <file>\n"
"              Enables a full trace dump of all incoming and  out\n"
"              going  data,  including descriptive information, to\n"
"              the given output file. Use \"-\" as filename to  have\n"
"              the output sent to stdout.\n"
"\n"
"              This is very similar to --trace, but leaves out the\n"
, stdout);
 fputs(
"              hex part and only shows the ASCII part of the dump.\n"
"              It  makes  smaller  output  that might be easier to\n"
"              read for untrained humans.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used. (Added in 7.9.7)\n"
"\n"
"       -u/--user <user:password>\n"
"              Specify user and password to use for server authen\n"
"              tication.\n"
"\n"
"              If this option is used several times, the last  one\n"
, stdout);
 fputs(
"              will be used.\n"
"\n"
"       -U/--proxy-user <user:password>\n"
"              Specify  user and password to use for proxy authen\n"
"              tication.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       --url <URL>\n"
"              Specify a URL to fetch. This option is mostly handy\n"
"              when you want to specify URL(s) in a config file.\n"
"\n"
"              This option may be used any  number  of  times.  To\n"
, stdout);
 fputs(
"              control   where   this  URL  is  written,  use  the\n"
"              -o/--output or the -O/--remote-name options.\n"
"\n"
"       -v/--verbose\n"
"              Makes the fetching more  verbose/talkative.  Mostly\n"
"              usable for debugging. Lines starting with '>' means\n"
"              data sent by curl, '<' means data received by  curl\n"
"              that  is  hidden in normal cases and lines starting\n"
"              with '*' means additional info provided by curl.\n"
"\n"
, stdout);
 fputs(
"              Note that if you want to see HTTP  headers  in  the\n"
"              output, -i/--include might be option you're looking\n"
"              for.\n"
"\n"
"              If you think this option  still  doesn't  give  you\n"
"              enough  details, consider using --trace or --trace-\n"
"              ascii instead.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable verbose.\n"
"\n"
"       -V/--version\n"
"              Displays  information  about  curl  and the libcurl\n"
, stdout);
 fputs(
"              version it uses.\n"
"\n"
"              The first line includes the full version  of  curl,\n"
"              libcurl  and  other 3rd party libraries linked with\n"
"              the executable.\n"
"\n"
"              The second line (starts  with  \"Protocols:\")  shows\n"
"              all protocols that libcurl reports to support.\n"
"\n"
"              The third line (starts with \"Features:\") shows spe\n"
"              cific features libcurl reports to offer.  Available\n"
"              features include:\n"
"\n"
, stdout);
 fputs(
"              IPv6   You can use IPv6 with this.\n"
"\n"
"              krb4   Krb4 for ftp is supported.\n"
"\n"
"              SSL    HTTPS and FTPS are supported.\n"
"\n"
"              libz   Automatic  decompression of compressed files\n"
"                     over HTTP is supported.\n"
"\n"
"              NTLM   NTLM authenticaion is supported.\n"
"\n"
"              GSS-Negotiate\n"
"                     Negotiate authenticaion is supported.\n"
"\n"
"              Debug  This curl uses a libcurl built  with  Debug.\n"
, stdout);
 fputs(
"                     This  enables more error-tracking and memory\n"
"                     debugging etc. For curl-developers only!\n"
"\n"
"              AsynchDNS\n"
"                     This curl uses asynchronous name resolves.\n"
"\n"
"              SPNEGO SPNEGO Negotiate authenticaion is supported.\n"
"\n"
"              Largefile\n"
"                     This curl supports transfers of large files,\n"
"                     files larger than 2GB.\n"
"\n"
"       -w/--write-out <format>\n"
, stdout);
 fputs(
"              Defines what to display after a completed and  suc\n"
"              cessful  operation. The format is a string that may\n"
"              contain plain text mixed with any number  of  vari\n"
"              ables.  The string can be specified as \"string\", to\n"
"              get read from a  particular  file  you  specify  it\n"
"              \"@filename\"  and  to  tell  curl to read the format\n"
"              from stdin you write \"@-\".\n"
"\n"
, stdout);
 fputs(
"              The variables present in the output format will  be\n"
"              substituted  by  the value or text that curl thinks\n"
"              fit, as described below. All variables  are  speci\n"
"              fied like %{variable_name} and to output a normal %\n"
"              you just write them like %%. You can output a  new\n"
"              line  by  using \\n, a carriage return with \\r and a\n"
"              tab space with \\t.\n"
"\n"
"              NOTE: The %-letter  is  a  special  letter  in  the\n"
, stdout);
 fputs(
"              win32-environment,  where all occurrences of % must\n"
"              be doubled when using this option.\n"
"\n"
"              Available variables are at this point:\n"
"\n"
"              url_effective  The URL that was fetched last.  This\n"
"                             is  mostly meaningful if you've told\n"
"                             curl to follow location: headers.\n"
"\n"
"              http_code      The numerical code that was found in\n"
"                             the last retrieved HTTP(S) page.\n"
"\n"
, stdout);
 fputs(
"              time_total     The total time, in seconds, that the\n"
"                             full operation lasted. The time will\n"
"                             be  displayed with millisecond reso\n"
"                             lution.\n"
"\n"
"              time_namelookup\n"
"                             The time, in seconds, it  took  from\n"
"                             the  start  until the name resolving\n"
"                             was completed.\n"
"\n"
, stdout);
 fputs(
"              time_connect   The time, in seconds, it  took  from\n"
"                             the  start  until the connect to the\n"
"                             remote  host  (or  proxy)  was  com\n"
"                             pleted.\n"
"\n"
"              time_pretransfer\n"
"                             The  time,  in seconds, it took from\n"
"                             the start until the file transfer is\n"
"                             just  about  to begin. This includes\n"
, stdout);
 fputs(
"                             all pre-transfer commands and  nego\n"
"                             tiations  that  are  specific to the\n"
"                             particular protocol(s) involved.\n"
"\n"
"              time_starttransfer\n"
"                             The time, in seconds, it  took  from\n"
"                             the  start  until  the first byte is\n"
"                             just about to  be  transfered.  This\n"
"                             includes  time_pretransfer  and also\n"
, stdout);
 fputs(
"                             the time the server needs to  calcu\n"
"                             late the result.\n"
"\n"
"              size_download  The  total amount of bytes that were\n"
"                             downloaded.\n"
"\n"
"              size_upload    The total amount of bytes that  were\n"
"                             uploaded.\n"
"\n"
"              size_header    The  total  amount  of  bytes of the\n"
"                             downloaded headers.\n"
"\n"
, stdout);
 fputs(
"              size_request   The total amount of bytes that  were\n"
"                             sent in the HTTP request.\n"
"\n"
"              speed_download The average download speed that curl\n"
"                             measured for the complete  download.\n"
"\n"
"              speed_upload   The  average  upload speed that curl\n"
"                             measured for the complete upload.\n"
"\n"
"              content_type   The Content-Type  of  the  requested\n"
, stdout);
 fputs(
"                             document,  if  there was any. (Added\n"
"                             in 7.9.5)\n"
"\n"
"       If this option is used several times, the last one will be\n"
"       used.\n"
"\n"
"       -x/--proxy <proxyhost[:port]>\n"
"              Use specified HTTP proxy. If the port number is not\n"
"              specified, it is assumed at port 1080.\n"
"\n"
"              This option overrides  existing  environment  vari\n"
"              ables  that  sets proxy to use. If there's an envi\n"
, stdout);
 fputs(
"              ronment variable setting a proxy, you can set proxy\n"
"              to \"\" to override it.\n"
"\n"
"              Note  that all operations that are performed over a\n"
"              HTTP proxy will transparantly be converted to HTTP.\n"
"              It  means that certain protocol specific operations\n"
"              might not be available. This is not the case if you\n"
"              can  tunnel  through  the  proxy,  as done with the\n"
"              -p/--proxytunnel option.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -X/--request <command>\n"
"              (HTTP)  Specifies a custom request to use when com\n"
"              municating with the  HTTP  server.   The  specified\n"
"              request  will  be used instead of the standard GET.\n"
"              Read the HTTP 1.1  specification  for  details  and\n"
"              explanations.\n"
"\n"
"              (FTP) Specifies a custom FTP command to use instead\n"
, stdout);
 fputs(
"              of LIST when doing file lists with ftp.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -y/--speed-time <time>\n"
"              If  a download is slower than speed-limit bytes per\n"
"              second during a  speed-time  period,  the  download\n"
"              gets  aborted.  If  speed-time is used, the default\n"
"              speed-limit will be 1 unless set with -y.\n"
"\n"
, stdout);
 fputs(
"              This option controls transfers and  thus  will  not\n"
"              affect  slow connects etc. If this is a concern for\n"
"              you, try the --connect-timeout option.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -Y/--speed-limit <speed>\n"
"              If  a  download is slower than this given speed, in\n"
"              bytes per second, for speed-time  seconds  it  gets\n"
, stdout);
 fputs(
"              aborted. speed-time is set with -Y and is 30 if not\n"
"              set.\n"
"\n"
"              If this option is used several times, the last  one\n"
"              will be used.\n"
"\n"
"       -z/--time-cond <date expression>\n"
"              (HTTP) Request to get a file that has been modified\n"
"              later than the given time and date, or one that has\n"
"              been modified before that time. The date expression\n"
"              can be all sorts of date strings or if  it  doesn't\n"
, stdout);
 fputs(
"              match  any  internal ones, it tries to get the time\n"
"              from a given file name instead! See the GNU date(1)\n"
"              or  curl_getdate(3)  man  pages for date expression\n"
"              details.\n"
"\n"
"              Start the date expression with a dash (-)  to  make\n"
"              it  request  for  a document that is older than the\n"
"              given date/time, default  is  a  document  that  is\n"
"              newer than the specified date/time.\n"
"\n"
, stdout);
 fputs(
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       -Z/--max-redirs <num>\n"
"              Set  maximum   number   of   redirection-followings\n"
"              allowed.  If -L/--location is used, this option can\n"
"              be used to prevent curl from following redirections\n"
"              \"in absurdum\".\n"
"\n"
"              If  this option is used several times, the last one\n"
"              will be used.\n"
"\n"
"       -0/--http1.0\n"
, stdout);
 fputs(
"              (HTTP) Forces curl to issue its requests using HTTP\n"
"              1.0 instead of using its internally preferred: HTTP\n"
"              1.1.\n"
"\n"
"       -1/--tlsv1\n"
"              (HTTPS) Forces curl to use TSL version 1 when nego\n"
"              tiating with a remote TLS server.\n"
"\n"
"       -2/--sslv2\n"
"              (HTTPS) Forces curl to use SSL version 2 when nego\n"
"              tiating with a remote SSL server.\n"
"\n"
"       -3/--sslv3\n"
, stdout);
 fputs(
"              (HTTPS) Forces curl to use SSL version 3 when nego\n"
"              tiating with a remote SSL server.\n"
"\n"
"       -4/--ipv4\n"
"              If  libcurl  is  capable of resolving an address to\n"
"              multiple  IP  versions  (which  it  is  if  it   is\n"
"              ipv6-capable), this option tells libcurl to resolve\n"
"              names to IPv4 addresses only. (Added in 7.10.8)\n"
"\n"
"       -6/--ipv6\n"
"              If libcurl is capable of resolving  an  address  to\n"
, stdout);
 fputs(
"              multiple   IP  versions  (which  it  is  if  it  is\n"
"              ipv6-capable), this option tells libcurl to resolve\n"
"              names to IPv6 addresses only. (Added in 7.10.8)\n"
"\n"
"       -#/--progress-bar\n"
"              Make   curl   display  progress  information  as  a\n"
"              progress bar instead of the default statistics.\n"
"\n"
"              If this option is used twice, the second will again\n"
"              disable the progress bar.\n"
"\n"
"FILES\n"
"       ~/.curlrc\n"
, stdout);
 fputs(
"              Default config file.\n"
"\n"
"ENVIRONMENT\n"
"       http_proxy [protocol://]<host>[:port]\n"
"              Sets proxy server to use for HTTP.\n"
"\n"
"       HTTPS_PROXY [protocol://]<host>[:port]\n"
"              Sets proxy server to use for HTTPS.\n"
"\n"
"       FTP_PROXY [protocol://]<host>[:port]\n"
"              Sets proxy server to use for FTP.\n"
"\n"
"       GOPHER_PROXY [protocol://]<host>[:port]\n"
"              Sets proxy server to use for GOPHER.\n"
"       ALL_PROXY [protocol://]<host>[:port]\n"
, stdout);
 fputs(
"              Sets  proxy  server  to use if no protocol-specific\n"
"              proxy is set.\n"
"\n"
"       NO_PROXY <comma-separated list of hosts>\n"
"              list of host names that shouldn't  go  through  any\n"
"              proxy. If set to a asterisk\n"
"\n"
"EXIT CODES\n"
"       There  exists  a  bunch of different error codes and their\n"
"       corresponding error messages that may  appear  during  bad\n"
"       conditions.  At  the  time of this writing, the exit codes\n"
"       are:\n"
"\n"
, stdout);
 fputs(
"       1      Unsupported protocol. This build  of  curl  has  no\n"
"              support for this protocol.\n"
"\n"
"       2      Failed to initialize.\n"
"\n"
"       3      URL malformat. The syntax was not correct.\n"
"\n"
"       4      URL  user  malformatted.  The  user-part of the URL\n"
"              syntax was not correct.\n"
"\n"
"       5      Couldn't resolve proxy. The given proxy host  could\n"
"              not be resolved.\n"
"\n"
"       6      Couldn't  resolve  host.  The given remote host was\n"
"              not resolved.\n"
, stdout);
 fputs(
"\n"
"       7      Failed to connect to host.\n"
"\n"
"       8      FTP weird server reply. The server sent  data  curl\n"
"              couldn't parse.\n"
"\n"
"       9      FTP access denied. The server denied login.\n"
"\n"
"       10     FTP  user/password  incorrect.  Either  one or both\n"
"              were not accepted by the server.\n"
"\n"
"       11     FTP weird PASS reply. Curl couldn't parse the reply\n"
"              sent to the PASS request.\n"
"\n"
"       12     FTP weird USER reply. Curl couldn't parse the reply\n"
, stdout);
 fputs(
"              sent to the USER request.\n"
"\n"
"       13     FTP weird PASV reply, Curl couldn't parse the reply\n"
"              sent to the PASV request.\n"
"\n"
"       14     FTP  weird  227  format.  Curl  couldn't  parse the\n"
"              227-line the server sent.\n"
"\n"
"       15     FTP can't get host. Couldn't resolve the host IP we\n"
"              got in the 227-line.\n"
"\n"
"       16     FTP  can't  reconnect. Couldn't connect to the host\n"
"              we got in the 227-line.\n"
"\n"
, stdout);
 fputs(
"       17     FTP couldn't set binary. Couldn't  change  transfer\n"
"              method to binary.\n"
"\n"
"       18     Partial  file.  Only  a part of the file was trans\n"
"              fered.\n"
"\n"
"       19     FTP couldn't download/access the  given  file,  the\n"
"              RETR (or similar) command failed.\n"
"\n"
"       20     FTP  write  error. The transfer was reported bad by\n"
"              the server.\n"
"\n"
"       21     FTP quote error. A  quote  command  returned  error\n"
"              from the server.\n"
"\n"
, stdout);
 fputs(
"       22     HTTP  page not retrieved. The requested url was not\n"
"              found or returned another error with the HTTP error\n"
"              code  being  400  or  above.  This return code only\n"
"              appears if -f/--fail is used.\n"
"\n"
"       23     Write error. Curl couldn't write data  to  a  local\n"
"              filesystem or similar.\n"
"\n"
"       24     Malformed user. User name badly specified.\n"
"\n"
"       25     FTP  couldn't STOR file. The server denied the STOR\n"
, stdout);
 fputs(
"              operation, used for FTP uploading.\n"
"\n"
"       26     Read error. Various reading problems.\n"
"\n"
"       27     Out of memory. A memory allocation request  failed.\n"
"       28     Operation  timeout.  The  specified time-out period\n"
"              was reached according to the conditions.\n"
"\n"
"       29     FTP couldn't set  ASCII.  The  server  returned  an\n"
"              unknown reply.\n"
"\n"
"       30     FTP  PORT  failed. The PORT command failed. Not all\n"
, stdout);
 fputs(
"              FTP servers support the PORT command, try  doing  a\n"
"              transfer using PASV instead!\n"
"\n"
"       31     FTP  couldn't  use  REST.  The REST command failed.\n"
"              This command is used for resumed FTP transfers.\n"
"\n"
"       32     FTP couldn't use SIZE. The SIZE command failed. The\n"
"              command  is  an  extension to the original FTP spec\n"
"              RFC 959.\n"
"\n"
"       33     HTTP range error. The range \"command\" didn't  work.\n"
, stdout);
 fputs(
"       34     HTTP  post  error. Internal post-request generation\n"
"              error.\n"
"\n"
"       35     SSL connect error. The SSL handshaking failed.\n"
"\n"
"       36     FTP bad download resume. Couldn't continue an  ear\n"
"              lier aborted download.\n"
"\n"
"       37     FILE  couldn't  read file. Failed to open the file.\n"
"              Permissions?\n"
"\n"
"       38     LDAP cannot bind. LDAP bind operation failed.\n"
"\n"
"       39     LDAP search failed.\n"
"\n"
, stdout);
 fputs(
"       40     Library not found. The LDAP library was not  found.\n"
"       41     Function  not  found.  A required LDAP function was\n"
"              not found.\n"
"\n"
"       42     Aborted by callback. An application  told  curl  to\n"
"              abort the operation.\n"
"\n"
"       43     Internal  error.  A  function was called with a bad\n"
"              parameter.\n"
"\n"
"       44     Internal error. A function  was  called  in  a  bad\n"
"              order.\n"
"\n"
, stdout);
 fputs(
"       45     Interface  error.  A  specified  outgoing interface\n"
"              could not be used.\n"
"\n"
"       46     Bad password entered. An error  was  signaled  when\n"
"              the password was entered.\n"
"\n"
"       47     Too  many redirects. When following redirects, curl\n"
"              hit the maximum amount.\n"
"\n"
"       48     Unknown TELNET option specified.\n"
"\n"
"       49     Malformed telnet option.\n"
"\n"
"       51     The remote peer's SSL certificate wasn't ok\n"
"\n"
, stdout);
 fputs(
"       52     The server didn't reply  anything,  which  here  is\n"
"              considered an error.\n"
"\n"
"       53     SSL crypto engine not found\n"
"\n"
"       54     Cannot set SSL crypto engine as default\n"
"\n"
"       55     Failed sending network data\n"
"\n"
"       56     Failure in receiving network data\n"
"\n"
"       57     Share is in use (internal error)\n"
"\n"
"       58     Problem with the local certificate\n"
"\n"
"       59     Couldn't use specified SSL cipher\n"
"\n"
"       60     Problem with the CA cert (path? permission?)\n"
"\n"
, stdout);
 fputs(
"       61     Unrecognized transfer encoding\n"
"\n"
"       62     Invalid LDAP URL\n"
"\n"
"       63     Maximum file size exceeded\n"
"\n"
"       XX     There  will  appear more error codes here in future\n"
"              releases. The existing  ones  are  meant  to  never\n"
"              change.\n"
"\n"
"AUTHORS / CONTRIBUTORS\n"
"       Daniel  Stenberg is the main author, but the whole list of\n"
"       contributors is found in the separate THANKS file.\n"
"\n"
"WWW\n"
"       http://curl.haxx.se\n"
"\n"
"FTP\n"
, stdout);
 fputs(
"       ftp://ftp.sunet.se/pub/www/utilities/curl/\n"
"\n"
"SEE ALSO\n"
"       ftp(1), wget(1), snarf(1)\n"
"\n"
"LATEST VERSION\n"
"\n"
"  You always find news about what's going on as well as the latest versions\n"
"  from the curl web pages, located at:\n"
"\n"
"        http://curl.haxx.se\n"
"\n"
"SIMPLE USAGE\n"
"\n"
"  Get the main page from netscape's web-server:\n"
"\n"
"        curl http://www.netscape.com/\n"
"\n"
"  Get the README file the user's home directory at funet's ftp-server:\n"
"\n"
"        curl ftp://ftp.funet.fi/README\n"
"\n"
, stdout);
 fputs(
"  Get a web page from a server using port 8000:\n"
"\n"
"        curl http://www.weirdserver.com:8000/\n"
"\n"
"  Get a list of a directory of an FTP site:\n"
"\n"
"        curl ftp://cool.haxx.se/\n"
"\n"
"  Get a gopher document from funet's gopher server:\n"
"\n"
"        curl gopher://gopher.funet.fi\n"
"\n"
"  Get the definition of curl from a dictionary:\n"
"\n"
"        curl dict://dict.org/m:curl\n"
"\n"
"  Fetch two documents at once:\n"
"\n"
"        curl ftp://cool.haxx.se/ http://www.weirdserver.com:8000/\n"
"\n"
"DOWNLOAD TO A FILE\n"
"\n"
, stdout);
 fputs(
"  Get a web page and store in a local file:\n"
"\n"
"        curl -o thatpage.html http://www.netscape.com/\n"
"\n"
"  Get a web page and store in a local file, make the local file get the name\n"
"  of the remote document (if no file name part is specified in the URL, this\n"
"  will fail):\n"
"\n"
"        curl -O http://www.netscape.com/index.html\n"
"\n"
"  Fetch two files and store them with their remote names:\n"
"\n"
"        curl -O www.haxx.se/index.html -O curl.haxx.se/download.html\n"
"\n"
"USING PASSWORDS\n"
"\n"
" FTP\n"
"\n"
, stdout);
 fputs(
"   To ftp files using name+passwd, include them in the URL like:\n"
"\n"
"        curl ftp://name:passwd@machine.domain:port/full/path/to/file\n"
"\n"
"   or specify them with the -u flag like\n"
"\n"
"        curl -u name:passwd ftp://machine.domain:port/full/path/to/file\n"
"\n"
" FTPS\n"
"\n"
"   It is just like for FTP, but you may also want to specify and use\n"
"   SSL-specific options for certificates etc.\n"
"\n"
" HTTP\n"
"\n"
"   The HTTP URL doesn't support user and password in the URL string. Curl\n"
, stdout);
 fputs(
"   does support that anyway to provide a ftp-style interface and thus you can\n"
"   pick a file like:\n"
"\n"
"        curl http://name:passwd@machine.domain/full/path/to/file\n"
"\n"
"   or specify user and password separately like in\n"
"\n"
"        curl -u name:passwd http://machine.domain/full/path/to/file\n"
"\n"
"   HTTP offers many different methods of authentication and curl supports\n"
"   several: Basic, Digest, NTLM and Negotiate. Without telling which method to\n"
, stdout);
 fputs(
"   use, curl defaults to Basic. You can also ask curl to pick the most secure\n"
"   ones out of the ones that the server accepts for the given URL, by using\n"
"   --anyauth.\n"
"\n"
"   NOTE! Since HTTP URLs don't support user and password, you can't use that\n"
"   style when using Curl via a proxy. You _must_ use the -u style fetch\n"
"   during such circumstances.\n"
"\n"
" HTTPS\n"
"\n"
"   Probably most commonly used with private certificates, as explained below.\n"
"\n"
" GOPHER\n"
"\n"
"   Curl features no password support for gopher.\n"
"\n"
, stdout);
 fputs(
"PROXY\n"
"\n"
" Get an ftp file using a proxy named my-proxy that uses port 888:\n"
"\n"
"        curl -x my-proxy:888 ftp://ftp.leachsite.com/README\n"
"\n"
" Get a file from a HTTP server that requires user and password, using the\n"
" same proxy as above:\n"
"\n"
"        curl -u user:passwd -x my-proxy:888 http://www.get.this/\n"
"\n"
" Some proxies require special authentication. Specify by using -U as above:\n"
"\n"
"        curl -U user:passwd -x my-proxy:888 http://www.get.this/\n"
"\n"
, stdout);
 fputs(
" See also the environment variables Curl support that offer further proxy\n"
" control.\n"
"\n"
"RANGES\n"
"\n"
"  With HTTP 1.1 byte-ranges were introduced. Using this, a client can request\n"
"  to get only one or more subparts of a specified document. Curl supports\n"
"  this with the -r flag.\n"
"\n"
"  Get the first 100 bytes of a document:\n"
"\n"
"        curl -r 0-99 http://www.get.this/\n"
"\n"
"  Get the last 500 bytes of a document:\n"
"\n"
"        curl -r -500 http://www.get.this/\n"
"\n"
, stdout);
 fputs(
"  Curl also supports simple ranges for FTP files as well. Then you can only\n"
"  specify start and stop position.\n"
"\n"
"  Get the first 100 bytes of a document using FTP:\n"
"\n"
"        curl -r 0-99 ftp://www.get.this/README  \n"
"\n"
"UPLOADING\n"
"\n"
" FTP\n"
"\n"
"  Upload all data on stdin to a specified ftp site:\n"
"\n"
"        curl -T - ftp://ftp.upload.com/myfile\n"
"\n"
"  Upload data from a specified file, login with user and password:\n"
"\n"
"        curl -T uploadfile -u user:passwd ftp://ftp.upload.com/myfile\n"
"\n"
, stdout);
 fputs(
"  Upload a local file to the remote site, and use the local file name remote\n"
"  too:\n"
" \n"
"        curl -T uploadfile -u user:passwd ftp://ftp.upload.com/\n"
"\n"
"  Upload a local file to get appended to the remote file using ftp:\n"
"\n"
"        curl -T localfile -a ftp://ftp.upload.com/remotefile\n"
"\n"
"  Curl also supports ftp upload through a proxy, but only if the proxy is\n"
"  configured to allow that kind of tunneling. If it does, you can run curl in\n"
"  a fashion similar to:\n"
"\n"
, stdout);
 fputs(
"        curl --proxytunnel -x proxy:port -T localfile ftp.upload.com\n"
"\n"
" HTTP\n"
"\n"
"  Upload all data on stdin to a specified http site:\n"
"\n"
"        curl -T - http://www.upload.com/myfile\n"
"\n"
"  Note that the http server must've been configured to accept PUT before this\n"
"  can be done successfully.\n"
"\n"
"  For other ways to do http data upload, see the POST section below.\n"
"\n"
"VERBOSE / DEBUG\n"
"\n"
"  If curl fails where it isn't supposed to, if the servers don't let you in,\n"
, stdout);
 fputs(
"  if you can't understand the responses: use the -v flag to get verbose\n"
"  fetching. Curl will output lots of info and what it sends and receives in\n"
"  order to let the user see all client-server interaction (but it won't show\n"
"  you the actual data).\n"
"\n"
"        curl -v ftp://ftp.upload.com/\n"
"\n"
"  To get even more details and information on what curl does, try using the\n"
"  --trace or --trace-ascii options with a given file name to log to, like\n"
"  this:\n"
"\n"
"        curl --trace trace.txt www.haxx.se\n"
" \n"
"\n"
, stdout);
 fputs(
"DETAILED INFORMATION\n"
"\n"
"  Different protocols provide different ways of getting detailed information\n"
"  about specific files/documents. To get curl to show detailed information\n"
"  about a single file, you should use -I/--head option. It displays all\n"
"  available info on a single file for HTTP and FTP. The HTTP information is a\n"
"  lot more extensive.\n"
"\n"
"  For HTTP, you can get the header information (the same as -I would show)\n"
"  shown before the data by using -i/--include. Curl understands the\n"
, stdout);
 fputs(
"  -D/--dump-header option when getting files from both FTP and HTTP, and it\n"
"  will then store the headers in the specified file.\n"
"\n"
"  Store the HTTP headers in a separate file (headers.txt in the example):\n"
"\n"
"        curl --dump-header headers.txt curl.haxx.se\n"
"\n"
"  Note that headers stored in a separate file can be very useful at a later\n"
"  time if you want curl to use cookies sent by the server. More about that in\n"
"  the cookies section.\n"
"\n"
"POST (HTTP)\n"
"\n"
, stdout);
 fputs(
"  It's easy to post data using curl. This is done using the -d <data>\n"
"  option.  The post data must be urlencoded.\n"
"\n"
"  Post a simple \"name\" and \"phone\" guestbook.\n"
"\n"
"        curl -d \"name=Rafael%20Sagula&phone=3320780\" \\\n"
"                http://www.where.com/guest.cgi\n"
"\n"
"  How to post a form with curl, lesson #1:\n"
"\n"
"  Dig out all the <input> tags in the form that you want to fill in. (There's\n"
"  a perl program called formfind.pl on the curl site that helps with this).\n"
"\n"
, stdout);
 fputs(
"  If there's a \"normal\" post, you use -d to post. -d takes a full \"post\n"
"  string\", which is in the format\n"
"\n"
"        <variable1>=<data1>&<variable2>=<data2>&...\n"
"\n"
"  The 'variable' names are the names set with \"name=\" in the <input> tags, and\n"
"  the data is the contents you want to fill in for the inputs. The data *must*\n"
"  be properly URL encoded. That means you replace space with + and that you\n"
"  write weird letters with %XX where XX is the hexadecimal representation of\n"
, stdout);
 fputs(
"  the letter's ASCII code.\n"
"\n"
"  Example:\n"
"\n"
"  (page located at http://www.formpost.com/getthis/\n"
"\n"
"        <form action=\"post.cgi\" method=\"post\">\n"
"        <input name=user size=10>\n"
"        <input name=pass type=password size=10>\n"
"        <input name=id type=hidden value=\"blablabla\">\n"
"        <input name=ding value=\"submit\">\n"
"        </form>\n"
"\n"
"  We want to enter user 'foobar' with password '12345'.\n"
"\n"
"  To post to this, you enter a curl command line like:\n"
"\n"
, stdout);
 fputs(
"        curl -d \"user=foobar&pass=12345&id=blablabla&ding=submit\"  (continues)\n"
"          http://www.formpost.com/getthis/post.cgi\n"
"\n"
"\n"
"  While -d uses the application/x-www-form-urlencoded mime-type, generally\n"
"  understood by CGI's and similar, curl also supports the more capable\n"
"  multipart/form-data type. This latter type supports things like file upload.\n"
"\n"
"  -F accepts parameters like -F \"name=contents\". If you want the contents to\n"
, stdout);
 fputs(
"  be read from a file, use <@filename> as contents. When specifying a file,\n"
"  you can also specify the file content type by appending ';type=<mime type>'\n"
"  to the file name. You can also post the contents of several files in one\n"
"  field.  For example, the field name 'coolfiles' is used to send three files,\n"
"  with different content types using the following syntax:\n"
"\n"
"        curl -F \"coolfiles=@fil1.gif;type=image/gif,fil2.txt,fil3.html\" \\\n"
"        http://www.post.com/postit.cgi\n"
"\n"
, stdout);
 fputs(
"  If the content-type is not specified, curl will try to guess from the file\n"
"  extension (it only knows a few), or use the previously specified type (from\n"
"  an earlier file if several files are specified in a list) or else it will\n"
"  using the default type 'text/plain'.\n"
"\n"
"  Emulate a fill-in form with -F. Let's say you fill in three fields in a\n"
"  form. One field is a file name which to post, one field is your name and one\n"
, stdout);
 fputs(
"  field is a file description. We want to post the file we have written named\n"
"  \"cooltext.txt\". To let curl do the posting of this data instead of your\n"
"  favourite browser, you have to read the HTML source of the form page and\n"
"  find the names of the input fields. In our example, the input field names\n"
"  are 'file', 'yourname' and 'filedescription'.\n"
"\n"
"        curl -F \"file=@cooltext.txt\" -F \"yourname=Daniel\" \\\n"
"             -F \"filedescription=Cool text file with cool text inside\" \\\n"
, stdout);
 fputs(
"             http://www.post.com/postit.cgi\n"
"\n"
"  To send two files in one post you can do it in two ways:\n"
"\n"
"  1. Send multiple files in a single \"field\" with a single field name:\n"
" \n"
"        curl -F \"pictures=@dog.gif,cat.gif\" \n"
" \n"
"  2. Send two fields with two field names: \n"
"\n"
"        curl -F \"docpicture=@dog.gif\" -F \"catpicture=@cat.gif\" \n"
"\n"
"REFERRER\n"
"\n"
"  A HTTP request has the option to include information about which address\n"
"  that referred to actual page.  Curl allows you to specify the\n"
, stdout);
 fputs(
"  referrer to be used on the command line. It is especially useful to\n"
"  fool or trick stupid servers or CGI scripts that rely on that information\n"
"  being available or contain certain data.\n"
"\n"
"        curl -e www.coolsite.com http://www.showme.com/\n"
"\n"
"  NOTE: The referer field is defined in the HTTP spec to be a full URL.\n"
"\n"
"USER AGENT\n"
"\n"
"  A HTTP request has the option to include information about the browser\n"
"  that generated the request. Curl allows it to be specified on the command\n"
, stdout);
 fputs(
"  line. It is especially useful to fool or trick stupid servers or CGI\n"
"  scripts that only accept certain browsers.\n"
"\n"
"  Example:\n"
"\n"
"  curl -A 'Mozilla/3.0 (Win95; I)' http://www.nationsbank.com/\n"
"\n"
"  Other common strings:\n"
"    'Mozilla/3.0 (Win95; I)'     Netscape Version 3 for Windows 95\n"
"    'Mozilla/3.04 (Win95; U)'    Netscape Version 3 for Windows 95\n"
"    'Mozilla/2.02 (OS/2; U)'     Netscape Version 2 for OS/2\n"
"    'Mozilla/4.04 [en] (X11; U; AIX 4.2; Nav)'           NS for AIX\n"
, stdout);
 fputs(
"    'Mozilla/4.05 [en] (X11; U; Linux 2.0.32 i586)'      NS for Linux\n"
"\n"
"  Note that Internet Explorer tries hard to be compatible in every way:\n"
"    'Mozilla/4.0 (compatible; MSIE 4.01; Windows 95)'    MSIE for W95\n"
"\n"
"  Mozilla is not the only possible User-Agent name:\n"
"    'Konqueror/1.0'             KDE File Manager desktop client\n"
"    'Lynx/2.7.1 libwww-FM/2.14' Lynx command line browser\n"
"\n"
"COOKIES\n"
"\n"
"  Cookies are generally used by web servers to keep state information at the\n"
, stdout);
 fputs(
"  client's side. The server sets cookies by sending a response line in the\n"
"  headers that looks like 'Set-Cookie: <data>' where the data part then\n"
"  typically contains a set of NAME=VALUE pairs (separated by semicolons ';'\n"
"  like \"NAME1=VALUE1; NAME2=VALUE2;\"). The server can also specify for what\n"
"  path the \"cookie\" should be used for (by specifying \"path=value\"), when the\n"
"  cookie should expire (\"expire=DATE\"), for what domain to use it\n"
, stdout);
 fputs(
"  (\"domain=NAME\") and if it should be used on secure connections only\n"
"  (\"secure\").\n"
"\n"
"  If you've received a page from a server that contains a header like:\n"
"        Set-Cookie: sessionid=boo123; path=\"/foo\";\n"
"\n"
"  it means the server wants that first pair passed on when we get anything in\n"
"  a path beginning with \"/foo\".\n"
"\n"
"  Example, get a page that wants my name passed in a cookie:\n"
"\n"
"        curl -b \"name=Daniel\" www.sillypage.com\n"
"\n"
, stdout);
 fputs(
"  Curl also has the ability to use previously received cookies in following\n"
"  sessions. If you get cookies from a server and store them in a file in a\n"
"  manner similar to:\n"
"\n"
"        curl --dump-header headers www.example.com\n"
"\n"
"  ... you can then in a second connect to that (or another) site, use the\n"
"  cookies from the 'headers' file like:\n"
"\n"
"        curl -b headers www.example.com\n"
"\n"
"  While saving headers to a file is a working way to store cookies, it is\n"
, stdout);
 fputs(
"  however error-prone and not the prefered way to do this. Instead, make curl\n"
"  save the incoming cookies using the well-known netscape cookie format like\n"
"  this:\n"
"\n"
"        curl -c cookies.txt www.example.com\n"
"\n"
"  Note that by specifying -b you enable the \"cookie awareness\" and with -L\n"
"  you can make curl follow a location: (which often is used in combination\n"
"  with cookies). So that if a site sends cookies and a location, you can\n"
"  use a non-existing file to trigger the cookie awareness like:\n"
"\n"
, stdout);
 fputs(
"        curl -L -b empty.txt www.example.com\n"
"\n"
"  The file to read cookies from must be formatted using plain HTTP headers OR\n"
"  as netscape's cookie file. Curl will determine what kind it is based on the\n"
"  file contents.  In the above command, curl will parse the header and store\n"
"  the cookies received from www.example.com.  curl will send to the server the\n"
"  stored cookies which match the request as it follows the location.  The\n"
"  file \"empty.txt\" may be a non-existant file.\n"
"\n"
, stdout);
 fputs(
"  Alas, to both read and write cookies from a netscape cookie file, you can\n"
"  set both -b and -c to use the same file:\n"
"\n"
"        curl -b cookies.txt -c cookies.txt www.example.com\n"
"\n"
"PROGRESS METER\n"
"\n"
"  The progress meter exists to show a user that something actually is\n"
"  happening. The different fields in the output have the following meaning:\n"
"\n"
"  % Total    % Received % Xferd  Average Speed          Time             Curr.\n"
, stdout);
 fputs(
"                                 Dload  Upload Total    Current  Left    Speed\n"
"  0  151M    0 38608    0     0   9406      0  4:41:43  0:00:04  4:41:39  9287\n"
"\n"
"  From left-to-right:\n"
"   %             - percentage completed of the whole transfer\n"
"   Total         - total size of the whole expected transfer\n"
"   %             - percentage completed of the download\n"
"   Received      - currently downloaded amount of bytes\n"
"   %             - percentage completed of the upload\n"
, stdout);
 fputs(
"   Xferd         - currently uploaded amount of bytes\n"
"   Average Speed\n"
"   Dload         - the average transfer speed of the download\n"
"   Average Speed\n"
"   Upload        - the average transfer speed of the upload\n"
"   Time Total    - expected time to complete the operation\n"
"   Time Current  - time passed since the invoke\n"
"   Time Left     - expected time left to completetion\n"
"   Curr.Speed    - the average transfer speed the last 5 seconds (the first\n"
, stdout);
 fputs(
"                   5 seconds of a transfer is based on less time of course.)\n"
"\n"
"  The -# option will display a totally different progress bar that doesn't\n"
"  need much explanation!\n"
"\n"
"SPEED LIMIT\n"
"\n"
"  Curl allows the user to set the transfer speed conditions that must be met\n"
"  to let the transfer keep going. By using the switch -y and -Y you\n"
"  can make curl abort transfers if the transfer speed is below the specified\n"
"  lowest limit for a specified time.\n"
"\n"
, stdout);
 fputs(
"  To have curl abort the download if the speed is slower than 3000 bytes per\n"
"  second for 1 minute, run:\n"
"\n"
"        curl -Y 3000 -y 60 www.far-away-site.com\n"
"\n"
"  This can very well be used in combination with the overall time limit, so\n"
"  that the above operatioin must be completed in whole within 30 minutes:\n"
"\n"
"        curl -m 1800 -Y 3000 -y 60 www.far-away-site.com\n"
"\n"
"  Forcing curl not to transfer data faster than a given rate is also possible,\n"
, stdout);
 fputs(
"  which might be useful if you're using a limited bandwidth connection and you\n"
"  don't want your transfer to use all of it (sometimes referred to as\n"
"  \"bandwith throttle\").\n"
"\n"
"  Make curl transfer data no faster than 10 kilobytes per second:\n"
"\n"
"        curl --limit-rate 10K www.far-away-site.com\n"
"\n"
"    or\n"
"\n"
"        curl --limit-rate 10240 www.far-away-site.com\n"
"\n"
"  Or prevent curl from uploading data faster than 1 megabyte per second:\n"
"\n"
"        curl -T upload --limit-rate 1M ftp://uploadshereplease.com\n"
"\n"
, stdout);
 fputs(
"  When using the --limit-rate option, the transfer rate is regulated on a\n"
"  per-second basis, which will cause the total transfer speed to become lower\n"
"  than the given number. Sometimes of course substantially lower, if your\n"
"  transfer stalls during periods.\n"
"\n"
"CONFIG FILE\n"
"\n"
"  Curl automatically tries to read the .curlrc file (or _curlrc file on win32\n"
"  systems) from the user's home dir on startup.\n"
"\n"
"  The config file could be made up with normal command line switches, but you\n"
, stdout);
 fputs(
"  can also specify the long options without the dashes to make it more\n"
"  readable. You can separate the options and the parameter with spaces, or\n"
"  with = or :. Comments can be used within the file. If the first letter on a\n"
"  line is a '#'-letter the rest of the line is treated as a comment.\n"
"\n"
"  If you want the parameter to contain spaces, you must inclose the entire\n"
"  parameter within double quotes (\"). Within those quotes, you specify a\n"
"  quote as \\\".\n"
"\n"
, stdout);
 fputs(
"  NOTE: You must specify options and their arguments on the same line.\n"
"\n"
"  Example, set default time out and proxy in a config file:\n"
"\n"
"        # We want a 30 minute timeout:\n"
"        -m 1800\n"
"        # ... and we use a proxy for all accesses:\n"
"        proxy = proxy.our.domain.com:8080\n"
"\n"
"  White spaces ARE significant at the end of lines, but all white spaces\n"
"  leading up to the first characters of each line are ignored.\n"
"\n"
"  Prevent curl from reading the default file by using -q as the first command\n"
, stdout);
 fputs(
"  line parameter, like:\n"
"\n"
"        curl -q www.thatsite.com\n"
"\n"
"  Force curl to get and display a local help page in case it is invoked\n"
"  without URL by making a config file similar to:\n"
"\n"
"        # default url to get\n"
"        url = \"http://help.with.curl.com/curlhelp.html\"\n"
"\n"
"  You can specify another config file to be read by using the -K/--config\n"
"  flag. If you set config file name to \"-\" it'll read the config from stdin,\n"
"  which can be handy if you want to hide options from being visible in process\n"
, stdout);
 fputs(
"  tables etc:\n"
"\n"
"        echo \"user = user:passwd\" | curl -K - http://that.secret.site.com\n"
"\n"
"EXTRA HEADERS\n"
"\n"
"  When using curl in your own very special programs, you may end up needing\n"
"  to pass on your own custom headers when getting a web page. You can do\n"
"  this by using the -H flag.\n"
"\n"
"  Example, send the header \"X-you-and-me: yes\" to the server when getting a\n"
"  page:\n"
"\n"
"        curl -H \"X-you-and-me: yes\" www.love.com\n"
"\n"
"  This can also be useful in case you want curl to send a different text in a\n"
, stdout);
 fputs(
"  header than it normally does. The -H header you specify then replaces the\n"
"  header curl would normally send. If you replace an internal header with an\n"
"  empty one, you prevent that header from being sent. To prevent the Host:\n"
"  header from being used:\n"
"\n"
"        curl -H \"Host:\" www.server.com\n"
"\n"
"FTP and PATH NAMES\n"
"\n"
"  Do note that when getting files with the ftp:// URL, the given path is\n"
"  relative the directory you enter. To get the file 'README' from your home\n"
"  directory at your ftp site, do:\n"
"\n"
, stdout);
 fputs(
"        curl ftp://user:passwd@my.site.com/README\n"
"\n"
"  But if you want the README file from the root directory of that very same\n"
"  site, you need to specify the absolute file name:\n"
"\n"
"        curl ftp://user:passwd@my.site.com//README\n"
"\n"
"  (I.e with an extra slash in front of the file name.)\n"
"\n"
"FTP and firewalls\n"
"\n"
"  The FTP protocol requires one of the involved parties to open a second\n"
"  connction as soon as data is about to get transfered. There are two ways to\n"
"  do this.\n"
"\n"
, stdout);
 fputs(
"  The default way for curl is to issue the PASV command which causes the\n"
"  server to open another port and await another connection performed by the\n"
"  client. This is good if the client is behind a firewall that don't allow\n"
"  incoming connections.\n"
"\n"
"        curl ftp.download.com\n"
"\n"
"  If the server for example, is behind a firewall that don't allow connections\n"
"  on other ports than 21 (or if it just doesn't support the PASV command), the\n"
, stdout);
 fputs(
"  other way to do it is to use the PORT command and instruct the server to\n"
"  connect to the client on the given (as parameters to the PORT command) IP\n"
"  number and port.\n"
"\n"
"  The -P flag to curl supports a few different options. Your machine may have\n"
"  several IP-addresses and/or network interfaces and curl allows you to select\n"
"  which of them to use. Default address can also be used:\n"
"\n"
"        curl -P - ftp.download.com\n"
"\n"
, stdout);
 fputs(
"  Download with PORT but use the IP address of our 'le0' interface (this does\n"
"  not work on windows):\n"
"\n"
"        curl -P le0 ftp.download.com\n"
"\n"
"  Download with PORT but use 192.168.0.10 as our IP address to use:\n"
"\n"
"        curl -P 192.168.0.10 ftp.download.com\n"
"\n"
"NETWORK INTERFACE\n"
"\n"
"  Get a web page from a server using a specified port for the interface:\n"
"\n"
"	curl --interface eth0:1 http://www.netscape.com/\n"
"\n"
"  or\n"
"\n"
"	curl --interface 192.168.1.10 http://www.netscape.com/\n"
"\n"
"HTTPS\n"
"\n"
, stdout);
 fputs(
"  Secure HTTP requires SSL libraries to be installed and used when curl is\n"
"  built. If that is done, curl is capable of retrieving and posting documents\n"
"  using the HTTPS procotol.\n"
"\n"
"  Example:\n"
"\n"
"        curl https://www.secure-site.com\n"
"\n"
"  Curl is also capable of using your personal certificates to get/post files\n"
"  from sites that require valid certificates. The only drawback is that the\n"
"  certificate needs to be in PEM-format. PEM is a standard and open format to\n"
, stdout);
 fputs(
"  store certificates with, but it is not used by the most commonly used\n"
"  browsers (Netscape and MSIE both use the so called PKCS#12 format). If you\n"
"  want curl to use the certificates you use with your (favourite) browser, you\n"
"  may need to download/compile a converter that can convert your browser's\n"
"  formatted certificates to PEM formatted ones. This kind of converter is\n"
"  included in recent versions of OpenSSL, and for older versions Dr Stephen\n"
, stdout);
 fputs(
"  N. Henson has written a patch for SSLeay that adds this functionality. You\n"
"  can get his patch (that requires an SSLeay installation) from his site at:\n"
"  http://www.drh-consultancy.demon.co.uk/\n"
"\n"
"  Example on how to automatically retrieve a document using a certificate with\n"
"  a personal password:\n"
"\n"
"        curl -E /path/to/cert.pem:password https://secure.site.com/\n"
"\n"
"  If you neglect to specify the password on the command line, you will be\n"
, stdout);
 fputs(
"  prompted for the correct password before any data can be received.\n"
"\n"
"  Many older SSL-servers have problems with SSLv3 or TLS, that newer versions\n"
"  of OpenSSL etc is using, therefore it is sometimes useful to specify what\n"
"  SSL-version curl should use. Use -3, -2 or -1 to specify that exact SSL\n"
"  version to use (for SSLv3, SSLv2 or TLSv1 respectively):\n"
"\n"
"        curl -2 https://secure.site.com/\n"
"\n"
"  Otherwise, curl will first attempt to use v3 and then v2.\n"
"\n"
, stdout);
 fputs(
"  To use OpenSSL to convert your favourite browser's certificate into a PEM\n"
"  formatted one that curl can use, do something like this (assuming netscape,\n"
"  but IE is likely to work similarly):\n"
"\n"
"    You start with hitting the 'security' menu button in netscape. \n"
"\n"
"    Select 'certificates->yours' and then pick a certificate in the list \n"
"\n"
"    Press the 'export' button \n"
"\n"
"    enter your PIN code for the certs \n"
"\n"
"    select a proper place to save it \n"
"\n"
, stdout);
 fputs(
"    Run the 'openssl' application to convert the certificate. If you cd to the\n"
"    openssl installation, you can do it like:\n"
"\n"
"     # ./apps/openssl pkcs12 -in [file you saved] -clcerts -out [PEMfile]\n"
"\n"
"\n"
"RESUMING FILE TRANSFERS\n"
"\n"
" To continue a file transfer where it was previously aborted, curl supports\n"
" resume on http(s) downloads as well as ftp uploads and downloads.\n"
"\n"
" Continue downloading a document:\n"
"\n"
"        curl -C - -o file ftp://ftp.server.com/path/file\n"
"\n"
" Continue uploading a document(*1):\n"
, stdout);
 fputs(
"\n"
"        curl -C - -T file ftp://ftp.server.com/path/file\n"
"\n"
" Continue downloading a document from a web server(*2):\n"
"\n"
"        curl -C - -o file http://www.server.com/\n"
"\n"
" (*1) = This requires that the ftp server supports the non-standard command\n"
"        SIZE. If it doesn't, curl will say so.\n"
"\n"
" (*2) = This requires that the web server supports at least HTTP/1.1. If it\n"
"        doesn't, curl will say so.\n"
"\n"
"TIME CONDITIONS\n"
"\n"
" HTTP allows a client to specify a time condition for the document it\n"
, stdout);
 fputs(
" requests. It is If-Modified-Since or If-Unmodified-Since. Curl allow you to\n"
" specify them with the -z/--time-cond flag.\n"
"\n"
" For example, you can easily make a download that only gets performed if the\n"
" remote file is newer than a local copy. It would be made like:\n"
"\n"
"        curl -z local.html http://remote.server.com/remote.html\n"
"\n"
" Or you can download a file only if the local file is newer than the remote\n"
" one. Do this by prepending the date string with a '-', as in:\n"
"\n"
, stdout);
 fputs(
"        curl -z -local.html http://remote.server.com/remote.html\n"
"\n"
" You can specify a \"free text\" date as condition. Tell curl to only download\n"
" the file if it was updated since yesterday:\n"
"\n"
"        curl -z yesterday http://remote.server.com/remote.html\n"
"\n"
" Curl will then accept a wide range of date formats. You always make the date\n"
" check the other way around by prepending it with a dash '-'.\n"
"\n"
"DICT\n"
"\n"
"  For fun try\n"
"\n"
"        curl dict://dict.org/m:curl\n"
"        curl dict://dict.org/d:heisenbug:jargon\n"
, stdout);
 fputs(
"        curl dict://dict.org/d:daniel:web1913\n"
"\n"
"  Aliases for 'm' are 'match' and 'find', and aliases for 'd' are 'define'\n"
"  and 'lookup'. For example,\n"
"\n"
"        curl dict://dict.org/find:curl\n"
"\n"
"  Commands that break the URL description of the RFC (but not the DICT\n"
"  protocol) are\n"
"\n"
"        curl dict://dict.org/show:db\n"
"        curl dict://dict.org/show:strat\n"
"\n"
"  Authentication is still missing (but this is not required by the RFC)\n"
"\n"
"LDAP\n"
"\n"
, stdout);
 fputs(
"  If you have installed the OpenLDAP library, curl can take advantage of it\n"
"  and offer ldap:// support.\n"
"\n"
"  LDAP is a complex thing and writing an LDAP query is not an easy task. I do\n"
"  advice you to dig up the syntax description for that elsewhere. Two places\n"
"  that might suit you are:\n"
"\n"
"  Netscape's \"Netscape Directory SDK 3.0 for C Programmer's Guide Chapter 10:\n"
"  Working with LDAP URLs\":\n"
"  http://developer.netscape.com/docs/manuals/dirsdk/csdk30/url.htm\n"
"\n"
, stdout);
 fputs(
"  RFC 2255, \"The LDAP URL Format\" http://www.rfc-editor.org/rfc/rfc2255.txt\n"
"\n"
"  To show you an example, this is now I can get all people from my local LDAP\n"
"  server that has a certain sub-domain in their email address:\n"
"\n"
"        curl -B \"ldap://ldap.frontec.se/o=frontec??sub?mail=*sth.frontec.se\"\n"
"\n"
"  If I want the same info in HTML format, I can get it by not using the -B\n"
"  (enforce ASCII) flag.\n"
"\n"
"ENVIRONMENT VARIABLES\n"
"\n"
"  Curl reads and understands the following environment variables:\n"
"\n"
, stdout);
 fputs(
"        http_proxy, HTTPS_PROXY, FTP_PROXY, GOPHER_PROXY\n"
"\n"
"  They should be set for protocol-specific proxies. General proxy should be\n"
"  set with\n"
"        \n"
"        ALL_PROXY\n"
"\n"
"  A comma-separated list of host names that shouldn't go through any proxy is\n"
"  set in (only an asterisk, '*' matches all hosts)\n"
"\n"
"        NO_PROXY\n"
"\n"
"  If a tail substring of the domain-path for a host matches one of these\n"
"  strings, transactions with that node will not be proxied.\n"
"\n"
"\n"
, stdout);
 fputs(
"  The usage of the -x/--proxy flag overrides the environment variables.\n"
"\n"
"NETRC\n"
"\n"
"  Unix introduced the .netrc concept a long time ago. It is a way for a user\n"
"  to specify name and password for commonly visited ftp sites in a file so\n"
"  that you don't have to type them in each time you visit those sites. You\n"
"  realize this is a big security risk if someone else gets hold of your\n"
"  passwords, so therefor most unix programs won't read this file unless it is\n"
, stdout);
 fputs(
"  only readable by yourself (curl doesn't care though).\n"
"\n"
"  Curl supports .netrc files if told so (using the -n/--netrc and\n"
"  --netrc-optional options). This is not restricted to only ftp,\n"
"  but curl can use it for all protocols where authentication is used.\n"
"\n"
"  A very simple .netrc file could look something like:\n"
"\n"
"        machine curl.haxx.se login iamdaniel password mysecret\n"
"\n"
"CUSTOM OUTPUT\n"
"\n"
"  To better allow script programmers to get to know about the progress of\n"
, stdout);
 fputs(
"  curl, the -w/--write-out option was introduced. Using this, you can specify\n"
"  what information from the previous transfer you want to extract.\n"
"\n"
"  To display the amount of bytes downloaded together with some text and an\n"
"  ending newline:\n"
"\n"
"        curl -w 'We downloaded %{size_download} bytes\\n' www.download.com\n"
"\n"
"KERBEROS4 FTP TRANSFER\n"
"\n"
"  Curl supports kerberos4 for FTP transfers. You need the kerberos package\n"
"  installed and used at curl build time for it to be used.\n"
"\n"
, stdout);
 fputs(
"  First, get the krb-ticket the normal way, like with the kauth tool. Then use\n"
"  curl in way similar to:\n"
"\n"
"        curl --krb4 private ftp://krb4site.com -u username:fakepwd\n"
"\n"
"  There's no use for a password on the -u switch, but a blank one will make\n"
"  curl ask for one and you already entered the real password to kauth.\n"
"\n"
"TELNET\n"
"\n"
"  The curl telnet support is basic and very easy to use. Curl passes all data\n"
"  passed to it on stdin to the remote server. Connect to a remote telnet\n"
, stdout);
 fputs(
"  server using a command line similar to:\n"
"\n"
"        curl telnet://remote.server.com\n"
"\n"
"  And enter the data to pass to the server on stdin. The result will be sent\n"
"  to stdout or to the file you specify with -o.\n"
"\n"
"  You might want the -N/--no-buffer option to switch off the buffered output\n"
"  for slow connections or similar.\n"
"\n"
"  Pass options to the telnet protocol negotiation, by using the -t option. To\n"
"  tell the server we use a vt100 terminal, try something like:\n"
"\n"
, stdout);
 fputs(
"        curl -tTTYPE=vt100 telnet://remote.server.com\n"
"\n"
"  Other interesting options for it -t include:\n"
"\n"
"   - XDISPLOC=<X display> Sets the X display location.\n"
"\n"
"   - NEW_ENV=<var,val> Sets an environment variable.\n"
"\n"
"  NOTE: the telnet protocol does not specify any way to login with a specified\n"
"  user and password so curl can't do that automatically. To do that, you need\n"
"  to track when the login prompt is received and send the username and\n"
"  password accordingly.\n"
"\n"
"PERSISTANT CONNECTIONS\n"
"\n"
, stdout);
 fputs(
"  Specifying multiple files on a single command line will make curl transfer\n"
"  all of them, one after the other in the specified order.\n"
"\n"
"  libcurl will attempt to use persistant connections for the transfers so that\n"
"  the second transfer to the same host can use the same connection that was\n"
"  already initiated and was left open in the previous transfer. This greatly\n"
"  decreases connection time for all but the first transfer and it makes a far\n"
"  better use of the network.\n"
"\n"
, stdout);
 fputs(
"  Note that curl cannot use persistant connections for transfers that are used\n"
"  in subsequence curl invokes. Try to stuff as many URLs as possible on the\n"
"  same command line if they are using the same host, as that'll make the\n"
"  transfers faster. If you use a http proxy for file transfers, practicly\n"
"  all transfers will be persistant.\n"
"\n"
"MAILING LISTS\n"
"\n"
"  For your convenience, we have several open mailing lists to discuss curl,\n"
"  its development and things relevant to this. Get all info at\n"
, stdout);
 fputs(
"  http://curl.haxx.se/mail/. The lists available are:\n"
"\n"
"  curl-users\n"
"\n"
"    Users of the command line tool. How to use it, what doesn't work, new\n"
"    features, related tools, questions, news, installations, compilations,\n"
"    running, porting etc.\n"
"\n"
"  curl-library\n"
"\n"
"    Developers using or developing libcurl. Bugs, extensions, improvements.\n"
"\n"
"  curl-announce\n"
"\n"
"    Low-traffic. Only announcements of new public versions.\n"
"\n"
"  curl-and-PHP\n"
"\n"
, stdout);
 fputs(
"    Using the curl functions in PHP. Everything curl with a PHP angle. Or PHP\n"
"    with a curl angle.\n"
"\n"
"  curl-commits\n"
"\n"
"    Receives notifications on all CVS commits done to the curl source module.\n"
"    This can become quite a large amount of mails during intense development,\n"
"    be aware. This is for us who like email...\n"
"\n"
"  curl-www-commits\n"
"\n"
"    Receives notifications on all CVS commits done to the curl www module\n"
"    (basicly the web site).  This can become quite a large amount of mails\n"
, stdout);
 fputs(
"    during intense changing, be aware. This is for us who like email...\n"
"\n"
"  Please direct curl questions, feature requests and trouble reports to one of\n"
"  these mailing lists instead of mailing any individual.\n"
, stdout) ;
}
#endif /* USE_MANUAL */
#else
/*
 * NEVER EVER edit this manually, fix the mkhelp.pl script instead!
 * Generation time: Mon Apr 26 08:08:53 2004
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef USE_MANUAL
#include "hugehelp.h"
#include <stdio.h>
#include <zlib.h>
static const unsigned char hugehelpgz[] = {
  /* This mumbo-jumbo is the huge help text compressed with gzip.
     Thanks to this operation, the size of this data shrunk from 96505
     to 29571 bytes. You can disable the use of compressed help
     texts by NOT passing -c to the mkhelp.pl tool. */
  0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0xed, 0xbd, 
  0xeb, 0x76, 0x1b, 0xd7, 0xb1, 0x2e, 0xfa, 0xfb, 0xf0, 0x29, 0x3a, 0xc8, 
  0x49, 0x40, 0x26, 0x00, 0x78, 0x91, 0xe4, 0x58, 0x8a, 0xe4, 0x84, 0xa6, 
  0x28, 0x99, 0xc3, 0x14, 0xc9, 0x4d, 0x52, 0xbe, 0x6c, 0xc7, 0x43, 0xa3, 
  0x01, 0x34, 0xc9, 0x0e, 0x81, 0x6e, 0xa4, 0xbb, 0x41, 0x0a, 0xce, 0xca, 
  0x79, 0xa3, 0xfc, 0xdb, 0x0f, 0x78, 0xaa, 0xbe, 0xaa, 0x9a, 0x73, 0xf6, 
  0x05, 0x94, 0x9c, 0x44, 0xce, 0xf9, 0x71, 0xbc, 0x56, 0x44, 0x12, 0xe8, 
  0x9e, 0xd7, 0x9a, 0x35, 0xeb, 0xfa, 0x55, 0x14, 0x7d, 0xe8, 0xbf, 0x77, 
  0xf8, 0xdf, 0x3b, 0xfa, 0x4f, 0x7e, 0x8f, 0xa2, 0x8d, 0x28, 0x3a, 0x2b, 
  0xf2, 0xbf, 0x26, 0x93, 0xaa, 0xfb, 0x85, 0x77, 0xef, 0xfe, 0x27, 0x92, 
  0xff, 0xa3, 0x17, 0xfe, 0x82, 0x9f, 0x78, 0xe9, 0x81, 0xff, 0xb6, 0x23, 
  0xff, 0xd2, 0xff, 0xbc, 0xdb, 0x8a, 0x3e, 0xe6, 0xa5, 0xff, 0x89, 0x36, 
  0xf1, 0xd2, 0x3b, 0xed, 0xe9, 0x39, 0xff, 0x4e, 0xa3, 0x7c, 0xb8, 0xa7, 
  0xbf, 0xf0, 0xf0, 0xf8, 0x9f, 0x6d, 0x7e, 0xf1, 0x2f, 0xef, 0xf8, 0x57, 
  0xfa, 0x64, 0x63, 0xe3, 0x64, 0xff, 0xcd, 0xa1, 0xbd, 0x3a, 0x59, 0x16, 
  0xb3, 0x68, 0x18, 0x55, 0x45, 0x9c, 0x95, 0x57, 0x49, 0x11, 0xc5, 0xd1, 
  0xdb, 0xf3, 0xe3, 0x8d, 0x8d, 0x8b, 0xef, 0x4f, 0x4e, 0xcf, 0x2e, 0x8e, 
  0x2e, 0x6a, 0x8f, 0xfd, 0x90, 0x2f, 0xaa, 0x34, 0xcf, 0xca, 0x1f, 0xa3, 
  0x1f, 0xe8, 0xa1, 0xd1, 0x68, 0xf4, 0xe3, 0xc6, 0xc6, 0xcb, 0xc3, 0x8b, 
  0x83, 0xf3, 0xa3, 0xb3, 0xcb, 0xa3, 0xd3, 0x93, 0xda, 0xb3, 0x69, 0x49, 
  0x4d, 0x55, 0x79, 0x3e, 0xa3, 0x7f, 0x7c, 0xeb, 0xd3, 0xb8, 0x8a, 0xa3, 
  0xab, 0x22, 0x9f, 0x47, 0x79, 0xc1, 0x5f, 0xc4, 0x51, 0x99, 0x14, 0x77, 
  0x49, 0x31, 0x88, 0x96, 0x65, 0x9a, 0x5d, 0x5b, 0x0b, 0x79, 0x96, 0x44, 
  0xf9, 0x55, 0x54, 0xdd, 0x24, 0x51, 0xb9, 0x5c, 0x2c, 0xf2, 0xa2, 0x4a, 
  0xa6, 0xd1, 0xa2, 0xc8, 0xab, 0x7c, 0x92, 0xcf, 0xca, 0x68, 0xf3, 0xab, 
  0xcb, 0xcb, 0xb3, 0x41, 0x14, 0xf1, 0x8f, 0x0b, 0xfa, 0xf9, 0x0a, 0x7f, 
  0xbd, 0xe2, 0x3f, 0xac, 0x85, 0xd7, 0xa7, 0x67, 0x5f, 0x1d, 0x9e, 0xd3, 
  0xa7, 0x2f, 0x8f, 0x0e, 0x2e, 0xe9, 0xc7, 0xe5, 0xe1, 0xf1, 0xc9, 0x21, 
  0xff, 0x72, 0xfc, 0x72, 0xff, 0x2c, 0xe2, 0xde, 0xa3, 0x57, 0x47, 0xc7, 
  0x87, 0x5b, 0x23, 0xfa, 0x8a, 0x7a, 0x89, 0x26, 0xf9, 0x7c, 0x1e, 0x67, 
  0x53, 0x1a, 0xb6, 0xb5, 0x30, 0x4d, 0xca, 0xf4, 0x3a, 0xa3, 0x7e, 0x69, 
  0x98, 0xf7, 0x79, 0x71, 0x1b, 0xdd, 0xa7, 0xd5, 0x4d, 0xbe, 0xac, 0x68, 
  0xa4, 0x34, 0x91, 0x34, 0xab, 0x92, 0x22, 0x9e, 0xf0, 0x72, 0x8c, 0x36, 
  0x6a, 0x13, 0xcf, 0xaf, 0x68, 0xa2, 0x3c, 0xf9, 0xf1, 0xb2, 0x9c, 0xe5, 
  0xf1, 0x94, 0x27, 0x42, 0xaf, 0x5c, 0x2d, 0x69, 0x25, 0x8a, 0x74, 0x72, 
  0x5b, 0x46, 0xb3, 0xf4, 0x36, 0xe1, 0xd9, 0xbc, 0x5f, 0xd9, 0xec, 0xdc, 
  0xb0, 0xd1, 0x76, 0x14, 0x2f, 0x69, 0xe6, 0x59, 0x95, 0x4e, 0x62, 0x6e, 
  0x9f, 0x06, 0x7d, 0x55, 0x2d, 0xa2, 0xe5, 0x82, 0x5b, 0x1b, 0x60, 0xd2, 
  0xd1, 0x22, 0x2f, 0xab, 0x41, 0x74, 0x71, 0x71, 0x1c, 0x6d, 0xde, 0x54, 
  0xd5, 0xa2, 0x7c, 0xb6, 0xe5, 0xc6, 0x90, 0x67, 0x59, 0x82, 0x71, 0x95, 
  0x03, 0xfa, 0x23, 0xbf, 0x4d, 0x13, 0xfa, 0xe5, 0x2a, 0x9d, 0x25, 0x7e, 
  0x17, 0x8a, 0xa4, 0x5c, 0xce, 0x69, 0xd2, 0x3c, 0xe1, 0x68, 0x9e, 0x17, 
  0x09, 0xad, 0xc2, 0xbe, 0x9b, 0xf8, 0x2a, 0x5f, 0x46, 0x34, 0xd9, 0xd9, 
  0x8c, 0xf6, 0x26, 0x89, 0xc6, 0xc9, 0x2c, 0xbf, 0x1f, 0x60, 0x2b, 0xe2, 
  0x79, 0xbe, 0xcc, 0x2a, 0x9e, 0xcf, 0x55, 0x12, 0x57, 0x4b, 0x6a, 0x45, 
  0x1e, 0x9b, 0xc7, 0x34, 0x1f, 0x7a, 0xab, 0xb0, 0x16, 0x6e, 0x12, 0x9a, 
  0x76, 0xb9, 0x48, 0xb3, 0x5f, 0x6d, 0x34, 0x69, 0x62, 0x91, 0xdf, 0x27, 
  0x05, 0x2d, 0xea, 0x78, 0x45, 0xcb, 0x30, 0xc6, 0xa7, 0x57, 0xb4, 0x19, 
  0x31, 0x35, 0xe3, 0xc6, 0x37, 0x2c, 0x92, 0x59, 0xcc, 0x3b, 0xce, 0xfd, 
  0xfc, 0xd3, 0x5a, 0x40, 0x87, 0xa3, 0xe8, 0x82, 0xc6, 0xa4, 0x6f, 0x6e, 
  0x3e, 0xda, 0xc2, 0xcb, 0xd3, 0xa4, 0x8a, 0xd3, 0x59, 0x49, 0xfb, 0xc0, 
  0xa4, 0xab, 0x8f, 0x63, 0x57, 0xe9, 0xef, 0x28, 0x2a, 0x57, 0x59, 0x15, 
  0xbf, 0x8f, 0xb8, 0x77, 0x47, 0x43, 0xbc, 0xbd, 0x8b, 0x24, 0x9b, 0xd2, 
  0x2a, 0xd3, 0xdc, 0xbf, 0xcf, 0x97, 0x7d, 0x1e, 0xc0, 0x55, 0x4a, 0x0b, 
  0x12, 0x7b, 0x02, 0xe0, 0x66, 0x69, 0x18, 0x44, 0x09, 0x93, 0x22, 0x05, 
  0xe9, 0xd3, 0xbe, 0x47, 0xe7, 0xaf, 0x0e, 0xa2, 0xbd, 0x47, 0x4f, 0x3f, 
  0xf3, 0xfb, 0x4e, 0xef, 0x47, 0x93, 0x38, 0xa3, 0x29, 0x27, 0x93, 0xf4, 
  0x6a, 0x15, 0xcd, 0x97, 0xb3, 0x2a, 0x5d, 0xd0, 0x8a, 0x53, 0xff, 0x25, 
  0xd3, 0xda, 0x22, 0x2e, 0xaa, 0x92, 0x17, 0x0e, 0x1f, 0xd0, 0xdc, 0xa3, 
  0xfb, 0x22, 0xad, 0x02, 0x82, 0xe7, 0x07, 0x68, 0xb9, 0xab, 0x12, 0x54, 
  0x46, 0x9d, 0x8c, 0x89, 0xb8, 0x68, 0x7d, 0xe3, 0x92, 0x7a, 0x7c, 0xe6, 
  0x3a, 0x8a, 0x78, 0xb3, 0x9f, 0x6d, 0x6f, 0x97, 0x69, 0x95, 0x8c, 0xfe, 
  0x4e, 0xa7, 0x64, 0x50, 0xdd, 0xe7, 0x83, 0xea, 0xa6, 0x48, 0x92, 0x7f, 
  0x8c, 0x88, 0x84, 0xdd, 0x83, 0x4c, 0xdf, 0xd8, 0x47, 0x1e, 0xd6, 0x75, 
  0xc2, 0x6d, 0xff, 0x6d, 0x99, 0x64, 0xdc, 0x24, 0x8d, 0x22, 0x9e, 0x2d, 
  0x6e, 0xe2, 0x8c, 0x48, 0x80, 0xe8, 0x91, 0x0f, 0x20, 0x91, 0x08, 0x0f, 
  0xaa, 0x76, 0x04, 0x7f, 0xf8, 0xb1, 0xd5, 0xf9, 0x15, 0xfa, 0xa6, 0x7f, 
  0x47, 0xfa, 0x6e, 0x4c, 0x8b, 0x4e, 0xbd, 0x6e, 0x33, 0x75, 0xfd, 0xb0, 
  0x3b, 0xdc, 0xdd, 0xd9, 0xf9, 0x71, 0x54, 0xbd, 0xaf, 0x3e, 0xf2, 0x85, 
  0x9d, 0x1d, 0xff, 0x0a, 0x3f, 0xbd, 0xc9, 0x53, 0x8f, 0x66, 0x44, 0x3b, 
  0x6e, 0xcf, 0x69, 0x3c, 0xd1, 0x4f, 0x49, 0x91, 0x97, 0x5b, 0x1d, 0x6d, 
  0xce, 0x92, 0x8a, 0xce, 0x60, 0xd0, 0x60, 0x3c, 0xfc, 0x49, 0xfa, 0xb7, 
  0x87, 0x4f, 0xf2, 0x28, 0x4b, 0x4a, 0x5e, 0x67, 0xc7, 0x4d, 0xdc, 0x32, 
  0x10, 0x35, 0x78, 0xd6, 0x12, 0x57, 0xf8, 0x76, 0x9e, 0xcf, 0x89, 0x20, 
  0xda, 0xcb, 0x7d, 0x7f, 0x7f, 0x3f, 0x8a, 0xb3, 0xd5, 0x28, 0x2f, 0xae, 
  0xb7, 0xe3, 0x62, 0x72, 0x93, 0xde, 0xd1, 0x74, 0x9f, 0x3e, 0xfd, 0x6c, 
  0x48, 0xff, 0x3c, 0xfd, 0x71, 0xfb, 0x2e, 0x9f, 0xb9, 0x11, 0xd3, 0x3c, 
  0x69, 0x25, 0x1e, 0xff, 0xc8, 0x1b, 0xfa, 0xf7, 0x78, 0x30, 0x1e, 0x4c, 
  0x06, 0x44, 0x54, 0xc9, 0xfb, 0x7f, 0x8c, 0x6e, 0xaa, 0xf9, 0x6c, 0x2d, 
  0xc5, 0x50, 0xeb, 0xc1, 0xf1, 0x12, 0xb2, 0xc9, 0x22, 0x0c, 0xca, 0xb1, 
  0x26, 0x22, 0xfb, 0x2c, 0x19, 0x05, 0xf4, 0xbd, 0xd2, 0x63, 0x3a, 0x4e, 
  0xe8, 0xa0, 0x54, 0x93, 0x1b, 0x9a, 0x08, 0x51, 0x4e, 0xac, 0x93, 0xac, 
  0xd2, 0x98, 0x8f, 0x26, 0x71, 0x03, 0xe6, 0x56, 0x32, 0x7b, 0xee, 0xcd, 
  0x0d, 0xf5, 0x2a, 0xa5, 0x17, 0xf2, 0x62, 0x9a, 0x14, 0x9e, 0x92, 0x0f, 
  0xf8, 0x40, 0xa2, 0xd1, 0x98, 0x16, 0x77, 0xbe, 0xa8, 0x98, 0xfb, 0x15, 
  0xc9, 0x90, 0xf8, 0x52, 0xc8, 0x59, 0x70, 0xec, 0x1c, 0x95, 0x83, 0xbb, 
  0xb8, 0x63, 0xaa, 0x87, 0x98, 0x98, 0x4e, 0x49, 0x8c, 0xff, 0x86, 0x96, 
  0x96, 0xe8, 0x0f, 0x7b, 0x30, 0xe7, 0x59, 0xf2, 0xb3, 0xa5, 0x5c, 0x01, 
  0x18, 0x52, 0x3c, 0x4f, 0xf4, 0x0e, 0xb0, 0x16, 0xd0, 0x7d, 0x96, 0x57, 
  0xd1, 0x34, 0xf7, 0x7d, 0x68, 0xe7, 0x25, 0x5d, 0x9f, 0x44, 0xba, 0xd3, 
  0xf2, 0x86, 0x78, 0x0e, 0x71, 0x83, 0xcb, 0x1b, 0x3e, 0xd5, 0xe9, 0x9c, 
  0xce, 0xf5, 0x5d, 0xe2, 0x38, 0x18, 0xcd, 0x33, 0x99, 0x8e, 0xa2, 0xd3, 
  0x2b, 0x7a, 0x6d, 0x59, 0xd0, 0xd0, 0x2b, 0x7e, 0x2c, 0xe5, 0x35, 0x9d, 
  0xad, 0xa8, 0x59, 0xbe, 0x5d, 0x32, 0x1d, 0x89, 0xec, 0x00, 0x96, 0x22, 
  0xf3, 0x67, 0x9f, 0x4f, 0x02, 0x7a, 0x95, 0xa5, 0xe7, 0x95, 0x07, 0xb7, 
  0xa4, 0x3d, 0xe3, 0x91, 0xd1, 0x8a, 0x33, 0xab, 0xa6, 0x3d, 0x19, 0x27, 
  0xd5, 0x7d, 0x92, 0xd0, 0x56, 0x95, 0x09, 0x6d, 0x39, 0x71, 0xad, 0x3a, 
  0xc3, 0xcb, 0xee, 0x72, 0x1e, 0xe7, 0xc6, 0xc6, 0x29, 0x6e, 0x48, 0x77, 
  0x9d, 0x0e, 0xe3, 0xed, 0xe1, 0x30, 0x5e, 0x30, 0x0b, 0x6a, 0xdc, 0xe1, 
  0x9b, 0x74, 0x8d, 0x6d, 0x45, 0xd1, 0xb7, 0x37, 0xdc, 0xa8, 0xf4, 0xc1, 
  0x9b, 0x9a, 0xf1, 0xf5, 0xe6, 0xee, 0x00, 0xcc, 0x07, 0xeb, 0x54, 0x25, 
  0xb3, 0x59, 0xa3, 0x05, 0xf4, 0xcc, 0x77, 0x2b, 0x9a, 0xc7, 0xf5, 0x4b, 
  0x0b, 0x5d, 0xc5, 0x05, 0xf3, 0x01, 0x5c, 0x04, 0x69, 0x56, 0x56, 0x89, 
  0xdc, 0x4c, 0x11, 0xad, 0x5b, 0xf1, 0xcf, 0x46, 0x0b, 0xca, 0x9c, 0xa8, 
  0x67, 0xe6, 0x8e, 0x47, 0x72, 0x74, 0xf0, 0xe6, 0x34, 0x4f, 0xca, 0xac, 
  0x5f, 0x45, 0xc9, 0xfb, 0x94, 0x2f, 0xa0, 0xb4, 0x32, 0x0a, 0x6c, 0x8e, 
  0xa1, 0x48, 0x98, 0x83, 0x7b, 0xc2, 0xd2, 0xff, 0xd0, 0x16, 0x6f, 0x84, 
  0x72, 0xd3, 0x52, 0xa6, 0x58, 0xdd, 0xa7, 0x93, 0x64, 0xa0, 0x27, 0x94, 
  0xb6, 0x7a, 0x2a, 0x22, 0x00, 0x1a, 0x6f, 0xb4, 0x30, 0x4d, 0xcb, 0x78, 
  0x4c, 0x23, 0xd1, 0xd9, 0xcd, 0xf3, 0x29, 0xfd, 0x7e, 0x1d, 0xa7, 0xc1, 
  0x35, 0x3c, 0xdc, 0xa7, 0xc5, 0xe5, 0x9b, 0x74, 0x18, 0x5f, 0xd3, 0x39, 
  0x88, 0x9e, 0xcb, 0x8f, 0x92, 0xae, 0xdf, 0xec, 0xfa, 0x8b, 0xe6, 0x7a, 
  0xf3, 0x7d, 0xba, 0x15, 0x5d, 0xe8, 0x41, 0xe4, 0x21, 0xbc, 0xe5, 0x57, 
  0xf7, 0x83, 0x77, 0x78, 0x0d, 0x4b, 0xbf, 0x96, 0x8d, 0x16, 0x70, 0x21, 
  0x0b, 0x09, 0xd3, 0xf5, 0x44, 0x2c, 0x24, 0x1a, 0xc7, 0x53, 0xa3, 0xb3, 
  0x83, 0xd7, 0x47, 0x44, 0xed, 0x74, 0x8f, 0x44, 0xe9, 0x15, 0xaf, 0x27, 
  0x51, 0x2b, 0x11, 0x50, 0xa3, 0x05, 0x62, 0xfc, 0x11, 0xb7, 0x1d, 0xf5, 
  0xde, 0xe4, 0x3f, 0xd1, 0x94, 0xe3, 0xed, 0xc7, 0xa3, 0x9d, 0xde, 0x88, 
  0x4f, 0x39, 0x7d, 0x48, 0xfc, 0x8a, 0x27, 0x19, 0x8d, 0x67, 0x71, 0x76, 
  0x5b, 0xea, 0x59, 0x6e, 0xb6, 0x80, 0x71, 0x92, 0xa4, 0x50, 0x2e, 0x8b, 
  0x82, 0xd8, 0xc8, 0x54, 0x79, 0x87, 0x8e, 0x1f, 0xb7, 0x8a, 0xa3, 0xea, 
  0xe8, 0x6f, 0xcb, 0xbc, 0x6a, 0xb6, 0x30, 0x8f, 0x8b, 0xdb, 0x12, 0x5d, 
  0xe2, 0x48, 0x31, 0x73, 0x22, 0x6e, 0x9d, 0x33, 0xa9, 0xf3, 0xf0, 0xd0, 
  0x00, 0x37, 0x39, 0xfc, 0x8a, 0x16, 0x97, 0x2f, 0x78, 0x7f, 0x60, 0xed, 
  0xce, 0x91, 0x3d, 0xcd, 0xed, 0xd4, 0x7d, 0xc4, 0xe6, 0x73, 0xcb, 0x2c, 
  0x7f, 0x30, 0x9f, 0xa0, 0x37, 0x33, 0x23, 0x82, 0x59, 0x5c, 0x56, 0x20, 
  0x81, 0x26, 0x61, 0x2a, 0xbb, 0xe3, 0x67, 0x78, 0x75, 0x99, 0xbd, 0xf4, 
  0x85, 0x86, 0x82, 0xed, 0x1f, 0x12, 0x9f, 0x61, 0x11, 0xaa, 0x7b, 0xa7, 
  0xa3, 0x4b, 0x3a, 0x32, 0xa5, 0x1e, 0x13, 0xac, 0xfa, 0x55, 0x7a, 0x4d, 
  0xb2, 0x05, 0xf5, 0x47, 0xc2, 0x5d, 0x5d, 0xf4, 0x6a, 0xae, 0x51, 0x42, 
  0x12, 0x20, 0x64, 0x17, 0xda, 0xc8, 0x64, 0x76, 0x35, 0x00, 0x4f, 0x58, 
  0x96, 0x89, 0xde, 0x1e, 0x25, 0xdf, 0xb3, 0x13, 0x69, 0x8b, 0xc9, 0xb7, 
  0xbd, 0x4f, 0x45, 0x32, 0xa7, 0xa5, 0xe7, 0x9d, 0xe0, 0x7f, 0x27, 0xb3, 
  0x38, 0x9d, 0x33, 0xff, 0xaa, 0x22, 0xbb, 0x8c, 0x8c, 0xa7, 0xd1, 0xff, 
  0x83, 0x7e, 0xc6, 0xab, 0x46, 0x0b, 0x57, 0x69, 0x51, 0x32, 0x6b, 0xe4, 
  0x6d, 0x8d, 0xa9, 0x3d, 0x62, 0xf5, 0xf4, 0x37, 0xee, 0x07, 0xba, 0x01, 
  0x26, 0xb7, 0xd8, 0x6e, 0xec, 0x3d, 0x89, 0x4b, 0x0b, 0xe2, 0xd5, 0xc9, 
  0xb0, 0xd1, 0x82, 0x6c, 0x5e, 0xc9, 0x2b, 0xbd, 0x64, 0x72, 0x9a, 0x2e, 
  0x27, 0x68, 0x2c, 0xa3, 0x53, 0x4d, 0xdc, 0x9b, 0xae, 0xcc, 0x0a, 0xf2, 
  0x2e, 0xe8, 0x68, 0x48, 0x04, 0xb4, 0x18, 0x35, 0x5a, 0xb0, 0x11, 0xe2, 
  0xec, 0x06, 0xcc, 0xa4, 0x54, 0x46, 0x1f, 0x1b, 0x57, 0x9d, 0x98, 0x2c, 
  0xdb, 0xe4, 0x30, 0xb6, 0xc0, 0xb6, 0xa6, 0x44, 0xb9, 0xf7, 0x37, 0xe9, 
  0xe4, 0x26, 0x90, 0x5a, 0x88, 0xfb, 0x83, 0xe8, 0x86, 0xc3, 0x71, 0x5c, 
  0xa6, 0x93, 0x41, 0xa3, 0x85, 0xe1, 0x70, 0x9a, 0x5e, 0x27, 0xcc, 0x84, 
  0xe8, 0xd7, 0xac, 0x9a, 0xcd, 0x07, 0x2a, 0xcf, 0xd2, 0x5f, 0xc9, 0x75, 
  0x4e, 0xb7, 0x5f, 0xc5, 0x62, 0x6d, 0xb4, 0xb9, 0x3f, 0x9d, 0x32, 0x13, 
  0xa5, 0x71, 0x36, 0x5a, 0xf8, 0xc3, 0x68, 0x77, 0x67, 0xf4, 0xd9, 0xd6, 
  0x47, 0xb2, 0xa8, 0x32, 0xa1, 0xf3, 0x4d, 0x37, 0x6a, 0x95, 0xce, 0x93, 
  0x52, 0xa8, 0xf4, 0x2a, 0x9f, 0x91, 0x6c, 0x1c, 0xc8, 0x4c, 0x76, 0x10, 
  0x26, 0x44, 0x03, 0x85, 0x88, 0x19, 0x90, 0x8d, 0xb3, 0x9c, 0xd8, 0x16, 
  0xab, 0x05, 0xfc, 0x59, 0x40, 0xa8, 0x63, 0x3a, 0x4a, 0x22, 0xa2, 0x47, 
  0xcf, 0x33, 0xba, 0x08, 0x5f, 0xb0, 0x7a, 0xb4, 0x86, 0x41, 0x9d, 0xc5, 
  0x65, 0x29, 0xfb, 0x0a, 0x1d, 0x0a, 0x84, 0x8b, 0x3f, 0xc1, 0x7e, 0x94, 
  0xff, 0x44, 0x2c, 0xb3, 0xf9, 0x5b, 0xcc, 0xa9, 0x04, 0xdc, 0x05, 0x2f, 
  0xc6, 0x51, 0x25, 0x62, 0x30, 0x88, 0x8d, 0x66, 0x45, 0x5c, 0x2a, 0x6c, 
  0x73, 0x51, 0x24, 0x77, 0x69, 0x4e, 0x6a, 0xcb, 0xaa, 0x45, 0xb6, 0x93, 
  0x84, 0x84, 0x9e, 0x69, 0x70, 0x6f, 0x4b, 0x7f, 0x90, 0x37, 0xa2, 0xde, 
  0x45, 0x52, 0x0d, 0x0f, 0xd0, 0xcb, 0xb3, 0x5e, 0x43, 0x4e, 0x09, 0xc5, 
  0x71, 0xe9, 0xa5, 0x24, 0x2d, 0x6a, 0x86, 0xab, 0x33, 0x32, 0xc1, 0x84, 
  0xc4, 0x89, 0x39, 0x09, 0x0a, 0x3d, 0x56, 0x4c, 0x77, 0x5f, 0x7c, 0xb3, 
  0x7f, 0xfc, 0xf6, 0x70, 0xf7, 0x8f, 0x8d, 0x16, 0xf8, 0xbb, 0x3d, 0xf9, 
  0x6e, 0xaf, 0xd7, 0xc5, 0x5b, 0x68, 0x95, 0xfb, 0x2f, 0xfa, 0x91, 0x88, 
  0x85, 0x01, 0x79, 0x0a, 0x47, 0xa1, 0x31, 0xe1, 0xbe, 0xa2, 0xcf, 0x2b, 
  0xb9, 0x9c, 0x1a, 0x2d, 0x60, 0xe5, 0x44, 0x96, 0xe1, 0xbd, 0x90, 0x15, 
  0xe6, 0xb3, 0x2d, 0x22, 0x50, 0x3c, 0x0d, 0x96, 0x87, 0xf8, 0x2a, 0x71, 
  0xad, 0x69, 0xe7, 0x3a, 0xa3, 0x2b, 0x91, 0x70, 0x06, 0x4a, 0xd4, 0xe1, 
  0x8c, 0xdd, 0x95, 0x0e, 0x2a, 0x6b, 0x5d, 0x04, 0x65, 0x09, 0xa2, 0xc3, 
  0x95, 0x4b, 0x8a, 0x44, 0x4c, 0x62, 0xdd, 0x88, 0x2e, 0x24, 0x5c, 0x42, 
  0x4c, 0x95, 0xca, 0x82, 0xc0, 0x9a, 0x59, 0xfd, 0x6c, 0x1e, 0xac, 0x3b, 
  0x9a, 0x99, 0xd0, 0x49, 0x4f, 0x87, 0xc3, 0xba, 0x05, 0xed, 0x56, 0xcf, 
  0x9d, 0x30, 0x30, 0x51, 0x21, 0x4c, 0x30, 0xc1, 0xf6, 0x5e, 0x93, 0x50, 
  0xc8, 0x43, 0x24, 0xe9, 0x87, 0xfb, 0x55, 0x25, 0x92, 0x95, 0x79, 0x9b, 
  0xd0, 0x3c, 0x5e, 0xf1, 0x64, 0x58, 0x12, 0x23, 0x5e, 0x78, 0xd5, 0x68, 
  0x81, 0x8e, 0x70, 0xbf, 0xc0, 0x54, 0x95, 0x19, 0x31, 0xc9, 0x61, 0xca, 
  0x2c, 0x50, 0x8d, 0xd3, 0x4c, 0x8f, 0xbe, 0xde, 0x4a, 0x1d, 0x6c, 0x72, 
  0x78, 0x4c, 0x27, 0x63, 0x96, 0x1b, 0x8f, 0x90, 0xa3, 0xa8, 0xaa, 0x3a, 
  0xe4, 0x10, 0x25, 0x98, 0xdc, 0x8b, 0x26, 0x4d, 0x06, 0xa3, 0x7b, 0x66, 
  0x83, 0x07, 0xe1, 0xea, 0x3e, 0xd0, 0xc8, 0x17, 0xc4, 0x79, 0x33, 0x3b, 
  0x3b, 0xca, 0x10, 0x9b, 0xa7, 0xb8, 0x40, 0xdb, 0x27, 0xa4, 0x94, 0x4d, 
  0xe2, 0x45, 0xb2, 0xad, 0x57, 0xb3, 0xed, 0x72, 0x30, 0x8c, 0x16, 0x31, 
  0x9e, 0x9c, 0x5e, 0x1e, 0x46, 0x22, 0xfb, 0xca, 0xf1, 0xc2, 0xc3, 0x5e, 
  0xd2, 0x14, 0xbe, 0x16, 0x9c, 0xfe, 0x16, 0x21, 0x40, 0x50, 0x05, 0xa9, 
  0x40, 0x09, 0x5b, 0x2c, 0x49, 0x10, 0x23, 0x6d, 0xc6, 0x66, 0x23, 0x5b, 
  0x38, 0xc6, 0x05, 0xcf, 0x84, 0xd8, 0xc1, 0xdd, 0x6c, 0x5d, 0x46, 0x2c, 
  0x43, 0xe0, 0x29, 0x6f, 0x0d, 0xb0, 0x1b, 0x6b, 0x38, 0x71, 0x43, 0x18, 
  0xfe, 0x35, 0x5e, 0x77, 0x9f, 0x17, 0xe0, 0xc9, 0x13, 0x2c, 0x1d, 0x31, 
  0x41, 0x52, 0x5a, 0xe2, 0x3b, 0x79, 0x1f, 0xcb, 0xa7, 0xab, 0x07, 0x89, 
  0xb3, 0x75, 0x57, 0xd1, 0xb4, 0x85, 0x0a, 0x86, 0x2f, 0xa9, 0xab, 0xe9, 
  0x72, 0xbe, 0x50, 0xd9, 0xe1, 0x57, 0x1d, 0x07, 0xf8, 0x67, 0x49, 0x07, 
  0xff, 0xaa, 0x70, 0xf0, 0xa5, 0xc8, 0x86, 0xc3, 0xb8, 0x9c, 0xa4, 0x69, 
  0xa3, 0x05, 0x12, 0xfc, 0xa2, 0xfd, 0x8b, 0x83, 0xa3, 0x23, 0x6f, 0x2a, 
  0xb9, 0x67, 0x39, 0xdc, 0x14, 0x18, 0x95, 0xc2, 0x31, 0x2d, 0x5a, 0x16, 
  0x36, 0x25, 0x35, 0x5a, 0x48, 0xb3, 0xab, 0x9c, 0xe8, 0xf4, 0x15, 0xec, 
  0x4b, 0x6c, 0x95, 0xc2, 0x94, 0x42, 0x61, 0x2a, 0xa1, 0x27, 0x8a, 0x89, 
  0x58, 0x40, 0x6a, 0x0a, 0xb7, 0xb1, 0xa1, 0x0c, 0x56, 0x0b, 0x10, 0x0f, 
  0x89, 0x9c, 0x62, 0x10, 0x88, 0x7a, 0x7f, 0xac, 0x56, 0x8b, 0xe4, 0xc5, 
  0x7e, 0x4f, 0xc5, 0x03, 0x5d, 0xa4, 0x49, 0x4c, 0x53, 0x69, 0xd2, 0x8e, 
  0x72, 0x59, 0x16, 0x5f, 0xc1, 0xc3, 0xca, 0x6a, 0xca, 0x92, 0x4d, 0x85, 
  0xee, 0x99, 0x1d, 0xd2, 0x35, 0x2f, 0x72, 0x33, 0x6b, 0x71, 0x74, 0x7f, 
  0x3d, 0xda, 0x6b, 0xb2, 0xa1, 0x15, 0x5d, 0xe9, 0xf3, 0xf2, 0x13, 0x4a, 
  0xef, 0xb2, 0xca, 0xcb, 0x92, 0x24, 0xf3, 0x50, 0x70, 0xc3, 0x4d, 0xdf, 
  0x7d, 0xff, 0x89, 0xd4, 0x66, 0xba, 0x0d, 0x53, 0x30, 0xa8, 0xef, 0x4b, 
  0x7e, 0xa3, 0x21, 0xb5, 0xad, 0x13, 0x57, 0x78, 0x80, 0xd3, 0xe4, 0x2a, 
  0x26, 0x9d, 0x52, 0x65, 0x05, 0x61, 0x4d, 0x3a, 0x1d, 0xdc, 0x8c, 0xcb, 
  0x72, 0x19, 0xcf, 0x5a, 0xf7, 0xdf, 0x82, 0xc4, 0xad, 0x8a, 0xb4, 0x45, 
  0x3a, 0x3b, 0xd1, 0x32, 0xe3, 0x5f, 0x44, 0x50, 0xe1, 0x61, 0xa4, 0x58, 
  0x5a, 0x56, 0xa3, 0x8a, 0x94, 0x75, 0x11, 0xb9, 0x26, 0x9a, 0x7c, 0x59, 
  0xaf, 0x0d, 0xa2, 0x68, 0xed, 0x0d, 0x1b, 0x0c, 0x8b, 0x4f, 0xec, 0x84, 
  0x83, 0x2a, 0x34, 0xfd, 0xb5, 0x45, 0x26, 0x7a, 0x4b, 0xd9, 0xff, 0x66, 
  0xb9, 0x24, 0x2e, 0x4c, 0xac, 0xc1, 0x44, 0x1f, 0x93, 0x86, 0x30, 0x2d, 
  0x93, 0x80, 0x9a, 0x2d, 0xd0, 0xd5, 0xb0, 0x35, 0x32, 0x81, 0x88, 0x08, 
  0xe1, 0xbf, 0x2f, 0x00, 0x0d, 0x27, 0xe9, 0xe2, 0x86, 0x99, 0xc7, 0xf3, 
  0x59, 0x5a, 0x82, 0x9d, 0xeb, 0x07, 0x2d, 0x21, 0xe8, 0xe2, 0xe2, 0xd8, 
  0x94, 0x34, 0x30, 0x40, 0x5c, 0x43, 0xf6, 0xb6, 0x12, 0x84, 0x5e, 0xf5, 
  0x62, 0x2a, 0xe8, 0x5a, 0xbe, 0x11, 0x2e, 0x10, 0x74, 0x05, 0xdd, 0xd7, 
  0xde, 0x8f, 0xe6, 0x4b, 0xfe, 0x68, 0xec, 0xef, 0xac, 0xbb, 0x78, 0x96, 
  0xb6, 0xae, 0x77, 0x79, 0x7a, 0x14, 0x9d, 0xf3, 0xc5, 0xb2, 0x5c, 0xb0, 
  0xc1, 0x80, 0x2d, 0xb0, 0xf2, 0xb9, 0x34, 0xab, 0xa6, 0xc8, 0x08, 0x1b, 
  0xdc, 0xe2, 0xea, 0x74, 0xb0, 0x9f, 0x85, 0x36, 0xa5, 0x9c, 0x54, 0xd8, 
  0xb2, 0x9c, 0xc1, 0xae, 0x34, 0xcd, 0x27, 0xe5, 0x36, 0x29, 0xb5, 0xe5, 
  0xb6, 0xf5, 0x53, 0x33, 0x18, 0xfd, 0xec, 0xbd, 0x79, 0x50, 0x85, 0x72, 
  0xd4, 0x0a, 0x5e, 0x59, 0xa1, 0xbb, 0x70, 0x57, 0xf2, 0x39, 0x11, 0x71, 
  0x59, 0xb6, 0x24, 0x1c, 0x53, 0xa1, 0xce, 0x55, 0xed, 0x88, 0xf8, 0x3a, 
  0xb4, 0x67, 0x9d, 0xc2, 0xa1, 0x8b, 0x28, 0x46, 0xfc, 0x8e, 0x6b, 0x29, 
  0x9e, 0x5d, 0xe7, 0x05, 0x71, 0xb5, 0x79, 0xe9, 0x6c, 0xc0, 0x4e, 0xfd, 
  0x31, 0x29, 0xbe, 0x48, 0xaa, 0x65, 0x91, 0x75, 0xc9, 0x06, 0xcb, 0x2c, 
  0xe8, 0x92, 0xb4, 0x84, 0xc9, 0x72, 0x2e, 0x56, 0xdc, 0x35, 0x6b, 0x13, 
  0xb7, 0x4c, 0x2c, 0x81, 0xfc, 0x5a, 0x82, 0xc5, 0x12, 0xcf, 0x5d, 0x66, 
  0xde, 0x1a, 0x08, 0x85, 0x1b, 0xea, 0xb4, 0x33, 0x87, 0xb5, 0x64, 0x24, 
  0x7e, 0x14, 0x2a, 0x13, 0xa9, 0xdb, 0xc5, 0x68, 0xed, 0x65, 0xf6, 0x81, 
  0x8d, 0x4a, 0x62, 0xa2, 0x62, 0x9c, 0x96, 0x7f, 0xb6, 0x7a, 0xa0, 0x93, 
  0xa2, 0x26, 0x9e, 0xfc, 0x9a, 0xb5, 0xf6, 0x94, 0xef, 0xbc, 0xed, 0xfc, 
  0xea, 0xaa, 0xbe, 0x53, 0x30, 0x8b, 0x0d, 0xb9, 0x3d, 0x66, 0xf2, 0xcf, 
  0x85, 0x01, 0xb7, 0xce, 0xcf, 0x9b, 0xf8, 0x7d, 0x3a, 0x5f, 0xce, 0xd1, 
  0x2f, 0x9f, 0x13, 0x7d, 0x4c, 0xb8, 0x10, 0x73, 0xb2, 0x98, 0x4f, 0xb2, 
  0xd9, 0x1b, 0xd7, 0x9d, 0x1f, 0xaf, 0x75, 0xe8, 0xf2, 0xb1, 0x3d, 0x84, 
  0xce, 0xf7, 0x48, 0x79, 0x2c, 0xa4, 0x96, 0x59, 0x3a, 0x67, 0x33, 0x47, 
  0x7b, 0xe3, 0xbc, 0xfd, 0x30, 0x5a, 0xdc, 0xc4, 0x25, 0xdd, 0x18, 0xb8, 
  0xd3, 0x4d, 0x13, 0xbf, 0x61, 0x01, 0x5c, 0x9f, 0x49, 0xa6, 0x9d, 0xe2, 
  0x71, 0xc8, 0xa8, 0x73, 0x08, 0xfc, 0x10, 0x0f, 0x68, 0x65, 0xc5, 0x2f, 
  0x80, 0x3b, 0x16, 0x82, 0xcd, 0x70, 0x1e, 0xbf, 0xc7, 0xa2, 0x74, 0xb6, 
  0x30, 0xfa, 0x44, 0xc7, 0x6a, 0x9c, 0x34, 0xa5, 0x8d, 0xba, 0x80, 0x15, 
  0x3d, 0x87, 0xe8, 0xc0, 0xea, 0x45, 0x73, 0x83, 0xcc, 0xfe, 0x84, 0x15, 
  0x56, 0x41, 0x1d, 0x0f, 0xf3, 0xe6, 0xdc, 0xc7, 0x74, 0x35, 0xd8, 0xd5, 
  0xc7, 0xc6, 0x39, 0x9e, 0xea, 0xac, 0x53, 0xfb, 0x20, 0x62, 0xbe, 0xaa, 
  0xe0, 0xc6, 0xe3, 0x53, 0x42, 0xba, 0x10, 0x2f, 0x25, 0xf1, 0x99, 0x22, 
  0x56, 0x11, 0x1a, 0x24, 0x2d, 0x8d, 0x34, 0x97, 0x17, 0x4e, 0x18, 0x6b, 
  0x26, 0xd4, 0x76, 0x20, 0x49, 0x43, 0x82, 0x8e, 0x03, 0x29, 0xb6, 0x43, 
  0xea, 0xe6, 0x2d, 0xbc, 0x4f, 0xb8, 0x19, 0x68, 0x53, 0xb5, 0xf6, 0x9c, 
  0x0e, 0x29, 0x2d, 0x99, 0x2d, 0xa4, 0xa5, 0x01, 0x31, 0x61, 0x6d, 0x96, 
  0x74, 0x51, 0x89, 0x4a, 0xe7, 0xa6, 0x45, 0x1b, 0x7d, 0x9b, 0xe5, 0xf7, 
  0xd9, 0x80, 0x3f, 0xc5, 0xd2, 0x74, 0x9b, 0x1e, 0x79, 0x6a, 0x55, 0x62, 
  0xda, 0x82, 0x3c, 0x19, 0x08, 0xcc, 0xfa, 0xb5, 0xe3, 0xf4, 0x1d, 0x84, 
  0x6a, 0x22, 0xbf, 0xd3, 0xe8, 0xb4, 0x11, 0x95, 0xf6, 0x79, 0x60, 0xbc, 
  0x2b, 0x7c, 0x99, 0xaf, 0xd1, 0x3e, 0xa0, 0x40, 0x8a, 0x7b, 0x53, 0x4c, 
  0x6e, 0xd3, 0xb8, 0xbc, 0x19, 0x44, 0xbd, 0x61, 0x6f, 0xe0, 0x8c, 0xfa, 
  0xba, 0x2c, 0x36, 0xb2, 0xee, 0x59, 0xc0, 0xf2, 0x08, 0xf9, 0x6d, 0x8d, 
  0x92, 0xa1, 0xc6, 0x59, 0x1d, 0x28, 0xd3, 0x18, 0x09, 0x9b, 0x7d, 0x58, 
  0xa8, 0xd5, 0x06, 0xcb, 0x92, 0xaa, 0xb6, 0xd6, 0xd2, 0x91, 0x84, 0xa6, 
  0xef, 0x6f, 0x72, 0xb6, 0x75, 0xc3, 0x79, 0x69, 0x94, 0x42, 0x23, 0xc8, 
  0xb9, 0x1d, 0xb1, 0x5d, 0xc2, 0x9f, 0xc4, 0xb2, 0x7f, 0x37, 0x1f, 0x74, 
  0x8c, 0x30, 0x9a, 0xcc, 0x92, 0xb8, 0x98, 0xad, 0x4c, 0x65, 0x1d, 0xde, 
  0xc9, 0xfc, 0xd8, 0xf2, 0x1c, 0x13, 0x19, 0x17, 0x2d, 0x43, 0x10, 0x3f, 
  0x45, 0x42, 0x21, 0xe9, 0x63, 0xab, 0x64, 0x3a, 0x88, 0xc6, 0x2c, 0xa8, 
  0x32, 0x4f, 0x52, 0x71, 0x0d, 0x1c, 0x25, 0xba, 0x4b, 0xcb, 0x74, 0x8c, 
  0x1d, 0x48, 0x92, 0x69, 0xb3, 0x85, 0x71, 0x3c, 0xb9, 0x15, 0x69, 0x0c, 
  0xbd, 0x8c, 0x21, 0xeb, 0xde, 0xc0, 0xd5, 0x58, 0xf2, 0x6b, 0x2b, 0xb6, 
  0x08, 0xdc, 0xd0, 0x29, 0x2e, 0xd3, 0x6a, 0xd9, 0x29, 0x1f, 0xb6, 0x4f, 
  0xbf, 0x6a, 0xe9, 0x76, 0xfe, 0x8d, 0x01, 0xc8, 0xd6, 0x31, 0x0b, 0x68, 
  0x52, 0x2d, 0x1d, 0x0a, 0x77, 0x26, 0x64, 0xf7, 0xd7, 0x30, 0x84, 0x03, 
  0x30, 0x04, 0x12, 0xf0, 0xb2, 0x25, 0xe9, 0x20, 0xc4, 0xb0, 0x89, 0xa1, 
  0x13, 0x21, 0x35, 0xd9, 0xc1, 0x81, 0x3e, 0xb2, 0x7d, 0x6e, 0xae, 0x5a, 
  0x7f, 0x20, 0x8d, 0x1c, 0xbd, 0xcb, 0xbe, 0xea, 0x20, 0xe2, 0xeb, 0x94, 
  0x55, 0x35, 0x69, 0x5d, 0xe4, 0x9e, 0xf0, 0x13, 0x5b, 0xdf, 0xe4, 0x7d, 
  0xcc, 0xa1, 0x0d, 0xd9, 0x72, 0x3e, 0x6e, 0xdb, 0x73, 0xe9, 0x12, 0x1b, 
  0xaf, 0xd8, 0x9c, 0xa0, 0xaa, 0x6c, 0xa0, 0x75, 0xde, 0xa6, 0x8b, 0x45, 
  0xc2, 0xda, 0xf5, 0x32, 0xab, 0x02, 0xb3, 0x50, 0x73, 0x6b, 0x92, 0xeb, 
  0x34, 0xcb, 0x42, 0xf7, 0x5b, 0xbe, 0x24, 0xdd, 0x47, 0xc6, 0x3f, 0x4e, 
  0xae, 0x98, 0x79, 0xc3, 0xf8, 0xc9, 0x4b, 0x8e, 0xe9, 0x34, 0x37, 0xf7, 
  0x0a, 0xce, 0x62, 0x6f, 0xec, 0x9a, 0xc2, 0x9d, 0x67, 0xbc, 0xec, 0xe8, 
  0x4a, 0x36, 0x0a, 0x2a, 0x92, 0xf8, 0x46, 0xca, 0x41, 0x97, 0x1e, 0x5c, 
  0x2d, 0xec, 0xc6, 0x32, 0x8f, 0xce, 0xc5, 0xd1, 0xff, 0x3e, 0xd4, 0x09, 
  0xb1, 0x43, 0x27, 0xf4, 0xe8, 0xac, 0x3a, 0xfc, 0x29, 0xad, 0xd3, 0xc7, 
  0xaa, 0x22, 0x9d, 0xe7, 0x03, 0xda, 0xd2, 0x1e, 0xae, 0x41, 0xe6, 0x7a, 
  0xce, 0xf3, 0xb2, 0xac, 0x72, 0xe2, 0x14, 0xec, 0xef, 0x9c, 0xad, 0xc4, 
  0xab, 0x4c, 0x54, 0xd9, 0x3c, 0xe1, 0x24, 0x75, 0x25, 0xdb, 0x37, 0x7c, 
  0xeb, 0xe6, 0xe6, 0x91, 0x87, 0xa3, 0x46, 0xb7, 0x75, 0xc4, 0xd6, 0x3a, 
  0x56, 0x06, 0x78, 0x5c, 0x65, 0xb4, 0x7e, 0x8b, 0x97, 0xd5, 0x62, 0x59, 
  0x6d, 0xc3, 0x48, 0xa0, 0x3e, 0xad, 0x2a, 0x37, 0x9b, 0x36, 0x36, 0xae, 
  0x8b, 0x7b, 0x74, 0xa8, 0xdb, 0x0f, 0x5e, 0x79, 0x1f, 0xba, 0xf1, 0xbc, 
  0x44, 0x02, 0xae, 0x43, 0xea, 0x48, 0xcb, 0xa0, 0xf2, 0xad, 0xce, 0x05, 
  0xba, 0x07, 0x9d, 0x81, 0xbf, 0x92, 0x24, 0x87, 0xbe, 0xbd, 0x6f, 0x21, 
  0xb7, 0x1b, 0x7a, 0xd0, 0x69, 0x9a, 0x42, 0x97, 0xd2, 0x01, 0x9e, 0x27, 
  0x51, 0x81, 0xc4, 0xc0, 0xb8, 0xa0, 0x23, 0x9e, 0xd3, 0x5a, 0x13, 0x23, 
  0xa1, 0x4b, 0xa6, 0xca, 0xe9, 0xef, 0x9b, 0x94, 0x66, 0x51, 0x4c, 0x6e, 
  0x56, 0xed, 0x0b, 0x2a, 0x23, 0x1e, 0x52, 0x77, 0x17, 0x4c, 0x8a, 0xd9, 
  0x95, 0xfa, 0xdd, 0xe8, 0xdc, 0xd1, 0xfc, 0xab, 0xe8, 0xf8, 0x15, 0x2f, 
  0xe2, 0xc1, 0x39, 0xfd, 0xa4, 0xc1, 0x0a, 0x69, 0x31, 0x53, 0x43, 0x18, 
  0x07, 0xab, 0xcd, 0xd1, 0x9b, 0x6f, 0x2e, 0x9a, 0xc2, 0xf1, 0xe9, 0xc5, 
  0xf6, 0xa3, 0xa7, 0x3b, 0x5b, 0xff, 0xba, 0xda, 0x2c, 0x8e, 0x57, 0x76, 
  0x66, 0xad, 0x51, 0x9b, 0x31, 0xd2, 0x89, 0x8c, 0x91, 0x8e, 0x55, 0x30, 
  0x89, 0x29, 0x9b, 0x57, 0x58, 0xf1, 0x7f, 0xfe, 0x80, 0x0d, 0xf9, 0x22, 
  0x11, 0x99, 0x2f, 0xb4, 0x45, 0xe1, 0x25, 0x31, 0xe3, 0x9e, 0x9d, 0x5e, 
  0x5c, 0x46, 0xe6, 0x52, 0x68, 0xdb, 0xd3, 0x9c, 0xc5, 0xc7, 0x42, 0x76, 
  0xf0, 0xd6, 0x7d, 0xbc, 0x12, 0x2a, 0x63, 0x23, 0x47, 0x32, 0x5f, 0x72, 
  0xe4, 0x06, 0x8c, 0x56, 0x4d, 0xc9, 0x3f, 0x96, 0xe0, 0x16, 0x16, 0xf3, 
  0x88, 0x4a, 0x67, 0xe6, 0xac, 0xfe, 0xea, 0xf2, 0xcd, 0x31, 0x6e, 0x56, 
  0x15, 0xfc, 0x9d, 0x64, 0xdf, 0xe1, 0xe4, 0x5a, 0x8e, 0xe7, 0xcc, 0x2d, 
  0xe8, 0x92, 0xa8, 0x70, 0xfe, 0x4f, 0xf2, 0x4a, 0x49, 0x1c, 0xaa, 0x3d, 
  0x66, 0x52, 0x8a, 0xe5, 0x03, 0x8c, 0x6d, 0xd6, 0xb1, 0xfd, 0x0d, 0x2b, 
  0x5c, 0xc6, 0x0e, 0x36, 0xb8, 0x3d, 0x38, 0x36, 0x84, 0xc9, 0x09, 0x52, 
  0x81, 0xc4, 0x22, 0x74, 0x48, 0x59, 0x59, 0x72, 0x2f, 0xf6, 0x5d, 0xa2, 
  0x4f, 0x68, 0x91, 0x57, 0x5b, 0xa3, 0xba, 0x79, 0x9b, 0x46, 0x90, 0xbc, 
  0x5f, 0x88, 0x10, 0x0b, 0x9b, 0x4b, 0xa3, 0x85, 0x1e, 0xd1, 0xf5, 0x50, 
  0x7c, 0x7a, 0x53, 0x33, 0xe7, 0x08, 0x61, 0xc7, 0xb0, 0x36, 0x7b, 0xbf, 
  0xd4, 0x82, 0x4d, 0xfe, 0x1d, 0xeb, 0xe0, 0x1c, 0x00, 0x81, 0x24, 0xbe, 
  0x54, 0x13, 0x31, 0xd4, 0x5f, 0xba, 0xea, 0x49, 0x25, 0x58, 0x2d, 0xe0, 
  0x25, 0x9d, 0xad, 0xb1, 0x25, 0x6c, 0xbf, 0x1f, 0x92, 0x0e, 0x3a, 0xe4, 
  0xa5, 0x1f, 0x52, 0x97, 0x3a, 0xa2, 0x11, 0x1d, 0x81, 0xf9, 0x82, 0x85, 
  0x2d, 0x0c, 0x61, 0xf8, 0x8a, 0xe8, 0x8a, 0x1f, 0x19, 0x7d, 0xac, 0x86, 
  0x53, 0x37, 0xd8, 0x89, 0x22, 0x2c, 0x6e, 0xfe, 0x96, 0xbc, 0xea, 0x7d, 
  0xeb, 0x03, 0xbf, 0x81, 0xd1, 0x22, 0xe5, 0x53, 0x1d, 0x05, 0x1b, 0xb5, 
  0x4e, 0x46, 0x9a, 0x27, 0xc5, 0xb5, 0xdc, 0x0e, 0x74, 0xf3, 0xb3, 0x0a, 
  0x2e, 0x5b, 0x1a, 0x9b, 0x2f, 0x9e, 0x57, 0xe4, 0xb7, 0x43, 0xf1, 0x07, 
  0xf0, 0x42, 0x2f, 0x5b, 0x97, 0x83, 0xac, 0x5a, 0x7f, 0x38, 0x8d, 0xd4, 
  0xfd, 0x92, 0xa5, 0xc9, 0x8c, 0x0e, 0x13, 0x5f, 0x70, 0xb3, 0xd9, 0x8b, 
  0x19, 0xdd, 0xb6, 0xab, 0x3e, 0x49, 0x42, 0xb0, 0xde, 0x5f, 0x27, 0x59, 
  0xdb, 0x55, 0xce, 0xd4, 0x2e, 0xd4, 0x0d, 0x33, 0x51, 0x89, 0x48, 0x96, 
  0xc9, 0xcd, 0x32, 0xbb, 0x95, 0xcb, 0x27, 0xc6, 0x07, 0x33, 0x12, 0xcf, 
  0x4a, 0xfc, 0x92, 0xde, 0x36, 0x67, 0xd1, 0x0f, 0xba, 0xfe, 0x6d, 0xd8, 
  0x6f, 0x17, 0x1f, 0x81, 0xdc, 0x59, 0x71, 0xb0, 0x90, 0x5b, 0x30, 0xc7, 
  0x3d, 0xd5, 0xf1, 0xf1, 0xe7, 0x81, 0xf7, 0xff, 0xb5, 0xe4, 0x94, 0xc0, 
  0x11, 0x11, 0x07, 0xc2, 0x8a, 0x59, 0xcb, 0x5d, 0xa3, 0xe2, 0xbd, 0x20, 
  0x3e, 0xd7, 0x74, 0x1e, 0xa6, 0x57, 0x6d, 0x8d, 0xa4, 0xfd, 0x2a, 0xcb, 
  0xac, 0x69, 0xa6, 0x07, 0xa3, 0xad, 0x06, 0x32, 0x7d, 0x8a, 0x0a, 0xe7, 
  0x23, 0x0b, 0x60, 0x82, 0x89, 0x67, 0xdc, 0x16, 0x7c, 0x0b, 0xc1, 0x29, 
  0x69, 0xd2, 0xde, 0x1b, 0x0b, 0x0a, 0x91, 0xdb, 0xae, 0xe6, 0xaa, 0x36, 
  0xa2, 0x19, 0x45, 0x67, 0xb9, 0x44, 0xfe, 0x60, 0x54, 0x4d, 0xb1, 0x02, 
  0x1a, 0x48, 0xb0, 0x02, 0xd3, 0xa8, 0x7f, 0x95, 0xe7, 0xe3, 0xb8, 0xb0, 
  0xdd, 0x86, 0x6f, 0x74, 0x9c, 0x88, 0x13, 0x96, 0x97, 0xb8, 0xed, 0x7e, 
  0xe4, 0xc9, 0xfe, 0x59, 0xde, 0x6a, 0xfb, 0xa3, 0x2e, 0x73, 0xa1, 0x06, 
  0x3c, 0xb5, 0xa0, 0xab, 0x98, 0x04, 0x01, 0xf6, 0x7c, 0x14, 0xab, 0x81, 
  0x6c, 0xa2, 0xec, 0x84, 0x39, 0x4f, 0xf9, 0xec, 0x74, 0x08, 0x2e, 0xd2, 
  0xcb, 0x50, 0x5e, 0x5c, 0xa7, 0xbc, 0x7a, 0xde, 0xaf, 0x42, 0x1d, 0x62, 
  0x6a, 0x60, 0x1c, 0xc4, 0xdb, 0xb0, 0x74, 0xff, 0x1b, 0x2a, 0x6f, 0x0e, 
  0x77, 0x56, 0x10, 0xe3, 0xa4, 0xff, 0x89, 0xe9, 0x4f, 0x77, 0x90, 0x9d, 
  0xd2, 0x72, 0x7d, 0x49, 0x5c, 0x06, 0xf7, 0x1c, 0xde, 0xb1, 0x7e, 0x24, 
  0x0f, 0xde, 0x50, 0x66, 0xaa, 0xc5, 0x96, 0xa6, 0xb1, 0x04, 0x1a, 0x61, 
  0x25, 0xdc, 0x24, 0xff, 0x6d, 0x15, 0xfe, 0x3f, 0x37, 0x1f, 0xdd, 0x97, 
  0x87, 0x26, 0xa4, 0xe1, 0x14, 0x4c, 0x0b, 0xa5, 0xbb, 0x21, 0x32, 0xf0, 
  0x8b, 0x32, 0x9d, 0xa7, 0x33, 0x52, 0xd8, 0x34, 0x46, 0x2b, 0x2e, 0x3b, 
  0x49, 0x4c, 0x17, 0x8d, 0x03, 0x6f, 0x06, 0xb4, 0x26, 0x1c, 0x82, 0x7a, 
  0x7d, 0x23, 0x6e, 0x89, 0xa5, 0x77, 0x0b, 0xea, 0xb4, 0x3b, 0x48, 0x28, 
  0x62, 0x6b, 0x72, 0x91, 0xe8, 0xb9, 0x7b, 0xef, 0x7c, 0x66, 0x3c, 0x22, 
  0x77, 0xfd, 0x97, 0xd1, 0x6d, 0xb2, 0xa0, 0xe3, 0x57, 0xb6, 0x8e, 0x7b, 
  0xe9, 0xd4, 0x5d, 0x1c, 0xf9, 0x4a, 0xc9, 0x3a, 0x56, 0x62, 0x76, 0xea, 
  0xb5, 0x84, 0xc6, 0xae, 0x89, 0x4c, 0x59, 0x0c, 0xfd, 0xb5, 0xa9, 0xa1, 
  0xa3, 0x36, 0x8c, 0xda, 0x24, 0x55, 0xf6, 0x6b, 0xcd, 0x42, 0x68, 0xe2, 
  0x4a, 0x3c, 0x51, 0xff, 0xf5, 0x9d, 0x87, 0xa1, 0x7d, 0xcd, 0x6e, 0x1f, 
  0x66, 0x2c, 0xa7, 0x95, 0x22, 0x27, 0xbd, 0x54, 0x93, 0x7c, 0xdd, 0x39, 
  0x61, 0x34, 0xde, 0x12, 0x8f, 0xea, 0xcf, 0xc9, 0xdd, 0xc1, 0x3a, 0x9f, 
  0x30, 0x4b, 0xec, 0x25, 0x4b, 0x04, 0xf7, 0xf0, 0xce, 0x32, 0x07, 0x6b, 
  0x69, 0x5b, 0x3c, 0x09, 0x48, 0x3f, 0x39, 0x8c, 0x73, 0xac, 0xda, 0xf3, 
  0xd6, 0xb3, 0xb8, 0xcd, 0x7a, 0x39, 0x3c, 0x3f, 0x90, 0x62, 0x75, 0x4d, 
  0xb3, 0xf6, 0x95, 0xec, 0xbc, 0xb3, 0xee, 0x5a, 0xc9, 0xd8, 0xea, 0x41, 
  0x97, 0xe2, 0x52, 0x83, 0xaa, 0x9c, 0x03, 0x83, 0x63, 0xa2, 0xaa, 0xd6, 
  0x85, 0xca, 0xd7, 0x30, 0xee, 0x14, 0xbe, 0xdb, 0x6d, 0xbc, 0x81, 0x79, 
  0xce, 0x7b, 0x2c, 0xd6, 0x3a, 0x29, 0xd4, 0x89, 0xa1, 0x51, 0x3c, 0xd8, 
  0x77, 0x17, 0x11, 0xac, 0x11, 0xe8, 0x23, 0x1f, 0xd8, 0xd1, 0x9e, 0x05, 
  0x5f, 0x4b, 0xff, 0x1f, 0xf0, 0x6d, 0xa8, 0xd0, 0x3e, 0x4c, 0x16, 0x45, 
  0xd5, 0x19, 0xe4, 0x77, 0x19, 0xea, 0x8c, 0x26, 0xe2, 0x73, 0xdf, 0x2c, 
  0x07, 0xea, 0xf9, 0x38, 0x3c, 0x3b, 0xbf, 0x8c, 0x3a, 0x6c, 0xd8, 0xc7, 
  0xfc, 0xb9, 0x8a, 0x50, 0xa5, 0xb0, 0x03, 0x8d, 0x09, 0x22, 0x9d, 0xea, 
  0x2e, 0x81, 0x9f, 0xd2, 0x85, 0x62, 0x8e, 0x60, 0xf5, 0xeb, 0x52, 0xa6, 
  0x64, 0x73, 0xe9, 0x6e, 0x8a, 0x67, 0x24, 0xc8, 0x97, 0x4a, 0xfe, 0x2e, 
  0xf8, 0xd3, 0xc7, 0x40, 0xf0, 0x38, 0x3a, 0x54, 0xeb, 0x4c, 0x47, 0xa2, 
  0xca, 0xbc, 0x70, 0xa4, 0xb3, 0x53, 0x7a, 0x16, 0xa6, 0x1c, 0x25, 0x22, 
  0xb7, 0xe0, 0xcd, 0x16, 0x2c, 0x7e, 0x90, 0xbb, 0xe0, 0xb7, 0xa2, 0x22, 
  0xbd, 0xbe, 0xe1, 0xfe, 0x69, 0x30, 0xa3, 0xc8, 0x4f, 0x5e, 0x7b, 0x61, 
  0x23, 0x60, 0xa3, 0x05, 0xa2, 0xe8, 0x24, 0x2b, 0x11, 0x93, 0xea, 0xad, 
  0x04, 0x39, 0x35, 0x43, 0x74, 0x3c, 0xc3, 0x2a, 0x58, 0xc8, 0xf7, 0x00, 
  0x51, 0x0b, 0xed, 0xe0, 0x3b, 0xc4, 0x3a, 0x71, 0xec, 0x27, 0x02, 0xde, 
  0x59, 0x98, 0x2e, 0x31, 0xf6, 0x04, 0x47, 0x59, 0xe2, 0xe3, 0xe9, 0xbc, 
  0xa9, 0xb2, 0x4a, 0xb7, 0x52, 0xb5, 0x6a, 0xd9, 0xb0, 0xf8, 0xf8, 0x8e, 
  0x45, 0xfc, 0x52, 0x7d, 0x28, 0x33, 0x5d, 0x7e, 0x9a, 0xca, 0x6b, 0x32, 
  0x3f, 0xdd, 0xb1, 0xa6, 0x44, 0x43, 0xb4, 0x1c, 0xb8, 0xe4, 0x9e, 0xfc, 
  0x8b, 0x64, 0x2b, 0xee, 0x84, 0x8f, 0xf5, 0x27, 0x48, 0x83, 0x2d, 0x8f, 
  0x82, 0xa7, 0xda, 0xf2, 0xee, 0xdf, 0xa0, 0xda, 0x8b, 0x6f, 0x78, 0xae, 
  0xff, 0x6c, 0x05, 0x19, 0xb2, 0x96, 0xeb, 0x89, 0x95, 0xf9, 0x83, 0x51, 
  0x6b, 0x48, 0xae, 0x66, 0xa5, 0x6e, 0x7b, 0x5e, 0x1c, 0xc1, 0x1a, 0xc5, 
  0x36, 0x49, 0x56, 0x7d, 0x81, 0x18, 0x81, 0x50, 0x65, 0xa3, 0x85, 0xb3, 
  0xfd, 0x8b, 0x6f, 0xd6, 0x50, 0xa7, 0xa3, 0x47, 0x98, 0x84, 0x2a, 0xba, 
  0xde, 0x3a, 0x5d, 0xf4, 0xdc, 0xf6, 0x2f, 0xe2, 0xf2, 0xe9, 0xde, 0xa2, 
  0x46, 0x24, 0x85, 0x38, 0x15, 0x9a, 0xe2, 0xc7, 0xb7, 0xf0, 0x12, 0xe0, 
  0xa2, 0xb7, 0x94, 0x87, 0x20, 0x50, 0xa3, 0x6e, 0x02, 0x40, 0x98, 0xc8, 
  0x46, 0x97, 0xd3, 0xdc, 0x4f, 0x45, 0x42, 0x7d, 0x74, 0x71, 0xb1, 0x83, 
  0xa1, 0x4c, 0x20, 0x01, 0x26, 0x5d, 0xd2, 0x87, 0xeb, 0x94, 0x6f, 0xb3, 
  0x58, 0xed, 0x07, 0x3c, 0x34, 0xf1, 0xbc, 0xd1, 0xbb, 0x7c, 0xa5, 0x47, 
  0x12, 0x3c, 0x56, 0x76, 0x89, 0xe9, 0xdc, 0x8c, 0xb5, 0x32, 0x51, 0xd9, 
  0x9c, 0xba, 0x1f, 0x43, 0xc3, 0x89, 0xa7, 0x5e, 0x9c, 0x82, 0x0d, 0xa5, 
  0xeb, 0x2e, 0xd0, 0x30, 0xec, 0x08, 0x89, 0x17, 0x5e, 0x51, 0x0e, 0x03, 
  0x70, 0x64, 0xa2, 0xbf, 0xea, 0x50, 0x57, 0x9a, 0x2e, 0x9c, 0x60, 0x49, 
  0xf2, 0x7b, 0xde, 0x5a, 0x7f, 0xf4, 0x71, 0xf6, 0x69, 0x4a, 0x2d, 0x09, 
  0x28, 0x08, 0xbe, 0x69, 0xad, 0xb3, 0xb7, 0x8a, 0xe5, 0x99, 0x85, 0x8c, 
  0xd4, 0x2c, 0x96, 0xce, 0xab, 0x2a, 0x02, 0x54, 0x9b, 0x05, 0xd2, 0xb4, 
  0xcb, 0x74, 0x2a, 0x86, 0x52, 0x91, 0x01, 0xa2, 0x9e, 0x2e, 0x58, 0xcf, 
  0xc5, 0x39, 0xb0, 0xd9, 0x18, 0x5a, 0x3d, 0x07, 0xef, 0x74, 0x38, 0x44, 
  0x8b, 0xe4, 0x93, 0x9b, 0x08, 0x1d, 0x01, 0x27, 0xb4, 0xa2, 0x45, 0xc2, 
  0x37, 0x26, 0x11, 0xef, 0xdb, 0xf3, 0xe3, 0x0f, 0x5a, 0xab, 0x7a, 0xe7, 
  0xfa, 0xf4, 0x59, 0x7c, 0x9d, 0xf4, 0x10, 0x64, 0xc3, 0x9e, 0x18, 0x95, 
  0x42, 0xd6, 0x85, 0x64, 0x47, 0x2e, 0x28, 0x3b, 0x88, 0x69, 0x16, 0x21, 
  0x44, 0x8c, 0xd8, 0x49, 0x65, 0x21, 0x68, 0x1d, 0x11, 0x68, 0x3e, 0xcc, 
  0x99, 0xe8, 0x70, 0x16, 0x5f, 0x6b, 0xc4, 0x80, 0x44, 0x36, 0xdb, 0xbe, 
  0x99, 0xcd, 0xb8, 0x53, 0x43, 0xac, 0xc5, 0xb0, 0xad, 0x34, 0xe1, 0x43, 
  0x85, 0xca, 0xde, 0x1f, 0xd9, 0x46, 0xdc, 0xb3, 0xb3, 0xa8, 0xab, 0xd1, 
  0x0e, 0x17, 0xe0, 0x07, 0x20, 0x65, 0x80, 0x90, 0xeb, 0x76, 0x65, 0xf3, 
  0x3f, 0x39, 0xbf, 0x40, 0x90, 0xfd, 0xe4, 0x6d, 0xcc, 0x99, 0x58, 0xd8, 
  0x45, 0x9c, 0x91, 0x10, 0xc7, 0x63, 0x1d, 0xd4, 0x33, 0x3d, 0x57, 0xe2, 
  0x1e, 0xd0, 0x21, 0x75, 0x06, 0x96, 0x63, 0xe8, 0xba, 0x91, 0xb4, 0x82, 
  0x9c, 0x78, 0x24, 0xa1, 0x60, 0x6a, 0x0e, 0x98, 0xc2, 0x57, 0x84, 0x05, 
  0x8d, 0xb3, 0xd6, 0xed, 0x98, 0x22, 0x15, 0x45, 0xe7, 0xf8, 0xcb, 0x59, 
  0xa2, 0x93, 0xec, 0x2e, 0x2d, 0xf2, 0x8c, 0xa3, 0x03, 0x9a, 0x04, 0x76, 
  0x7e, 0x74, 0x71, 0x10, 0x9d, 0x5e, 0x44, 0xa7, 0x27, 0xc7, 0xdf, 0x33, 
  0xa1, 0x21, 0x0a, 0x87, 0xae, 0x9f, 0xeb, 0x44, 0xb6, 0x39, 0x78, 0x95, 
  0x63, 0x41, 0x8a, 0xb6, 0x94, 0xca, 0x52, 0xfe, 0x20, 0x08, 0x71, 0x14, 
  0x33, 0x82, 0x90, 0xeb, 0xf0, 0xde, 0xe6, 0xe2, 0xa3, 0x1a, 0x5a, 0x5c, 
  0x21, 0x89, 0xcb, 0x34, 0x29, 0xd4, 0xef, 0x0e, 0x0b, 0xe4, 0xc4, 0xc2, 
  0xe7, 0x35, 0x5b, 0x30, 0x24, 0x73, 0x38, 0x75, 0x9b, 0x71, 0xdc, 0xf1, 
  0x1d, 0x77, 0x5e, 0x2c, 0xb3, 0x6e, 0x17, 0xc5, 0x2f, 0x77, 0x23, 0x0d, 
  0x93, 0xeb, 0xe9, 0x10, 0x9a, 0x60, 0xe7, 0x5d, 0x84, 0xf3, 0x7c, 0x51, 
  0xcf, 0xb1, 0x58, 0xc4, 0x6c, 0x7c, 0x55, 0xdb, 0x13, 0x44, 0x86, 0xac, 
  0x2a, 0xf2, 0x05, 0xf1, 0xcf, 0xd7, 0xf4, 0x4d, 0x73, 0x20, 0x09, 0x88, 
  0xf0, 0x65, 0x9c, 0xcc, 0x79, 0x51, 0xf3, 0xc9, 0xad, 0xf9, 0xb4, 0xe4, 
  0x77, 0x6f, 0x52, 0x67, 0x9d, 0x24, 0x99, 0x76, 0x05, 0xde, 0x13, 0x1f, 
  0xa4, 0xcb, 0x24, 0xc9, 0xae, 0x39, 0x95, 0x87, 0x55, 0x0a, 0x0e, 0xdd, 
  0x09, 0x73, 0x9a, 0xe8, 0x50, 0xb3, 0x92, 0xa2, 0x0c, 0xa2, 0x83, 0x23, 
  0x0c, 0xa5, 0x0d, 0x99, 0x68, 0xd3, 0x0a, 0x31, 0x3c, 0xe4, 0x6b, 0x82, 
  0x5d, 0x07, 0xcf, 0xf9, 0x5f, 0x8e, 0x7d, 0x27, 0x85, 0xe5, 0x87, 0x67, 
  0xa6, 0x01, 0xfd, 0xb8, 0x6e, 0x51, 0xda, 0x71, 0x6d, 0xf5, 0xcb, 0x39, 
  0x68, 0xad, 0x2b, 0xba, 0xb2, 0x1e, 0x9f, 0x68, 0x7e, 0x71, 0x5a, 0x5b, 
  0x34, 0xef, 0xb2, 0x5b, 0xa5, 0x91, 0xe6, 0xb2, 0x4e, 0x60, 0xbd, 0x84, 
  0xe5, 0x4d, 0x42, 0x03, 0xcf, 0x0e, 0xdf, 0x38, 0x2f, 0xb7, 0xb9, 0x96, 
  0x65, 0xa6, 0x44, 0x2e, 0x3c, 0x95, 0x7f, 0xb6, 0x85, 0x67, 0xce, 0x99, 
  0xc5, 0xe9, 0xb7, 0x21, 0x87, 0x69, 0x41, 0xd1, 0xdf, 0x96, 0x9c, 0x5e, 
  0x38, 0xc5, 0x8a, 0xe7, 0x5d, 0x99, 0x2b, 0x44, 0xd7, 0x73, 0x96, 0xd5, 
  0x47, 0x35, 0x6b, 0x3e, 0x07, 0x4d, 0xfa, 0x89, 0x9b, 0x61, 0x6b, 0x51, 
  0xa4, 0x77, 0xed, 0x75, 0xb8, 0x4d, 0x56, 0xb8, 0xe5, 0x82, 0x27, 0x6a, 
  0x2f, 0xd3, 0x1e, 0xf3, 0xcf, 0x8c, 0x15, 0xc8, 0x5f, 0xfd, 0x62, 0x91, 
  0x1f, 0x20, 0x06, 0x31, 0xc2, 0x3f, 0xe7, 0x7f, 0xbb, 0x23, 0xda, 0x82, 
  0xdd, 0xbf, 0x87, 0x13, 0x25, 0x18, 0x37, 0xde, 0x55, 0x09, 0xee, 0x8e, 
  0x2e, 0xf8, 0x96, 0x6c, 0x53, 0x5f, 0x20, 0xb6, 0xb7, 0xd2, 0xfe, 0x0d, 
  0xa2, 0x97, 0x87, 0xe7, 0x58, 0x8f, 0xc3, 0x93, 0xd7, 0x72, 0xe5, 0x73, 
  0x44, 0xf7, 0x75, 0x96, 0xfe, 0xd4, 0xbe, 0xf7, 0xa9, 0x87, 0xf2, 0x97, 
  0xbb, 0xf7, 0x87, 0x93, 0x58, 0x4e, 0xc8, 0xc1, 0x7e, 0x38, 0xf8, 0x4f, 
  0x74, 0x32, 0xf8, 0x25, 0x1a, 0xb0, 0x63, 0x38, 0x89, 0x5d, 0x74, 0x62, 
  0x6e, 0x26, 0x51, 0x8d, 0x2d, 0x62, 0x1c, 0x06, 0x3e, 0x5f, 0xce, 0xda, 
  0x0e, 0x12, 0xb6, 0x2f, 0xd7, 0xc7, 0x59, 0xca, 0xeb, 0xc1, 0x27, 0x9b, 
  0xe5, 0x96, 0x8f, 0x1d, 0x6c, 0x2b, 0x85, 0xc1, 0x69, 0xda, 0xe8, 0x94, 
  0x4b, 0xdd, 0xc6, 0x94, 0xce, 0x56, 0xd7, 0xb8, 0x77, 0x44, 0x05, 0x85, 
  0x85, 0xba, 0xe9, 0x36, 0x38, 0xa0, 0xeb, 0xfe, 0xdd, 0xc1, 0xfe, 0xbb, 
  0x2f, 0xdf, 0x9e, 0xbc, 0x3c, 0x3e, 0xec, 0x4b, 0xce, 0x80, 0x44, 0x4e, 
  0xd0, 0x45, 0xec, 0x52, 0x93, 0xe4, 0xe4, 0xc0, 0x55, 0xdc, 0x0c, 0x6a, 
  0x8d, 0xe1, 0xe2, 0x12, 0x99, 0x40, 0xfe, 0x40, 0xc8, 0x8a, 0xce, 0x9a, 
  0x54, 0xa4, 0x6c, 0x8a, 0xf8, 0x71, 0x4f, 0x0b, 0x4d, 0x5b, 0x88, 0x86, 
  0x11, 0xaa, 0x78, 0x6f, 0x03, 0xee, 0xd0, 0x25, 0x98, 0x29, 0x11, 0xf3, 
  0x24, 0x01, 0x84, 0xf5, 0x6b, 0x4b, 0x13, 0xf3, 0xc9, 0xa6, 0x35, 0xc1, 
  0x86, 0xbd, 0x25, 0xcd, 0x1d, 0x65, 0x97, 0x2b, 0x0d, 0x93, 0xc6, 0x86, 
  0xc1, 0x59, 0x10, 0x84, 0xd8, 0xee, 0xff, 0x0f, 0xb7, 0x44, 0xd4, 0x35, 
  0xd4, 0x21, 0x4f, 0x8a, 0xea, 0xff, 0x34, 0x4d, 0x0d, 0x49, 0x0a, 0x17, 
  0x51, 0xea, 0xfd, 0x51, 0x81, 0xbb, 0x38, 0x16, 0x3a, 0x1b, 0x25, 0xef, 
  0x13, 0x78, 0x3d, 0x3a, 0x73, 0xec, 0x0e, 0x60, 0xf7, 0xa1, 0x8d, 0xf9, 
  0x36, 0x2f, 0x24, 0xcd, 0xea, 0xa5, 0x35, 0x60, 0x2f, 0x21, 0xc1, 0x35, 
  0x9f, 0x4d, 0x71, 0xb1, 0xe7, 0x2d, 0xc5, 0x91, 0x73, 0xe4, 0x49, 0xff, 
  0xbc, 0xfc, 0x6a, 0xf4, 0x0b, 0xb2, 0xa1, 0x18, 0x5b, 0xdb, 0x38, 0x73, 
  0x7e, 0xee, 0xff, 0xf9, 0xd3, 0xe7, 0x97, 0x75, 0xdd, 0x09, 0x0c, 0x0f, 
  0x15, 0xce, 0x4f, 0xcb, 0x92, 0xd9, 0x38, 0x3f, 0x03, 0xc7, 0xe0, 0x7d, 
  0xe3, 0x38, 0x77, 0x37, 0x9c, 0x8a, 0x30, 0x4e, 0xda, 0xb4, 0x2d, 0xbe, 
  0xdc, 0x64, 0x1a, 0x3a, 0x46, 0xdf, 0x15, 0xc9, 0x4d, 0x5c, 0xde, 0x44, 
  0xcb, 0x2a, 0x65, 0x2b, 0x0e, 0xa4, 0xb3, 0x99, 0x3a, 0x18, 0x5b, 0xe2, 
  0xbb, 0xc5, 0xe6, 0x46, 0x1a, 0xca, 0xe4, 0x97, 0xd2, 0xf4, 0x08, 0x16, 
  0xdc, 0xdc, 0x02, 0xb1, 0x90, 0xde, 0x94, 0xcf, 0x18, 0x98, 0xa1, 0x96, 
  0x35, 0x3d, 0xe7, 0xa8, 0x6d, 0xd8, 0x93, 0x92, 0x2b, 0x9a, 0x7e, 0x4a, 
  0xd4, 0x34, 0x53, 0x6b, 0x51, 0xa7, 0xa1, 0xc1, 0x71, 0xcc, 0xd4, 0x8c, 
  0xe5, 0xfa, 0x37, 0x68, 0x5f, 0xd9, 0x57, 0x29, 0x79, 0xd5, 0xb2, 0xbf, 
  0x6d, 0x3e, 0x66, 0xbc, 0xeb, 0x17, 0xa3, 0xb8, 0x2b, 0xf6, 0x18, 0xc7, 
  0xe9, 0x6c, 0x8d, 0x85, 0xfc, 0x15, 0xe2, 0xc9, 0x4a, 0xce, 0xb2, 0xe2, 
  0xc9, 0x6f, 0x66, 0xb9, 0x46, 0xb0, 0x70, 0x18, 0x13, 0x2d, 0xea, 0x16, 
  0x8b, 0x09, 0xf5, 0x84, 0x70, 0x27, 0x04, 0x16, 0x79, 0x11, 0xe4, 0x47, 
  0x72, 0xbe, 0xa5, 0xa5, 0xd9, 0x0a, 0xa6, 0x86, 0x8a, 0xbb, 0x15, 0x14, 
  0xbc, 0xaa, 0x2d, 0x31, 0x9b, 0x49, 0x4f, 0xe0, 0x1c, 0xe8, 0xc9, 0xa4, 
  0x9a, 0x84, 0x8f, 0x73, 0x7c, 0x51, 0x3c, 0x53, 0xa5, 0xf0, 0x0a, 0xe0, 
  0x0f, 0x2d, 0xeb, 0x34, 0xac, 0x4c, 0xec, 0x15, 0xc9, 0xcc, 0x32, 0x3e, 
  0x89, 0xcb, 0x44, 0x4d, 0xb0, 0x71, 0x18, 0x20, 0x21, 0xb1, 0x73, 0x65, 
  0x3b, 0x90, 0x82, 0x7a, 0x99, 0xa5, 0x92, 0xad, 0xe7, 0xe2, 0x97, 0x21, 
  0x34, 0x49, 0xd0, 0x73, 0x69, 0x51, 0x11, 0xf6, 0x5d, 0x4b, 0x25, 0x13, 
  0xd7, 0x36, 0x89, 0xa9, 0x9b, 0x1a, 0x29, 0x9a, 0x5f, 0x21, 0xa4, 0x51, 
  0x44, 0x57, 0x81, 0xab, 0x18, 0x23, 0xb8, 0xf0, 0x66, 0xd5, 0x65, 0x3c, 
  0x66, 0x12, 0xdc, 0x32, 0xb5, 0x18, 0xca, 0x2d, 0xf6, 0x52, 0x9d, 0x0d, 
  0x42, 0xd3, 0x02, 0xd2, 0x82, 0x9d, 0xa9, 0xda, 0x94, 0x29, 0xe6, 0x1c, 
  0x3a, 0x93, 0x08, 0x0f, 0x74, 0xbb, 0xa9, 0xee, 0xcc, 0x4f, 0x18, 0x01, 
  0x23, 0x5d, 0xa1, 0xdb, 0x65, 0x51, 0x33, 0xb7, 0x5f, 0x55, 0x8b, 0x07, 
  0x82, 0x8f, 0x6a, 0x69, 0xf5, 0x7c, 0xde, 0xd8, 0xe4, 0x48, 0x37, 0xe8, 
  0xb6, 0x8f, 0x78, 0xc4, 0x65, 0x19, 0xcb, 0x4d, 0xc8, 0xf3, 0x6b, 0x8e, 
  0x40, 0x53, 0xdf, 0xc5, 0xfc, 0xcf, 0xb3, 0x45, 0x12, 0xbc, 0x8b, 0x70, 
  0xd0, 0xa0, 0x18, 0xfc, 0x5e, 0xd1, 0xd2, 0xc4, 0xc5, 0xb4, 0xc5, 0xd6, 
  0x58, 0x65, 0xe3, 0x9b, 0x0c, 0xa6, 0x04, 0x31, 0x4d, 0x09, 0xbd, 0xf2, 
  0x7c, 0x6a, 0x79, 0x7e, 0xdd, 0xf6, 0x72, 0x7f, 0x63, 0x9a, 0xe3, 0x38, 
  0x30, 0x7b, 0x6a, 0x60, 0xd4, 0x3c, 0xd5, 0x18, 0x16, 0xb0, 0xca, 0x16, 
  0x43, 0xc8, 0x19, 0xed, 0xa3, 0x95, 0x05, 0xf2, 0x87, 0xad, 0xff, 0xd6, 
  0x96, 0x91, 0x56, 0xd1, 0x6d, 0x67, 0x66, 0x37, 0x15, 0xdb, 0x6a, 0xe5, 
  0x64, 0x99, 0x71, 0x98, 0xa3, 0x9e, 0xe4, 0x63, 0xd5, 0x09, 0x00, 0xc4, 
  0xf3, 0xcf, 0x56, 0xfc, 0x2d, 0x10, 0x5e, 0x24, 0xd5, 0xc7, 0x96, 0x5d, 
  0x8c, 0xbe, 0xcb, 0xe6, 0x1a, 0xab, 0x6d, 0xa3, 0xed, 0xc8, 0xd2, 0xb8, 
  0x43, 0x97, 0x2b, 0xe1, 0x63, 0x30, 0x4b, 0x37, 0x78, 0x44, 0xbf, 0x9a, 
  0x2e, 0xd8, 0xb2, 0xe9, 0xfb, 0x15, 0xde, 0x1d, 0xed, 0xfc, 0xd7, 0x56, 
  0x98, 0x6e, 0xb1, 0xee, 0xc3, 0xf0, 0x26, 0x16, 0x9e, 0x99, 0xc8, 0x69, 
  0x08, 0x03, 0xf4, 0xa3, 0x92, 0x78, 0xe0, 0x44, 0x24, 0xc2, 0xae, 0xe0, 
  0x04, 0x52, 0x5e, 0xb6, 0x2f, 0x8f, 0x2f, 0x46, 0xff, 0x9f, 0x98, 0xa5, 
  0xc5, 0x28, 0x69, 0x12, 0xb5, 0x06, 0x98, 0x3c, 0x14, 0x61, 0x30, 0x63, 
  0x8b, 0x0f, 0x0e, 0x93, 0x8b, 0x58, 0x0b, 0x82, 0xd2, 0x34, 0x1c, 0xad, 
  0x35, 0x10, 0x65, 0xb6, 0xb1, 0xb9, 0x39, 0x39, 0x94, 0xcd, 0xc2, 0xd5, 
  0x04, 0xaa, 0x0a, 0xf1, 0x69, 0x16, 0x9e, 0x76, 0xd9, 0x4e, 0x60, 0x90, 
  0x7c, 0x3d, 0x27, 0x34, 0x48, 0xc0, 0x9d, 0x04, 0x05, 0x04, 0x96, 0xa4, 
  0x5a, 0x08, 0x57, 0x93, 0x75, 0x23, 0xf6, 0x25, 0x2e, 0xaa, 0x6d, 0x04, 
  0x6e, 0xc9, 0xbb, 0x51, 0x3c, 0xe1, 0x9c, 0x5d, 0x69, 0x80, 0x36, 0xec, 
  0xfc, 0xd5, 0xc1, 0xee, 0xe7, 0x9f, 0xfd, 0x41, 0x39, 0x7c, 0xe7, 0x25, 
  0x58, 0x6a, 0x50, 0xa3, 0x06, 0xe7, 0x06, 0xde, 0xfc, 0x92, 0x6f, 0x45, 
  0x64, 0x8d, 0x22, 0x51, 0xb1, 0x43, 0x10, 0xee, 0xeb, 0xf8, 0xfa, 0x8a, 
  0x5b, 0xa4, 0x37, 0x28, 0xfe, 0x27, 0x26, 0x88, 0x01, 0xaf, 0xcb, 0x55, 
  0xfa, 0xfe, 0xc1, 0xf8, 0x78, 0x09, 0xd6, 0xca, 0xa2, 0x3f, 0x47, 0x0c, 
  0xb4, 0x85, 0x1e, 0xff, 0xca, 0x32, 0xdd, 0xb5, 0xda, 0x35, 0x6d, 0x19, 
  0xa4, 0x97, 0x35, 0x11, 0x3c, 0xdd, 0xdd, 0x05, 0x1d, 0xf8, 0xc8, 0xa8, 
  0x46, 0x0b, 0xcf, 0x45, 0x16, 0xf5, 0xbe, 0x5b, 0x87, 0xe5, 0xf2, 0x67, 
  0xdc, 0x6c, 0xcf, 0x85, 0x37, 0xe3, 0xc2, 0x90, 0x38, 0xae, 0x3f, 0xb7, 
  0xbc, 0x59, 0xb7, 0x89, 0x4f, 0x1a, 0x8f, 0x30, 0x70, 0x66, 0xc8, 0xb1, 
  0x41, 0xf1, 0x58, 0x9c, 0x05, 0xeb, 0x17, 0x71, 0xd7, 0x3a, 0x18, 0x9e, 
  0x0b, 0x51, 0x96, 0x3a, 0xd1, 0x9e, 0x6b, 0xab, 0xb1, 0xa4, 0x69, 0x92, 
  0xa8, 0x3d, 0x43, 0x0a, 0x93, 0x5b, 0x9a, 0x0e, 0x27, 0x8b, 0x8b, 0xa8, 
  0x92, 0x60, 0x19, 0x36, 0xa0, 0xf8, 0x77, 0x35, 0x6d, 0xa3, 0xd3, 0xc7, 
  0x73, 0xf8, 0x3e, 0xe6, 0x1c, 0x91, 0x41, 0xe4, 0x00, 0x4e, 0xa0, 0xa1, 
  0xb8, 0x28, 0x03, 0x41, 0x0d, 0x0b, 0xe3, 0x0c, 0x07, 0x5d, 0x41, 0xcc, 
  0x51, 0xdf, 0xde, 0xe8, 0x1b, 0x57, 0xc6, 0xfa, 0xab, 0x33, 0x10, 0xc7, 
  0x69, 0x28, 0xa3, 0x69, 0xdb, 0x41, 0xe5, 0x50, 0x6d, 0x13, 0xcd, 0x6d, 
  0xa3, 0x95, 0x69, 0x2d, 0x8f, 0x17, 0x51, 0xcd, 0xcf, 0x3a, 0xb5, 0xe7, 
  0xe1, 0x2b, 0x37, 0xd0, 0x17, 0x7f, 0xae, 0xbd, 0x7f, 0x7f, 0x3f, 0x9a, 
  0xaf, 0xec, 0xbb, 0xb2, 0x86, 0x8b, 0xe5, 0xa3, 0xb3, 0xd4, 0x79, 0x64, 
  0x14, 0xd3, 0x2f, 0x1d, 0xb9, 0xf9, 0x00, 0x36, 0xb9, 0x65, 0x01, 0x6d, 
  0xd1, 0x95, 0xda, 0x2c, 0x89, 0xd4, 0x43, 0x5d, 0x04, 0x9f, 0xe8, 0x2d, 
  0xb3, 0xd7, 0x10, 0xaf, 0xfe, 0x1d, 0x0e, 0x46, 0xd2, 0x9d, 0x95, 0x7a, 
  0x9d, 0x27, 0xb2, 0x6d, 0xe3, 0x9c, 0x68, 0xd5, 0x08, 0x8f, 0x3d, 0x3a, 
  0x55, 0xb1, 0x9c, 0x54, 0x6d, 0xb1, 0xdd, 0x80, 0xa3, 0x24, 0xd5, 0xc9, 
  0xb9, 0x62, 0x61, 0x3c, 0x3a, 0x50, 0xb6, 0x71, 0x09, 0xc3, 0x91, 0x28, 
  0x6d, 0xd4, 0xf6, 0x9a, 0xc4, 0x70, 0x25, 0x3e, 0x1c, 0xae, 0x81, 0xcb, 
  0x46, 0x8e, 0xfa, 0x48, 0x34, 0xee, 0x6b, 0x74, 0xaf, 0xc4, 0x26, 0x35, 
  0x05, 0x50, 0x0d, 0x5c, 0xaa, 0xf2, 0xb5, 0x3b, 0xd3, 0xbb, 0x4f, 0xc6, 
  0x2f, 0xfe, 0x0c, 0xe4, 0x2b, 0xe4, 0x31, 0x4a, 0xfa, 0x32, 0x93, 0xe5, 
  0x36, 0xff, 0xd9, 0xe3, 0xf0, 0xbe, 0xae, 0x8d, 0x61, 0x0b, 0xec, 0xd5, 
  0xb2, 0x80, 0xaa, 0x9e, 0x08, 0x75, 0x96, 0x58, 0x14, 0x4b, 0xac, 0xd4, 
  0x53, 0xf5, 0x66, 0xff, 0xe4, 0xed, 0xfe, 0xf1, 0x83, 0x4e, 0xcb, 0xd0, 
  0x65, 0xe1, 0x60, 0xa4, 0xa0, 0xd6, 0x04, 0x57, 0xc7, 0x35, 0x5d, 0x1d, 
  0xd7, 0xb3, 0x7c, 0x9c, 0x5f, 0x5d, 0x3d, 0xd0, 0x94, 0x5c, 0x86, 0xc0, 
  0x4e, 0x13, 0x92, 0xee, 0xb1, 0x6b, 0x86, 0xdf, 0x1b, 0x8b, 0x17, 0x1b, 
  0x00, 0x0b, 0xa3, 0x2e, 0xcf, 0x9e, 0x4f, 0x14, 0x0a, 0xdc, 0xcc, 0xab, 
  0x06, 0xfa, 0x17, 0xf0, 0xbe, 0x3a, 0x44, 0x4e, 0x33, 0x50, 0x05, 0x4c, 
  0xac, 0x8c, 0xfe, 0xfe, 0x8f, 0x1f, 0x7e, 0x74, 0x01, 0x57, 0xea, 0x03, 
  0xa0, 0xef, 0xe7, 0xe2, 0xfb, 0x6b, 0x59, 0xa1, 0xe8, 0x1d, 0x62, 0x8e, 
  0x95, 0x24, 0x9c, 0x0b, 0x28, 0x15, 0xb0, 0x6b, 0xea, 0xf6, 0xd6, 0xa4, 
  0x74, 0x1d, 0x34, 0x35, 0x1e, 0xb6, 0x20, 0xc2, 0x1f, 0xae, 0xea, 0xce, 
  0x2c, 0xb9, 0xa6, 0x7f, 0x79, 0x01, 0x1c, 0xdf, 0x91, 0xac, 0x9d, 0x64, 
  0xa5, 0x24, 0xdf, 0xd6, 0xe6, 0x35, 0x90, 0x33, 0xb8, 0xa7, 0x94, 0xab, 
  0xbc, 0x3d, 0x3f, 0x72, 0xd2, 0x72, 0xb0, 0x2d, 0xaf, 0x79, 0x5b, 0x5a, 
  0xbc, 0xce, 0xb9, 0x4a, 0x07, 0x35, 0x91, 0xc2, 0x63, 0x10, 0x72, 0x08, 
  0x07, 0x6e, 0x44, 0x67, 0xa6, 0x68, 0xa9, 0xac, 0xac, 0xbf, 0xfb, 0x58, 
  0x42, 0xe4, 0x35, 0xd5, 0x83, 0xf9, 0x34, 0x4f, 0xde, 0xf2, 0x14, 0xe2, 
  0x2e, 0xcf, 0xe2, 0xeb, 0xc3, 0x4b, 0x87, 0xbc, 0x13, 0xc0, 0xdf, 0xf0, 
  0x84, 0x6a, 0x31, 0xf4, 0x51, 0xd7, 0xa6, 0x22, 0xdd, 0xf6, 0x3e, 0xe5, 
  0xa0, 0x9a, 0x7b, 0x83, 0xa3, 0x80, 0x0a, 0x2d, 0xd7, 0x91, 0x84, 0xf4, 
  0x0a, 0x07, 0x14, 0x67, 0x61, 0xdb, 0x6c, 0x6b, 0x6b, 0x77, 0x6c, 0x01, 
  0xcf, 0xfd, 0x3f, 0xf5, 0x1d, 0x02, 0x59, 0x77, 0x3a, 0xaa, 0xcf, 0xbb, 
  0x68, 0x84, 0x78, 0x0d, 0x8f, 0x06, 0x7e, 0xe0, 0xb2, 0x28, 0x1d, 0x61, 
  0x17, 0x36, 0xcb, 0x60, 0x50, 0x1d, 0xc3, 0xf8, 0xea, 0x70, 0xff, 0xa5, 
  0xcd, 0x7d, 0xed, 0x20, 0xea, 0x67, 0x91, 0xb3, 0xf9, 0x18, 0xf0, 0xf0, 
  0x5a, 0xf6, 0x8c, 0x28, 0xeb, 0x06, 0x1d, 0x84, 0x87, 0xf4, 0x06, 0xae, 
  0xd8, 0xd9, 0xa2, 0x95, 0x82, 0x13, 0x5f, 0x73, 0x68, 0xc0, 0x6c, 0x11, 
  0x3c, 0x1b, 0xb8, 0x6d, 0x9f, 0xcb, 0xcf, 0x35, 0x72, 0xe0, 0x21, 0x82, 
  0xfe, 0xf5, 0xd1, 0x30, 0xae, 0xc1, 0x3b, 0x53, 0x88, 0x87, 0xd1, 0xd9, 
  0xbe, 0x6e, 0x61, 0xd9, 0x30, 0x0f, 0x86, 0x01, 0xb9, 0x06, 0xdf, 0x27, 
  0x39, 0x54, 0x4c, 0x07, 0x49, 0xd0, 0x74, 0x29, 0xe7, 0xac, 0x4b, 0x7d, 
  0x56, 0xdf, 0xa9, 0x46, 0x02, 0xc7, 0xd3, 0x29, 0x27, 0x6d, 0xd2, 0x2d, 
  0x4f, 0xb7, 0x8f, 0x0d, 0x8b, 0x1f, 0x63, 0x29, 0xb3, 0x23, 0xac, 0x12, 
  0x57, 0x8c, 0x5c, 0x34, 0x6c, 0xc2, 0x0d, 0x10, 0x53, 0x71, 0xe6, 0x59, 
  0x03, 0x42, 0xb8, 0xa3, 0x5c, 0x0f, 0x1d, 0xc7, 0x72, 0x89, 0x0c, 0x5c, 
  0x5c, 0xf8, 0x88, 0xa2, 0xe2, 0x57, 0x38, 0xae, 0x06, 0x5e, 0x5c, 0xf3, 
  0x7c, 0xfb, 0x94, 0xaf, 0x65, 0x3b, 0x1b, 0xdc, 0x05, 0x2f, 0x5b, 0x20, 
  0xb7, 0xef, 0x9a, 0xfb, 0x56, 0x4b, 0x4d, 0x2c, 0x8e, 0x67, 0x9e, 0x6a, 
  0xeb, 0xf2, 0xc7, 0xa9, 0x85, 0x23, 0x19, 0xd0, 0xa8, 0xec, 0x10, 0x2d, 
  0xab, 0x25, 0x98, 0x6c, 0x9c, 0xa9, 0x86, 0xac, 0xd1, 0xf7, 0x16, 0xf8, 
  0xd3, 0xd2, 0xca, 0x47, 0xba, 0x21, 0xba, 0x8e, 0xcc, 0xaa, 0x8a, 0x64, 
  0x31, 0x8b, 0x27, 0x7e, 0x25, 0xd4, 0x59, 0xde, 0x8d, 0xf3, 0x62, 0xac, 
  0x94, 0x93, 0x4b, 0xc1, 0xcd, 0x93, 0xe2, 0x2a, 0xe1, 0xdc, 0x11, 0xc9, 
  0x64, 0xc5, 0xcd, 0xea, 0x20, 0x6d, 0x10, 0xb6, 0xd4, 0xa4, 0x87, 0x73, 
  0x74, 0x07, 0xe9, 0x3b, 0xce, 0xfc, 0x1a, 0xe8, 0x1a, 0xe2, 0x6c, 0x58, 
  0x14, 0x39, 0x77, 0x44, 0x6c, 0xb3, 0xa5, 0x95, 0x23, 0x68, 0x53, 0xae, 
  0x36, 0x09, 0x81, 0xe3, 0x88, 0x0e, 0x27, 0x40, 0x4d, 0xf2, 0x19, 0x32, 
  0x32, 0xb1, 0x19, 0x6a, 0xa5, 0xe9, 0xa2, 0x28, 0xed, 0x51, 0x44, 0x3e, 
  0x3a, 0x45, 0x71, 0x51, 0x4b, 0x12, 0x0a, 0xee, 0xd8, 0xc0, 0xcd, 0xd9, 
  0xc6, 0xcb, 0x53, 0x1c, 0xad, 0x20, 0x4c, 0xa3, 0x33, 0x8b, 0xba, 0xec, 
  0xbe, 0x7e, 0x5d, 0x96, 0x36, 0xcc, 0xa4, 0x3e, 0xaf, 0x2e, 0xc0, 0x8b, 
  0x94, 0xa3, 0x1f, 0x75, 0x48, 0x83, 0x74, 0x0a, 0xb6, 0x75, 0xf7, 0xb6, 
  0x39, 0x3f, 0xf8, 0x2e, 0xf1, 0xaf, 0xd9, 0x81, 0xf2, 0x87, 0x3d, 0xa5, 
  0x11, 0xa6, 0xd9, 0x64, 0xb6, 0x9c, 0x26, 0x6b, 0xac, 0x8d, 0x47, 0xf2, 
  0x6d, 0xe4, 0x92, 0x97, 0x8c, 0x39, 0xa8, 0x1c, 0x21, 0x06, 0xae, 0x51, 
  0x47, 0xdc, 0x4f, 0xfd, 0x61, 0xb4, 0xc2, 0xe7, 0x90, 0x16, 0x54, 0x01, 
  0x7c, 0x45, 0x20, 0x1e, 0xf2, 0x11, 0x1c, 0x40, 0x89, 0x4b, 0xda, 0xf9, 
  0x93, 0xb0, 0x58, 0x3b, 0x0b, 0x1f, 0x9a, 0x34, 0xff, 0x47, 0x9c, 0x49, 
  0xae, 0xcc, 0x68, 0xf4, 0x09, 0xad, 0x65, 0xf5, 0xf1, 0x87, 0x86, 0x01, 
  0x50, 0xe9, 0x15, 0x1f, 0x92, 0xe7, 0x5d, 0xe9, 0xe8, 0x67, 0xf4, 0x25, 
  0x2b, 0xc1, 0x9c, 0xc6, 0x13, 0x18, 0xc8, 0x84, 0x2f, 0x86, 0xa9, 0x39, 
  0xae, 0x9d, 0x4e, 0x26, 0x09, 0x12, 0x48, 0x32, 0x98, 0x56, 0x7d, 0x8f, 
  0xb2, 0x64, 0x47, 0x67, 0xbc, 0xdb, 0xac, 0x3e, 0xf3, 0x2d, 0x7c, 0x93, 
  0xb7, 0xbc, 0x00, 0xfc, 0xd8, 0x28, 0xda, 0xcf, 0x4c, 0x10, 0xd4, 0xe8, 
  0x2f, 0xf6, 0x0e, 0x61, 0x07, 0x5a, 0xc2, 0xa7, 0x4a, 0x9f, 0xc1, 0xdc, 
  0x92, 0xea, 0x66, 0xe7, 0xd9, 0x6e, 0x08, 0xb9, 0x91, 0x69, 0x6e, 0x37, 
  0x50, 0x63, 0x7f, 0x31, 0x9b, 0xf8, 0x91, 0xde, 0x4a, 0x5d, 0x54, 0xba, 
  0xfd, 0x8a, 0xff, 0xc7, 0x58, 0xd4, 0x51, 0xf4, 0x2a, 0x11, 0xa3, 0x4b, 
  0x83, 0x58, 0x39, 0x0b, 0xfa, 0x57, 0xf2, 0x49, 0x67, 0xba, 0x7c, 0xe9, 
  0xa2, 0xea, 0x45, 0x1d, 0x94, 0xc4, 0x2a, 0xdc, 0xc6, 0xa2, 0x5e, 0x61, 
  0x56, 0xe2, 0x0c, 0x6c, 0x9e, 0x38, 0x56, 0x5a, 0xed, 0x0a, 0x56, 0x39, 
  0xce, 0xc8, 0x86, 0xd5, 0x9e, 0x00, 0x60, 0xc3, 0x89, 0x5f, 0x2d, 0xac, 
  0x2a, 0x7a, 0x8c, 0x0d, 0x48, 0xb4, 0x8d, 0x3c, 0x0f, 0xd5, 0x8d, 0xb0, 
  0x19, 0x9a, 0xda, 0x5d, 0x7a, 0xad, 0x83, 0x38, 0xdb, 0x4f, 0x2d, 0xd8, 
  0x00, 0x4e, 0x03, 0xe3, 0x15, 0x9d, 0xe7, 0x53, 0x71, 0x58, 0x20, 0xb4, 
  0x8b, 0xb1, 0x2a, 0x78, 0xea, 0x9f, 0xfe, 0x80, 0xd4, 0x7b, 0x19, 0xfe, 
  0x95, 0xb6, 0xeb, 0xaf, 0xcb, 0xec, 0x76, 0xa8, 0x78, 0x6c, 0x1a, 0xff, 
  0x57, 0x76, 0x33, 0x19, 0xac, 0x8b, 0xe1, 0x5b, 0x57, 0xf9, 0x0c, 0x92, 
  0x91, 0xaa, 0x97, 0x2e, 0xcd, 0x5f, 0xed, 0x15, 0x9d, 0x19, 0xbc, 0xba, 
  0x60, 0xf5, 0x60, 0x1d, 0x2f, 0xd5, 0xa6, 0x15, 0x0f, 0x77, 0x42, 0x12, 
  0x72, 0x47, 0x3e, 0x62, 0xcf, 0x20, 0xe3, 0xb4, 0xa7, 0x5a, 0x46, 0x21, 
  0xe0, 0x94, 0xe8, 0x22, 0xbb, 0x31, 0xc0, 0xae, 0xae, 0x3c, 0xbc, 0xe4, 
  0xea, 0x0a, 0xf0, 0xf6, 0x2c, 0x45, 0x30, 0x46, 0x69, 0x8c, 0x24, 0xc7, 
  0x00, 0x8b, 0xae, 0x94, 0x8c, 0x33, 0x48, 0xa8, 0xab, 0x05, 0xfb, 0x68, 
  0x9b, 0x02, 0x7e, 0x41, 0x17, 0x3c, 0x70, 0x74, 0x2c, 0x26, 0xd7, 0xc6, 
  0xeb, 0x1a, 0x09, 0x56, 0x02, 0x52, 0x56, 0x5b, 0x27, 0x5d, 0xf1, 0xfd, 
  0x3a, 0x99, 0x31, 0x2a, 0x21, 0xd1, 0xdc, 0x7d, 0x56, 0x37, 0x2d, 0x3e, 
  0xed, 0xb6, 0x50, 0xff, 0x42, 0xf1, 0x4d, 0xb7, 0xb8, 0x67, 0x04, 0xda, 
  0xb3, 0x3b, 0x8c, 0x23, 0xa0, 0xc6, 0xe4, 0x3d, 0xa7, 0x5c, 0xa6, 0x15, 
  0x82, 0xea, 0x21, 0xfa, 0x98, 0xb9, 0x6f, 0x21, 0x4c, 0xb5, 0xb9, 0x83, 
  0xd6, 0x72, 0x2f, 0x12, 0x38, 0xa1, 0xc0, 0x61, 0x08, 0xaf, 0xa7, 0x0f, 
  0x8b, 0xbe, 0xe0, 0x7d, 0x68, 0x2b, 0x79, 0xa2, 0xd5, 0x88, 0xb4, 0xc4, 
  0xd6, 0xfc, 0x81, 0x42, 0x6f, 0x34, 0x23, 0x9c, 0x4c, 0x82, 0x68, 0x5b, 
  0xbb, 0xd5, 0x8b, 0x60, 0x26, 0x6f, 0xbe, 0xb4, 0xe7, 0x74, 0x30, 0x0c, 
  0xcd, 0xd4, 0x19, 0x07, 0x98, 0x86, 0x1e, 0x76, 0x34, 0x6a, 0xd4, 0x00, 
  0x64, 0xc3, 0x18, 0x06, 0x55, 0x0e, 0xba, 0x55, 0x53, 0xbc, 0x8b, 0xc4, 
  0x84, 0x8d, 0xab, 0x0b, 0x7d, 0xa4, 0x3e, 0xdc, 0x30, 0xb2, 0x35, 0x5c, 
  0x26, 0x80, 0xb6, 0xb6, 0x5d, 0x8c, 0x8a, 0xcc, 0x55, 0xdb, 0x2e, 0x23, 
  0x8a, 0x7f, 0x9d, 0x87, 0x80, 0x0d, 0x75, 0xe9, 0x44, 0xe0, 0x2b, 0x8e, 
  0x93, 0xa4, 0x55, 0x78, 0xbd, 0x72, 0x4c, 0xd2, 0x73, 0xfa, 0xa7, 0x3b, 
  0xea, 0x27, 0x3a, 0xd3, 0x30, 0x25, 0x7e, 0xcc, 0xd9, 0x2b, 0xe9, 0xae, 
  0x0b, 0x45, 0x65, 0x0b, 0xfb, 0xe9, 0x8a, 0x21, 0x58, 0x04, 0xef, 0xa7, 
  0x02, 0x35, 0xe5, 0x00, 0xa8, 0xbb, 0x4d, 0x7d, 0x9f, 0x2e, 0xc0, 0x80, 
  0xc6, 0xf0, 0xc1, 0x30, 0x27, 0x37, 0x61, 0x8c, 0xd8, 0xe2, 0x73, 0xe8, 
  0xf1, 0x91, 0x0b, 0x0a, 0xd4, 0x8b, 0xaa, 0x6d, 0xf1, 0xc6, 0x84, 0x65, 
  0x45, 0x2d, 0x10, 0xaa, 0x3e, 0x7f, 0x8e, 0xdc, 0x7b, 0x89, 0x5a, 0x0f, 
  0x1c, 0x30, 0xd0, 0xe1, 0xee, 0xb4, 0x40, 0x28, 0x87, 0xf0, 0xf4, 0x0b, 
  0x86, 0x3c, 0xdd, 0x16, 0xe3, 0xc7, 0xd1, 0xf3, 0x19, 0xb5, 0x33, 0xfb, 
  0xa2, 0xd3, 0x0b, 0x23, 0x19, 0x63, 0x34, 0x93, 0x62, 0xcc, 0x40, 0xf7, 
  0x8f, 0x9b, 0x69, 0x60, 0x1a, 0xc6, 0x33, 0xea, 0x4a, 0xa5, 0x45, 0xb3, 
  0x2e, 0x7e, 0x0f, 0x72, 0x96, 0x00, 0x5e, 0x05, 0x48, 0x97, 0xaa, 0x18, 
  0xf6, 0x91, 0x01, 0xd6, 0x6f, 0xda, 0x6f, 0xfb, 0x65, 0x7c, 0x95, 0xf4, 
  0x07, 0x30, 0xe9, 0x5f, 0xa5, 0x53, 0x41, 0x8d, 0xef, 0xf3, 0x4d, 0xde, 
  0xd7, 0x35, 0xee, 0xd3, 0x16, 0x49, 0x63, 0x0a, 0x78, 0xd7, 0xca, 0x5b, 
  0xd3, 0x61, 0xa8, 0x91, 0x9c, 0x96, 0x8e, 0x55, 0x30, 0xaf, 0x8f, 0xb2, 
  0x9a, 0xe9, 0x1a, 0xfb, 0x80, 0x6d, 0xa1, 0xf3, 0xa4, 0x86, 0xcc, 0x95, 
  0x8d, 0x0b, 0x29, 0x2a, 0x4f, 0xb8, 0xb4, 0x7f, 0xc6, 0x10, 0x2b, 0x60, 
  0xb9, 0xb9, 0xe7, 0x2b, 0x6c, 0xbc, 0x4c, 0x67, 0x55, 0x27, 0x83, 0xf4, 
  0x4b, 0x6c, 0x94, 0x30, 0xf2, 0xd8, 0x80, 0x3c, 0x66, 0xda, 0xeb, 0x15, 
  0xa4, 0xa7, 0xb6, 0x33, 0x8f, 0x9d, 0x91, 0xc3, 0x6f, 0x88, 0xaf, 0x98, 
  0xf8, 0x2e, 0x91, 0xa6, 0xaa, 0xc3, 0x17, 0xc2, 0x7c, 0x2d, 0xda, 0xb7, 
  0xc6, 0x0b, 0x3e, 0xf5, 0xf9, 0xfb, 0x5a, 0x00, 0x65, 0xae, 0xd2, 0xeb, 
  0xe8, 0xb9, 0xfe, 0xec, 0x8a, 0xc1, 0x75, 0xf8, 0x52, 0xea, 0xc4, 0xd2, 
  0x47, 0x9d, 0x89, 0x5f, 0xc0, 0x52, 0x11, 0x64, 0x5e, 0x5c, 0x43, 0xe0, 
  0xeb, 0x4a, 0xc6, 0xd0, 0xf0, 0x1d, 0xdf, 0x8d, 0x96, 0x79, 0x11, 0x77, 
  0x03, 0xd8, 0xbe, 0xef, 0xa0, 0x3b, 0xfb, 0x47, 0xb1, 0xf4, 0xad, 0x13, 
  0x33, 0xd3, 0x1a, 0xde, 0x91, 0xc9, 0xab, 0x49, 0xd6, 0x45, 0x2a, 0x2e, 
  0x04, 0xbd, 0x74, 0x10, 0xb9, 0x5c, 0x4e, 0xc4, 0xbd, 0xad, 0x2a, 0x74, 
  0x3c, 0xa9, 0x96, 0xf1, 0xec, 0x03, 0x63, 0xa0, 0xcd, 0x3f, 0x5d, 0xe8, 
  0x45, 0xa3, 0x49, 0x12, 0x49, 0x8a, 0x52, 0x1d, 0xc4, 0x8b, 0x61, 0x69, 
  0xd5, 0x83, 0xd5, 0x81, 0xf5, 0xe3, 0x0a, 0x06, 0xb8, 0x58, 0xb2, 0xfa, 
  0x82, 0x5a, 0x07, 0xc2, 0x57, 0x92, 0x56, 0xe0, 0x9d, 0x76, 0x21, 0x02, 
  0xa3, 0x33, 0xf3, 0xd2, 0xdc, 0x39, 0x31, 0x66, 0xc1, 0x95, 0x3f, 0x06, 
  0x1a, 0x25, 0xad, 0x4f, 0xb6, 0xbc, 0x80, 0x16, 0xb2, 0xab, 0x12, 0x93, 
  0x56, 0x0d, 0x01, 0xb0, 0x7b, 0x19, 0x62, 0xf6, 0x23, 0x37, 0x6a, 0xd2, 
  0x4e, 0x79, 0x5d, 0xce, 0x33, 0xb1, 0xdb, 0xc4, 0x36, 0x72, 0xec, 0x0b, 
  0xb6, 0xb3, 0xff, 0xeb, 0x7e, 0x34, 0xb9, 0x89, 0x39, 0x22, 0xdd, 0x22, 
  0x1a, 0x3a, 0xb0, 0x04, 0x54, 0xbd, 0xc5, 0x6b, 0xce, 0x65, 0xa3, 0x90, 
  0x53, 0xf0, 0x77, 0xf1, 0x49, 0x62, 0xc5, 0x61, 0x63, 0x0d, 0x29, 0x9a, 
  0x4a, 0x90, 0x69, 0xba, 0x7a, 0x7f, 0xd8, 0xaf, 0xa7, 0x3b, 0x78, 0x17, 
  0x4d, 0x57, 0x7c, 0x67, 0x80, 0x33, 0xd0, 0x82, 0xc6, 0xf2, 0x96, 0x6d, 
  0x18, 0x73, 0x25, 0x45, 0x2d, 0xf7, 0xe6, 0x3a, 0x18, 0x2d, 0x3d, 0x5c, 
  0x24, 0x4d, 0xbf, 0xd3, 0xbd, 0x03, 0x2c, 0x72, 0xc6, 0x8b, 0x51, 0x20, 
  0x55, 0x3b, 0x43, 0x9c, 0x50, 0x11, 0xfa, 0x6b, 0x87, 0xc3, 0x76, 0x7a, 
  0xa5, 0xc3, 0xb1, 0x01, 0x6d, 0x09, 0xc6, 0xd0, 0x8a, 0x5d, 0x27, 0x0b, 
  0xb6, 0x2c, 0x69, 0x81, 0x05, 0xb3, 0x9f, 0x32, 0x47, 0x68, 0x1d, 0x38, 
  0x12, 0x82, 0x95, 0x8e, 0x2e, 0x72, 0x84, 0x07, 0x05, 0xfa, 0xaf, 0x77, 
  0xc1, 0x80, 0xad, 0xb4, 0x54, 0x61, 0x5e, 0xbe, 0x17, 0x51, 0x4f, 0x15, 
  0x5f, 0xc4, 0x36, 0xde, 0xc4, 0xef, 0xdf, 0x8f, 0xca, 0x44, 0x80, 0x26, 
  0x7b, 0xff, 0xb6, 0xe7, 0x64, 0x08, 0x9c, 0xbf, 0x21, 0x24, 0x8e, 0xe7, 
  0x28, 0xb8, 0xf1, 0xc5, 0x03, 0xfb, 0x3c, 0x37, 0xfc, 0x41, 0x57, 0x82, 
  0x88, 0xdf, 0xab, 0x23, 0x49, 0xb4, 0x75, 0x53, 0xbb, 0xf7, 0xd2, 0x20, 
  0x6f, 0x5c, 0x38, 0x27, 0xf2, 0x23, 0xc4, 0x7e, 0x0a, 0xe5, 0x26, 0x16, 
  0xd8, 0xc1, 0x96, 0x6e, 0xba, 0x48, 0x17, 0x92, 0x4e, 0xcc, 0x06, 0xbc, 
  0xa9, 0x46, 0x89, 0x89, 0xcd, 0xd3, 0x0d, 0x45, 0x36, 0x07, 0x59, 0xae, 
  0x61, 0x11, 0x23, 0xe7, 0x2e, 0x47, 0xfa, 0xfc, 0x98, 0x1a, 0xb9, 0x4f, 
  0xa7, 0xd5, 0x4d, 0x67, 0x70, 0xab, 0xe8, 0x71, 0x58, 0x05, 0x44, 0xa6, 
  0x25, 0x71, 0xb9, 0x2c, 0x44, 0x77, 0x01, 0x82, 0xd6, 0xb6, 0xc8, 0x92, 
  0x03, 0x15, 0x51, 0x5b, 0x57, 0x68, 0xb9, 0xbc, 0x62, 0xf7, 0x35, 0x9f, 
  0x3e, 0xb5, 0xae, 0x73, 0x45, 0x26, 0xfc, 0x0a, 0x9f, 0xdc, 0x6d, 0x5f, 
  0x5c, 0x15, 0xfd, 0xaf, 0xfb, 0x9d, 0xa2, 0x28, 0x70, 0xb8, 0x94, 0x18, 
  0xd5, 0x0e, 0x4d, 0x07, 0xea, 0x36, 0x9d, 0xe5, 0xe8, 0x9e, 0x2e, 0xe0, 
  0x39, 0x2e, 0xf5, 0x37, 0x7d, 0x75, 0x2f, 0xa7, 0x55, 0x0b, 0x4b, 0xe5, 
  0x3a, 0x16, 0xb0, 0x2f, 0xf1, 0x45, 0xf7, 0xaf, 0xad, 0xcb, 0xd7, 0x7d, 
  0xe7, 0xe9, 0x66, 0xba, 0xbf, 0x4e, 0xf5, 0xc1, 0x51, 0xb7, 0x33, 0xb9, 
  0x7c, 0x16, 0xed, 0xed, 0xec, 0x7c, 0x3d, 0x88, 0x1e, 0xcd, 0xb1, 0xf0, 
  0xbb, 0xaf, 0x3b, 0xa5, 0x2d, 0x60, 0x4e, 0x16, 0x9a, 0x13, 0x1e, 0xe4, 
  0xe4, 0x7d, 0x4f, 0xd7, 0x19, 0xd6, 0x51, 0xe8, 0x6b, 0x2d, 0x24, 0x40, 
  0x5c, 0xd5, 0x14, 0x65, 0x46, 0xa1, 0x64, 0xcb, 0xe8, 0x24, 0x99, 0x42, 
  0xa7, 0x83, 0x75, 0x4d, 0x72, 0x89, 0x39, 0xd6, 0x6f, 0x31, 0xeb, 0x4c, 
  0x4e, 0x64, 0x22, 0x94, 0x7e, 0x70, 0x96, 0xcb, 0x19, 0xbf, 0x31, 0x5b, 
  0x89, 0x3f, 0x1c, 0x9e, 0x05, 0x12, 0x1a, 0x92, 0x85, 0x0e, 0xae, 0x7d, 
  0x0f, 0xb8, 0x51, 0xce, 0xf2, 0xeb, 0x74, 0x82, 0x4c, 0xe2, 0x2e, 0x83, 
  0x6b, 0x78, 0xb6, 0xee, 0x81, 0xe7, 0x5d, 0x15, 0xf9, 0x74, 0x39, 0x51, 
  0x8f, 0x8c, 0x4b, 0x57, 0xff, 0xc5, 0x64, 0x86, 0x19, 0x67, 0xa6, 0xa5, 
  0x65, 0x35, 0x64, 0xbb, 0xc7, 0x43, 0x81, 0x72, 0xfc, 0x90, 0xd9, 0xb5, 
  0xd9, 0xc2, 0x33, 0xf5, 0x01, 0xcf, 0xa2, 0x73, 0xc0, 0x31, 0xda, 0x8e, 
  0xd5, 0x46, 0xe9, 0x2a, 0x28, 0x35, 0xe8, 0x22, 0xba, 0x4b, 0x93, 0x7b, 
  0xce, 0xe7, 0x56, 0x1f, 0x8f, 0x60, 0x9b, 0xeb, 0x19, 0x66, 0x52, 0x68, 
  0x0e, 0x5b, 0xd3, 0x4a, 0xe7, 0xa4, 0xb9, 0x13, 0x03, 0x1c, 0xc2, 0xc1, 
  0x5a, 0x0f, 0x75, 0x60, 0xdb, 0x54, 0x30, 0xa6, 0x8e, 0x30, 0x37, 0x66, 
  0xb6, 0xd9, 0x24, 0x09, 0x31, 0x0c, 0x7c, 0xf0, 0x30, 0x0f, 0xc8, 0x45, 
  0xf4, 0xe1, 0xe8, 0xc7, 0xed, 0x28, 0x4b, 0x78, 0x25, 0x85, 0xdf, 0xd2, 
  0x49, 0x58, 0x13, 0xc9, 0x5f, 0xb3, 0x79, 0x6b, 0x7c, 0x8f, 0x8e, 0xec, 
  0xe4, 0xf8, 0xc2, 0x65, 0x7c, 0xeb, 0x4d, 0x54, 0xe2, 0x42, 0x6c, 0xf0, 
  0x49, 0x2e, 0x19, 0xf3, 0xca, 0x85, 0x8d, 0x96, 0x82, 0x24, 0x8c, 0x75, 
  0x93, 0x78, 0x1c, 0xb9, 0xa8, 0x48, 0x36, 0x71, 0xb9, 0xa0, 0x1d, 0x31, 
  0xa5, 0xdc, 0xd9, 0x1f, 0xc5, 0x92, 0xc2, 0x6e, 0x0a, 0xe1, 0x6a, 0x6a, 
  0xf8, 0xe5, 0xc8, 0x24, 0x9b, 0x7b, 0x2a, 0x0e, 0xf5, 0x16, 0xe2, 0xf7, 
  0x7c, 0x9c, 0xcf, 0x88, 0x86, 0xe9, 0xc2, 0xb9, 0x2d, 0x3f, 0xa1, 0xc1, 
  0xcd, 0xcd, 0x2d, 0x20, 0xc7, 0x30, 0x51, 0xb2, 0xd3, 0x42, 0xaa, 0x21, 
  0xe9, 0xc2, 0x39, 0xd4, 0x90, 0xa5, 0x21, 0xb6, 0x82, 0x40, 0x59, 0x06, 
  0x68, 0xfb, 0x2d, 0x1b, 0x0f, 0xdc, 0x91, 0xac, 0x34, 0xc2, 0x5d, 0x18, 
  0xd7, 0x01, 0xb7, 0x7d, 0x91, 0x81, 0xcd, 0x94, 0x98, 0xed, 0xa4, 0xa3, 
  0x30, 0x84, 0x4b, 0x11, 0x35, 0x6b, 0x21, 0x44, 0x1e, 0x97, 0x44, 0xb9, 
  0x25, 0x4b, 0xe3, 0xc3, 0x68, 0x67, 0x2d, 0xc7, 0xb5, 0xc8, 0xd5, 0x61, 
  0x41, 0x2d, 0xf7, 0x07, 0x5f, 0x1e, 0x89, 0xf3, 0xfd, 0xb0, 0xe1, 0x0d, 
  0xce, 0x8f, 0x2e, 0xb8, 0x2d, 0x0b, 0x49, 0xac, 0x81, 0x5d, 0x85, 0x3e, 
  0x10, 0xe0, 0x35, 0x99, 0xa9, 0x79, 0xd0, 0x5d, 0xf5, 0x45, 0x9d, 0x43, 
  0xb3, 0x59, 0x63, 0x61, 0x4a, 0xc7, 0x2b, 0x48, 0x75, 0xbc, 0x17, 0x70, 
  0xc5, 0xe6, 0x35, 0x55, 0x57, 0x4c, 0x1d, 0x4e, 0xe6, 0xc0, 0x6c, 0x4f, 
  0x02, 0x2d, 0x9d, 0xc1, 0xdb, 0xc6, 0xa5, 0x14, 0x5b, 0x12, 0xcd, 0xa4, 
  0x48, 0x54, 0xc5, 0x74, 0x59, 0xe8, 0x96, 0x1d, 0x7a, 0x83, 0x82, 0x86, 
  0x74, 0x17, 0xa8, 0x09, 0x92, 0x9e, 0x04, 0xc1, 0x36, 0x29, 0x5d, 0x2e, 
  0x22, 0x07, 0xb4, 0x18, 0xec, 0xa4, 0xb4, 0xc0, 0xa9, 0x67, 0x48, 0x46, 
  0x85, 0x13, 0x60, 0x92, 0x2c, 0xba, 0x02, 0xa6, 0xd8, 0xd7, 0xf5, 0xfb, 
  0x0e, 0x6c, 0x92, 0xc8, 0xd3, 0xe1, 0xb0, 0x2a, 0x96, 0xa5, 0x20, 0x8e, 
  0x34, 0x69, 0x52, 0x21, 0x1b, 0x49, 0x42, 0xe6, 0x7c, 0x51, 0xde, 0xfc, 
  0x4f, 0x79, 0x5e, 0x8c, 0x3e, 0x1d, 0x1e, 0x49, 0x4d, 0x06, 0x6b, 0x8c, 
  0xf6, 0xa1, 0xd3, 0x73, 0x0c, 0xd9, 0xa7, 0x76, 0xd8, 0x06, 0xc0, 0xd2, 
  0x33, 0xb3, 0x20, 0xac, 0x95, 0x2d, 0xff, 0x42, 0x36, 0xf5, 0x72, 0x2e, 
  0x24, 0xf5, 0xdf, 0xfb, 0xf8, 0x30, 0xde, 0x81, 0x99, 0xec, 0x9d, 0x57, 
  0xc8, 0x5b, 0xc1, 0x42, 0x95, 0x64, 0x5b, 0xd9, 0x8e, 0xd2, 0x5b, 0x6a, 
  0xa3, 0xe6, 0x4f, 0xb9, 0x8e, 0x9c, 0xc0, 0x72, 0xf8, 0x6b, 0xb1, 0x6d, 
  0x61, 0x80, 0x2d, 0x8f, 0x53, 0x36, 0xa2, 0x71, 0x21, 0x20, 0x17, 0x9a, 
  0x11, 0x81, 0xd6, 0xad, 0xe5, 0x52, 0x73, 0x91, 0xdb, 0xbc, 0x1c, 0x58, 
  0x08, 0xb9, 0x2a, 0x97, 0x2b, 0xa9, 0xf6, 0xe8, 0xe3, 0xdd, 0x5a, 0x84, 
  0x9d, 0x5d, 0x35, 0x25, 0x51, 0x0b, 0xb4, 0x07, 0x96, 0x13, 0xd7, 0x0e, 
  0x81, 0xca, 0x1b, 0xa5, 0xae, 0x46, 0x5f, 0x5c, 0x4a, 0xea, 0xb0, 0x2f, 
  0x4a, 0xf0, 0xe0, 0xe9, 0xd9, 0xfa, 0xaf, 0x91, 0x0c, 0x03, 0x63, 0xe3, 
  0x5a, 0x49, 0x7f, 0x22, 0xc1, 0x1d, 0x92, 0xdc, 0x7a, 0x2c, 0xea, 0x1b, 
  0x18, 0x82, 0x45, 0x74, 0x87, 0xe3, 0x86, 0xb9, 0xa4, 0x88, 0xb4, 0x5b, 
  0xe2, 0x1e, 0x52, 0xfb, 0x41, 0xcb, 0x2b, 0x7f, 0x9f, 0x09, 0x64, 0x66, 
  0x58, 0x3c, 0xce, 0x73, 0x1c, 0x0e, 0xc1, 0xe5, 0x7a, 0x74, 0x85, 0x41, 
  0xa5, 0xb4, 0xa2, 0x54, 0xef, 0xe2, 0xd9, 0x32, 0x31, 0x24, 0x3b, 0x2f, 
  0xaa, 0x3b, 0x74, 0x0e, 0x01, 0xc1, 0x43, 0x49, 0xbe, 0xb5, 0x18, 0xed, 
  0x40, 0x90, 0x07, 0x97, 0x4c, 0xde, 0x43, 0x7d, 0x22, 0x16, 0xf9, 0xd9, 
  0xa3, 0x4e, 0x20, 0xe5, 0x67, 0x3e, 0x33, 0x10, 0xd3, 0x54, 0x8b, 0x90, 
  0xf9, 0x33, 0x00, 0x3c, 0xcd, 0xae, 0x77, 0x44, 0xef, 0xaf, 0x9d, 0xae, 
  0x69, 0x7b, 0xc8, 0x56, 0x43, 0x89, 0x06, 0x03, 0x64, 0x0d, 0x76, 0x96, 
  0x6f, 0xa0, 0x2c, 0xef, 0x76, 0xc2, 0x58, 0x4e, 0x7d, 0x10, 0x4b, 0xe8, 
  0xe7, 0x0e, 0x38, 0x04, 0xae, 0x3b, 0xd0, 0x19, 0xe9, 0xa5, 0xeb, 0xa9, 
  0xd9, 0x44, 0xe2, 0x17, 0x11, 0xb5, 0x04, 0x22, 0xaa, 0x1e, 0x39, 0xce, 
  0x85, 0x4d, 0x38, 0xc5, 0x84, 0xe3, 0x0d, 0x1b, 0x2d, 0xb0, 0x08, 0x02, 
  0xbf, 0xe1, 0x65, 0x0d, 0x3b, 0xc8, 0x91, 0xce, 0x7c, 0xdb, 0xc3, 0xaa, 
  0xff, 0xeb, 0x40, 0xf3, 0x96, 0x38, 0x85, 0x29, 0x02, 0x79, 0xba, 0x9d, 
  0x78, 0x65, 0x10, 0xd4, 0x00, 0x77, 0x08, 0xf0, 0xe5, 0xbd, 0xee, 0xc7, 
  0x2b, 0xac, 0x81, 0x10, 0x69, 0x77, 0x9a, 0xdd, 0x98, 0x4b, 0x27, 0x45, 
  0x7f, 0xcd, 0xc7, 0x7a, 0xe5, 0x31, 0xb7, 0x66, 0x4e, 0x76, 0x05, 0x67, 
  0xf3, 0x92, 0x6e, 0xc2, 0xe9, 0x32, 0x11, 0xb5, 0xbe, 0xcd, 0xf6, 0xb4, 
  0x04, 0x5a, 0x29, 0x2a, 0x10, 0x64, 0x22, 0x5a, 0x4d, 0x40, 0xd6, 0x88, 
  0x6f, 0x4a, 0xc6, 0x63, 0x02, 0x24, 0x3f, 0xdb, 0x14, 0x82, 0x97, 0x33, 
  0xe4, 0xc3, 0x48, 0x7d, 0x15, 0x57, 0x51, 0xa5, 0x99, 0x63, 0x1e, 0x62, 
  0xf8, 0xb7, 0x3c, 0x2a, 0x02, 0xe9, 0xbf, 0x1e, 0xef, 0xee, 0xd3, 0x98, 
  0xac, 0xdf, 0x60, 0x9b, 0xb3, 0x65, 0xcb, 0xcd, 0xf7, 0x06, 0x1f, 0x8e, 
  0xa2, 0x97, 0xe2, 0xd3, 0x15, 0x89, 0x68, 0xa9, 0x21, 0x58, 0x82, 0x2d, 
  0xe6, 0x5b, 0xc9, 0xb6, 0x19, 0xe0, 0xab, 0x2a, 0x26, 0xad, 0x46, 0x6e, 
  0x2d, 0x28, 0xa9, 0x9c, 0x28, 0x4a, 0xd2, 0x08, 0x0f, 0x3a, 0x03, 0xa2, 
  0xdd, 0xd0, 0xfd, 0x92, 0xef, 0xda, 0xf9, 0xfa, 0xf4, 0x42, 0xde, 0x4a, 
  0xd6, 0xbc, 0xb2, 0x2e, 0xc0, 0x31, 0x57, 0xf4, 0x65, 0xb5, 0x68, 0x61, 
  0x8e, 0x4f, 0x4c, 0x05, 0x91, 0xbc, 0x74, 0x06, 0x5b, 0xe1, 0xf0, 0x86, 
  0x2c, 0x7d, 0x3f, 0x0a, 0x45, 0x2d, 0x11, 0xfc, 0xd8, 0x86, 0xd2, 0x99, 
  0x87, 0x23, 0x0b, 0xa8, 0x39, 0x65, 0xc8, 0x08, 0x68, 0x22, 0xbd, 0xf1, 
  0x5e, 0x63, 0x6e, 0x9b, 0x8f, 0xb7, 0xda, 0xd5, 0xa5, 0xa8, 0xdb, 0xcd, 
  0xdd, 0x5a, 0x05, 0x63, 0x13, 0x03, 0xc3, 0xda, 0x52, 0x6b, 0x6b, 0x50, 
  0xc0, 0x6a, 0x01, 0x90, 0x7f, 0xb6, 0x1d, 0x5a, 0xf6, 0x2f, 0x5e, 0x25, 
  0x16, 0xc3, 0x64, 0xe9, 0xa3, 0x89, 0x16, 0x9c, 0x64, 0xdf, 0x4a, 0xde, 
  0x17, 0xd8, 0xac, 0x4d, 0x62, 0x8d, 0x41, 0xec, 0x14, 0xdb, 0x62, 0xf3, 
  0x02, 0x7f, 0x14, 0xd1, 0x75, 0x91, 0x33, 0xbf, 0x61, 0x3b, 0x1c, 0xcf, 
  0x72, 0xab, 0xab, 0xaa, 0x5b, 0x98, 0xb3, 0xec, 0x52, 0x96, 0x7b, 0x5f, 
  0x9d, 0xbe, 0x39, 0xec, 0x85, 0xb8, 0x0c, 0x40, 0xc1, 0x6e, 0x8b, 0x07, 
  0xbc, 0xc1, 0x7e, 0x4b, 0x5b, 0x54, 0xbe, 0x1f, 0xfd, 0x6d, 0x99, 0x4e, 
  0x6e, 0xb1, 0xb7, 0x30, 0xcf, 0xc3, 0x80, 0x96, 0xb8, 0x90, 0x10, 0xba, 
  0x83, 0x54, 0x1c, 0xe3, 0x08, 0x2f, 0x1e, 0x6b, 0xf3, 0xee, 0x57, 0xe2, 
  0x12, 0x66, 0x12, 0x26, 0x6d, 0x8a, 0x17, 0x91, 0xb6, 0xde, 0xe3, 0x86, 
  0xa9, 0xbe, 0xd9, 0x1a, 0x62, 0x59, 0x8d, 0xa6, 0xf9, 0x9c, 0x6b, 0x8c, 
  0xd2, 0x7a, 0x2b, 0xda, 0x38, 0xef, 0x37, 0xc8, 0xae, 0x3f, 0x5f, 0x71, 
  0x3c, 0x6d, 0xdf, 0xf0, 0x8b, 0xd7, 0xa0, 0x24, 0x6c, 0xb4, 0x0c, 0xd1, 
  0xe8, 0xab, 0xa3, 0xfd, 0x48, 0x89, 0x3a, 0x92, 0x86, 0x3d, 0xea, 0x5f, 
  0x4b, 0x36, 0x23, 0x79, 0xba, 0xfa, 0x74, 0x72, 0x84, 0x2c, 0x5c, 0xab, 
  0x46, 0x13, 0x3e, 0x1e, 0x1a, 0x2a, 0x44, 0xe3, 0xdd, 0x6f, 0x78, 0x8f, 
  0x42, 0xeb, 0xa4, 0x3e, 0x6f, 0xc8, 0xfe, 0x7e, 0x60, 0x62, 0x52, 0x6a, 
  0x13, 0xc4, 0x28, 0xe8, 0xd6, 0x63, 0x4f, 0x04, 0x56, 0x54, 0xd6, 0xa6, 
  0x63, 0x9c, 0x7f, 0x84, 0x2c, 0x74, 0x01, 0x75, 0x48, 0x13, 0xcc, 0x9d, 
  0xeb, 0x03, 0xd7, 0xb2, 0x90, 0x1f, 0xc0, 0x6e, 0x8c, 0x5e, 0x5f, 0x5c, 
  0x0c, 0x4f, 0xec, 0xe1, 0xa8, 0x03, 0xbf, 0xb1, 0xd9, 0x42, 0xfd, 0x05, 
  0xad, 0xd1, 0xc4, 0x96, 0x1e, 0x57, 0x43, 0x7e, 0xbc, 0x8a, 0xde, 0xa4, 
  0x93, 0x22, 0x2f, 0xf3, 0xab, 0xaa, 0xcb, 0x45, 0xe9, 0x6b, 0x0e, 0x38, 
  0x65, 0x9f, 0xa3, 0x4f, 0x63, 0xa0, 0x37, 0x2b, 0x3c, 0xc9, 0x11, 0x72, 
  0xfb, 0x49, 0x06, 0x99, 0xd3, 0x29, 0x6b, 0xd9, 0x6d, 0xe6, 0x09, 0x1b, 
  0x4d, 0xa0, 0xdd, 0xaa, 0x1f, 0x0a, 0x9c, 0xe5, 0x6b, 0x75, 0x7a, 0x3d, 
  0x69, 0x4a, 0xb9, 0xe3, 0x16, 0x20, 0x3d, 0x22, 0x5a, 0xc7, 0xce, 0x24, 
  0xa7, 0x48, 0x3f, 0xd7, 0x96, 0xa7, 0x83, 0xb8, 0xe5, 0x8f, 0xa9, 0x8f, 
  0x4a, 0x43, 0xe5, 0xfa, 0x67, 0xc8, 0x73, 0x0e, 0x31, 0x6c, 0xd8, 0x5f, 
  0x76, 0x74, 0x78, 0xf9, 0x2a, 0x9a, 0x16, 0x31, 0xad, 0x02, 0xfe, 0x1d, 
  0xb6, 0x42, 0x49, 0x92, 0x9f, 0xe2, 0xdb, 0x61, 0xb9, 0xe0, 0xcd, 0x1a, 
  0x32, 0xeb, 0x1d, 0xee, 0x3c, 0xe6, 0x9a, 0xde, 0x1f, 0x51, 0xb7, 0xaa, 
  0x1e, 0x7d, 0xe8, 0x3d, 0x85, 0xde, 0x55, 0x68, 0x9e, 0x42, 0xde, 0x9a, 
  0xb5, 0x7e, 0x42, 0xda, 0xcc, 0xfd, 0xb3, 0x23, 0xef, 0x22, 0x6c, 0x79, 
  0x08, 0xcd, 0x45, 0x08, 0xaf, 0x60, 0x93, 0xf6, 0x42, 0x1f, 0xa1, 0xb2, 
  0x25, 0xef, 0x25, 0xb4, 0x2f, 0x9c, 0xa3, 0x90, 0x09, 0xa7, 0x55, 0x7c, 
  0xc4, 0x8a, 0x97, 0xfe, 0x17, 0xb1, 0x2b, 0x4f, 0xf8, 0xf6, 0xce, 0x87, 
  0xe3, 0x25, 0x7f, 0xd7, 0x68, 0xe4, 0xa5, 0xb0, 0x07, 0x83, 0xac, 0x90, 
  0x67, 0xa0, 0x23, 0x5a, 0x18, 0xb0, 0xe6, 0x73, 0x97, 0xec, 0x0d, 0x9a, 
  0x73, 0xa6, 0x74, 0x27, 0x86, 0x9f, 0x00, 0x2f, 0xba, 0xa2, 0x1c, 0xe5, 
  0x20, 0xc8, 0x6e, 0x55, 0x93, 0x5c, 0xb4, 0x36, 0x93, 0x16, 0x9d, 0x42, 
  0x3b, 0x97, 0xbe, 0xb4, 0x33, 0xdd, 0x6b, 0xb4, 0xe1, 0x82, 0x9e, 0x44, 
  0xb6, 0xee, 0x8c, 0xc0, 0xd6, 0x47, 0xb5, 0x11, 0x0f, 0x22, 0x9f, 0x09, 
  0x84, 0xb7, 0x44, 0xa7, 0x47, 0x52, 0x67, 0xa0, 0x75, 0x7b, 0xe2, 0x14, 
  0x46, 0x86, 0x34, 0xaf, 0x60, 0x5b, 0xae, 0x8d, 0xb8, 0x28, 0x48, 0xfa, 
  0x2e, 0x1d, 0x7e, 0xc0, 0xfa, 0x72, 0x46, 0x18, 0x82, 0x07, 0x52, 0x8c, 
  0x2b, 0xbf, 0xa6, 0x9f, 0x40, 0x4b, 0xd4, 0xc4, 0x4e, 0x70, 0x80, 0x56, 
  0x2f, 0x02, 0xce, 0xea, 0x38, 0xa2, 0x67, 0x89, 0xd1, 0xc9, 0xe5, 0xf1, 
  0x9b, 0x36, 0x2b, 0x14, 0x74, 0x21, 0xfe, 0xee, 0x61, 0x5b, 0xd1, 0x07, 
  0x59, 0xe2, 0x43, 0x1c, 0x91, 0x03, 0x88, 0x8e, 0x8e, 0x2e, 0x22, 0x70, 
  0x44, 0xb5, 0x91, 0x1a, 0x37, 0xe4, 0x6a, 0x7b, 0x39, 0xb1, 0x44, 0x92, 
  0x9f, 0x8a, 0x55, 0x1b, 0x03, 0x42, 0x81, 0x3f, 0x59, 0x51, 0x28, 0x4a, 
  0x54, 0xf6, 0x62, 0xf8, 0x27, 0x50, 0x0e, 0x67, 0xc3, 0xcc, 0x80, 0xdf, 
  0xb7, 0x48, 0x72, 0x44, 0x25, 0x77, 0x8c, 0x81, 0x65, 0x0c, 0x16, 0x6c, 
  0xac, 0x64, 0xab, 0x08, 0x0e, 0xe3, 0xb8, 0x74, 0xde, 0x5f, 0x62, 0xd4, 
  0x44, 0x5f, 0xbe, 0x70, 0x73, 0x13, 0x9b, 0x08, 0xb5, 0x3f, 0xae, 0x7c, 
  0xea, 0x77, 0x5d, 0xd2, 0x22, 0x95, 0x2e, 0x2f, 0x60, 0x42, 0xf3, 0x99, 
  0x00, 0x2d, 0xff, 0x13, 0x63, 0xce, 0xf1, 0x65, 0xc8, 0xda, 0x61, 0xb1, 
  0x92, 0xca, 0x8a, 0x37, 0x82, 0xcb, 0x5a, 0xea, 0xc6, 0xb0, 0x6f, 0x53, 
  0xf6, 0xb5, 0xa3, 0x0a, 0xe7, 0x62, 0x39, 0x66, 0xcb, 0xae, 0xde, 0xa1, 
  0x2e, 0xa0, 0x13, 0x31, 0xd9, 0x4d, 0xd3, 0x87, 0xee, 0x54, 0x77, 0x84, 
  0x06, 0x09, 0xb4, 0x5a, 0x76, 0x50, 0x90, 0x8d, 0x3f, 0xae, 0x96, 0x60, 
  0x88, 0x13, 0xa9, 0xc2, 0x32, 0xc6, 0xac, 0x70, 0xce, 0xac, 0xc7, 0xe5, 
  0xef, 0x57, 0x6e, 0x24, 0x1d, 0x18, 0x55, 0xb0, 0x54, 0x59, 0x25, 0x14, 
  0xa2, 0x51, 0xbc, 0x00, 0x4a, 0xfd, 0x64, 0xb1, 0x22, 0x08, 0x9d, 0x73, 
  0x57, 0xc0, 0x07, 0xa2, 0x3f, 0xba, 0x94, 0x03, 0xc7, 0xe2, 0x79, 0xae, 
  0xff, 0x4d, 0x56, 0x9e, 0xd3, 0xb0, 0x95, 0xbf, 0x3d, 0x00, 0x14, 0xea, 
  0xf8, 0x28, 0x5f, 0x59, 0xf2, 0x5c, 0xad, 0xb0, 0xb7, 0x94, 0xa0, 0xd2, 
  0xed, 0xec, 0xc8, 0x10, 0x13, 0x0f, 0xde, 0xdf, 0xff, 0xc1, 0x7a, 0xcd, 
  0x0f, 0x3f, 0x42, 0xde, 0x47, 0x28, 0xb3, 0x73, 0x1f, 0x1b, 0xd5, 0x95, 
  0x83, 0x8e, 0x16, 0x26, 0x02, 0x80, 0x42, 0xc3, 0xe0, 0xd0, 0x03, 0x9d, 
  0xb3, 0x1d, 0xfd, 0xd8, 0x3c, 0x9a, 0xaa, 0x1a, 0x76, 0xce, 0xc2, 0x82, 
  0x32, 0x00, 0x30, 0x13, 0x40, 0x11, 0x39, 0x25, 0x57, 0x93, 0x0a, 0xa6, 
  0x6b, 0x01, 0x1f, 0x15, 0xd6, 0xc1, 0x00, 0x0f, 0x0d, 0x77, 0x9e, 0xbd, 
  0xf3, 0x02, 0xaa, 0x89, 0x09, 0xb1, 0x63, 0x16, 0x86, 0xd4, 0x34, 0x6b, 
  0x87, 0x9f, 0xcb, 0xce, 0xab, 0xcf, 0xfd, 0xef, 0x0c, 0x92, 0x58, 0xdd, 
  0xe7, 0xff, 0x18, 0xb1, 0xf5, 0x11, 0x82, 0xfd, 0x30, 0x8f, 0x7a, 0x3c, 
  0xf8, 0x77, 0xbf, 0xde, 0x65, 0x91, 0xa6, 0xe5, 0x83, 0xcf, 0x0b, 0x2c, 
  0x82, 0x51, 0x81, 0xcd, 0xa1, 0x5c, 0x13, 0xed, 0x5e, 0xef, 0x8e, 0x7b, 
  0x19, 0xb0, 0x2a, 0xf1, 0x8f, 0x11, 0xff, 0xfb, 0xc3, 0xee, 0xf0, 0xc9, 
  0x8f, 0xae, 0xd7, 0x5f, 0xef, 0xbe, 0xfb, 0xf5, 0x5e, 0x6f, 0x63, 0x6d, 
  0x1e, 0xd3, 0xd2, 0x20, 0xc1, 0x95, 0x20, 0x63, 0x05, 0x95, 0x91, 0x3c, 
  0x8d, 0xb8, 0x74, 0x8e, 0xf6, 0xe6, 0x4d, 0xee, 0x72, 0x9e, 0x38, 0x85, 
  0xb1, 0x33, 0xd3, 0x24, 0xa8, 0xc9, 0x17, 0xa0, 0x73, 0x78, 0x39, 0x8d, 
  0x09, 0x4e, 0x91, 0x2b, 0x3a, 0x76, 0xa5, 0x5e, 0xd7, 0x87, 0x7d, 0x57, 
  0xd3, 0x15, 0x69, 0x5d, 0xa2, 0xc1, 0x07, 0x54, 0x7e, 0x8a, 0x5c, 0x15, 
  0xae, 0x27, 0x87, 0x84, 0x8c, 0x07, 0x69, 0x1c, 0x7e, 0x03, 0x69, 0x38, 
  0xc0, 0x90, 0x42, 0x68, 0x80, 0x84, 0xba, 0x74, 0x94, 0xa5, 0x13, 0x5c, 
  0x3d, 0xf8, 0x6a, 0x88, 0xeb, 0x9d, 0x66, 0x33, 0x1f, 0xbe, 0x22, 0x39, 
  0xf0, 0x1a, 0x0d, 0x23, 0x2f, 0x77, 0xa5, 0x7a, 0xeb, 0x19, 0x1f, 0x78, 
  0xf4, 0x43, 0x36, 0xc7, 0xb1, 0x7d, 0xe7, 0xea, 0x6a, 0xb4, 0xf5, 0xe9, 
  0xb7, 0xc6, 0xdd, 0xf0, 0xa8, 0x2a, 0xf3, 0x7c, 0x71, 0x53, 0xd0, 0x2d, 
  0xd6, 0x1d, 0xad, 0x89, 0x52, 0xf3, 0xf2, 0x80, 0x3b, 0x07, 0x41, 0xc4, 
  0xe5, 0x2f, 0x17, 0x5a, 0xea, 0x19, 0x7d, 0x93, 0xcd, 0xb7, 0xc0, 0xa9, 
  0x70, 0xa5, 0x34, 0x6e, 0x33, 0x08, 0x64, 0x2c, 0xac, 0x2f, 0xb3, 0xce, 
  0x6b, 0x85, 0x65, 0x56, 0xef, 0xdc, 0xb3, 0x60, 0x7c, 0x74, 0x3a, 0xd2, 
  0x0a, 0x5f, 0x2a, 0x10, 0x45, 0x1d, 0x79, 0xd4, 0xb8, 0xcb, 0xb8, 0x0d, 
  0x74, 0xad, 0x19, 0x90, 0xba, 0xff, 0x50, 0xe9, 0x3f, 0x9d, 0x66, 0x2e, 
  0x37, 0x66, 0xfd, 0x66, 0x19, 0x2e, 0xb6, 0x75, 0xc1, 0xaa, 0x65, 0x96, 
  0x25, 0xb3, 0xae, 0xdc, 0xd9, 0xd8, 0x95, 0x3c, 0x97, 0x16, 0x02, 0x21, 
  0x6b, 0x73, 0xf8, 0xde, 0xde, 0xdf, 0x1a, 0x3c, 0x58, 0x7c, 0x33, 0xa8, 
  0x55, 0x94, 0xe5, 0xd9, 0x10, 0xed, 0x99, 0xa8, 0x25, 0x55, 0xc0, 0x9d, 
  0xa3, 0xb3, 0x29, 0x73, 0x63, 0x60, 0xd4, 0x76, 0x81, 0x1a, 0x16, 0x0a, 
  0x6d, 0xf8, 0x7e, 0x15, 0xde, 0x34, 0xf3, 0x04, 0xa5, 0x52, 0xe4, 0x3e, 
  0x49, 0xab, 0x2e, 0xf0, 0xa4, 0x5c, 0x32, 0x61, 0x70, 0x60, 0x9d, 0xb1, 
  0x58, 0xc1, 0xf9, 0xb4, 0x8b, 0x78, 0x41, 0x0d, 0xb3, 0x9f, 0xa8, 0x35, 
  0x0b, 0x84, 0xb5, 0x87, 0xbb, 0x5e, 0x5b, 0x8f, 0x83, 0xd3, 0x93, 0x93, 
  0xc3, 0x83, 0x30, 0x81, 0xb7, 0x2d, 0x14, 0x42, 0xac, 0xf0, 0x7a, 0xa5, 
  0x16, 0x66, 0x10, 0x19, 0x46, 0xe2, 0xb7, 0xd5, 0xcf, 0xa5, 0x76, 0xdd, 
  0x8e, 0x75, 0xf0, 0x8c, 0x02, 0x7a, 0xba, 0x1e, 0x55, 0x51, 0x7f, 0x62, 
  0x8e, 0x6e, 0x60, 0xe7, 0x68, 0x6d, 0xb1, 0x5a, 0xeb, 0xf0, 0xc9, 0xa9, 
  0x4b, 0xfa, 0x0f, 0xe8, 0xeb, 0x6c, 0x3b, 0xc0, 0xbc, 0x79, 0xae, 0xa9, 
  0x5b, 0xdd, 0x31, 0xcd, 0xe7, 0x22, 0x6f, 0x97, 0x96, 0x14, 0xca, 0x2e, 
  0x5e, 0x62, 0xdf, 0xdb, 0xec, 0xfc, 0xe7, 0x22, 0x4a, 0xb4, 0x88, 0xf9, 
  0x4c, 0xf0, 0xa9, 0x92, 0x6c, 0x4d, 0x95, 0x58, 0x33, 0x3c, 0x50, 0x97, 
  0xaa, 0x83, 0xab, 0x84, 0x2b, 0x86, 0x23, 0x58, 0x45, 0x15, 0x95, 0xae, 
  0x99, 0xbb, 0x16, 0x00, 0xed, 0x87, 0xa4, 0x05, 0xd8, 0x20, 0x36, 0xf0, 
  0xe2, 0x90, 0x33, 0xdc, 0x2e, 0xaf, 0x0c, 0x1e, 0x6f, 0xa5, 0x63, 0x32, 
  0x7b, 0x69, 0x14, 0xba, 0xf5, 0xdb, 0x29, 0x91, 0x28, 0x33, 0x86, 0x6f, 
  0xeb, 0x6b, 0x41, 0xb1, 0x56, 0xdd, 0x42, 0x8e, 0x0f, 0xb5, 0xf4, 0x36, 
  0x18, 0xa6, 0x73, 0x46, 0x59, 0x90, 0xd8, 0x2a, 0xc0, 0x17, 0xc5, 0xe5, 
  0x6d, 0x59, 0x8b, 0x65, 0xe8, 0x40, 0x3c, 0xe4, 0x6c, 0xd2, 0x45, 0xab, 
  0x99, 0xfa, 0x60, 0x46, 0x6b, 0xf7, 0xa2, 0x19, 0x03, 0xde, 0x92, 0x20, 
  0x5c, 0x9e, 0x5c, 0x4b, 0xb2, 0x90, 0xaf, 0x47, 0x49, 0xd4, 0xe3, 0x0c, 
  0xba, 0x5e, 0x18, 0x3b, 0x69, 0x8e, 0x50, 0x7b, 0x97, 0xad, 0xf4, 0x47, 
  0x67, 0xdd, 0x2d, 0xd8, 0xc8, 0x43, 0x15, 0x00, 0x62, 0xde, 0xe6, 0xdb, 
  0x2c, 0x7d, 0x8f, 0x50, 0x81, 0xb6, 0xc6, 0xe0, 0xd2, 0x02, 0xd7, 0x8f, 
  0x2a, 0xea, 0xed, 0x3e, 0xdd, 0x1b, 0xed, 0x7e, 0xf6, 0x39, 0x2b, 0x1d, 
  0xbb, 0xb5, 0xe1, 0x49, 0x41, 0x4b, 0x6a, 0x84, 0x0e, 0xd5, 0x3f, 0xbb, 
  0x5b, 0xe0, 0x4a, 0x97, 0x1d, 0x26, 0xde, 0xa8, 0x43, 0x70, 0x08, 0x57, 
  0x62, 0xbe, 0x1a, 0x05, 0x96, 0xda, 0x5a, 0xa7, 0x66, 0x37, 0x6e, 0x1a, 
  0x83, 0xf4, 0x4c, 0xf0, 0x75, 0x2d, 0x75, 0x60, 0xb5, 0x18, 0x99, 0x0a, 
  0x99, 0x5b, 0x2e, 0xdc, 0x15, 0x91, 0x75, 0x8b, 0x74, 0x72, 0xdb, 0xdd, 
  0xbf, 0x44, 0x50, 0xa2, 0x8f, 0x7e, 0x69, 0xc9, 0x34, 0xae, 0xb7, 0x9f, 
  0x79, 0xff, 0xe6, 0x59, 0xab, 0x72, 0xae, 0xc0, 0x0f, 0xbc, 0x6c, 0xd7, 
  0x72, 0xc0, 0x51, 0x92, 0x38, 0x13, 0x07, 0xd6, 0x55, 0x7b, 0x70, 0xa3, 
  0x9e, 0x40, 0xe4, 0x0b, 0x86, 0xb8, 0xda, 0x25, 0x1d, 0x07, 0x11, 0xad, 
  0x5a, 0x4e, 0x51, 0x77, 0xbd, 0x94, 0x91, 0xbc, 0x4c, 0x73, 0x21, 0xd1, 
  0x90, 0x9d, 0x35, 0xfc, 0xce, 0xef, 0x7f, 0x1f, 0xb0, 0xa3, 0xbf, 0xd5, 
  0x40, 0x05, 0xe2, 0x32, 0x88, 0x77, 0xf6, 0xf1, 0xd5, 0x79, 0x56, 0xcb, 
  0x88, 0x44, 0xa9, 0xb9, 0x0e, 0x66, 0xfc, 0x7f, 0xb3, 0xb7, 0x62, 0x7b, 
  0xc4, 0x0c, 0xd8, 0xfc, 0x50, 0xce, 0xd1, 0x0c, 0xdd, 0x21, 0x9e, 0x5a, 
  0x1e, 0xc6, 0xb4, 0x5d, 0xa7, 0x29, 0x0e, 0x03, 0xe2, 0x83, 0x11, 0xfe, 
  0x2f, 0x62, 0x98, 0x08, 0xc8, 0xe6, 0xc0, 0x7c, 0xee, 0xbf, 0x9b, 0x59, 
  0x32, 0xcc, 0x3d, 0xea, 0x5d, 0x15, 0xe3, 0xb4, 0x82, 0x72, 0x1a, 0x84, 
  0x8c, 0x69, 0x21, 0x37, 0xdc, 0x15, 0xec, 0xa0, 0xed, 0x4c, 0xff, 0x1c, 
  0x34, 0x2b, 0x1b, 0xfc, 0xaf, 0xb7, 0x5c, 0x1b, 0xd8, 0x9a, 0xb1, 0xda, 
  0xab, 0x02, 0x86, 0xdf, 0x0e, 0x95, 0xae, 0x55, 0x3e, 0x31, 0xdb, 0xb1, 
  0x40, 0x30, 0x4b, 0x0b, 0x03, 0x17, 0x1f, 0x1f, 0x75, 0x94, 0xfc, 0x61, 
  0xce, 0x2a, 0x1d, 0xfa, 0x7a, 0x34, 0xc8, 0xb6, 0xd1, 0x0a, 0xeb, 0xa2, 
  0x99, 0x4d, 0x7e, 0x15, 0xfd, 0x2f, 0xac, 0xc5, 0x9a, 0x98, 0x7c, 0x7b, 
  0x87, 0x98, 0xc4, 0x97, 0x87, 0xaf, 0x4e, 0xcf, 0x0f, 0x6b, 0xb5, 0x50, 
  0xe1, 0xc8, 0x8b, 0x01, 0xba, 0xda, 0x19, 0x1e, 0xc5, 0x78, 0x3e, 0x72, 
  0x90, 0xdc, 0x10, 0x24, 0x24, 0x54, 0x1e, 0x8f, 0x5c, 0x51, 0xec, 0x72, 
  0x39, 0x61, 0x5c, 0xd0, 0xab, 0x65, 0x53, 0x3e, 0xb2, 0x9e, 0x42, 0x28, 
  0x29, 0x75, 0xf5, 0xb0, 0x1d, 0x92, 0xeb, 0x37, 0x47, 0x1c, 0xa1, 0x3e, 
  0xf2, 0xb2, 0x79, 0xa7, 0x0a, 0x2a, 0x58, 0x10, 0xf1, 0x1c, 0x01, 0xb9, 
  0x8c, 0x71, 0x6b, 0xe3, 0x91, 0xf8, 0x3f, 0x06, 0x6b, 0xd7, 0x5a, 0x39, 
  0x6d, 0xc9, 0x42, 0x06, 0xd9, 0xa8, 0x01, 0x1b, 0x6e, 0x5e, 0xe4, 0x10, 
  0x22, 0x0d, 0x05, 0xad, 0x0b, 0x26, 0x37, 0x80, 0x82, 0xb0, 0xde, 0xe5, 
  0xf8, 0x6b, 0x28, 0xb3, 0x77, 0xb0, 0x77, 0x67, 0x58, 0xc4, 0xe3, 0xee, 
  0x24, 0xa9, 0x9f, 0x1f, 0x22, 0x1e, 0x02, 0xa6, 0xff, 0x0b, 0xc8, 0xf0, 
  0xe2, 0xa1, 0x43, 0x14, 0x84, 0xa6, 0x48, 0x74, 0xe4, 0x3e, 0x3a, 0x7b, 
  0xef, 0x38, 0x09, 0xf3, 0x05, 0x89, 0x21, 0x28, 0xe4, 0x3b, 0xea, 0x77, 
  0x79, 0x6c, 0x95, 0x96, 0x44, 0xd8, 0x04, 0x8e, 0x5f, 0x03, 0x15, 0x1f, 
  0x22, 0xc5, 0x3f, 0xac, 0xe6, 0x3a, 0x30, 0xfc, 0x16, 0x46, 0x7c, 0xb1, 
  0x8d, 0x35, 0xb9, 0xa6, 0xd5, 0xc0, 0x8f, 0x2f, 0xd6, 0xe5, 0x83, 0x6f, 
  0x31, 0xa8, 0x04, 0xdd, 0x11, 0xc9, 0x9d, 0x98, 0xc1, 0x39, 0xe2, 0x26, 
  0xd2, 0x02, 0x05, 0x9b, 0x7c, 0x1b, 0xc5, 0xd0, 0x3a, 0xd3, 0x96, 0xff, 
  0xcd, 0xcc, 0x2c, 0x5b, 0x86, 0xfb, 0x85, 0x16, 0x77, 0x47, 0xbb, 0x48, 
  0xce, 0x76, 0x31, 0xa6, 0xa3, 0xe8, 0x9c, 0xdb, 0x42, 0xf6, 0x4d, 0x9b, 
  0x00, 0x7c, 0x86, 0x0b, 0x30, 0xa0, 0xbc, 0x26, 0xc9, 0xc1, 0x30, 0x2d, 
  0xb2, 0xd8, 0x19, 0x3e, 0x7e, 0xfa, 0xb4, 0x66, 0x84, 0x09, 0x79, 0xf1, 
  0x93, 0x9d, 0x1d, 0x89, 0x17, 0x6a, 0xbe, 0x46, 0x5f, 0x0c, 0x9f, 0xe2, 
  0xc5, 0xfa, 0x6b, 0x2a, 0xa5, 0xae, 0x7d, 0x6f, 0xc8, 0xdf, 0x74, 0x74, 
  0x87, 0xbb, 0x6d, 0xed, 0x5b, 0x4f, 0x3b, 0xde, 0xc2, 0x6b, 0x12, 0xf3, 
  0x2e, 0x60, 0xa7, 0x52, 0x19, 0x1b, 0x8f, 0xb6, 0x0f, 0x67, 0xed, 0x90, 
  0xdd, 0xc7, 0x6d, 0x87, 0xee, 0xce, 0x70, 0x67, 0x30, 0xdc, 0xed, 0xe8, 
  0xc2, 0xb2, 0x70, 0xd4, 0xfe, 0x2a, 0x4a, 0x30, 0x3a, 0x5e, 0xdb, 0x05, 
  0x4b, 0x46, 0x9b, 0xbf, 0xdb, 0xda, 0xfc, 0x6a, 0xab, 0x6b, 0xd9, 0xfe, 
  0xb0, 0xb3, 0x33, 0xf8, 0x8c, 0x7f, 0x3e, 0x7d, 0xba, 0xb6, 0x05, 0x3f, 
  0x86, 0x47, 0xb6, 0x26, 0xb5, 0x59, 0x52, 0x3b, 0x1d, 0xad, 0xef, 0x52, 
  0xab, 0xbb, 0x4f, 0x9f, 0x0e, 0xb8, 0x97, 0x27, 0x1f, 0xd5, 0x3a, 0xb3, 
  0xce, 0xfb, 0x3c, 0x8a, 0x7c, 0xfa, 0x29, 0x5a, 0xd1, 0x09, 0x96, 0x6b, 
  0x5b, 0x00, 0x2d, 0x97, 0x8d, 0x39, 0xd2, 0x9f, 0xd1, 0x0b, 0x29, 0x6c, 
  0xef, 0xeb, 0x00, 0x04, 0xfa, 0x66, 0x5d, 0x20, 0x67, 0x93, 0xde, 0x4a, 
  0x15, 0xef, 0x0d, 0x97, 0x18, 0xa5, 0xf0, 0x88, 0x2e, 0x54, 0xda, 0x23, 
  0xfe, 0x7f, 0x1f, 0x80, 0xed, 0x68, 0xb9, 0xd0, 0xf8, 0x3e, 0xb6, 0x22, 
  0xd9, 0x30, 0xaa, 0xb8, 0xd3, 0x62, 0xd7, 0x21, 0x29, 0x9b, 0x41, 0xc5, 
  0x30, 0x75, 0x29, 0xa5, 0x1e, 0x6f, 0x41, 0x0c, 0xda, 0x53, 0x44, 0xae, 
  0x8a, 0xeb, 0xc9, 0x40, 0xbf, 0x82, 0x70, 0xdf, 0x00, 0xc9, 0x4a, 0xab, 
  0x8c, 0x0c, 0x2c, 0x08, 0xd1, 0xa4, 0x22, 0xc3, 0x3c, 0x44, 0x40, 0x94, 
  0xc7, 0x5c, 0x70, 0x63, 0xe7, 0xa3, 0x2b, 0xc7, 0xdf, 0x62, 0xcd, 0x4a, 
  0x8d, 0xb4, 0x75, 0xf7, 0x75, 0x62, 0xb1, 0x11, 0xe5, 0x8a, 0x78, 0xe5, 
  0xfb, 0xa8, 0x8f, 0x10, 0x39, 0xe7, 0x5e, 0x2c, 0xab, 0x7c, 0xd1, 0x8f, 
  0x36, 0xcd, 0xa3, 0x6e, 0x2b, 0xa7, 0x97, 0x45, 0x98, 0x3a, 0xc2, 0xc6, 
  0xb9, 0x39, 0xe7, 0xd3, 0x4d, 0x19, 0x23, 0xf8, 0xc8, 0x8d, 0x7d, 0x9a, 
  0x2c, 0x10, 0x82, 0x66, 0xb1, 0xca, 0xa4, 0xfc, 0x9f, 0xbf, 0x3a, 0xa8, 
  0x55, 0x54, 0x1f, 0xfd, 0xa7, 0x85, 0x52, 0xcf, 0x3b, 0xcf, 0xbd, 0x85, 
  0x8f, 0x5f, 0xfe, 0x00, 0x34, 0x98, 0x47, 0x4f, 0x98, 0xa5, 0xe3, 0x66, 
  0xf8, 0xb5, 0xd4, 0x46, 0x6f, 0x8a, 0x31, 0x4b, 0xd3, 0xe5, 0x31, 0xb6, 
  0x2a, 0x9e, 0x2f, 0x3a, 0x8c, 0x7a, 0x22, 0x0a, 0x69, 0xb0, 0x4d, 0xdb, 
  0xc2, 0x17, 0xdf, 0xd1, 0xb5, 0x0c, 0xd9, 0x18, 0x7d, 0x8b, 0xcb, 0x01, 
  0x96, 0xc6, 0x10, 0x22, 0x52, 0xec, 0x06, 0x1d, 0x50, 0x0c, 0xae, 0xe7, 
  0x8f, 0x8e, 0xf6, 0x5a, 0x93, 0xae, 0x3e, 0x6d, 0x07, 0xfb, 0x88, 0x25, 
  0x19, 0x6d, 0x40, 0xf9, 0x0f, 0x96, 0xb6, 0xe4, 0x9c, 0x1b, 0x80, 0xab, 
  0x36, 0x2f, 0x36, 0x41, 0x5c, 0x9d, 0xe7, 0xd3, 0x84, 0xa4, 0x7e, 0xa9, 
  0xf1, 0xc3, 0xe1, 0x36, 0x6c, 0x22, 0xb8, 0x86, 0x66, 0x17, 0x89, 0x9c, 
  0x8d, 0x30, 0x39, 0xe0, 0x73, 0xb7, 0x22, 0x02, 0x4a, 0x0e, 0xe4, 0x60, 
  0x37, 0xe8, 0x1b, 0xaf, 0xb7, 0xcf, 0x97, 0x1f, 0xef, 0xde, 0xfe, 0x17, 
  0x0c, 0x18, 0xf5, 0xe6, 0x87, 0x17, 0x3c, 0x3d, 0x1a, 0xf6, 0xb0, 0x6b, 
  0x80, 0xbe, 0xfc, 0x96, 0xa8, 0x39, 0x9c, 0x1a, 0xa5, 0x26, 0x06, 0xf1, 
  0xe3, 0xf0, 0x7c, 0xf1, 0xa2, 0x9b, 0x4c, 0xbb, 0x22, 0x72, 0x2a, 0xa8, 
  0xb4, 0x9f, 0x32, 0x0e, 0xdc, 0x8f, 0x23, 0x14, 0xb0, 0xb8, 0xfc, 0x4d, 
  0x19, 0x3d, 0x87, 0xc1, 0xff, 0x19, 0xf3, 0x81, 0x56, 0x99, 0x99, 0xb7, 
  0x2d, 0xe0, 0xfe, 0x8b, 0xd3, 0x83, 0xaf, 0x2f, 0x9e, 0x98, 0x99, 0xf3, 
  0xc8, 0xaa, 0xc1, 0x32, 0x8e, 0xab, 0x9c, 0xff, 0x0e, 0x47, 0x2c, 0xbc, 
  0xe0, 0x41, 0x81, 0x17, 0xe8, 0xab, 0xfc, 0x45, 0x5c, 0x96, 0x4b, 0xb6, 
  0x9e, 0x33, 0x78, 0x3b, 0xda, 0xd8, 0xdd, 0xf9, 0x7c, 0xa7, 0x85, 0x84, 
  0x7c, 0xaa, 0xa6, 0xeb, 0x1a, 0x54, 0xf0, 0xee, 0x07, 0x02, 0x38, 0x7c, 
  0x71, 0x89, 0x08, 0x32, 0x75, 0xe4, 0x0b, 0x5d, 0xa9, 0xb3, 0x88, 0xce, 
  0x67, 0x53, 0x38, 0x70, 0x46, 0xcc, 0x81, 0xaa, 0x84, 0x2b, 0xe8, 0x15, 
  0x44, 0x11, 0x4b, 0xf0, 0xbc, 0xe4, 0xfd, 0x64, 0xb6, 0xe4, 0x92, 0x83, 
  0xbf, 0x20, 0x04, 0x40, 0x59, 0x91, 0x48, 0xba, 0xa6, 0x4c, 0xdf, 0xb9, 
  0x05, 0xc5, 0xb3, 0x0e, 0xc6, 0x59, 0xa1, 0x80, 0xe8, 0x89, 0xf4, 0x95, 
  0xce, 0x4a, 0x7d, 0xeb, 0x7c, 0xb3, 0x96, 0x6c, 0x5c, 0x03, 0x21, 0x15, 
  0x17, 0x39, 0x22, 0x04, 0x49, 0x79, 0x41, 0x7a, 0x44, 0x4b, 0x00, 0xb6, 
  0x3b, 0xc8, 0x92, 0xa8, 0xa5, 0xff, 0x7c, 0x59, 0xd5, 0x4a, 0x7f, 0x68, 
  0xdc, 0x32, 0xed, 0x72, 0xda, 0xe2, 0x13, 0x52, 0x66, 0xcc, 0x30, 0xd2, 
  0x0c, 0x26, 0xaa, 0xbc, 0x01, 0x7e, 0x1a, 0x1f, 0xab, 0x69, 0x32, 0x61, 
  0x46, 0x62, 0x81, 0xfa, 0x6d, 0x31, 0x9e, 0x4b, 0x2b, 0x8c, 0xb9, 0x2a, 
  0x43, 0xfa, 0x0b, 0x94, 0x2a, 0x70, 0x3b, 0x53, 0x4d, 0x16, 0xc3, 0x8c, 
  0x98, 0xdb, 0xac, 0xa5, 0xcc, 0x5d, 0x72, 0xe8, 0x38, 0xa0, 0x8d, 0x74, 
  0x4d, 0xa3, 0xcb, 0x83, 0xb3, 0x77, 0x27, 0xa7, 0x2f, 0x0f, 0x8f, 0xf7, 
  0xbf, 0x77, 0xc6, 0xf0, 0x51, 0x64, 0x68, 0x6a, 0x9d, 0xfe, 0xc4, 0xd9, 
  0xbb, 0x24, 0x2e, 0x57, 0xef, 0x48, 0xdc, 0xa2, 0xc7, 0x37, 0x1f, 0x6d, 
  0xb1, 0x8c, 0x21, 0x59, 0x48, 0x61, 0xcc, 0x27, 0xa9, 0x5b, 0x1a, 0x1a, 
  0xd7, 0x69, 0x70, 0x6f, 0x41, 0x6c, 0xef, 0x7d, 0x18, 0x08, 0xe7, 0x83, 
  0x48, 0x38, 0xff, 0x6c, 0x57, 0xc7, 0xe2, 0x4c, 0x39, 0x60, 0xe0, 0x94, 
  0x6b, 0x40, 0x70, 0x2a, 0x3a, 0x5a, 0x55, 0x32, 0xcb, 0x92, 0x4a, 0x83, 
  0xff, 0xa2, 0xe7, 0xa7, 0x67, 0x97, 0x2f, 0xee, 0xe2, 0x16, 0xb0, 0x05, 
  0xfc, 0x47, 0xb9, 0xe5, 0xd6, 0xbb, 0xe8, 0x4a, 0x79, 0xd9, 0xc7, 0x65, 
  0x70, 0x30, 0xb4, 0x21, 0x72, 0x74, 0x03, 0xcc, 0xf1, 0xd9, 0x6d, 0x59, 
  0x2d, 0x2f, 0x2f, 0xbf, 0x3f, 0x3b, 0x7c, 0xf1, 0x9c, 0xeb, 0x46, 0x7d, 
  0x21, 0xa5, 0xdb, 0xa0, 0x31, 0x6b, 0x19, 0x29, 0x41, 0x15, 0x69, 0xbe, 
  0xf3, 0xdd, 0xcb, 0xa3, 0x8b, 0xb3, 0xe3, 0xd3, 0x83, 0x17, 0xcf, 0xbf, 
  0x33, 0x48, 0xaa, 0xe0, 0x5d, 0xf7, 0x99, 0x4b, 0x9d, 0x68, 0xe7, 0x08, 
  0x1c, 0x7e, 0xfb, 0xee, 0xf0, 0xe4, 0x9b, 0x17, 0xcf, 0xef, 0xe2, 0x62, 
  0xc0, 0x53, 0xd6, 0xa2, 0x71, 0x59, 0x67, 0xf8, 0x6b, 0xb0, 0x6a, 0x97, 
  0x0c, 0xad, 0x07, 0xa0, 0xdd, 0x07, 0xd4, 0x60, 0x61, 0x7c, 0x2e, 0xe4, 
  0xde, 0x4c, 0x2d, 0x1e, 0x65, 0x2d, 0x94, 0x21, 0x84, 0x29, 0xb4, 0x9c, 
  0x12, 0x10, 0x51, 0xde, 0x9e, 0x1f, 0x1b, 0x4b, 0x2f, 0x34, 0x89, 0x21, 
  0xf0, 0x51, 0xaa, 0x03, 0xfd, 0x01, 0x8b, 0x35, 0x37, 0x30, 0x08, 0xab, 
  0xaf, 0x46, 0x56, 0xb0, 0x10, 0xa7, 0xab, 0xee, 0x33, 0x1d, 0x75, 0xe4, 
  0x51, 0xf8, 0x38, 0x7f, 0x40, 0x14, 0x30, 0x9b, 0x8e, 0x79, 0x62, 0x29, 
  0x3c, 0x65, 0xd1, 0xb6, 0x1c, 0x29, 0x91, 0x8b, 0xe2, 0x16, 0xa4, 0x80, 
  0x0f, 0xed, 0xd6, 0x2c, 0x39, 0x66, 0xd9, 0x0c, 0xfa, 0x82, 0x59, 0x63, 
  0x54, 0x16, 0xca, 0x61, 0xd3, 0xeb, 0xf2, 0xd3, 0x0a, 0xf8, 0x74, 0x11, 
  0xc4, 0x93, 0x31, 0x38, 0xc2, 0xad, 0x1b, 0x5b, 0xa1, 0x7c, 0x62, 0x7d, 
  0xe6, 0xa8, 0xf1, 0xce, 0x86, 0xf4, 0xe7, 0x0a, 0xd6, 0x21, 0x31, 0xfd, 
  0xd2, 0x4c, 0x0f, 0xad, 0xea, 0x1a, 0xd4, 0x38, 0x7b, 0xa7, 0x68, 0xf0, 
  0x5e, 0x6f, 0x51, 0xb4, 0x65, 0x6f, 0x7c, 0x71, 0x55, 0x1f, 0xda, 0x99, 
  0x76, 0x72, 0x98, 0x9d, 0x73, 0x0e, 0x00, 0x6b, 0xec, 0xe7, 0xe7, 0x7a, 
  0x53, 0x61, 0x9d, 0x89, 0xb3, 0xb7, 0xce, 0xbe, 0xfa, 0x51, 0x77, 0x51, 
  0x43, 0x26, 0xf0, 0x53, 0xea, 0x0d, 0x7b, 0xd1, 0x66, 0xac, 0x46, 0x6a, 
  0x18, 0xbb, 0xb6, 0x9c, 0xad, 0x1e, 0x10, 0x0b, 0x6b, 0xae, 0x0c, 0xa4, 
  0x00, 0x89, 0xdf, 0xb4, 0x13, 0x75, 0xe8, 0x4b, 0x31, 0x75, 0x49, 0x74, 
  0xd0, 0xe7, 0x03, 0xbb, 0x29, 0xaa, 0x46, 0x42, 0x74, 0xc8, 0xab, 0xba, 
  0x44, 0xe2, 0xa6, 0xa2, 0x10, 0xaf, 0xc3, 0x74, 0x0a, 0xb3, 0xa9, 0x3f, 
  0x57, 0x58, 0x39, 0x60, 0x58, 0x18, 0xe2, 0xb2, 0xc7, 0x70, 0x40, 0x1c, 
  0xd5, 0xf0, 0xb2, 0xcb, 0x80, 0x26, 0x19, 0x66, 0x1c, 0xf9, 0xe1, 0xa8, 
  0x35, 0xb4, 0x20, 0x8f, 0xa2, 0x43, 0x7e, 0x60, 0x78, 0x19, 0xfd, 0xbe, 
  0xa3, 0xe4, 0xe6, 0x22, 0x4e, 0x8b, 0x40, 0x3f, 0xbe, 0x57, 0x14, 0x0a, 
  0xdd, 0x7e, 0x31, 0xa4, 0xe6, 0x0a, 0x9c, 0x3e, 0x92, 0x6b, 0xa2, 0x05, 
  0x84, 0xc5, 0xc9, 0x21, 0x2e, 0x80, 0xa8, 0x67, 0x38, 0xd3, 0x3d, 0xd3, 
  0x47, 0xa8, 0x67, 0xc3, 0x4f, 0x19, 0x20, 0xee, 0xb7, 0x95, 0xe0, 0x00, 
  0x3b, 0xb0, 0x1e, 0x44, 0x9e, 0xb6, 0xf6, 0xee, 0x2c, 0x75, 0x9a, 0x95, 
  0x94, 0x23, 0xc4, 0x12, 0x9b, 0xde, 0x51, 0x7a, 0xb4, 0x0e, 0xfb, 0x05, 
  0x94, 0x93, 0x1a, 0xec, 0x75, 0x59, 0xad, 0x66, 0x01, 0xa8, 0x52, 0xbb, 
  0xfe, 0x99, 0xc6, 0xcf, 0x0c, 0x2c, 0xb6, 0xa2, 0x03, 0xa7, 0x42, 0x02, 
  0xea, 0x78, 0x23, 0xf8, 0xdf, 0xde, 0xdf, 0x79, 0x60, 0xbb, 0x03, 0xfe, 
  0x77, 0xef, 0x1f, 0x3d, 0xa8, 0xdc, 0x1e, 0xba, 0x51, 0x26, 0xd1, 0x3e, 
  0xaf, 0xdc, 0xb0, 0xc5, 0xd8, 0x74, 0x84, 0xd4, 0x70, 0x92, 0xd0, 0x9a, 
  0x6e, 0xd1, 0x6b, 0x2f, 0x9d, 0x5f, 0xff, 0xb0, 0x3b, 0xdc, 0xdd, 0xd9, 
  0xd9, 0xf9, 0x71, 0xb4, 0xe0, 0x65, 0x66, 0x9f, 0x23, 0xf5, 0xc9, 0x9e, 
  0xc7, 0x45, 0x3a, 0x61, 0x3d, 0x7f, 0x1e, 0xb7, 0x2a, 0x8c, 0xa4, 0x31, 
  0x20, 0x24, 0x65, 0x50, 0xdb, 0x81, 0xb8, 0xc7, 0x95, 0x3c, 0xd7, 0xf0, 
  0x79, 0x0b, 0xa7, 0x8c, 0x91, 0x1e, 0x14, 0xc9, 0x93, 0x5c, 0xca, 0x19, 
  0x07, 0x09, 0xe6, 0x00, 0x6a, 0x13, 0xd2, 0x53, 0x26, 0xb1, 0xad, 0xcd, 
  0x6e, 0x25, 0x07, 0x09, 0x96, 0x4c, 0x96, 0xc2, 0x91, 0xf7, 0x8b, 0xac, 
  0xa4, 0x44, 0x6a, 0x1a, 0x71, 0x31, 0xed, 0x20, 0xe6, 0x7a, 0xd0, 0xed, 
  0x7c, 0x96, 0x13, 0xab, 0xe1, 0x30, 0x38, 0xb8, 0xe0, 0x09, 0xcc, 0x05, 
  0xe2, 0xd2, 0x63, 0xb2, 0x00, 0x04, 0xa1, 0x1d, 0x59, 0x12, 0x86, 0xf8, 
  0x26, 0xe2, 0xd4, 0x53, 0x79, 0xf1, 0x13, 0xcb, 0xd4, 0xeb, 0x11, 0x01, 
  0x75, 0xd5, 0x87, 0x71, 0x39, 0x49, 0xd3, 0xff, 0x7f, 0xed, 0x9d, 0x4c, 
  0x91, 0x96, 0x2e, 0x6b, 0xc6, 0x27, 0x64, 0x60, 0xea, 0x92, 0x90, 0x31, 
  0x4b, 0xa8, 0x8b, 0x32, 0x12, 0x01, 0xb4, 0x95, 0xf7, 0x92, 0xbc, 0x17, 
  0xb9, 0x01, 0x4e, 0x24, 0x18, 0x9b, 0x6e, 0x38, 0xbc, 0x81, 0xc7, 0xb0, 
  0x7f, 0x71, 0x70, 0x74, 0x54, 0x8b, 0x7c, 0xe2, 0xa5, 0x6c, 0x65, 0xad, 
  0x57, 0x0e, 0x3a, 0xa4, 0x64, 0xf0, 0x66, 0x58, 0x0a, 0x2c, 0xd0, 0x10, 
  0x46, 0x37, 0x64, 0x27, 0x71, 0x20, 0xac, 0x54, 0xc3, 0x6d, 0xad, 0x18, 
  0x5c, 0x6f, 0xcc, 0x94, 0x97, 0x19, 0x4b, 0x11, 0x1c, 0x37, 0x7c, 0xb3, 
  0x24, 0x4e, 0xfc, 0xc9, 0x95, 0x84, 0x07, 0x68, 0x6d, 0xa9, 0x68, 0xc9, 
  0xd1, 0x73, 0xfe, 0xd7, 0x55, 0x78, 0x5d, 0x97, 0x45, 0x2b, 0x99, 0x61, 
  0x41, 0x6e, 0x5a, 0x50, 0x9a, 0xc1, 0xac, 0x99, 0x12, 0xb8, 0xd4, 0xc6, 
  0x54, 0x5c, 0x23, 0x8d, 0x7e, 0xb2, 0x88, 0xab, 0xb7, 0xa6, 0x3e, 0xff, 
  0x9c, 0x09, 0x3e, 0x3c, 0xc3, 0x30, 0xba, 0xf7, 0xbf, 0x3f, 0x41, 0x06, 
  0x6a, 0xea, 0xac, 0x39, 0x7e, 0x51, 0x83, 0x86, 0xb2, 0xf8, 0xd5, 0xba, 
  0x06, 0xec, 0x6b, 0xce, 0xdd, 0xd0, 0x6c, 0x57, 0x5d, 0x4a, 0x70, 0x18, 
  0xe9, 0x10, 0x54, 0x77, 0x60, 0xc1, 0x0d, 0xbe, 0x94, 0x4e, 0x4f, 0x71, 
  0x87, 0x7f, 0x8d, 0x43, 0xff, 0x1c, 0xd8, 0x19, 0x1b, 0x3f, 0xd4, 0x09, 
  0x23, 0xb6, 0x5a, 0xf8, 0xd9, 0xd8, 0xeb, 0xd9, 0x51, 0x2f, 0xa2, 0xc8, 
  0x67, 0x91, 0xd5, 0x65, 0x31, 0x49, 0x12, 0xb7, 0x39, 0xff, 0xa2, 0x2a, 
  0xfe, 0x40, 0x0d, 0x28, 0x1d, 0xb9, 0x53, 0x41, 0xb8, 0xb0, 0x46, 0xfe, 
  0x35, 0x63, 0x2b, 0xdb, 0xe8, 0xdf, 0xc3, 0x3b, 0x09, 0x8d, 0x1e, 0xe7, 
  0xad, 0x7c, 0x98, 0x37, 0x96, 0xe5, 0x25, 0xeb, 0xc9, 0xec, 0x12, 0x79, 
  0x41, 0x91, 0x3e, 0xbe, 0x5d, 0xc5, 0xb3, 0xdb, 0x98, 0x59, 0x27, 0x5b, 
  0x08, 0xb1, 0xb8, 0x2d, 0xf7, 0x1c, 0xec, 0x5f, 0xa2, 0x31, 0x8f, 0x97, 
  0xd7, 0xd7, 0xa8, 0x00, 0x76, 0x9c, 0x32, 0xb6, 0x7d, 0xa9, 0x78, 0xa8, 
  0x62, 0x64, 0xe8, 0x7f, 0xd1, 0x87, 0x34, 0xd4, 0xd4, 0xa3, 0xa5, 0x22, 
  0x04, 0x73, 0x4b, 0xad, 0x80, 0x31, 0x88, 0xfa, 0xcf, 0xf5, 0x51, 0xf9, 
  0x92, 0x71, 0x83, 0x68, 0x08, 0x82, 0x55, 0xda, 0x21, 0x91, 0x39, 0x64, 
  0xc3, 0xe8, 0x26, 0x25, 0xae, 0xc0, 0x18, 0xef, 0xf5, 0xe2, 0x7f, 0x26, 
  0x1a, 0xfa, 0x21, 0x75, 0x45, 0x95, 0xf7, 0x7f, 0x67, 0xbd, 0xc6, 0xd3, 
  0x69, 0xaa, 0x99, 0x6d, 0x7c, 0x63, 0x78, 0x60, 0x4b, 0x1d, 0xe1, 0x03, 
  0x88, 0x66, 0x69, 0x3d, 0xa2, 0x9e, 0xc3, 0xd0, 0x25, 0x84, 0xcd, 0x00, 
  0x3e, 0x0c, 0x94, 0xa0, 0x6d, 0xdf, 0xa6, 0x4d, 0x1d, 0xd4, 0x01, 0x43, 
  0x1c, 0xff, 0x55, 0xb2, 0x53, 0x13, 0x0e, 0x43, 0xde, 0xb4, 0xe7, 0x70, 
  0xd5, 0x5d, 0x59, 0x02, 0x68, 0xa5, 0xaa, 0x5f, 0x79, 0x02, 0xa6, 0x85, 
  0x80, 0xfa, 0x68, 0x29, 0xd2, 0xb8, 0xf7, 0xba, 0xb0, 0x7e, 0x92, 0x0c, 
  0xc1, 0x80, 0x66, 0x0e, 0x19, 0x38, 0x27, 0xae, 0xca, 0x9e, 0x26, 0x50, 
  0x31, 0xb6, 0x89, 0xde, 0xf2, 0x4d, 0x79, 0x19, 0x97, 0xfe, 0xa7, 0x2f, 
  0x3d, 0xa8, 0x24, 0x1b, 0xd0, 0x7d, 0x90, 0x12, 0xd0, 0x4e, 0x92, 0x12, 
  0xdc, 0xeb, 0x5a, 0x06, 0x9c, 0xda, 0x7a, 0x54, 0xfc, 0xb4, 0x92, 0xa6, 
  0xea, 0xa1, 0x68, 0x02, 0x20, 0x68, 0xaa, 0x41, 0x0a, 0x2d, 0xba, 0xec, 
  0x84, 0x1d, 0x13, 0xc7, 0xa2, 0x00, 0xf7, 0x79, 0x88, 0xfa, 0x44, 0x24, 
  0x1c, 0x97, 0x85, 0x66, 0xc5, 0x06, 0x9b, 0x91, 0x2f, 0xe6, 0x19, 0x51, 
  0x81, 0x07, 0xe9, 0x7d, 0x8f, 0x0a, 0x29, 0x08, 0xb4, 0xd2, 0x4c, 0x89, 
  0x14, 0xd1, 0xe7, 0xd9, 0xad, 0xda, 0xc7, 0x3b, 0xa4, 0x91, 0xe4, 0x7d, 
  0x32, 0x59, 0x56, 0x6b, 0xcb, 0xfe, 0xea, 0xe2, 0x62, 0x8c, 0x9b, 0x38, 
  0x1c, 0xa5, 0x85, 0x5f, 0xf6, 0xce, 0x2c, 0x6a, 0xf4, 0x59, 0x6f, 0x2b, 
  0x12, 0xe1, 0xa2, 0x03, 0x13, 0x38, 0x88, 0x2d, 0x65, 0xfa, 0xb7, 0x51, 
  0x1b, 0xf0, 0x0f, 0x9f, 0x01, 0xcd, 0xd3, 0xe8, 0xea, 0x9f, 0xf6, 0xbe, 
  0x68, 0x74, 0x8f, 0xde, 0x7b, 0xaf, 0xc4, 0x83, 0x87, 0xbe, 0x45, 0xae, 
  0x21, 0x7e, 0xdd, 0x8a, 0x12, 0xe6, 0xc8, 0x15, 0x73, 0xf6, 0x95, 0x5d, 
  0x7d, 0xe7, 0x57, 0x08, 0xd3, 0x88, 0xf6, 0xcd, 0xf3, 0xd3, 0x3c, 0x34, 
  0xf6, 0xae, 0x6e, 0xd0, 0xb3, 0x76, 0xbc, 0xdb, 0xdd, 0x67, 0x91, 0xaf, 
  0xeb, 0xc4, 0x7c, 0x19, 0x1f, 0x69, 0xf1, 0xb2, 0x0e, 0x70, 0x19, 0x40, 
  0xca, 0x46, 0xd1, 0xd7, 0xfc, 0xc3, 0xd2, 0xd7, 0xd3, 0xf2, 0x01, 0x74, 
  0x5b, 0x24, 0xb3, 0x48, 0xa4, 0xeb, 0x05, 0x36, 0xfb, 0x15, 0x7e, 0x79, 
  0x10, 0x11, 0x97, 0xa6, 0xfa, 0x13, 0xe7, 0x5f, 0x5b, 0x61, 0x66, 0x3e, 
  0xa0, 0x9c, 0x6c, 0x5e, 0x28, 0xa0, 0xb7, 0x84, 0xb6, 0x58, 0xf5, 0x3b, 
  0xe8, 0x93, 0xdd, 0xbe, 0x5e, 0x36, 0xe3, 0x0b, 0x87, 0x7a, 0x70, 0x8c, 
  0x92, 0x5f, 0xd6, 0x0c, 0xe3, 0x36, 0xfc, 0xf1, 0xb5, 0xaf, 0xd5, 0x32, 
  0x6f, 0xbb, 0x07, 0xe0, 0x13, 0x73, 0x7f, 0x46, 0xbb, 0x2f, 0xf9, 0xaa, 
  0xd1, 0x2b, 0x79, 0xa2, 0xa1, 0xa6, 0x25, 0x50, 0x06, 0x85, 0x02, 0x90, 
  0x39, 0x64, 0x84, 0x8c, 0x87, 0x47, 0xdd, 0xbd, 0x8b, 0x69, 0xcf, 0x6a, 
  0xee, 0x49, 0xed, 0x5f, 0xf6, 0xe2, 0x80, 0x95, 0xdd, 0x9a, 0xba, 0x31, 
  0xa7, 0xeb, 0xb5, 0x95, 0xbf, 0xe6, 0xdc, 0xae, 0x7a, 0xeb, 0x49, 0x5d, 
  0xbe, 0x57, 0x6a, 0xd8, 0x1a, 0x4e, 0x19, 0x75, 0x97, 0xcd, 0x49, 0xe2, 
  0x09, 0x6e, 0x55, 0xb6, 0xdf, 0x2f, 0x57, 0xd9, 0xe4, 0xe6, 0xe5, 0xc9, 
  0xc5, 0x03, 0x03, 0x0b, 0xa6, 0x86, 0xa7, 0x8b, 0x3c, 0x63, 0xff, 0x0a, 
  0xae, 0x79, 0xda, 0xda, 0x7c, 0x76, 0xd7, 0xc1, 0x79, 0x2e, 0xce, 0x4e, 
  0x0e, 0x5f, 0x9f, 0xda, 0x8f, 0x7f, 0x69, 0x79, 0x8f, 0x19, 0xac, 0xa4, 
  0xc3, 0x99, 0xd1, 0x1a, 0x9b, 0xb3, 0x82, 0x78, 0xe3, 0x28, 0x51, 0x1e, 
  0xb0, 0x4e, 0x84, 0xe8, 0x06, 0xdd, 0x2d, 0x88, 0x81, 0x23, 0xc4, 0x98, 
  0xd9, 0x7b, 0xfd, 0x65, 0xc0, 0xb9, 0xef, 0x89, 0x73, 0xc3, 0xdd, 0xc2, 
  0xc2, 0x0e, 0x29, 0x8c, 0x60, 0xd1, 0x5f, 0xb4, 0x88, 0xe0, 0x0a, 0x77, 
  0xba, 0xd9, 0x70, 0xcc, 0x4a, 0x6c, 0xc1, 0x64, 0x00, 0x5f, 0x40, 0x69, 
  0x2d, 0x70, 0xd0, 0x72, 0xd9, 0x32, 0x26, 0x6a, 0xac, 0x59, 0x00, 0x6a, 
  0xa2, 0x25, 0xe8, 0xd1, 0x9f, 0x78, 0x67, 0x34, 0xe1, 0x48, 0x83, 0x10, 
  0x56, 0x6b, 0x4a, 0x80, 0x89, 0x0f, 0x07, 0xa8, 0x43, 0xf3, 0xf4, 0xbd, 
  0xb9, 0x2b, 0x83, 0xba, 0x43, 0x60, 0xf3, 0x6c, 0x80, 0xee, 0x74, 0xfc, 
  0x6a, 0xaa, 0xa6, 0xf6, 0xa5, 0xd1, 0x5b, 0xde, 0xc0, 0x4c, 0x9a, 0x67, 
  0x4f, 0xbe, 0xeb, 0x0d, 0xba, 0x4b, 0x44, 0x88, 0x22, 0x26, 0x31, 0x45, 
  0x12, 0x7b, 0x34, 0x59, 0xb2, 0x46, 0xa9, 0xce, 0x26, 0x20, 0xbb, 0x04, 
  0xf8, 0xa8, 0x4d, 0x8c, 0xfb, 0x3f, 0x9b, 0x62, 0xdb, 0x8b, 0xbc, 0x0d, 
  0x0c, 0xe5, 0xeb, 0x5c, 0x16, 0x07, 0x7a, 0xa8, 0xdc, 0xe2, 0x74, 0xd5, 
  0x7b, 0x94, 0xa2, 0x7c, 0x10, 0x7f, 0x90, 0xd1, 0xd3, 0xfb, 0xf3, 0xb0, 
  0xd7, 0xc9, 0xf5, 0x7d, 0xea, 0x14, 0x73, 0x28, 0x16, 0xfd, 0x6a, 0xf5, 
  0x5e, 0x6c, 0xfd, 0xad, 0xba, 0x51, 0x33, 0x92, 0x6f, 0x39, 0x26, 0xe9, 
  0xa5, 0x5a, 0x56, 0x96, 0x82, 0x56, 0xa1, 0xc9, 0xd9, 0x12, 0x52, 0x08, 
  0xf6, 0x00, 0xbb, 0x25, 0x23, 0x67, 0xd1, 0xa7, 0x85, 0x95, 0x9c, 0x56, 
  0x70, 0x40, 0x5a, 0x29, 0x66, 0x8e, 0xc2, 0x9e, 0xe5, 0xf7, 0x40, 0x78, 
  0x0f, 0x06, 0x27, 0xc5, 0xd5, 0xd6, 0x9b, 0xe3, 0x61, 0x37, 0xfb, 0xcd, 
  0xdf, 0xed, 0x85, 0x77, 0xbc, 0x80, 0xff, 0x88, 0x34, 0x34, 0xd4, 0xaa, 
  0x66, 0x9b, 0x24, 0xfa, 0x9b, 0x36, 0x0a, 0x8e, 0x14, 0x8d, 0x94, 0xb5, 
  0x42, 0x3c, 0xa3, 0x34, 0xf8, 0x9b, 0x91, 0xbb, 0x6e, 0x5c, 0x23, 0x0c, 
  0x3d, 0xf7, 0xcf, 0xd6, 0x1d, 0xc0, 0x36, 0x52, 0x1f, 0x5a, 0xfa, 0x17, 
  0x52, 0x1c, 0x88, 0xea, 0x39, 0xb3, 0x99, 0x9d, 0x58, 0x21, 0xc0, 0xd2, 
  0x5f, 0x44, 0x01, 0x8c, 0x5b, 0x70, 0x6d, 0x63, 0xc1, 0x33, 0xd6, 0xa7, 
  0xaa, 0x07, 0xc0, 0x97, 0x7e, 0x63, 0xc1, 0xd1, 0xe2, 0x58, 0x8e, 0x5c, 
  0x41, 0xb0, 0xc8, 0x7d, 0xde, 0x29, 0xd8, 0x02, 0x60, 0x67, 0x18, 0xb8, 
  0x61, 0x06, 0xa6, 0xfe, 0xb0, 0xf4, 0x10, 0xe6, 0x49, 0xd2, 0x09, 0xf9, 
  0xcd, 0x9a, 0x72, 0xf3, 0xd3, 0x7c, 0xc9, 0x71, 0x3c, 0xa2, 0xc4, 0xb5, 
  0x4a, 0x04, 0xb7, 0x61, 0x49, 0x5c, 0x9c, 0x87, 0xdf, 0x4c, 0xa0, 0x99, 
  0x6a, 0xcc, 0x12, 0x9c, 0xa4, 0x5d, 0xa0, 0xbc, 0xef, 0x24, 0x19, 0x1d, 
  0xb2, 0xf0, 0xa5, 0xa6, 0x17, 0x4a, 0xdc, 0x10, 0x1b, 0x7f, 0x24, 0xc3, 
  0x10, 0x3a, 0x6d, 0x77, 0xed, 0xd6, 0xa8, 0xed, 0x9a, 0x57, 0x8d, 0x94, 
  0xf5, 0x0a, 0x1a, 0xb5, 0xc7, 0xc5, 0xed, 0xc3, 0x69, 0x32, 0x9b, 0x3e, 
  0xdc, 0x82, 0x1d, 0x3e, 0x49, 0xb9, 0x74, 0xfe, 0xaf, 0x67, 0xed, 0x62, 
  0x4b, 0x66, 0x14, 0xaa, 0xaa, 0xc5, 0x3b, 0x20, 0x69, 0xb9, 0xc3, 0x46, 
  0x0c, 0x28, 0x29, 0x38, 0x23, 0x4f, 0x10, 0xb6, 0xfc, 0x74, 0xf2, 0x25, 
  0xe2, 0xbe, 0x1f, 0x1e, 0x81, 0x53, 0xe2, 0x0b, 0x0d, 0x78, 0x14, 0x00, 
  0xaa, 0xcd, 0x8b, 0x2d, 0xad, 0xbd, 0xd6, 0xe1, 0x10, 0x78, 0x57, 0xe5, 
  0x55, 0x3c, 0xf3, 0x32, 0x1e, 0xfe, 0xe2, 0x2f, 0x06, 0x01, 0xe4, 0xd4, 
  0x60, 0x1d, 0x22, 0x5d, 0xf3, 0xaa, 0x60, 0x61, 0xd9, 0xbb, 0x65, 0x78, 
  0x2c, 0x56, 0x8c, 0x0f, 0xb1, 0x34, 0x1d, 0x1e, 0x9e, 0x56, 0x42, 0x41, 
  0x64, 0x77, 0x83, 0x31, 0xe6, 0x39, 0xbd, 0x94, 0xaa, 0xec, 0xcb, 0x17, 
  0xe9, 0x3f, 0x1f, 0x6e, 0x61, 0xb6, 0xec, 0x24, 0x33, 0xcc, 0x95, 0x0f, 
  0x3d, 0x2b, 0x64, 0xcb, 0xc5, 0xc3, 0x6d, 0xd8, 0x80, 0xeb, 0x6b, 0x90, 
  0x22, 0x26, 0x3f, 0xbf, 0x15, 0x0e, 0xfa, 0xe1, 0xad, 0x50, 0x60, 0x35, 
  0xb6, 0xb7, 0xa5, 0x33, 0x5f, 0xca, 0x55, 0x84, 0x81, 0xb6, 0x4e, 0xd8, 
  0xf8, 0x8f, 0xb7, 0xdd, 0xdd, 0x8a, 0xdd, 0xd3, 0xb1, 0xcc, 0x95, 0x4f, 
  0x37, 0xe0, 0x7a, 0xa2, 0xce, 0xc3, 0x2d, 0x58, 0x68, 0x3d, 0x12, 0x40, 
  0xa2, 0x4d, 0xf6, 0xfe, 0x48, 0x0e, 0x9c, 0x66, 0x88, 0x77, 0x44, 0xab, 
  0x37, 0xfe, 0x7b, 0x68, 0xae, 0x5c, 0x78, 0x53, 0xe5, 0x96, 0x0f, 0xef, 
  0x9d, 0xae, 0x45, 0x73, 0x31, 0xb0, 0x16, 0x1f, 0xb7, 0x14, 0xb2, 0x12, 
  0x7e, 0x21, 0xc4, 0x5d, 0xec, 0x43, 0xe8, 0x1f, 0x6e, 0x01, 0x77, 0x85, 
  0x69, 0xa8, 0x88, 0x56, 0x27, 0xa1, 0xd3, 0xe0, 0x4f, 0x54, 0xbb, 0x7c, 
  0xb8, 0x05, 0xd1, 0xd6, 0x92, 0xa1, 0xeb, 0xd2, 0xe7, 0x03, 0x00, 0xbd, 
  0x87, 0x24, 0xc5, 0x0f, 0x2c, 0x26, 0x0b, 0x92, 0x1a, 0x35, 0x00, 0x93, 
  0x8b, 0xbf, 0x1f, 0x59, 0x0f, 0xfb, 0x98, 0x0d, 0x0d, 0x44, 0x13, 0x53, 
  0x1c, 0xc5, 0xf8, 0x76, 0xc7, 0xc2, 0xec, 0x9a, 0x7d, 0xc2, 0xc2, 0x7d, 
  0xfc, 0x4e, 0xfd, 0xa7, 0x89, 0x36, 0x08, 0x97, 0x46, 0xa0, 0xf7, 0x47, 
  0xed, 0x94, 0x86, 0x8d, 0x68, 0xb5, 0x1e, 0x1b, 0x3c, 0x80, 0xc3, 0x3f, 
  0xe2, 0xe2, 0x30, 0x6b, 0x41, 0x8b, 0x4e, 0x45, 0x3c, 0x63, 0x17, 0xe4, 
  0x87, 0x67, 0x01, 0xf6, 0x18, 0xc4, 0xe4, 0x32, 0x52, 0x7e, 0x29, 0x09, 
  0xdd, 0xf1, 0xac, 0x1d, 0x64, 0xd2, 0xe4, 0x79, 0x71, 0x65, 0x09, 0xd7, 
  0x25, 0xd7, 0x06, 0xda, 0x68, 0xa1, 0x93, 0xfd, 0x94, 0xbc, 0xb3, 0x68, 
  0x57, 0x3b, 0x22, 0xe0, 0xf4, 0x3e, 0xbb, 0x42, 0xe2, 0x9a, 0xe5, 0xc6, 
  0x49, 0x8a, 0x0f, 0x90, 0x86, 0xb5, 0xd5, 0x41, 0x05, 0xe8, 0x4b, 0x9d, 
  0xa4, 0xb5, 0x4b, 0xa5, 0xb3, 0xab, 0x8f, 0xe8, 0x4b, 0xda, 0x5a, 0xd7, 
  0x93, 0x55, 0xd7, 0xac, 0xcd, 0xca, 0xfa, 0x82, 0x20, 0x2f, 0xbd, 0x89, 
  0x6b, 0xe5, 0x63, 0x67, 0xb5, 0xf6, 0xce, 0x46, 0x9f, 0x2e, 0xa3, 0xf5, 
  0x3f, 0x30, 0xbb, 0x50, 0xa2, 0x86, 0x6a, 0xbf, 0xae, 0xe6, 0x2b, 0x30, 
  0xd2, 0xfd, 0x26, 0x72, 0xcf, 0x31, 0x9b, 0xf0, 0x83, 0x38, 0x66, 0x45, 
  0xcd, 0x77, 0x02, 0xf5, 0xc3, 0x3d, 0x3b, 0x64, 0x7d, 0xcb, 0x4b, 0xb7, 
  0xdb, 0x26, 0xc0, 0x1c, 0xed, 0x1e, 0x84, 0xdb, 0x5d, 0x2c, 0xb9, 0x8d, 
  0xc2, 0x3c, 0xe3, 0xff, 0xa1, 0x41, 0x48, 0x6b, 0xad, 0x11, 0x28, 0x6a, 
  0xf9, 0x3b, 0x94, 0x49, 0x92, 0x11, 0xd4, 0x6a, 0x75, 0xfb, 0x08, 0x6c, 
  0x07, 0x91, 0xfa, 0xa1, 0x4d, 0xb7, 0x9a, 0x92, 0xc0, 0x4b, 0x96, 0x78, 
  0x18, 0xbe, 0xb0, 0x48, 0x21, 0x34, 0xd7, 0xd5, 0x87, 0x38, 0x00, 0xfc, 
  0x5a, 0x4f, 0xb6, 0x3e, 0x5d, 0xc4, 0xb6, 0x8b, 0xc5, 0x8c, 0x9e, 0xe3, 
  0xc7, 0x07, 0xa2, 0x54, 0xbd, 0x36, 0x6a, 0x29, 0xe5, 0xcd, 0xf8, 0x54, 
  0xc3, 0x01, 0x29, 0xc3, 0x98, 0xfc, 0x46, 0x46, 0xc2, 0x54, 0x63, 0x1c, 
  0x5d, 0x64, 0x6a, 0x3d, 0x30, 0xf5, 0x01, 0x97, 0x4b, 0x10, 0x6f, 0x9a, 
  0xbc, 0x37, 0xdc, 0xfb, 0x30, 0xba, 0x6b, 0xbd, 0x76, 0xed, 0x42, 0xba, 
  0x39, 0x26, 0x4c, 0xd3, 0xa7, 0x35, 0x48, 0xc8, 0x82, 0xb1, 0xfa, 0x2e, 
  0x58, 0xac, 0x15, 0x7b, 0xd7, 0xc4, 0x4e, 0x2c, 0x5d, 0x01, 0x62, 0x8d, 
  0x64, 0x75, 0xe5, 0xc2, 0x49, 0x0f, 0xc7, 0x47, 0xed, 0xac, 0xf8, 0x1e, 
  0xf2, 0x51, 0x6d, 0x0a, 0x5d, 0x05, 0x88, 0xe0, 0x41, 0x90, 0x71, 0xc6, 
  0xa1, 0xc0, 0xab, 0xa7, 0x9e, 0x6f, 0x5a, 0xad, 0x4f, 0xc7, 0x11, 0x47, 
  0x70, 0x4a, 0x76, 0x95, 0xbe, 0x96, 0xd9, 0x49, 0x50, 0x15, 0x5f, 0x19, 
  0x9c, 0xf4, 0x91, 0xb1, 0x02, 0x22, 0xe9, 0x57, 0xf4, 0x5e, 0x25, 0xe9, 
  0x54, 0xfc, 0x74, 0xa7, 0x3f, 0x18, 0x0e, 0x10, 0x39, 0x69, 0xf4, 0x30, 
  0x6c, 0x1b, 0x7a, 0x51, 0xfb, 0x9b, 0xde, 0x8f, 0xae, 0x19, 0x5b, 0x05, 
  0x87, 0x85, 0xe6, 0x65, 0xba, 0x68, 0xfb, 0x3a, 0x48, 0x1b, 0x4e, 0x24, 
  0x63, 0x57, 0xa4, 0x57, 0xeb, 0xb0, 0x66, 0x34, 0xb9, 0xde, 0x41, 0x11, 
  0x04, 0x49, 0xfc, 0x03, 0xc0, 0x0a, 0x4e, 0xad, 0x60, 0x6f, 0x97, 0x8f, 
  0xac, 0x81, 0xb4, 0xf0, 0x00, 0x42, 0xeb, 0xa7, 0x71, 0x62, 0x7e, 0x07, 
  0x87, 0x9c, 0xb0, 0xf3, 0xe7, 0x2a, 0x63, 0xad, 0xa9, 0x72, 0xad, 0x7e, 
  0x4d, 0x80, 0xfe, 0x5b, 0x71, 0x69, 0x7b, 0x35, 0x2c, 0x7a, 0xdd, 0x95, 
  0x95, 0xb9, 0xcc, 0x52, 0x45, 0xc9, 0xb0, 0x85, 0x30, 0xb4, 0x04, 0x4b, 
  0x22, 0x53, 0x66, 0xba, 0xae, 0xda, 0xba, 0xbb, 0x72, 0x5c, 0x15, 0x69, 
  0xad, 0x42, 0x5e, 0xab, 0x98, 0xee, 0x0a, 0x2d, 0xbc, 0x3e, 0xbc, 0x6c, 
  0x57, 0x56, 0x56, 0x9b, 0x10, 0xfa, 0xe5, 0xc4, 0x1c, 0x47, 0x23, 0xea, 
  0x51, 0x41, 0xc0, 0x96, 0x85, 0xd2, 0x76, 0xa4, 0x6d, 0x71, 0x35, 0xc6, 
  0x38, 0x8b, 0xbb, 0xeb, 0x15, 0x6b, 0x02, 0x6e, 0x7b, 0x89, 0x38, 0xdd, 
  0x26, 0xc8, 0xc2, 0xe5, 0x65, 0xd2, 0x51, 0xb7, 0x93, 0x5f, 0x8f, 0x8f, 
  0x2e, 0x2e, 0x65, 0x11, 0x51, 0x1c, 0x5a, 0xa4, 0x6e, 0x46, 0x3a, 0x28, 
  0x3d, 0x80, 0xc1, 0x2f, 0x46, 0x1a, 0x2b, 0x57, 0x3e, 0x45, 0x50, 0x9a, 
  0xf9, 0xdf, 0x2f, 0x3a, 0xa2, 0x72, 0x62, 0x7f, 0xff, 0xb2, 0xa1, 0x96, 
  0xe1, 0x96, 0xd4, 0x4e, 0x1a, 0x96, 0x35, 0x11, 0xa9, 0x60, 0xd1, 0x92, 
  0x89, 0x55, 0xb1, 0x9d, 0x2e, 0x0b, 0x5f, 0x10, 0xd8, 0xba, 0xe4, 0xc7, 
  0xd3, 0x7c, 0x6a, 0xd0, 0xdd, 0xd6, 0x4d, 0xdb, 0xa4, 0x58, 0x46, 0x2e, 
  0xd3, 0x54, 0xc6, 0x14, 0x34, 0x52, 0x03, 0xcb, 0xb1, 0x7c, 0xf7, 0x8e, 
  0x5b, 0x5d, 0xc7, 0x69, 0x8b, 0xb1, 0x6b, 0x25, 0x20, 0x99, 0x53, 0x4a, 
  0x3e, 0xc7, 0xea, 0xe1, 0x34, 0x56, 0x71, 0x98, 0x87, 0xe6, 0x65, 0x4d, 
  0x75, 0x5e, 0xba, 0x6a, 0x99, 0xed, 0xbb, 0x26, 0xd6, 0x8a, 0xa9, 0xbc, 
  0x6c, 0xa6, 0x6d, 0x96, 0x62, 0x9d, 0xb7, 0x8d, 0x4d, 0xa5, 0x00, 0x16, 
  0xc0, 0xb6, 0x3b, 0xb0, 0x63, 0x88, 0x2d, 0xd1, 0xdc, 0x8a, 0x95, 0x01, 
  0x23, 0x29, 0x02, 0xf4, 0x87, 0x21, 0x9f, 0x3f, 0x0d, 0xd5, 0x34, 0x8b, 
  0xee, 0x74, 0xd7, 0x73, 0x12, 0xba, 0x59, 0x4b, 0x38, 0x18, 0x5a, 0x50, 
  0x08, 0x69, 0xd0, 0x36, 0xfd, 0x38, 0x7a, 0x8a, 0xac, 0x1e, 0x12, 0x62, 
  0x60, 0x02, 0xe2, 0x31, 0xb8, 0x70, 0x29, 0x35, 0x94, 0xb4, 0x2a, 0x48, 
  0x38, 0x8a, 0xa9, 0x13, 0x8b, 0xdf, 0xef, 0xef, 0x25, 0x41, 0x8b, 0xd3, 
  0x1e, 0x99, 0xff, 0x77, 0x08, 0x0a, 0xc9, 0x2f, 0x58, 0x9c, 0xef, 0x27, 
  0x8e, 0x99, 0xa7, 0xb7, 0x87, 0x38, 0x2f, 0xcf, 0xb9, 0x48, 0x38, 0x73, 
  0x24, 0x75, 0xa2, 0xad, 0xe1, 0xd9, 0xe7, 0x9e, 0x3f, 0xb3, 0xe5, 0xdd, 
  0x30, 0xf6, 0x51, 0xe0, 0x9d, 0x81, 0x4b, 0x13, 0x5a, 0x61, 0x29, 0x94, 
  0xdc, 0xe2, 0xb8, 0x88, 0x76, 0xb5, 0xed, 0xb0, 0x58, 0x33, 0x2c, 0x12, 
  0xaf, 0x0a, 0x77, 0x3f, 0x60, 0x13, 0x36, 0x5f, 0x6e, 0xd6, 0x5e, 0xcb, 
  0x16, 0x1a, 0xb4, 0x6e, 0xa9, 0xea, 0x62, 0x48, 0x4b, 0xe7, 0x89, 0xcb, 
  0xa3, 0x0e, 0xa7, 0xd1, 0x71, 0xc1, 0x8e, 0xc5, 0xf8, 0x5a, 0xc2, 0x75, 
  0x43, 0x3c, 0x12, 0x6f, 0x88, 0x83, 0x01, 0xd5, 0xbe, 0x59, 0x68, 0xe5, 
  0x1d, 0xd6, 0xe8, 0x80, 0x16, 0x1e, 0x00, 0xaa, 0x60, 0x23, 0xee, 0x05, 
  0x38, 0x23, 0x1c, 0x27, 0x41, 0x63, 0x56, 0x83, 0x08, 0x9c, 0xd2, 0xba, 
  0x38, 0xa6, 0x86, 0x76, 0x79, 0x0b, 0xc2, 0xc8, 0x64, 0x8d, 0xe8, 0x16, 
  0x1e, 0xfe, 0x2b, 0x24, 0x6d, 0xf0, 0xab, 0xaf, 0x4f, 0xde, 0x62, 0x6c, 
  0x9b, 0xbb, 0x1d, 0xf8, 0xdc, 0x92, 0xc2, 0x41, 0xbd, 0xe0, 0x89, 0x47, 
  0x5b, 0x00, 0x2a, 0x88, 0xb4, 0x5a, 0x0a, 0xe2, 0x51, 0x1e, 0x5c, 0x07, 
  0xbd, 0x94, 0xda, 0xee, 0x33, 0xa8, 0xfe, 0x55, 0x7b, 0x1d, 0x0d, 0x43, 
  0x0a, 0x58, 0x03, 0x9b, 0xc3, 0x2d, 0x71, 0x92, 0x70, 0xfc, 0x5c, 0x33, 
  0xb4, 0xb6, 0x0a, 0xee, 0x56, 0x5c, 0x80, 0xbe, 0x4c, 0xb7, 0x06, 0x89, 
  0xd0, 0x2a, 0xcf, 0xa6, 0x01, 0x29, 0x74, 0xd6, 0x9d, 0xe6, 0xfe, 0xb7, 
  0xc5, 0x98, 0xa1, 0x3c, 0xd6, 0xd9, 0xde, 0x5d, 0x73, 0x2e, 0xf6, 0xa5, 
  0x85, 0x90, 0x7f, 0x1f, 0x52, 0x9a, 0x17, 0xde, 0x5d, 0xa3, 0xbf, 0x5c, 
  0x86, 0xd5, 0xff, 0xd6, 0xc2, 0x04, 0x48, 0x2f, 0x2a, 0xa3, 0xe7, 0xa4, 
  0x27, 0xb4, 0xc2, 0xbb, 0x92, 0x2a, 0xa8, 0x64, 0xe1, 0x7c, 0x66, 0x50, 
  0xbc, 0x7c, 0x5a, 0x52, 0x9e, 0x0d, 0x1d, 0xde, 0x62, 0x47, 0x28, 0x02, 
  0x63, 0x12, 0xca, 0x5d, 0x55, 0xab, 0xa2, 0x12, 0xde, 0x56, 0x35, 0x84, 
  0x84, 0x35, 0xc5, 0x2b, 0x51, 0xda, 0x17, 0xa5, 0x0b, 0xc4, 0xfc, 0x0e, 
  0x62, 0x75, 0xfd, 0x86, 0xa3, 0x29, 0xdb, 0xa5, 0xa2, 0x89, 0x03, 0x92, 
  0xee, 0x39, 0x5d, 0xce, 0x7b, 0xbf, 0xdc, 0xfa, 0xee, 0x70, 0x49, 0xa1, 
  0xaa, 0x5a, 0xec, 0x8e, 0x76, 0xba, 0x39, 0xd6, 0x2b, 0xa9, 0xf8, 0x65, 
  0xce, 0x84, 0x94, 0x54, 0x2f, 0xd6, 0x41, 0x4a, 0xa3, 0xd2, 0x52, 0x5d, 
  0x2a, 0xfc, 0x74, 0x33, 0xe3, 0x7c, 0xb4, 0x13, 0x0a, 0x84, 0x86, 0xfb, 
  0x55, 0xba, 0x83, 0x8f, 0x0c, 0x90, 0x84, 0xae, 0x66, 0x5a, 0x97, 0x67, 
  0xdd, 0x2d, 0xec, 0x06, 0x63, 0xdd, 0x65, 0x8e, 0x3b, 0x2b, 0xef, 0x76, 
  0xd7, 0x20, 0x4d, 0x34, 0x86, 0xca, 0x92, 0xdd, 0xe5, 0xc5, 0xb1, 0x0b, 
  0x96, 0xd9, 0x15, 0x49, 0xae, 0xcb, 0x54, 0x09, 0xdb, 0xa4, 0x83, 0xc3, 
  0x36, 0xcb, 0xf1, 0xe5, 0xf1, 0x85, 0x43, 0x56, 0x71, 0x83, 0xd8, 0xe3, 
  0xfb, 0xb4, 0x9c, 0xdd, 0xed, 0x7d, 0xfc, 0x20, 0x2e, 0x82, 0x41, 0xec, 
  0xfd, 0xdc, 0x41, 0xf0, 0xcb, 0xad, 0x41, 0x3c, 0xd2, 0x41, 0x3c, 0xfa, 
  0xd7, 0x06, 0xf1, 0xe8, 0x3f, 0x32, 0x88, 0xc7, 0x1c, 0x6c, 0xb6, 0xb8, 
  0x7b, 0xdc, 0x41, 0xaa, 0x2e, 0xfc, 0x88, 0x59, 0x0e, 0xf2, 0xff, 0x04, 
  0xcf, 0xdf, 0xb9, 0x1a, 0x00, 0x8a, 0xa3, 0x08, 0x52, 0x2d, 0x9f, 0xb4, 
  0x4b, 0x65, 0x60, 0xac, 0x27, 0x1b, 0x74, 0x19, 0x14, 0xea, 0x51, 0x5e, 
  0x66, 0x37, 0x4d, 0x47, 0xda, 0xe3, 0xe2, 0xee, 0xb3, 0xa1, 0xf6, 0xbb, 
  0x55, 0x3f, 0xbb, 0x82, 0xff, 0x65, 0x03, 0x84, 0x6f, 0x1a, 0xb1, 0x10, 
  0x4d, 0x1e, 0x18, 0xcf, 0xe5, 0x26, 0x3a, 0x3a, 0xbb, 0x7b, 0x6c, 0x43, 
  0x4d, 0x24, 0x1c, 0xa3, 0x85, 0x8d, 0xfb, 0x79, 0x10, 0x41, 0xfc, 0x99, 
  0xac, 0xca, 0x67, 0xed, 0x55, 0xb1, 0x3e, 0x39, 0xfe, 0xa1, 0x6b, 0x49, 
  0x00, 0xe1, 0x67, 0x8b, 0xf2, 0xd0, 0xaa, 0x7c, 0xe4, 0xb2, 0x7c, 0xe2, 
  0x55, 0xf9, 0xec, 0xe7, 0xac, 0xca, 0xaf, 0x45, 0xad, 0x46, 0x62, 0xf9, 
  0x70, 0x1c, 0x17, 0x1d, 0xa1, 0xa4, 0x3e, 0x75, 0xc3, 0x62, 0x31, 0x82, 
  0x54, 0xf4, 0x7a, 0xa4, 0x5d, 0xd9, 0x2e, 0x05, 0xe1, 0x1e, 0xa5, 0xc6, 
  0x9b, 0x5a, 0xa8, 0x5d, 0x80, 0xa4, 0x8d, 0x56, 0x6c, 0xfc, 0x99, 0x7c, 
  0xca, 0x64, 0x6e, 0x45, 0x3e, 0x74, 0x83, 0xa1, 0xae, 0x5e, 0x1d, 0x1d, 
  0x1f, 0xba, 0x48, 0x9d, 0xff, 0xc7, 0xb0, 0xa8, 0xda, 0x01, 0x29, 0x18, 
  0x64, 0x3d, 0x8a, 0xf8, 0xf0, 0xe4, 0x9b, 0xa3, 0xf3, 0xd3, 0x93, 0x37, 
  0x87, 0x27, 0x2e, 0x9b, 0x09, 0x5e, 0x5a, 0x31, 0xd5, 0xfc, 0x60, 0xd6, 
  0x95, 0x67, 0xdb, 0xdb, 0x3f, 0x22, 0x53, 0xfc, 0x0b, 0x35, 0xc2, 0xb5, 
  0xaf, 0x48, 0x33, 0x5e, 0x79, 0x8c, 0x0d, 0x8b, 0xe2, 0x16, 0x6b, 0xce, 
  0x46, 0x60, 0x09, 0xba, 0x78, 0x77, 0x76, 0x7e, 0xfa, 0xdd, 0xf7, 0xff, 
  0xc1, 0xf6, 0x2f, 0x6a, 0x70, 0x17, 0xff, 0xd1, 0xe6, 0x5f, 0x85, 0xa3, 
  0x7f, 0x7d, 0x7a, 0xf6, 0xd5, 0xe1, 0xf9, 0x7f, 0xb4, 0x7d, 0x69, 0xd2, 
  0x59, 0x2f, 0xf6, 0x8f, 0x8f, 0xff, 0xa5, 0xe6, 0x0d, 0x86, 0xd2, 0xd0, 
  0x9e, 0xcc, 0xf4, 0x70, 0x85, 0xc4, 0x6b, 0x6d, 0x69, 0x68, 0x16, 0x90, 
  0x36, 0x75, 0x33, 0x94, 0x66, 0x59, 0xd7, 0x70, 0x4e, 0x4e, 0x75, 0x24, 
  0x62, 0x28, 0x1a, 0x1a, 0x4c, 0xcb, 0x54, 0x2b, 0x31, 0x5e, 0x49, 0xf5, 
  0xb6, 0x2f, 0x5a, 0xa1, 0x1f, 0xfe, 0x4b, 0x3b, 0xd1, 0x2c, 0x08, 0x0a, 
  0x7e, 0x8a, 0x04, 0xf4, 0xe6, 0x81, 0xfd, 0x8c, 0x64, 0xf5, 0xae, 0xe1, 
  0x40, 0x21, 0x66, 0xe5, 0x0c, 0xa9, 0x66, 0xec, 0x59, 0x2f, 0xd2, 0xf2, 
  0x96, 0x48, 0xf6, 0xbb, 0xa3, 0xcb, 0xe8, 0xe0, 0xf4, 0xa5, 0x27, 0xf9, 
  0x4b, 0x09, 0x58, 0x87, 0xe5, 0x55, 0x44, 0xd0, 0xf1, 0x32, 0xe3, 0x6c, 
  0xe5, 0xab, 0xa0, 0xc4, 0x9f, 0xe0, 0x30, 0x70, 0x94, 0x41, 0x69, 0xd1, 
  0xb3, 0xa9, 0x63, 0x13, 0x93, 0xbc, 0x10, 0xcc, 0x17, 0x24, 0xe5, 0xc8, 
  0xa3, 0x06, 0x3f, 0xe1, 0xa2, 0xab, 0x24, 0x9f, 0x95, 0xe3, 0x96, 0xd4, 
  0x78, 0x41, 0xc7, 0x6f, 0xea, 0x5b, 0xc8, 0x24, 0x2c, 0x9b, 0xc3, 0xa5, 
  0xf6, 0x43, 0x38, 0x10, 0xe1, 0x12, 0x8c, 0x2b, 0x22, 0x85, 0x9b, 0x15, 
  0x4f, 0xcb, 0xaa, 0x8a, 0x39, 0x26, 0x5a, 0xcb, 0x57, 0xde, 0x55, 0xdb, 
  0x76, 0xe6, 0xe2, 0xe0, 0x82, 0xd4, 0x67, 0x58, 0x21, 0x38, 0x8a, 0x70, 
  0xea, 0x03, 0x74, 0x23, 0xe8, 0x77, 0xed, 0xa4, 0xd6, 0xb0, 0x9e, 0x87, 
  0x84, 0x97, 0x58, 0x33, 0xae, 0xaf, 0x3d, 0x3d, 0x37, 0xa4, 0x71, 0x88, 
  0x84, 0xa9, 0x75, 0x15, 0xd3, 0x9f, 0x02, 0x39, 0xfc, 0x91, 0xcf, 0xed, 
  0x9b, 0xc7, 0x33, 0xab, 0x2f, 0x84, 0xb8, 0x30, 0x81, 0x8c, 0xb9, 0x8f, 
  0xc5, 0x82, 0x8a, 0xa5, 0x9c, 0x04, 0x54, 0xf4, 0x38, 0xc8, 0x0a, 0x44, 
  0xb6, 0x87, 0x6f, 0xa0, 0x52, 0x97, 0x63, 0x22, 0xdf, 0x0c, 0xc3, 0x9c, 
  0xa0, 0x76, 0x76, 0xe4, 0x87, 0x3a, 0x7a, 0x22, 0x3f, 0x0e, 0x8c, 0xca, 
  0xf4, 0x8a, 0x31, 0x6a, 0xf2, 0xb5, 0x96, 0x85, 0xda, 0xc5, 0x6d, 0x3f, 
  0xe9, 0x80, 0xcd, 0x77, 0xd0, 0x7d, 0x65, 0xc3, 0xef, 0xfb, 0x59, 0xa3, 
  0x07, 0xd7, 0x85, 0x80, 0xf6, 0x86, 0xf5, 0x9c, 0x03, 0x30, 0x5f, 0x1e, 
  0x71, 0x47, 0x0f, 0xed, 0xe6, 0xff, 0xd0, 0xdc, 0x88, 0x20, 0x1a, 0xa1, 
  0x8e, 0x0a, 0xfc, 0xb9, 0x63, 0x75, 0xd1, 0x7d, 0xc2, 0x41, 0xca, 0x7a, 
  0xea, 0x01, 0x6b, 0xa4, 0xdb, 0xa2, 0x10, 0x7a, 0x50, 0xc4, 0x90, 0xa9, 
  0xd0, 0xe5, 0x9d, 0x9a, 0xd8, 0x54, 0x50, 0x26, 0xd7, 0x77, 0xf0, 0xd4, 
  0x77, 0x10, 0x03, 0xf5, 0x8e, 0x2e, 0xb9, 0x2c, 0xb5, 0xd8, 0x16, 0x6d, 
  0x5b, 0x3e, 0x92, 0x8a, 0x43, 0xfe, 0xd5, 0xdd, 0x1d, 0xf7, 0x2a, 0x76, 
  0x75, 0xdb, 0x65, 0xf6, 0x20, 0x4d, 0x4e, 0x36, 0x2d, 0x8a, 0x0e, 0x53, 
  0xa9, 0x44, 0x0a, 0x10, 0xa1, 0xa2, 0xab, 0xa6, 0x1c, 0xfb, 0x12, 0xa5, 
  0x92, 0xde, 0x84, 0x6b, 0x71, 0x4a, 0x86, 0x43, 0x88, 0x46, 0xe8, 0x7a, 
  0xdc, 0x6d, 0xac, 0xc6, 0xd9, 0xfe, 0xc5, 0x85, 0xad, 0x05, 0x32, 0xbf, 
  0xeb, 0xd3, 0x54, 0xcf, 0xf1, 0xa2, 0x95, 0x2f, 0x62, 0x69, 0x71, 0xc8, 
  0x8f, 0x96, 0x36, 0x1a, 0xbe, 0xc9, 0xdd, 0xbd, 0x46, 0x57, 0x6f, 0x2f, 
  0x0e, 0xcf, 0xff, 0xdd, 0xae, 0xb4, 0x8d, 0x66, 0x57, 0x8f, 0xda, 0xb3, 
  0xfa, 0x46, 0xda, 0x1a, 0xfc, 0x3b, 0xb3, 0xfa, 0xa6, 0xa3, 0xab, 0xc7, 
  0x7e, 0xcb, 0xa4, 0xaf, 0x68, 0x6f, 0xef, 0x0f, 0x91, 0x2b, 0x23, 0xa6, 
  0x49, 0xfd, 0xae, 0x3f, 0xdf, 0x61, 0xa3, 0x2b, 0x7a, 0x6b, 0x88, 0xc8, 
  0xbf, 0xaa, 0x4e, 0x81, 0x41, 0x57, 0x4f, 0x5c, 0x57, 0xa4, 0xe5, 0x52, 
  0x5b, 0x6c, 0x89, 0x91, 0xd3, 0xd3, 0x3a, 0xb8, 0x28, 0x12, 0xc7, 0x07, 
  0xe8, 0x88, 0x97, 0xa0, 0x95, 0x51, 0xe9, 0xdc, 0xc8, 0xd6, 0x6b, 0xd0, 
  0xcb, 0x67, 0x7e, 0x42, 0xd2, 0x0d, 0xe7, 0xe9, 0xc8, 0x69, 0x0a, 0x3a, 
  0x6a, 0xc0, 0xf2, 0x72, 0x5f, 0x2d, 0x1a, 0xfc, 0x40, 0x47, 0x7f, 0xf0, 
  0xd3, 0xb1, 0x56, 0xf9, 0xce, 0x1a, 0xa7, 0x59, 0x5c, 0xac, 0x82, 0xae, 
  0xac, 0xe4, 0x6b, 0xb4, 0x26, 0x54, 0x44, 0xab, 0x9c, 0x70, 0xec, 0x8c, 
  0xbc, 0xea, 0xbb, 0xf8, 0x5c, 0x81, 0x31, 0x80, 0xd9, 0x17, 0x69, 0xde, 
  0x67, 0x04, 0x1c, 0x79, 0xc5, 0xf2, 0x33, 0x9e, 0x29, 0xe8, 0xa3, 0xb1, 
  0x9a, 0xa4, 0x5b, 0x61, 0xa1, 0x08, 0xf1, 0xf0, 0xed, 0x3e, 0x6d, 0x0f, 
  0xdd, 0xec, 0xb3, 0xdb, 0x7a, 0xe8, 0x43, 0x6c, 0x73, 0x81, 0xb0, 0xea, 
  0xd8, 0xf4, 0xf3, 0xc3, 0xcb, 0x73, 0x84, 0x3f, 0x69, 0xa6, 0xe8, 0x96, 
  0x73, 0x7f, 0x5c, 0x81, 0x93, 0x05, 0x37, 0x4d, 0xc0, 0x1a, 0x24, 0xb2, 
  0x54, 0x61, 0x89, 0x24, 0xae, 0xc0, 0xc2, 0x48, 0x78, 0x06, 0x92, 0x26, 
  0xc1, 0x67, 0x3e, 0xe6, 0x73, 0xdf, 0x91, 0x3c, 0xd2, 0xe4, 0x02, 0x7b, 
  0x9e, 0x0b, 0x08, 0x72, 0xaa, 0x36, 0xbd, 0x1f, 0xe9, 0xdf, 0x6e, 0x58, 
  0x1a, 0x7d, 0xca, 0x11, 0xba, 0x5d, 0xb0, 0x4e, 0xb0, 0xa9, 0x74, 0xf6, 
  0xb0, 0xe7, 0x7d, 0x99, 0x82, 0xc5, 0x22, 0x7c, 0x5c, 0x63, 0x0f, 0x65, 
  0x16, 0xbe, 0x50, 0xa9, 0x40, 0x72, 0x77, 0x39, 0x9c, 0x25, 0xba, 0x31, 
  0x2f, 0xfc, 0x40, 0xac, 0x44, 0x96, 0x88, 0x1e, 0xce, 0x67, 0x86, 0xae, 
  0xba, 0xc6, 0x28, 0x51, 0x94, 0x52, 0x5c, 0x22, 0x7a, 0xcc, 0x98, 0x79, 
  0x30, 0xe5, 0x8d, 0xf3, 0x3b, 0x57, 0xf0, 0x52, 0x43, 0x6c, 0xf1, 0x64, 
  0x47, 0xad, 0x76, 0x91, 0x65, 0x4a, 0x16, 0x10, 0x87, 0x57, 0x0c, 0xcf, 
  0x4d, 0x7b, 0x65, 0x7a, 0x49, 0x30, 0x65, 0x61, 0x42, 0x52, 0x04, 0x41, 
  0x17, 0xb4, 0xce, 0x7b, 0x64, 0x1f, 0xe5, 0x82, 0x41, 0x99, 0x3c, 0x45, 
  0x1c, 0xe9, 0x00, 0xd7, 0x90, 0x42, 0x96, 0x91, 0xa7, 0x94, 0xa0, 0x9f, 
  0xc7, 0xaa, 0xa7, 0xcd, 0xd4, 0x8b, 0xcc, 0x37, 0x07, 0xb2, 0x9b, 0xb5, 
  0x52, 0x1e, 0x91, 0x01, 0x27, 0x11, 0x9b, 0xa9, 0x30, 0x78, 0xf3, 0x49, 
  0x70, 0xd4, 0x6d, 0x50, 0x17, 0x97, 0xa7, 0xe7, 0x7a, 0x50, 0xda, 0xf7, 
  0x15, 0x2f, 0x2c, 0x3f, 0xb0, 0xae, 0x76, 0xe8, 0xc0, 0x57, 0x77, 0xe4, 
  0x56, 0x25, 0x2e, 0xa3, 0x56, 0xea, 0x68, 0xef, 0x33, 0xef, 0x61, 0xd4, 
  0x45, 0xf9, 0x26, 0x2e, 0x00, 0x2f, 0xc5, 0x91, 0xe8, 0x80, 0x9a, 0x2d, 
  0x72, 0xd2, 0xd6, 0xe6, 0x81, 0x26, 0xb8, 0x27, 0xac, 0xe2, 0x14, 0x65, 
  0x1b, 0x34, 0x6b, 0x83, 0xa9, 0x53, 0x7e, 0x83, 0x8d, 0x50, 0x6d, 0x82, 
  0xde, 0x3e, 0xab, 0xe7, 0xc7, 0x5a, 0x10, 0x4e, 0x70, 0x1a, 0x14, 0x39, 
  0x15, 0xa7, 0xcf, 0xa8, 0xe9, 0x4c, 0xc5, 0x17, 0x48, 0x4f, 0x10, 0x8f, 
  0xda, 0x46, 0x3b, 0xd4, 0x12, 0xb5, 0x90, 0x99, 0xf2, 0x26, 0x74, 0x27, 
  0x63, 0xc8, 0x06, 0x4e, 0xee, 0x25, 0x59, 0x3f, 0xf6, 0xa7, 0xdd, 0x6c, 
  0x4e, 0x72, 0xb9, 0x5d, 0xf7, 0x35, 0xa0, 0x59, 0x20, 0x7b, 0x35, 0xb5, 
  0xd8, 0x65, 0x26, 0xe5, 0x70, 0xe5, 0xc6, 0xf4, 0xd2, 0x65, 0xc0, 0x18, 
  0x80, 0xf0, 0x6c, 0x53, 0x47, 0xc3, 0x35, 0x50, 0x76, 0xfb, 0x42, 0xc1, 
  0x87, 0x3b, 0xea, 0xd0, 0xb6, 0xe1, 0x88, 0xeb, 0x4d, 0x88, 0xf7, 0x4c, 
  0x3d, 0xae, 0xed, 0xb0, 0x73, 0xe3, 0x42, 0x62, 0x4e, 0xc4, 0x85, 0x69, 
  0xb6, 0x7f, 0x3f, 0xde, 0xdd, 0x0e, 0xa2, 0x93, 0xbc, 0xd8, 0xf3, 0xc3, 
  0x8b, 0x4b, 0x5d, 0x10, 0xfe, 0xb5, 0xc5, 0x0b, 0xbb, 0xb2, 0x55, 0x0c, 
  0xe6, 0xba, 0xf4, 0x94, 0xc7, 0x81, 0x6d, 0x7c, 0x0e, 0x5e, 0xd5, 0xeb, 
  0xe9, 0xba, 0x01, 0xec, 0xb5, 0x37, 0x04, 0x56, 0x38, 0x06, 0x52, 0x44, 
  0xe7, 0xfc, 0x5b, 0x6b, 0xd1, 0xda, 0xe5, 0x07, 0x1d, 0x4f, 0x84, 0xf1, 
  0x3e, 0x63, 0x2d, 0xaa, 0x4a, 0x32, 0x2b, 0x54, 0x84, 0xb4, 0x87, 0x22, 
  0xbd, 0x06, 0x3a, 0x12, 0xd6, 0x96, 0x28, 0xac, 0xc9, 0xfe, 0x5f, 0x1d, 
  0x44, 0x4f, 0x9f, 0x3c, 0x0d, 0xc6, 0xf6, 0xc8, 0xb3, 0x49, 0xc1, 0x9d, 
  0x0c, 0x98, 0xbc, 0x7c, 0xd0, 0xd3, 0x6e, 0x7b, 0xa4, 0xa0, 0xc9, 0xda, 
  0x71, 0x41, 0x37, 0xb7, 0x38, 0x8f, 0x1e, 0x87, 0x8c, 0x16, 0x72, 0xba, 
  0x36, 0x71, 0x64, 0x2e, 0x1d, 0xfe, 0xd4, 0x05, 0x32, 0x5c, 0x73, 0x61, 
  0x80, 0xae, 0xa2, 0x82, 0x0d, 0xd0, 0xbb, 0x47, 0x4f, 0x5c, 0x4e, 0x9b, 
  0x5d, 0xfd, 0xc1, 0xd0, 0xf8, 0x63, 0x4e, 0xce, 0x2e, 0x6f, 0x04, 0x2d, 
  0xba, 0x79, 0x7b, 0x3d, 0xf2, 0x42, 0x05, 0x5f, 0x4a, 0xce, 0x97, 0x29, 
  0x5b, 0x55, 0x17, 0x2b, 0x48, 0xd1, 0x5b, 0x26, 0xb2, 0x9e, 0x71, 0xd1, 
  0xce, 0x8d, 0xe0, 0x08, 0x19, 0xf1, 0x46, 0x76, 0x84, 0x9e, 0x3d, 0x52, 
  0x99, 0xe2, 0xe8, 0xf8, 0x30, 0xa4, 0x2e, 0xc9, 0xa2, 0x01, 0x4f, 0xf3, 
  0x1a, 0x02, 0x31, 0x2d, 0x5f, 0xf6, 0xb5, 0x49, 0x5c, 0x67, 0xa8, 0xdc, 
  0x0a, 0x2b, 0xde, 0x9f, 0x7c, 0xeb, 0xc2, 0x44, 0x8e, 0x5f, 0xee, 0x43, 
  0x02, 0x83, 0xae, 0x93, 0x66, 0x5c, 0x9a, 0x88, 0x3f, 0x19, 0xa3, 0xe6, 
  0x98, 0x63, 0x30, 0xad, 0x25, 0x78, 0xea, 0x5f, 0x2e, 0x69, 0x66, 0xa4, 
  0x64, 0x37, 0x1f, 0x79, 0x2c, 0x47, 0xf9, 0x58, 0x8b, 0x65, 0x71, 0xfb, 
  0xb8, 0xee, 0x64, 0x8d, 0xf1, 0x66, 0x58, 0x4a, 0x11, 0xe8, 0x80, 0xf2, 
  0x80, 0x6b, 0x41, 0x0f, 0x17, 0xe9, 0xf0, 0xc2, 0xe5, 0x82, 0x67, 0xb8, 
  0xaa, 0xab, 0x16, 0xd1, 0x98, 0x4a, 0x63, 0x57, 0xf6, 0x58, 0xb7, 0x96, 
  0xa5, 0x4d, 0xbb, 0xb6, 0xe5, 0xdc, 0xec, 0xeb, 0xe2, 0x73, 0xca, 0x34, 
  0x31, 0x91, 0x71, 0x3c, 0xb9, 0x25, 0x56, 0x9c, 0xf1, 0xa5, 0x38, 0x73, 
  0xe1, 0x21, 0x9c, 0x01, 0xe1, 0xeb, 0xbd, 0x76, 0x39, 0x93, 0xe5, 0x7c, 
  0xb8, 0xf4, 0x2c, 0xdf, 0x8b, 0x9c, 0x00, 0x47, 0xac, 0x46, 0x65, 0x2c, 
  0x8b, 0x84, 0xe3, 0x45, 0xe7, 0x2e, 0x1f, 0x2b, 0x34, 0x27, 0xf8, 0x88, 
  0x64, 0x41, 0xa3, 0x0f, 0xda, 0x7e, 0x5c, 0x6f, 0xdb, 0x49, 0x39, 0xae, 
  0x61, 0x8d, 0x3e, 0x97, 0xa6, 0x91, 0xf8, 0x12, 0x47, 0x1d, 0x6d, 0x13, 
  0xd7, 0xaf, 0xb5, 0xfb, 0xc4, 0xb7, 0x7b, 0x05, 0xdc, 0xf3, 0x60, 0xd0, 
  0x01, 0x9c, 0x18, 0x5d, 0x2a, 0x02, 0x66, 0xb2, 0xae, 0x02, 0xc4, 0x24, 
  0x2c, 0x52, 0x57, 0x97, 0x26, 0x1e, 0xcb, 0x09, 0xfa, 0x32, 0x0e, 0xe0, 
  0x1e, 0xb8, 0x9a, 0x1c, 0x42, 0x8f, 0x69, 0xf9, 0x15, 0x2b, 0x13, 0xe3, 
  0xe7, 0x4a, 0x7f, 0x31, 0x66, 0xd0, 0x51, 0xe8, 0x43, 0xb0, 0xbe, 0xb5, 
  0x05, 0x7e, 0xdc, 0x5a, 0xf1, 0x5d, 0xc9, 0x21, 0xba, 0xcc, 0xe1, 0x06, 
  0xcd, 0x56, 0xce, 0x35, 0x56, 0x8e, 0x04, 0xb7, 0xb3, 0xed, 0x34, 0xd3, 
  0x2a, 0x92, 0xcd, 0xa4, 0x95, 0xb4, 0xd2, 0x1a, 0x0a, 0xe2, 0x00, 0x94, 
  0xb8, 0xd7, 0xa0, 0xa3, 0xcf, 0xd5, 0x52, 0x23, 0x17, 0xdb, 0xe5, 0xe1, 
  0xf1, 0xc9, 0xe1, 0xa5, 0xd9, 0x79, 0x3b, 0xe4, 0x95, 0xc7, 0x4f, 0x1b, 
  0x92, 0x8e, 0x42, 0xdb, 0x35, 0xe3, 0x36, 0x9e, 0xec, 0xba, 0x98, 0x71, 
  0xab, 0xf7, 0x92, 0xa0, 0xae, 0x35, 0xb8, 0x57, 0x42, 0xca, 0x00, 0x02, 
  0x99, 0x20, 0xef, 0x33, 0x7f, 0xc8, 0x6f, 0xfd, 0xab, 0x7b, 0x41, 0x0a, 
  0xb5, 0x48, 0x3e, 0xa9, 0x2a, 0x56, 0x0b, 0x28, 0x0d, 0xd9, 0x8a, 0x33, 
  0xcf, 0xae, 0x91, 0xec, 0x04, 0xd3, 0xbe, 0x18, 0xd0, 0x5a, 0x06, 0xfd, 
  0x10, 0x13, 0x3d, 0x6b, 0x32, 0xd3, 0x27, 0x8f, 0x3c, 0x33, 0x2d, 0x56, 
  0x0b, 0x54, 0xe8, 0x03, 0xea, 0xb9, 0x3b, 0x76, 0xfe, 0x51, 0xa1, 0xd9, 
  0x03, 0x61, 0x37, 0x2c, 0x38, 0xb4, 0xdf, 0x8a, 0xdb, 0xc5, 0x29, 0x9e, 
  0x3c, 0x09, 0xed, 0x21, 0xa4, 0x47, 0x42, 0x4c, 0xd1, 0xfa, 0xea, 0x10, 
  0x39, 0xfd, 0xa3, 0x9f, 0xb9, 0x47, 0x97, 0x28, 0x1d, 0xab, 0xb8, 0x0c, 
  0xeb, 0x5f, 0x10, 0xfa, 0xb8, 0xb8, 0x89, 0x05, 0x0d, 0x2e, 0x95, 0xf4, 
  0xe9, 0xcd, 0xb4, 0x76, 0xae, 0xbc, 0x87, 0xe1, 0x89, 0x6a, 0x61, 0x22, 
  0xd6, 0x79, 0x09, 0x5d, 0x70, 0xed, 0x82, 0xfd, 0xf0, 0x6f, 0x3c, 0xad, 
  0x1b, 0x8b, 0x96, 0xb5, 0x38, 0x55, 0x2c, 0x40, 0xba, 0xb8, 0x09, 0xea, 
  0x89, 0x7c, 0xb6, 0xd3, 0xdd, 0xc5, 0xc1, 0x3e, 0xda, 0x8f, 0x36, 0x19, 
  0xdd, 0xfe, 0x4f, 0x5a, 0x8f, 0x9b, 0xb9, 0xfa, 0x9f, 0xfc, 0xf0, 0x3e, 
  0xdb, 0x55, 0x2a, 0x64, 0x35, 0xf7, 0x3a, 0x4b, 0x7f, 0x62, 0xc2, 0x32, 
  0x49, 0x86, 0xcb, 0x40, 0xf2, 0xd2, 0xf9, 0xa7, 0xf7, 0xf4, 0xac, 0xdf, 
  0xc5, 0xb3, 0x54, 0xf9, 0x28, 0xdb, 0xdb, 0xdc, 0xf7, 0x8f, 0x94, 0x46, 
  0x85, 0xe4, 0xa1, 0x56, 0x72, 0x20, 0x38, 0x43, 0xa0, 0x26, 0x09, 0xc7, 
  0x07, 0xdb, 0x93, 0xdf, 0x7d, 0x17, 0x5a, 0x60, 0x3d, 0xea, 0x5f, 0x5c, 
  0x04, 0xf9, 0xca, 0x6a, 0x75, 0x15, 0xe0, 0x3d, 0x3a, 0x79, 0xcb, 0xaa, 
  0x0d, 0xa1, 0x5c, 0x24, 0xb3, 0x84, 0xe1, 0x30, 0xe4, 0x9a, 0xf0, 0x41, 
  0xb4, 0x1c, 0xba, 0xa1, 0xb9, 0x1c, 0x52, 0xa5, 0x18, 0x4a, 0x46, 0x96, 
  0xb4, 0x8b, 0xde, 0x88, 0x82, 0x4d, 0xf4, 0xb9, 0xff, 0xf6, 0xf2, 0xab, 
  0xd3, 0xf3, 0x8b, 0x68, 0x9b, 0x4b, 0x32, 0x5d, 0x9e, 0x1f, 0x7d, 0xf9, 
  0x96, 0x84, 0x7d, 0x67, 0x2c, 0x7e, 0x19, 0x93, 0x12, 0x30, 0xe3, 0x50, 
  0x8a, 0x24, 0x1b, 0x27, 0xc5, 0xb5, 0x41, 0xf5, 0x71, 0x61, 0x16, 0xa4, 
  0x21, 0xe7, 0x85, 0x15, 0x9c, 0x36, 0x48, 0x6d, 0x35, 0x68, 0x6f, 0x84, 
  0x48, 0x29, 0x29, 0x3d, 0x92, 0x17, 0x08, 0xd6, 0xb2, 0x5c, 0x35, 0xd5, 
  0x19, 0x15, 0xca, 0xfc, 0xf2, 0xab, 0xfd, 0x93, 0xaf, 0x2f, 0xcc, 0xcf, 
  0xf2, 0xed, 0xb7, 0xdf, 0x86, 0xfe, 0x95, 0x67, 0xdb, 0xdb, 0x80, 0xea, 
  0xb8, 0x89, 0xdf, 0xbf, 0x1f, 0x95, 0x44, 0x33, 0x41, 0x79, 0x0e, 0x0f, 
  0x20, 0x56, 0x2e, 0x89, 0x74, 0xe9, 0xeb, 0xed, 0xc5, 0x72, 0xcc, 0x28, 
  0x66, 0xdb, 0xcb, 0x4a, 0x61, 0x4e, 0xf1, 0xf6, 0xf6, 0xc6, 0xc6, 0xc5, 
  0xe1, 0x61, 0xb4, 0x7f, 0x7c, 0x71, 0x1a, 0xbc, 0xbb, 0xb9, 0xbb, 0x35, 
  0x88, 0xee, 0xaf, 0x93, 0x0a, 0xbf, 0x94, 0x59, 0x5c, 0x5c, 0x71, 0x84, 
  0xca, 0xc6, 0xf1, 0xfe, 0x25, 0x8b, 0xa3, 0xdf, 0x1c, 0x9e, 0x5f, 0x1c, 
  0x9d, 0x9e, 0xf0, 0x06, 0x72, 0x1e, 0x67, 0x3c, 0x63, 0x5c, 0x7e, 0x29, 
  0xb0, 0x9e, 0x25, 0xf7, 0x86, 0x28, 0xca, 0x59, 0xcb, 0xc4, 0x6a, 0x84, 
  0xd1, 0x4b, 0xe1, 0xb8, 0x7b, 0x4e, 0xb8, 0x8d, 0x0d, 0x2f, 0xbf, 0x62, 
  0xb1, 0xcb, 0x5c, 0x84, 0x1b, 0x81, 0xce, 0x2c, 0xb8, 0x89, 0xc9, 0x58, 
  0x42, 0x5d, 0x06, 0x92, 0x15, 0x88, 0x50, 0xea, 0x20, 0xa5, 0xb1, 0x73, 
  0x09, 0x2e, 0x8e, 0xde, 0x9c, 0x91, 0xc4, 0xf3, 0xf6, 0x62, 0xff, 0xf5, 
  0x21, 0x3f, 0xfa, 0x3a, 0xa9, 0xfc, 0xc6, 0x08, 0xf2, 0x29, 0x77, 0x42, 
  0x4b, 0x52, 0x4e, 0xe2, 0x05, 0x07, 0x45, 0x53, 0x37, 0x43, 0x61, 0x70, 
  0x41, 0xdb, 0x61, 0x61, 0x43, 0x46, 0x7e, 0xb3, 0xe7, 0x81, 0xb8, 0x16, 
  0xb6, 0x7b, 0x7e, 0xb8, 0xff, 0xf2, 0xcd, 0xa1, 0x05, 0x48, 0xe1, 0xaa, 
  0x62, 0xf6, 0x5a, 0x2f, 0x2a, 0xcf, 0x21, 0xe0, 0x57, 0xbc, 0x0d, 0xf4, 
  0x0d, 0x17, 0xb1, 0xe9, 0xee, 0xce, 0x6f, 0x19, 0x9e, 0x1d, 0x5d, 0xa5, 
  0xdb, 0xd2, 0xba, 0xf5, 0x17, 0xbb, 0x25, 0xb1, 0xf0, 0x22, 0x65, 0xcc, 
  0xa2, 0x64, 0x40, 0x4d, 0xf9, 0x7c, 0x67, 0x67, 0xe7, 0x81, 0x79, 0xc0, 
  0x2e, 0xa7, 0x16, 0x09, 0x9a, 0xca, 0x33, 0x7e, 0x7c, 0xdb, 0xb7, 0x6f, 
  0x4e, 0x97, 0x38, 0x18, 0x3b, 0xff, 0x99, 0x89, 0xd8, 0x4e, 0x3a, 0x7a, 
  0xf7, 0xa0, 0x27, 0x79, 0xee, 0xf6, 0x20, 0x68, 0xee, 0x3a, 0x67, 0xd6, 
  0xe4, 0x43, 0x79, 0x24, 0xce, 0x44, 0x17, 0x42, 0xbf, 0xec, 0x5e, 0x0b, 
  0xf9, 0x92, 0x5a, 0x96, 0x5f, 0xdc, 0x8a, 0x84, 0x4b, 0x3f, 0xe5, 0xe4, 
  0xf8, 0xb4, 0x32, 0x2c, 0x08, 0x17, 0xc8, 0xc2, 0x83, 0x87, 0x0c, 0x43, 
  0xd2, 0x61, 0xb3, 0x5d, 0xfe, 0x86, 0x5a, 0xe5, 0x1f, 0xa3, 0xbc, 0xb8, 
  0xde, 0x9e, 0x3f, 0xc3, 0x65, 0x4d, 0x0f, 0xbd, 0x42, 0xb5, 0x50, 0xae, 
  0x24, 0xe0, 0x0a, 0x85, 0xf2, 0xb6, 0x71, 0x00, 0xe5, 0x47, 0xcc, 0xf9, 
  0x23, 0xd6, 0xf8, 0xe5, 0xe9, 0xb7, 0x27, 0xc7, 0xa7, 0xfb, 0x2f, 0xa3, 
  0xcb, 0x53, 0x12, 0x86, 0x58, 0x2e, 0xef, 0xd8, 0x57, 0x56, 0xa2, 0xca, 
  0x4a, 0xea, 0x96, 0xd7, 0x6a, 0x44, 0x36, 0xc7, 0x30, 0x14, 0xb4, 0x7f, 
  0x24, 0xa8, 0xde, 0x54, 0xf3, 0x0f, 0x13, 0xeb, 0xc7, 0x74, 0x32, 0xf0, 
  0xa0, 0xf1, 0x01, 0xd2, 0xaa, 0x45, 0xb9, 0x69, 0x75, 0xaa, 0x3a, 0x24, 
  0xbd, 0xdb, 0xdb, 0x4d, 0xf1, 0x11, 0xfa, 0x50, 0x37, 0x01, 0x7c, 0x2d, 
  0xeb, 0xb5, 0x3c, 0x1c, 0x20, 0xa3, 0xa2, 0x0d, 0x83, 0xd7, 0xb3, 0xf0, 
  0xbf, 0xd5, 0x9a, 0xe0, 0xe9, 0xda, 0x29, 0x11, 0x9b, 0x49, 0xde, 0x63, 
  0xd6, 0xf5, 0x8d, 0x13, 0xc8, 0x05, 0x3f, 0x3b, 0x5f, 0x40, 0x47, 0xca, 
  0x24, 0xeb, 0x90, 0xe1, 0x4c, 0xec, 0xe8, 0x8e, 0xfb, 0xb1, 0xfd, 0xf4, 
  0x5d, 0xf0, 0x37, 0x21, 0x8b, 0xd9, 0x76, 0xaa, 0x96, 0x0c, 0xe0, 0xed, 
  0xc5, 0xd1, 0xc9, 0x6b, 0xd8, 0xf9, 0xbf, 0x3d, 0x3d, 0x7f, 0x79, 0x41, 
  0xcd, 0x32, 0x17, 0xde, 0x80, 0xd4, 0x08, 0x60, 0x14, 0x19, 0x95, 0x1c, 
  0x51, 0xee, 0xfa, 0xf7, 0x10, 0x39, 0x11, 0x9c, 0x2a, 0x10, 0x48, 0x18, 
  0xa6, 0x5f, 0x9b, 0x66, 0xad, 0xd5, 0x80, 0xe4, 0xf8, 0x75, 0x01, 0x43, 
  0x9b, 0xfe, 0x59, 0xab, 0x71, 0x69, 0x31, 0x30, 0x78, 0x74, 0xb7, 0x39, 
  0x91, 0x78, 0x9b, 0xef, 0xf7, 0xed, 0x2a, 0xdf, 0x06, 0xb8, 0xc5, 0x86, 
  0x04, 0x12, 0x96, 0xbe, 0xba, 0x4d, 0x20, 0x12, 0x0c, 0x97, 0xd1, 0xd5, 
  0x2c, 0xbe, 0x46, 0x87, 0xcd, 0xe5, 0x58, 0x46, 0x41, 0x67, 0xda, 0xfd, 
  0xc7, 0x76, 0xc9, 0xe0, 0x2e, 0x68, 0x4f, 0x2a, 0x64, 0x23, 0x59, 0x10, 
  0x79, 0xff, 0x6a, 0x0c, 0x93, 0x9b, 0x11, 0x10, 0xbd, 0x8c, 0x65, 0xc1, 
  0x60, 0xa3, 0x4d, 0xc4, 0x32, 0xad, 0x75, 0xb5, 0x21, 0xa2, 0xe1, 0x30, 
  0x48, 0xcb, 0x90, 0x8c, 0x11, 0x6e, 0x29, 0x10, 0x97, 0x24, 0xf6, 0x99, 
  0xfa, 0x44, 0x74, 0xd6, 0x86, 0x8a, 0xad, 0xd0, 0xfc, 0x79, 0x45, 0x0d, 
  0x02, 0xca, 0x6c, 0x39, 0x6d, 0xb8, 0xb8, 0x60, 0xf9, 0x25, 0x48, 0x54, 
  0x0c, 0x94, 0x1b, 0x91, 0x44, 0x88, 0x06, 0x56, 0x20, 0xce, 0x54, 0xc9, 
  0x56, 0x74, 0xdf, 0x49, 0x14, 0x1d, 0x50, 0xb3, 0x38, 0x42, 0x96, 0xd9, 
  0x3a, 0xe0, 0x48, 0x9d, 0x46, 0xa3, 0x0e, 0xe2, 0x65, 0x69, 0xe9, 0x33, 
  0xdc, 0x1a, 0x97, 0x58, 0xb3, 0x80, 0xda, 0xae, 0x8d, 0x56, 0x9a, 0x5f, 
  0xbf, 0xd3, 0x1f, 0xde, 0xe4, 0xf6, 0xec, 0x4c, 0x9c, 0x98, 0xad, 0x64, 
  0x1f, 0xd2, 0xec, 0xe1, 0xed, 0xd6, 0x41, 0x7c, 0x54, 0xc7, 0x58, 0x64, 
  0x60, 0x10, 0x69, 0x59, 0x58, 0xef, 0x2c, 0x17, 0x6f, 0x04, 0xc2, 0x6f, 
  0x1b, 0x75, 0x51, 0x79, 0x74, 0x35, 0x74, 0x95, 0x0d, 0x78, 0x98, 0x10, 
  0x25, 0xf8, 0x8c, 0x34, 0xbb, 0x32, 0x9d, 0x0c, 0xb4, 0xc4, 0xf7, 0x40, 
  0x11, 0x79, 0xe8, 0x0d, 0x07, 0xf4, 0x42, 0xca, 0x17, 0xd1, 0x30, 0xb2, 
  0x4f, 0x49, 0x9e, 0x40, 0x20, 0x18, 0x34, 0x10, 0xe7, 0xfe, 0xd8, 0x90, 
  0x5c, 0xb0, 0x81, 0x32, 0x7d, 0xd1, 0x08, 0x10, 0x12, 0x84, 0xb6, 0x3d, 
  0xfa, 0x04, 0x88, 0x2f, 0x2e, 0x6f, 0x5d, 0x10, 0x1a, 0xf6, 0x07, 0x02, 
  0x03, 0x1b, 0x8c, 0xca, 0x64, 0xa2, 0x42, 0x26, 0x24, 0xc8, 0x7c, 0xe9, 
  0x9c, 0x24, 0xf8, 0xdb, 0x55, 0xf5, 0x36, 0x10, 0x45, 0xb8, 0x18, 0x4b, 
  0x97, 0x95, 0x27, 0x3e, 0x0f, 0xf0, 0xbb, 0xb0, 0xd8, 0xdc, 0x70, 0x48, 
  0xeb, 0xc4, 0x2b, 0x22, 0x6a, 0x10, 0x03, 0x50, 0xfc, 0x2a, 0xba, 0x48, 
  0x19, 0x00, 0xdd, 0x48, 0x16, 0xf9, 0x3f, 0x0f, 0x51, 0xac, 0xcb, 0xc9, 
  0x52, 0x9d, 0xc0, 0xaa, 0x81, 0x08, 0x0d, 0x06, 0x20, 0x12, 0xb0, 0xb3, 
  0xdf, 0xa5, 0xb1, 0x25, 0x73, 0xc9, 0xdc, 0xdf, 0x31, 0x08, 0xc5, 0x3b, 
  0x57, 0x27, 0x8f, 0xf6, 0x5f, 0x5e, 0x04, 0x00, 0x04, 0xa8, 0x5e, 0x82, 
  0x13, 0x4a, 0x2e, 0xb7, 0x3e, 0x49, 0x0b, 0x62, 0xf2, 0x9c, 0x25, 0x33, 
  0x11, 0x30, 0x1e, 0xc4, 0xca, 0x60, 0xec, 0xac, 0x66, 0xc4, 0x63, 0x46, 
  0x7f, 0xe0, 0xe5, 0x62, 0x7b, 0x1c, 0x60, 0x3a, 0x7d, 0x39, 0x0b, 0xab, 
  0xda, 0x1b, 0x1e, 0x56, 0x00, 0x93, 0x20, 0x2d, 0x06, 0x70, 0x9a, 0x02, 
  0x4c, 0x42, 0xcd, 0x49, 0x0c, 0x0b, 0xda, 0xc5, 0xa8, 0x1d, 0x72, 0x15, 
  0xc7, 0x9e, 0x38, 0x5a, 0x0e, 0x42, 0x11, 0x54, 0x38, 0xd8, 0xd8, 0x40, 
  0x80, 0x09, 0xb7, 0xc0, 0x17, 0x5d, 0xe6, 0xd8, 0xae, 0x2b, 0x04, 0x20, 
  0xbe, 0x7a, 0x29, 0xb3, 0x3c, 0x5f, 0x69, 0x4e, 0x20, 0x76, 0x0f, 0xd0, 
  0x43, 0x22, 0x39, 0x7d, 0xfe, 0x79, 0xeb, 0x52, 0x78, 0xef, 0x9e, 0x7e, 
  0x46, 0x5f, 0x07, 0x12, 0xda, 0x8c, 0xed, 0xde, 0x06, 0xf9, 0xeb, 0xc5, 
  0xb4, 0xd7, 0x3e, 0x5a, 0x3e, 0xa8, 0x7e, 0xe5, 0xc2, 0x75, 0xb8, 0x43, 
  0x57, 0xbc, 0xb5, 0x63, 0x4b, 0x1d, 0xd6, 0xf1, 0x86, 0x80, 0x1d, 0x2b, 
  0x72, 0x65, 0x29, 0x2e, 0x99, 0x67, 0xed, 0x43, 0xeb, 0xd1, 0x31, 0xa7, 
  0xad, 0xc1, 0x06, 0xb7, 0x27, 0xd7, 0x8c, 0xe6, 0x0b, 0x97, 0x85, 0x81, 
  0x8b, 0x5c, 0x1b, 0xe6, 0x18, 0x76, 0x1d, 0x8c, 0x03, 0x3a, 0xa9, 0x1f, 
  0xd3, 0x91, 0xc3, 0xa4, 0x74, 0x38, 0xcc, 0xc3, 0xb7, 0xeb, 0x87, 0xf3, 
  0xf6, 0x5f, 0x1a, 0x4e, 0x58, 0xb9, 0xac, 0x0b, 0xc9, 0x5e, 0x0b, 0xb6, 
  0xd4, 0x18, 0x30, 0xd8, 0x0d, 0x09, 0x92, 0x05, 0xbc, 0x5d, 0x9a, 0x90, 
  0xa8, 0x99, 0x34, 0x44, 0x0d, 0xe7, 0xfb, 0x27, 0xaf, 0x0f, 0x41, 0x9f, 
  0xcc, 0x26, 0x7c, 0xe6, 0x16, 0x27, 0x7f, 0x48, 0xf5, 0xb3, 0x52, 0xc2, 
  0x02, 0x52, 0x7e, 0x63, 0xba, 0x9c, 0xb0, 0xe1, 0xe8, 0xad, 0x83, 0x5c, 
  0x01, 0xc4, 0x0c, 0x6a, 0xab, 0x82, 0x45, 0xa8, 0x79, 0x78, 0x23, 0xb2, 
  0x88, 0x7f, 0x50, 0xb8, 0x06, 0x1c, 0x40, 0x3d, 0x2d, 0x97, 0xe3, 0x45, 
  0xac, 0x79, 0x06, 0x71, 0x18, 0x88, 0x6e, 0x45, 0x94, 0x6a, 0x53, 0x60, 
  0x5e, 0xa7, 0x15, 0x82, 0xec, 0x1e, 0x2e, 0x70, 0x0f, 0x8f, 0x42, 0xe1, 
  0x56, 0x92, 0xf1, 0x77, 0x5d, 0xe5, 0x2c, 0x11, 0xca, 0xb5, 0xc1, 0xd6, 
  0xd2, 0x17, 0x11, 0x97, 0x32, 0x5b, 0xb7, 0xc6, 0xae, 0xd1, 0x7a, 0x85, 
  0xb2, 0x0f, 0xb6, 0x89, 0x42, 0x67, 0xeb, 0xda, 0xc4, 0x94, 0xb0, 0x73, 
  0x0e, 0x21, 0x4b, 0xab, 0x3f, 0xe9, 0x0a, 0x9b, 0xe7, 0x4b, 0xa5, 0x32, 
  0xd1, 0xfd, 0xa0, 0x98, 0x67, 0x2e, 0x9f, 0x54, 0x3d, 0x8a, 0x76, 0x73, 
  0x09, 0x26, 0x81, 0x0a, 0x70, 0x0b, 0xb6, 0xce, 0xa7, 0xce, 0x9c, 0xf5, 
  0x51, 0x0b, 0xa3, 0x54, 0x4a, 0xdd, 0xae, 0x5b, 0xa2, 0xab, 0xf6, 0x6c, 
  0x54, 0x85, 0x8b, 0x48, 0x96, 0x3b, 0x63, 0x01, 0x9d, 0xe4, 0x39, 0x2f, 
  0xc5, 0xbd, 0x55, 0xd4, 0x74, 0x12, 0x53, 0xe1, 0x9d, 0x64, 0x73, 0x1c, 
  0x30, 0xa0, 0x10, 0x4f, 0x16, 0xd4, 0x45, 0x21, 0x96, 0xd3, 0xa5, 0x1f, 
  0x0d, 0x2f, 0xa3, 0x61, 0xc0, 0x37, 0x34, 0x3d, 0x9b, 0x99, 0xc6, 0x7c, 
  0x65, 0x77, 0xa8, 0xf6, 0x81, 0xf6, 0x4d, 0xb1, 0xab, 0x15, 0x5c, 0x19, 
  0x48, 0x74, 0x8c, 0x50, 0x4c, 0x8b, 0x6f, 0x74, 0x74, 0x29, 0xdd, 0x80, 
  0x0f, 0x35, 0xb8, 0xc4, 0xc7, 0x0d, 0xa5, 0x56, 0x9d, 0x5e, 0x3d, 0x38, 
  0x2a, 0x3d, 0xf3, 0x24, 0x07, 0x26, 0x9f, 0x75, 0x15, 0x65, 0xf0, 0xe5, 
  0xeb, 0xab, 0x3c, 0x7f, 0xb6, 0x11, 0xfd, 0xbb, 0x83, 0x7b, 0x60, 0x58, 
  0x48, 0x4e, 0x42, 0x75, 0x88, 0x64, 0xda, 0x18, 0x66, 0xc0, 0xfe, 0xb9, 
  0xd5, 0xf6, 0x12, 0xa1, 0x25, 0x19, 0x44, 0xdc, 0xdd, 0xb1, 0xb4, 0x64, 
  0x2b, 0xd3, 0x41, 0xef, 0xbc, 0xe7, 0x9a, 0xbd, 0x6f, 0x61, 0x88, 0x2e, 
  0x63, 0x9a, 0x25, 0x5c, 0x30, 0x8a, 0xf4, 0x2a, 0x2c, 0x33, 0xce, 0x87, 
  0x5f, 0x62, 0x67, 0x91, 0xbe, 0xcf, 0x44, 0x04, 0xd8, 0x23, 0xb0, 0xb5, 
  0xdb, 0x54, 0x6b, 0xa5, 0x22, 0xa9, 0x17, 0x42, 0xe8, 0x11, 0x4a, 0x3b, 
  0xb1, 0x08, 0xea, 0x93, 0xb0, 0xb9, 0x82, 0xa7, 0x84, 0x68, 0xb3, 0x44, 
  0x49, 0x83, 0x8f, 0xcb, 0x1b, 0x98, 0x89, 0x1d, 0xc4, 0x76, 0x6b, 0xba, 
  0xb5, 0x64, 0x61, 0xe2, 0xcc, 0xc2, 0x96, 0xc1, 0x50, 0x6b, 0x4b, 0x51, 
  0x5f, 0x81, 0x40, 0x9e, 0xfe, 0xd8, 0x63, 0xc0, 0xdc, 0x62, 0xfd, 0x39, 
  0x68, 0x41, 0xe9, 0x37, 0xa8, 0xcf, 0x63, 0xcc, 0x22, 0x90, 0x06, 0x6d, 
  0xc9, 0xd5, 0xc9, 0xe2, 0x0a, 0xe3, 0x49, 0x21, 0x39, 0xac, 0xb1, 0x80, 
  0x10, 0xba, 0x50, 0x89, 0xc2, 0x25, 0x8b, 0xc9, 0x3a, 0x4b, 0x1a, 0x18, 
  0x12, 0xa9, 0x7d, 0xd5, 0x55, 0x75, 0x18, 0x33, 0x88, 0xa1, 0x04, 0x4b, 
  0xc0, 0x74, 0xc5, 0xd8, 0x7a, 0xb9, 0xf4, 0x88, 0xf9, 0xc9, 0xf0, 0x06, 
  0x00, 0xb7, 0x15, 0xcf, 0xef, 0xc5, 0x25, 0x4b, 0x83, 0x90, 0x5e, 0x4d, 
  0x60, 0xf9, 0xe6, 0xf0, 0xfc, 0xcb, 0xd3, 0x8b, 0xc3, 0x68, 0x3b, 0x7a, 
  0x79, 0xf8, 0xe5, 0x5b, 0x66, 0x1a, 0xbc, 0x5f, 0xa2, 0xaf, 0x21, 0x1b, 
  0x58, 0x40, 0xc0, 0x80, 0x06, 0xe0, 0x84, 0x39, 0xc9, 0xbf, 0x19, 0x18, 
  0x5d, 0xf8, 0x32, 0x7f, 0xfc, 0xc4, 0x2c, 0x11, 0xbd, 0x28, 0xcd, 0x18, 
  0x55, 0x50, 0x81, 0x76, 0x55, 0xc8, 0xcb, 0x18, 0x59, 0xa3, 0x32, 0xc8, 
  0x56, 0x2b, 0x2e, 0x58, 0x3e, 0xf3, 0x42, 0xdc, 0x9d, 0xa8, 0x73, 0x7a, 
  0x30, 0x3c, 0x1c, 0xb2, 0x01, 0x1f, 0xeb, 0x3d, 0x04, 0x9d, 0x5b, 0x61, 
  0xd7, 0x66, 0xb9, 0x5c, 0x5b, 0xc0, 0x00, 0xe6, 0xb6, 0x81, 0x34, 0x98, 
  0x02, 0xdb, 0x5d, 0x51, 0x73, 0x14, 0x9a, 0xb8, 0x14, 0x72, 0x83, 0xbf, 
  0x87, 0xbb, 0x98, 0x29, 0x3f, 0x06, 0x3b, 0x2a, 0x13, 0x49, 0xb7, 0x93, 
  0x6b, 0x53, 0xed, 0x5b, 0xa2, 0x09, 0xc5, 0xb2, 0x66, 0x9b, 0x7c, 0x20, 
  0x38, 0x51, 0xd6, 0xd5, 0x70, 0xdb, 0x88, 0x14, 0xb8, 0x97, 0x5e, 0x9d, 
  0x70, 0x71, 0x2c, 0xac, 0xfc, 0xd6, 0xa8, 0x49, 0x38, 0x77, 0xeb, 0xd9, 
  0xc2, 0xa5, 0xcc, 0x94, 0x33, 0x99, 0xe4, 0x26, 0x76, 0x15, 0x8d, 0x60, 
  0x4a, 0xf5, 0xc1, 0xf8, 0xec, 0x28, 0x73, 0x78, 0x79, 0x72, 0x9a, 0xd8, 
  0x7b, 0x1f, 0xc8, 0x5b, 0x5d, 0x28, 0xbf, 0x02, 0xeb, 0x6b, 0x2a, 0xa7, 
  0xba, 0xd7, 0x9a, 0x19, 0x7d, 0xbc, 0x14, 0xf9, 0x35, 0xb6, 0x14, 0x7a, 
  0x74, 0xd4, 0x2c, 0x33, 0xa1, 0x27, 0x50, 0x5a, 0xc7, 0xbf, 0xa3, 0xea, 
  0x7d, 0x15, 0x5a, 0x1b, 0x88, 0x47, 0x6e, 0xbc, 0x3c, 0xbc, 0xdc, 0x3f, 
  0x3a, 0x3e, 0x7c, 0x19, 0x1d, 0x9d, 0xbc, 0x3a, 0x3d, 0x7f, 0xb3, 0x7f, 
  0xa9, 0xe6, 0xd5, 0x97, 0x4e, 0x9b, 0xf2, 0x28, 0xb4, 0xa6, 0x75, 0x7a, 
  0x4d, 0x0b, 0x34, 0x4c, 0xdb, 0x78, 0xad, 0xc0, 0x0d, 0xb2, 0x0e, 0x49, 
  0x6d, 0x11, 0x36, 0x0c, 0x5a, 0xc9, 0x29, 0xd3, 0xb8, 0x99, 0xb7, 0x9d, 
  0xb9, 0x6b, 0x64, 0xeb, 0x69, 0xba, 0x10, 0x2a, 0xbe, 0x3d, 0xd8, 0x94, 
  0x2b, 0xd8, 0x22, 0xb7, 0xd4, 0xca, 0xd7, 0xb7, 0x64, 0xa2, 0x1c, 0x1e, 
  0x71, 0xda, 0x16, 0x52, 0x1c, 0xb4, 0x90, 0xd4, 0x51, 0x65, 0x69, 0x13, 
  0xa5, 0x86, 0x5d, 0xf8, 0x7a, 0x85, 0x20, 0x41, 0x14, 0x9a, 0x09, 0xda, 
  0x74, 0xa1, 0xf9, 0x86, 0x1a, 0x3b, 0xf2, 0x9a, 0x7d, 0xb8, 0xc1, 0x9c, 
  0xed, 0xbc, 0xc1, 0x31, 0x43, 0x95, 0x7a, 0x0c, 0x24, 0xfe, 0x40, 0xab, 
  0xac, 0xbd, 0xd2, 0x46, 0x3c, 0x0f, 0x35, 0x9b, 0x96, 0xe2, 0xe0, 0x84, 
  0x4d, 0x6d, 0xba, 0x5a, 0x23, 0x24, 0xb3, 0x0c, 0x8f, 0x88, 0x62, 0x79, 
  0x3e, 0xbc, 0x16, 0x9c, 0xa1, 0xc9, 0x3f, 0x33, 0xcf, 0x68, 0x34, 0x66, 
  0xc9, 0xcb, 0xc7, 0x01, 0xb6, 0xb5, 0x1e, 0x37, 0x7f, 0x70, 0x4b, 0x23, 
  0xb5, 0x97, 0xf4, 0x10, 0x57, 0x2b, 0x18, 0x6a, 0xf7, 0x56, 0x88, 0x86, 
  0x45, 0x23, 0xdb, 0x42, 0x11, 0x9b, 0x20, 0x0e, 0x70, 0x54, 0xab, 0x04, 
  0xd1, 0x66, 0x53, 0x9d, 0x07, 0x08, 0xbc, 0x32, 0x03, 0x1a, 0x0b, 0xed, 
  0xde, 0xe6, 0xe5, 0x70, 0xb8, 0xd3, 0xac, 0xa3, 0x78, 0x1b, 0x16, 0xe4, 
  0xc2, 0x3d, 0x8b, 0x95, 0x0c, 0x5e, 0x88, 0xbd, 0xef, 0x01, 0xeb, 0xbf, 
  0x69, 0x90, 0x3e, 0x4c, 0xb3, 0xda, 0x60, 0xf2, 0x3e, 0x66, 0x41, 0xaf, 
  0x6d, 0xb2, 0xab, 0x4d, 0x2a, 0x7c, 0xb1, 0x6e, 0xa3, 0x0f, 0x19, 0xbd, 
  0x75, 0x8d, 0xd1, 0x4f, 0xbb, 0x46, 0xa0, 0x6c, 0x1c, 0x55, 0x24, 0x88, 
  0xaa, 0x18, 0x5f, 0x30, 0x86, 0xad, 0x9a, 0x33, 0x8d, 0x37, 0x34, 0x3a, 
  0x3e, 0xc4, 0x24, 0x0f, 0xf3, 0xc9, 0x26, 0x8c, 0x23, 0xce, 0xf6, 0x1b, 
  0x05, 0x5f, 0x0f, 0x02, 0xf2, 0xa2, 0x37, 0xa8, 0x81, 0xad, 0xb5, 0xcf, 
  0x98, 0xeb, 0x65, 0x1b, 0x56, 0x6a, 0xc7, 0x5e, 0x9a, 0xa8, 0xf8, 0x09, 
  0xf6, 0x2f, 0xa9, 0x86, 0xe0, 0xf2, 0x6c, 0xbf, 0xe6, 0xca, 0x6a, 0xb0, 
  0x18, 0xb0, 0xe6, 0x2b, 0x97, 0x06, 0x48, 0x00, 0x73, 0x75, 0x70, 0x20, 
  0xb8, 0x7d, 0x7c, 0x0d, 0x9b, 0xa1, 0xe4, 0x60, 0xc7, 0x9c, 0xed, 0xe0, 
  0x2a, 0xb8, 0x5d, 0x02, 0x5e, 0xc6, 0x5a, 0x41, 0xd9, 0x2a, 0x76, 0x7a, 
  0x17, 0x33, 0xb8, 0xdc, 0xd4, 0xed, 0x7b, 0xc6, 0x0f, 0xc4, 0x26, 0x63, 
  0xf7, 0x04, 0xc9, 0x94, 0xc9, 0xa0, 0xb7, 0xb8, 0xa1, 0x3e, 0x7a, 0xd1, 
  0x35, 0x6b, 0x29, 0x63, 0x1a, 0x7a, 0x8b, 0x83, 0x4e, 0xe5, 0xf1, 0x17, 
  0xe7, 0xf1, 0x55, 0x9c, 0xcc, 0x7e, 0xb3, 0xb7, 0x73, 0x11, 0x5f, 0x2f, 
  0x67, 0xf1, 0x6f, 0xf1, 0xe2, 0x8b, 0x47, 0x8f, 0xf6, 0x76, 0xfe, 0xf0, 
  0xf9, 0x4e, 0x2f, 0xfa, 0x4b, 0x0b, 0xaf, 0x27, 0x34, 0x6a, 0xa3, 0x5a, 
  0x10, 0x33, 0x5e, 0xf4, 0x33, 0x9a, 0x5c, 0xc3, 0x16, 0xff, 0x15, 0xcb, 
  0x2e, 0xba, 0x06, 0x31, 0x22, 0x7d, 0x85, 0x4f, 0x0a, 0xc8, 0x3d, 0x23, 
  0x21, 0x10, 0x5d, 0xff, 0x7a, 0xf7, 0x99, 0xb0, 0xb2, 0x6b, 0x58, 0x50, 
  0x62, 0xa1, 0xd8, 0xe8, 0x79, 0x9a, 0xd1, 0x15, 0xf4, 0x45, 0x54, 0xc5, 
  0xd7, 0x8e, 0x56, 0xd1, 0x82, 0x2b, 0x1c, 0x64, 0x56, 0xc1, 0xab, 0x14, 
  0xd5, 0x51, 0x46, 0xd1, 0xe6, 0xa5, 0x20, 0xd9, 0x40, 0xee, 0x59, 0x24, 
  0xc5, 0x4c, 0x92, 0x98, 0xe2, 0xb9, 0x05, 0x2a, 0xf0, 0xfb, 0xec, 0x86, 
  0x1a, 0x2d, 0x66, 0x56, 0x25, 0x56, 0xec, 0x4c, 0xa9, 0x27, 0xb8, 0xd9, 
  0xa2, 0xf4, 0xd8, 0xd6, 0x72, 0xdf, 0x84, 0x18, 0x39, 0xb4, 0x58, 0x80, 
  0x33, 0xed, 0x61, 0x56, 0xc2, 0x32, 0xc0, 0xcd, 0xa6, 0x36, 0xd3, 0x11, 
  0x7e, 0x47, 0x5d, 0x01, 0xad, 0xe5, 0xd2, 0x5b, 0x48, 0xd0, 0xaf, 0x43, 
  0xb0, 0x15, 0x7b, 0x54, 0x5a, 0x9b, 0x57, 0xec, 0x7d, 0xd2, 0xd1, 0x73, 
  0x53, 0x6f, 0x77, 0xbf, 0x78, 0x01, 0x82, 0xd8, 0xfd, 0xe2, 0xb7, 0xee, 
  0xb3, 0x3d, 0xfd, 0x6c, 0xef, 0x8b, 0xdf, 0x8e, 0x46, 0x18, 0x1f, 0x53, 
  0x48, 0xdf, 0xbe, 0xee, 0x6b, 0x3a, 0x4c, 0xac, 0x47, 0x58, 0xfe, 0x72, 
  0x00, 0x04, 0xb2, 0xd7, 0x3d, 0xeb, 0x39, 0x5c, 0xe5, 0x81, 0xc2, 0x93, 
  0x54, 0xbe, 0x14, 0xb9, 0x05, 0xeb, 0x55, 0x70, 0x78, 0x74, 0x2c, 0xba, 
  0x33, 0x66, 0xa1, 0x9d, 0x32, 0xa8, 0x63, 0xfe, 0x3b, 0xa6, 0xd4, 0xdf, 
  0x6d, 0x20, 0xad, 0x98, 0xb6, 0x81, 0xb7, 0x03, 0xa5, 0x26, 0x22, 0x23, 
  0x5b, 0xa9, 0x4f, 0x26, 0x70, 0x3b, 0xdc, 0x32, 0x07, 0x0e, 0xf0, 0x25, 
  0x18, 0xe0, 0xb1, 0xfe, 0x5e, 0x8d, 0xa4, 0xb2, 0xe1, 0x1b, 0x16, 0xd0, 
  0x2b, 0xe1, 0xe3, 0x82, 0xba, 0xaa, 0x9b, 0xf5, 0x9b, 0xef, 0xbe, 0x53, 
  0x79, 0x8a, 0x7e, 0xd1, 0x71, 0xdf, 0x10, 0x27, 0x9a, 0x12, 0x73, 0x63, 
  0xf0, 0x59, 0x6a, 0x5c, 0x80, 0x76, 0xf5, 0xc6, 0xbf, 0xd2, 0x79, 0x4a, 
  0x23, 0xb4, 0xb1, 0x52, 0x30, 0x86, 0x47, 0x86, 0x25, 0x3d, 0x14, 0x26, 
  0x06, 0xca, 0xdc, 0x84, 0x5b, 0xc4, 0x3b, 0x19, 0x43, 0xc2, 0xe7, 0x9d, 
  0xc3, 0xa6, 0x83, 0xf6, 0xa9, 0x31, 0x53, 0x80, 0x75, 0x23, 0x41, 0xb1, 
  0x22, 0xe4, 0xbc, 0xe8, 0xc9, 0x83, 0xd7, 0x69, 0x4f, 0x4d, 0x91, 0xf2, 
  0x49, 0xcf, 0xe7, 0x36, 0xc9, 0x6e, 0x60, 0xcb, 0x5e, 0x88, 0xe4, 0x94, 
  0xfe, 0x94, 0xbc, 0xd8, 0xdd, 0xe9, 0x7e, 0x82, 0xd5, 0x22, 0x94, 0x13, 
  0x7c, 0xe1, 0xcd, 0x5f, 0x0f, 0x3d, 0x9f, 0x4e, 0xe5, 0x69, 0xad, 0x11, 
  0x01, 0xc0, 0xe0, 0x17, 0xbd, 0x31, 0xdf, 0xaf, 0xfc, 0xff, 0x6b, 0xc6, 
  0x81, 0x78, 0x08, 0x7d, 0xb6, 0x5c, 0x8e, 0xe7, 0x69, 0x6d, 0xc0, 0xdb, 
  0x3c, 0xc1, 0x2f, 0x60, 0x4c, 0x49, 0x1c, 0x6d, 0x20, 0x50, 0x46, 0x44, 
  0xbf, 0xfe, 0x55, 0x9e, 0x8f, 0xe3, 0xa2, 0xaf, 0xe6, 0x3e, 0x1b, 0x67, 
  0x7f, 0x77, 0xef, 0xd1, 0xe3, 0x27, 0xfd, 0x91, 0x8a, 0x69, 0x60, 0x10, 
  0xd0, 0xd0, 0x52, 0xd5, 0x64, 0xa4, 0x89, 0x58, 0x8e, 0x67, 0x58, 0xdc, 
  0xac, 0xd3, 0x2c, 0xce, 0x3c, 0x8c, 0xbb, 0x7b, 0x21, 0xbd, 0xfd, 0x96, 
  0xfb, 0x79, 0x81, 0x2e, 0x7e, 0x9b, 0x4e, 0x5f, 0xb8, 0x19, 0xfe, 0x96, 
  0xe7, 0xf2, 0x42, 0x27, 0x41, 0xfb, 0x6a, 0x31, 0x74, 0x65, 0x08, 0xae, 
  0xf0, 0xa1, 0xcd, 0xb5, 0x4d, 0xdc, 0xc0, 0xa4, 0x6f, 0xa0, 0x22, 0x4e, 
  0xc5, 0x50, 0x08, 0x61, 0xd5, 0x47, 0x77, 0x6d, 0xbf, 0x1f, 0x52, 0x2b, 
  0x43, 0x6e, 0x65, 0xe8, 0xd9, 0x75, 0x34, 0xe7, 0xb0, 0x59, 0xde, 0x88, 
  0x81, 0xc6, 0x14, 0xce, 0x60, 0xe5, 0x50, 0x41, 0x20, 0xcf, 0x11, 0x31, 
  0x76, 0xf0, 0xfa, 0xa8, 0xaf, 0xce, 0x2a, 0xd1, 0xdb, 0xd4, 0x58, 0x5d, 
  0x57, 0x31, 0xc5, 0x12, 0x5d, 0x24, 0x96, 0x8b, 0xbb, 0x11, 0x14, 0x18, 
  0xc7, 0xce, 0x0c, 0x71, 0x14, 0x51, 0x72, 0x52, 0xee, 0x9c, 0x59, 0x0c, 
  0xa8, 0x62, 0x00, 0xbd, 0x05, 0xcd, 0x00, 0xf7, 0x42, 0x9c, 0x30, 0xd0, 
  0x8c, 0x3d, 0x4c, 0xdc, 0xf0, 0x95, 0xb3, 0x5b, 0xbb, 0x40, 0x31, 0x7d, 
  0x94, 0xbe, 0x12, 0x6e, 0x62, 0x0c, 0xa2, 0x37, 0xb2, 0x7a, 0x1b, 0x42, 
  0x09, 0x21, 0xef, 0x80, 0xd5, 0x1d, 0x09, 0x4f, 0x1e, 0xa7, 0x5b, 0xc4, 
  0x42, 0xe6, 0x9e, 0xcf, 0x1d, 0xfe, 0xf6, 0x17, 0x11, 0x20, 0x5a, 0xe5, 
  0x2d, 0x0d, 0xa3, 0x52, 0x03, 0x90, 0x18, 0x6b, 0xf1, 0x92, 0x6a, 0x07, 
  0xce, 0x46, 0x1f, 0x78, 0xb0, 0x54, 0x2c, 0x90, 0x16, 0x64, 0xa2, 0xb4, 
  0x9e, 0x62, 0x07, 0xe0, 0x16, 0xfa, 0x7f, 0xc4, 0x21, 0x78, 0x3e, 0x07, 
  0x38, 0x24, 0xfd, 0xfa, 0x45, 0x5f, 0x8c, 0x77, 0xb5, 0x8a, 0x83, 0x0d, 
  0x1f, 0x80, 0x10, 0x68, 0x38, 0x9f, 0xfc, 0xca, 0xe1, 0x16, 0x88, 0x2c, 
  0x96, 0x66, 0x0a, 0x58, 0x40, 0xb2, 0xd4, 0x8c, 0x83, 0x08, 0x59, 0xac, 
  0x54, 0x59, 0x68, 0xa0, 0x8d, 0x27, 0x1c, 0xb4, 0xc6, 0xb2, 0x63, 0x9f, 
  0xdd, 0xc3, 0x78, 0xaf, 0xef, 0xf3, 0x74, 0x73, 0xa8, 0x55, 0x6c, 0x2c, 
  0x48, 0x02, 0xf0, 0x78, 0xa9, 0x4f, 0xeb, 0x64, 0xf9, 0x70, 0x62, 0x65, 
  0x20, 0x3a, 0xf8, 0x50, 0x33, 0x49, 0x61, 0x6b, 0x1d, 0x91, 0x57, 0x1c, 
  0x10, 0xab, 0x9d, 0xbe, 0xe0, 0xe5, 0xde, 0x1d, 0x5d, 0xa7, 0x57, 0xb2, 
  0x18, 0xc4, 0x22, 0xaf, 0x93, 0x6d, 0xfa, 0x93, 0x2b, 0xdb, 0xed, 0xb1, 
  0x4c, 0xc6, 0xbf, 0x3c, 0x82, 0x0f, 0x33, 0xbc, 0xf9, 0x83, 0xb3, 0xe1, 
  0xce, 0x05, 0xff, 0x92, 0xba, 0x1b, 0x5f, 0xe1, 0xf0, 0x74, 0x94, 0x20, 
  0x73, 0x83, 0x3d, 0x0b, 0x10, 0xf0, 0x82, 0xc2, 0x97, 0x05, 0xa4, 0x24, 
  0x96, 0x1a, 0x4a, 0x1f, 0xe0, 0xa1, 0xc8, 0xfb, 0x3e, 0x4c, 0x78, 0x33, 
  0x55, 0x7b, 0x09, 0x07, 0xc0, 0xe1, 0x5e, 0x4d, 0xee, 0xb7, 0x00, 0x15, 
  0x63, 0xea, 0xad, 0xd5, 0x5e, 0x0e, 0x03, 0xf8, 0x65, 0xf7, 0x37, 0x15, 
  0xf2, 0x94, 0xa3, 0xcb, 0xe2, 0x02, 0x71, 0xb1, 0xd8, 0xe6, 0xb4, 0xb9, 
  0x83, 0x71, 0x91, 0xd4, 0xdd, 0xd1, 0x12, 0xf1, 0xb0, 0x85, 0x22, 0x7d, 
  0xb3, 0x12, 0xaa, 0xba, 0x82, 0x2d, 0xfb, 0x75, 0xb7, 0xbc, 0x6c, 0x74, 
  0xd5, 0x67, 0xec, 0xf5, 0x6d, 0x78, 0x2e, 0x84, 0xb7, 0x1d, 0xd2, 0x71, 
  0x44, 0xe9, 0x01, 0xdc, 0x97, 0x43, 0xb9, 0x2f, 0x55, 0x08, 0x1a, 0xbe, 
  0x1a, 0x45, 0xc7, 0x88, 0x75, 0x28, 0xe3, 0x15, 0xc8, 0xd9, 0xee, 0x54, 
  0xa3, 0x00, 0x22, 0x17, 0x91, 0xba, 0x37, 0x24, 0x4d, 0x6a, 0x14, 0x9d, 
  0x66, 0x46, 0x46, 0x00, 0x70, 0xf2, 0x7a, 0xa6, 0x48, 0x14, 0x2a, 0x81, 
  0x0c, 0x60, 0x7f, 0x76, 0xcf, 0xa1, 0xa2, 0x28, 0x9e, 0x92, 0x42, 0x69, 
  0x8e, 0x48, 0x83, 0x46, 0x5c, 0x8d, 0x38, 0x16, 0x39, 0x03, 0x56, 0xee, 
  0x08, 0x5f, 0xd2, 0x7e, 0x12, 0xd4, 0x7c, 0x73, 0x95, 0x98, 0xe1, 0x32, 
  0xa1, 0xd6, 0x40, 0x59, 0x3c, 0x77, 0x26, 0x9d, 0x1e, 0x34, 0xc5, 0x59, 
  0xe2, 0xf4, 0x69, 0x05, 0x48, 0x94, 0x60, 0x2b, 0x4b, 0x54, 0x15, 0x01, 
  0xc3, 0xe7, 0xb8, 0xf3, 0x20, 0x79, 0x5c, 0xf1, 0x1d, 0xfd, 0xc2, 0x97, 
  0xfc, 0xb8, 0xa0, 0x9d, 0xb6, 0xd2, 0x98, 0xe8, 0x35, 0xc4, 0xe0, 0xff, 
  0xea, 0xf2, 0xcd, 0x71, 0x54, 0xd2, 0xa3, 0x93, 0xc4, 0x25, 0x26, 0xf1, 
  0xca, 0x5a, 0x04, 0x03, 0xa6, 0xa8, 0xc6, 0x10, 0x91, 0x80, 0xf4, 0x29, 
  0xb9, 0xd9, 0x64, 0x6d, 0x39, 0xd4, 0x3b, 0xe2, 0xc5, 0xa9, 0x1d, 0xd3, 
  0xe0, 0x09, 0x79, 0x75, 0x43, 0x62, 0xc3, 0xfa, 0xbc, 0x04, 0xfd, 0x41, 
  0xd4, 0xe7, 0xa1, 0xf2, 0x17, 0x7d, 0xac, 0x27, 0x3e, 0x0e, 0x96, 0xaf, 
  0x3f, 0xea, 0x38, 0x79, 0xfc, 0xcc, 0x8b, 0x3f, 0xd7, 0x56, 0x09, 0x9f, 
  0x5b, 0x53, 0x2f, 0x24, 0x62, 0xac, 0x25, 0x65, 0xdb, 0xbb, 0x41, 0xfb, 
  0x2f, 0x0e, 0xa8, 0x15, 0x01, 0xf9, 0x97, 0x3d, 0x81, 0x40, 0xed, 0x3e, 
  0x4b, 0x11, 0x4d, 0xd9, 0x6a, 0xe8, 0xc3, 0x27, 0xf7, 0xd2, 0xd8, 0x8f, 
  0x0b, 0x95, 0x10, 0x8e, 0x26, 0x24, 0x60, 0xdc, 0x96, 0x76, 0x33, 0x15, 
  0x4d, 0xef, 0x3e, 0x87, 0x5d, 0x01, 0x7c, 0x66, 0x77, 0x14, 0x5d, 0xf0, 
  0xbb, 0x8d, 0xfa, 0x9d, 0x69, 0xa0, 0xae, 0xf7, 0xb0, 0xa0, 0x3d, 0xb3, 
  0x93, 0x38, 0x25, 0xde, 0x56, 0xb9, 0x6d, 0x0a, 0xa6, 0xa9, 0x6b, 0x75, 
  0x4b, 0xe2, 0x57, 0xd3, 0xfc, 0x9a, 0xd9, 0xd5, 0x80, 0x6e, 0x56, 0xfe, 
  0xd9, 0x8b, 0xf0, 0xf8, 0x9e, 0xf6, 0x2b, 0x63, 0xc6, 0x71, 0x11, 0xd1, 
  0xdd, 0xfe, 0xd6, 0x68, 0x8e, 0xa8, 0x63, 0x4b, 0xa6, 0xf9, 0x44, 0x9b, 
  0x77, 0xad, 0xcb, 0x9e, 0x50, 0x17, 0xee, 0x0b, 0xdf, 0xdd, 0xc6, 0xf9, 
  0xe1, 0xab, 0xc3, 0xf3, 0x73, 0x71, 0x40, 0xee, 0xd7, 0x50, 0x65, 0x91, 
  0x15, 0x2d, 0x51, 0xda, 0x56, 0x38, 0xd7, 0x82, 0x37, 0x42, 0xcb, 0x81, 
  0x45, 0xbd, 0xf1, 0x41, 0x55, 0xd4, 0x89, 0x8d, 0xc8, 0xbc, 0x7e, 0x82, 
  0x1f, 0x23, 0x06, 0x4b, 0x58, 0xbb, 0x10, 0xba, 0xe3, 0xec, 0xca, 0x33, 
  0xe6, 0x7a, 0xb0, 0x87, 0xd5, 0xee, 0xba, 0x8d, 0xc8, 0x5e, 0x2d, 0x04, 
  0x11, 0xdb, 0xd5, 0xe3, 0x6d, 0xd7, 0x84, 0x95, 0x68, 0x8b, 0x44, 0x7d, 
  0x79, 0x33, 0xa7, 0x2d, 0xe3, 0x62, 0xbe, 0x62, 0xfa, 0x61, 0x49, 0xbe, 
  0x60, 0x07, 0x77, 0x59, 0x2d, 0x17, 0xe9, 0xd4, 0x19, 0x1f, 0xe9, 0x73, 
  0x12, 0x47, 0x22, 0xa1, 0xc0, 0xd2, 0x46, 0x0c, 0x2f, 0x97, 0xa9, 0xc6, 
  0xa1, 0xed, 0x47, 0x12, 0xc6, 0xbc, 0xe5, 0x06, 0xb1, 0x99, 0x52, 0x24, 
  0xc4, 0x00, 0x35, 0xf9, 0xf0, 0xb7, 0x8e, 0x49, 0x02, 0xa3, 0x17, 0x53, 
  0xb2, 0x79, 0x4e, 0x43, 0xaa, 0x65, 0xcb, 0xca, 0xdc, 0xc7, 0x2c, 0xf9, 
  0xb2, 0x0c, 0x58, 0x00, 0xf0, 0x74, 0xe5, 0x68, 0x08, 0xfc, 0xf2, 0xf1, 
  0x44, 0xe2, 0x62, 0xa5, 0x59, 0xeb, 0x0a, 0xa9, 0x4e, 0xc6, 0x95, 0xa8, 
  0x39, 0x3c, 0xe7, 0xf0, 0x3c, 0xda, 0x7f, 0xcd, 0xc8, 0x14, 0xff, 0xde, 
  0xb6, 0xf2, 0x73, 0xca, 0xb1, 0x6c, 0x53, 0x35, 0x61, 0x24, 0x31, 0x8b, 
  0xac, 0xe4, 0xc3, 0xd6, 0x76, 0x14, 0xf0, 0xe9, 0xf5, 0x4a, 0x27, 0xf5, 
  0xbd, 0xdb, 0x88, 0x3e, 0xb8, 0x7b, 0x1f, 0xb3, 0x77, 0xac, 0x7b, 0x86, 
  0xbb, 0x87, 0xab, 0x54, 0x2d, 0xe3, 0xb6, 0x27, 0x3a, 0xfa, 0xb2, 0xa5, 
  0xfe, 0xc8, 0xee, 0xec, 0x47, 0xfd, 0x37, 0xf9, 0x4f, 0x74, 0x41, 0xc5, 
  0xdb, 0x8f, 0x46, 0x3b, 0xd1, 0xe6, 0xb7, 0x69, 0xf6, 0xf4, 0xc9, 0x1f, 
  0xa3, 0xa3, 0xad, 0x7e, 0x2d, 0x10, 0x4b, 0x80, 0x2c, 0xc7, 0x71, 0x76, 
  0xeb, 0xb6, 0xea, 0x14, 0x76, 0x74, 0x71, 0xfe, 0x1b, 0xc6, 0xda, 0x33, 
  0xec, 0xfd, 0xda, 0x16, 0xa5, 0x2c, 0x92, 0xc4, 0x74, 0x45, 0xdf, 0x38, 
  0xc0, 0x1f, 0xd6, 0x35, 0xe9, 0xa9, 0x29, 0x2f, 0xdd, 0xd3, 0x27, 0xad, 
  0x26, 0x1e, 0xbb, 0x36, 0xde, 0x4a, 0x1b, 0x3f, 0xb3, 0x89, 0xbd, 0xd1, 
  0xce, 0x5e, 0xb4, 0x79, 0x7a, 0xb1, 0xbd, 0xe7, 0x5a, 0x68, 0x37, 0xb1, 
  0x87, 0x26, 0xf8, 0xa1, 0xfa, 0xcb, 0x8f, 0xb9, 0xff, 0x1f, 0x92, 0xec, 
  0xc7, 0x68, 0xf3, 0xbb, 0xdd, 0x5d, 0x6a, 0xe0, 0x8f, 0xd1, 0xfe, 0xd1, 
  0x77, 0xd1, 0xe3, 0x11, 0x35, 0x76, 0x12, 0xdf, 0x69, 0x73, 0x8a, 0x79, 
  0x71, 0x81, 0x46, 0xe8, 0xfb, 0x56, 0x1b, 0x4f, 0x1a, 0x6d, 0x1c, 0x93, 
  0x7e, 0xf2, 0x9e, 0xf8, 0xdc, 0xce, 0xe8, 0xd1, 0x5e, 0x94, 0x3e, 0xf9, 
  0xfc, 0x33, 0x6b, 0x48, 0xdb, 0xc0, 0xf7, 0x75, 0x9b, 0x99, 0x64, 0x6d, 
  0xd0, 0xf5, 0x7b, 0xf8, 0x9e, 0xc4, 0x78, 0xb0, 0x06, 0x20, 0xd2, 0xdd, 
  0xc4, 0x52, 0xf8, 0x72, 0x2c, 0x78, 0xd0, 0xb4, 0x53, 0x62, 0x57, 0x65, 
  0x03, 0x39, 0x12, 0x65, 0x56, 0xcf, 0x5a, 0xc3, 0x61, 0x1d, 0xc9, 0x1e, 
  0xfd, 0x63, 0xf4, 0xe6, 0xe2, 0xe8, 0x90, 0x66, 0xb4, 0x43, 0x43, 0xf3, 
  0x6b, 0x28, 0x03, 0xc2, 0x57, 0x58, 0x5c, 0x5a, 0xd5, 0x0d, 0x2e, 0x95, 
  0x88, 0x36, 0x42, 0xc8, 0x5b, 0x10, 0x1d, 0x5d, 0x26, 0x25, 0xfa, 0xe5, 
  0xac, 0xcb, 0xe1, 0xfe, 0x35, 0x8b, 0xb2, 0xca, 0xfe, 0xb9, 0xeb, 0xaf, 
  0xf3, 0x8c, 0x8e, 0x49, 0x91, 0x17, 0xdb, 0xbb, 0xa3, 0x9d, 0x7e, 0xed, 
  0x06, 0xfb, 0xfa, 0xe5, 0x61, 0xf4, 0x8a, 0x2f, 0xbc, 0x37, 0x71, 0x16, 
  0x5f, 0x23, 0xd3, 0xb2, 0xbc, 0x65, 0x3f, 0xb0, 0x78, 0x15, 0xe4, 0xfd, 
  0xe3, 0x55, 0xf6, 0x9e, 0xf6, 0xf1, 0x0f, 0xa3, 0x5d, 0x4e, 0x00, 0x62, 
  0xed, 0xeb, 0xd5, 0x1b, 0xfa, 0x7b, 0xf7, 0x71, 0x3f, 0xe2, 0xaf, 0xea, 
  0x9a, 0xa4, 0x9d, 0xd7, 0x8d, 0x83, 0xd3, 0xd3, 0xaf, 0x8f, 0x24, 0x24, 
  0xe0, 0x40, 0x8d, 0x7b, 0x7c, 0xe1, 0x3b, 0xed, 0x4c, 0xb8, 0x2a, 0x69, 
  0x11, 0x1c, 0x23, 0x69, 0x27, 0x8b, 0x56, 0xf2, 0x36, 0x49, 0x16, 0x00, 
  0xe4, 0x69, 0x70, 0x04, 0x2b, 0xea, 0x21, 0x23, 0x63, 0x01, 0x2f, 0x9d, 
  0x26, 0x0d, 0xc4, 0x84, 0xaa, 0x74, 0x86, 0xc4, 0xf1, 0xca, 0xe5, 0x1d, 
  0xc4, 0xce, 0x73, 0x63, 0x55, 0xf3, 0xb4, 0x29, 0x33, 0x84, 0x4a, 0x89, 
  0x39, 0x7a, 0x51, 0x75, 0xb0, 0xfe, 0x45, 0x52, 0x0d, 0x65, 0xd0, 0xcf, 
  0xd4, 0x76, 0xd8, 0x57, 0x43, 0x88, 0x33, 0xe3, 0x2c, 0x14, 0xcf, 0x0f, 
  0x06, 0xcc, 0xd5, 0x82, 0x2b, 0xa1, 0x70, 0xe5, 0x77, 0xe1, 0xc9, 0xa8, 
  0xf0, 0x94, 0x20, 0x70, 0xe9, 0x64, 0xff, 0xcd, 0xe1, 0x8b, 0x6f, 0xf6, 
  0x8f, 0xdf, 0x1e, 0xa2, 0x48, 0x78, 0x19, 0x6d, 0x7a, 0x30, 0x16, 0x8c, 
  0x71, 0x9e, 0x4e, 0xf2, 0x19, 0x3b, 0x3b, 0xfa, 0x7f, 0xec, 0x83, 0x33, 
  0xd1, 0x00, 0x7a, 0xfc, 0xd6, 0xae, 0xbc, 0x46, 0x74, 0xc1, 0x7f, 0xed, 
  0xc9, 0x5f, 0x7b, 0x7f, 0xec, 0x6d, 0xd5, 0x26, 0xdd, 0xd2, 0xd6, 0x98, 
  0x5e, 0xee, 0x25, 0x32, 0x89, 0x03, 0xc7, 0x30, 0xe2, 0x9e, 0xac, 0x4a, 
  0xcf, 0x3c, 0x05, 0x76, 0xa7, 0xf1, 0xb3, 0x9b, 0xe3, 0x55, 0xa8, 0x0b, 
  0xf6, 0xf8, 0xa5, 0x17, 0x30, 0x4d, 0xf4, 0x38, 0x1e, 0xfd, 0x26, 0xb1, 
  0xd5, 0x92, 0x36, 0xac, 0x89, 0xe4, 0xfd, 0x82, 0xa3, 0x58, 0x36, 0x7b, 
  0xf2, 0xcb, 0x8b, 0x97, 0xfb, 0x97, 0x87, 0xfc, 0x82, 0x75, 0x1f, 0x49, 
  0x04, 0x9b, 0x43, 0xb3, 0xe1, 0xf1, 0x6c, 0xf6, 0xe4, 0xc3, 0x17, 0x3c, 
  0xa1, 0xde, 0x96, 0x58, 0xd4, 0xe1, 0x6d, 0x6d, 0x8c, 0x2b, 0xcf, 0x34, 
  0x0c, 0xcc, 0xb2, 0xfd, 0xe0, 0x0d, 0xd2, 0xc8, 0x85, 0xcd, 0x9e, 0x7c, 
  0xd7, 0x73, 0x76, 0x44, 0x2d, 0x7c, 0xe3, 0x0a, 0x7a, 0xc6, 0x5d, 0x01, 
  0xdb, 0x02, 0x3e, 0xed, 0xf7, 0x47, 0x4d, 0xe6, 0x62, 0xf9, 0x08, 0x00, 
  0x79, 0xdc, 0xc6, 0x97, 0x02, 0xd0, 0xc8, 0xb6, 0x8e, 0x3c, 0xdf, 0xdd, 
  0x7b, 0xf4, 0x47, 0xac, 0xe7, 0x8b, 0xde, 0x36, 0xdd, 0x0d, 0xbd, 0x3f, 
  0x72, 0xd7, 0x69, 0xe5, 0x80, 0xad, 0xdd, 0x7e, 0xb0, 0x8c, 0xaf, 0x14, 
  0x25, 0x61, 0x13, 0x28, 0x0d, 0xcf, 0xb6, 0x13, 0x99, 0x17, 0x16, 0xf4, 
  0x5e, 0x22, 0x7c, 0x2d, 0x9d, 0xc7, 0xbc, 0xca, 0xd8, 0x2f, 0x54, 0xe0, 
  0xc8, 0x1c, 0xd2, 0x9a, 0x74, 0x17, 0xde, 0x1f, 0x03, 0x05, 0x08, 0xc5, 
  0x1c, 0xb5, 0xee, 0x0e, 0xf7, 0x39, 0x5f, 0x59, 0x10, 0x70, 0x59, 0x9a, 
  0xaa, 0x25, 0x7b, 0xd6, 0x52, 0x5b, 0xc7, 0x6a, 0x63, 0x30, 0x01, 0x19, 
  0xb2, 0x00, 0xb1, 0x96, 0x15, 0x04, 0x24, 0xad, 0xa8, 0xee, 0xbd, 0xef, 
  0x76, 0x67, 0xc7, 0x63, 0xce, 0x62, 0x30, 0x98, 0xf3, 0x50, 0x3b, 0x74, 
  0x4b, 0x6f, 0xc7, 0x2f, 0x0d, 0xf2, 0xb4, 0xf8, 0xa2, 0x94, 0xb5, 0x2c, 
  0x9d, 0x2d, 0x03, 0x3e, 0x2f, 0x7d, 0xb6, 0xbe, 0x4f, 0x8d, 0x58, 0x62, 
  0x4c, 0x43, 0x54, 0x4b, 0xd1, 0xd9, 0x88, 0xd5, 0x64, 0x49, 0xf1, 0xa0, 
  0xe7, 0xbd, 0xc3, 0x25, 0x82, 0x29, 0xaa, 0x46, 0x62, 0x13, 0x1c, 0x8d, 
  0x46, 0x4e, 0x04, 0x87, 0x3b, 0x47, 0x3d, 0x21, 0x80, 0xf3, 0xaa, 0x21, 
  0x4c, 0xd0, 0x1a, 0x33, 0x4c, 0x82, 0xe6, 0xfa, 0x6f, 0x69, 0x40, 0xc6, 
  0xd2, 0x21, 0x69, 0xd4, 0x66, 0xc2, 0x2b, 0xd5, 0xd7, 0x6e, 0xfb, 0xeb, 
  0xa3, 0x4e, 0x69, 0x13, 0x1e, 0x18, 0x9b, 0xd8, 0xc0, 0xca, 0x18, 0x79, 
  0x50, 0x8e, 0x4f, 0xe5, 0x6e, 0x2d, 0x98, 0x82, 0x39, 0x37, 0x0a, 0x74, 
  0x22, 0x81, 0xb1, 0xb2, 0x68, 0x3a, 0x14, 0x05, 0xc4, 0x67, 0x26, 0x97, 
  0xdf, 0xf3, 0x5d, 0xa4, 0x05, 0x08, 0x17, 0x05, 0x6b, 0x1f, 0xbc, 0xc6, 
  0x76, 0x83, 0x08, 0xce, 0x22, 0xc7, 0x0e, 0x4a, 0x33, 0x53, 0xb1, 0x18, 
  0xb2, 0x1a, 0x07, 0x3d, 0x52, 0x03, 0xd4, 0x35, 0xc1, 0xae, 0x8c, 0x15, 
  0xde, 0xc3, 0x15, 0x4e, 0xb7, 0xb9, 0x7b, 0xed, 0x9d, 0x83, 0x8e, 0x86, 
  0x92, 0x54, 0x67, 0x31, 0xe4, 0xc6, 0x3c, 0xb4, 0x04, 0xdb, 0x43, 0x5e, 
  0xdb, 0x89, 0xb5, 0xe8, 0x5c, 0xb6, 0x8d, 0xa5, 0xf1, 0x97, 0x72, 0x9d, 
  0x73, 0xd1, 0x82, 0x8a, 0x91, 0xd3, 0xa1, 0xad, 0x29, 0xdb, 0x8b, 0xe2, 
  0x7b, 0xba, 0x79, 0x32, 0x22, 0x41, 0xf1, 0xde, 0x88, 0xa1, 0xe0, 0x38, 
  0x30, 0x77, 0xb9, 0x19, 0x5a, 0x49, 0xac, 0x38, 0x28, 0x8a, 0xa5, 0x28, 
  0x7a, 0xf9, 0x15, 0x2b, 0xe7, 0x66, 0x57, 0x4a, 0x81, 0x9e, 0xce, 0x88, 
  0x1f, 0x2a, 0xa0, 0x9b, 0xc6, 0xc8, 0x23, 0x27, 0x0e, 0x7d, 0x91, 0xbb, 
  0xc2, 0xbd, 0xb1, 0x78, 0x42, 0xc4, 0xbb, 0x6f, 0xab, 0x85, 0x7a, 0x2b, 
  0xae, 0x93, 0x41, 0x10, 0xae, 0xcc, 0x54, 0xc5, 0xe5, 0xdd, 0xb2, 0xa1, 
  0xcb, 0xa5, 0x72, 0x21, 0x41, 0x45, 0x7a, 0x2d, 0xa5, 0x0d, 0xdd, 0x82, 
  0xba, 0xa9, 0x75, 0xd3, 0xd8, 0x31, 0xaf, 0x4a, 0x32, 0x5f, 0x54, 0xab, 
  0x75, 0xab, 0x79, 0xe9, 0x4a, 0x06, 0xa9, 0x21, 0xa0, 0x46, 0xcb, 0xe6, 
  0x18, 0x73, 0xa8, 0x4f, 0x96, 0xf7, 0x82, 0xc2, 0x84, 0x35, 0x47, 0x26, 
  0x60, 0x19, 0x38, 0x2f, 0xd8, 0xa7, 0xf9, 0xd8, 0xa6, 0x23, 0xf5, 0xd9, 
  0xc7, 0x41, 0x4c, 0xd9, 0xdc, 0x39, 0xe7, 0x9b, 0xf8, 0xde, 0x85, 0xe0, 
  0x48, 0xf9, 0x86, 0x71, 0xec, 0x35, 0xad, 0x8d, 0xa8, 0x66, 0x74, 0x64, 
  0x74, 0xae, 0xa3, 0x4c, 0xd9, 0x50, 0x7e, 0x97, 0x78, 0x4c, 0x00, 0x6f, 
  0xf7, 0xf2, 0x68, 0x3a, 0x7a, 0xf8, 0x1d, 0x2f, 0x69, 0x78, 0x19, 0x1d, 
  0xbb, 0xc2, 0x24, 0x1b, 0xab, 0x32, 0x8a, 0x82, 0x26, 0x45, 0x7b, 0xcf, 
  0x43, 0x0e, 0x2f, 0x63, 0x53, 0xe7, 0xa9, 0xb5, 0xa8, 0xc1, 0xd0, 0xc0, 
  0x30, 0x0e, 0x34, 0x13, 0x5e, 0x90, 0xb4, 0x52, 0xaa, 0x2a, 0x5d, 0xe8, 
  0x96, 0x77, 0x42, 0xda, 0x2c, 0x7b, 0x6e, 0x93, 0x7a, 0x56, 0x06, 0x3c, 
  0x20, 0x02, 0xb6, 0x1b, 0x39, 0x47, 0xf2, 0xfe, 0x2c, 0xe6, 0x58, 0x8a, 
  0x5c, 0x7c, 0xd4, 0xd8, 0x33, 0x50, 0x35, 0x0c, 0x3c, 0x0d, 0x9e, 0xda, 
  0x3a, 0x7f, 0x2e, 0x66, 0x40, 0x88, 0x0d, 0x88, 0x37, 0xdc, 0x0c, 0x91, 
  0x09, 0x37, 0x32, 0x9c, 0x18, 0x73, 0x77, 0x1e, 0xf9, 0xce, 0x4c, 0x98, 
  0x71, 0xed, 0x90, 0x7e, 0xe8, 0xcc, 0x9e, 0x9d, 0x9f, 0xbe, 0x3e, 0x3f, 
  0xbc, 0xb8, 0x88, 0xde, 0x1c, 0x5e, 0x8a, 0xae, 0x7f, 0x19, 0x62, 0x21, 
  0xc2, 0xfc, 0x6d, 0x20, 0x70, 0x16, 0x03, 0x11, 0x8b, 0xab, 0x43, 0xf0, 
  0xe7, 0x72, 0x76, 0xed, 0x40, 0x94, 0x83, 0x1e, 0x3f, 0xd3, 0xa8, 0xae, 
  0x1b, 0x18, 0xa0, 0x11, 0x65, 0x03, 0x0f, 0x99, 0xb3, 0xe7, 0x7a, 0x2b, 
  0x5f, 0x50, 0xfe, 0xf1, 0xc6, 0x58, 0x97, 0xb7, 0xea, 0x6a, 0xfd, 0x3c, 
  0x4c, 0xef, 0x37, 0xd1, 0xa5, 0xd5, 0x97, 0xfb, 0x4d, 0x74, 0x6e, 0x04, 
  0xf2, 0x9b, 0xe8, 0x3b, 0x6a, 0x73, 0xca, 0xc5, 0xff, 0xa4, 0x76, 0xcc, 
  0x05, 0x6a, 0xc6, 0x78, 0x18, 0x08, 0x00, 0x98, 0x07, 0xff, 0x11, 0x99, 
  0x17, 0xa3, 0x87, 0xab, 0xb0, 0x20, 0x99, 0x51, 0xea, 0xd2, 0x68, 0x8c, 
  0x97, 0xeb, 0xf9, 0x00, 0x65, 0x0b, 0xab, 0x28, 0x3a, 0x4e, 0xae, 0x2a, 
  0x08, 0x24, 0xdc, 0x1d, 0x35, 0xb7, 0xc3, 0x00, 0x4c, 0xbb, 0x5c, 0x2c, 
  0x97, 0x7e, 0x7d, 0xf4, 0xf9, 0x67, 0x3b, 0x9f, 0xcb, 0xaf, 0xf6, 0xef, 
  0xd3, 0xc7, 0x3b, 0x8a, 0x71, 0x46, 0x7f, 0x3d, 0x7e, 0xf6, 0x78, 0xf7, 
  0x19, 0xa7, 0xb2, 0xef, 0x3c, 0xdb, 0xa1, 0xff, 0x7f, 0xac, 0x9f, 0x30, 
  0x06, 0xc0, 0xd3, 0xbd, 0xcf, 0xff, 0x80, 0xf0, 0x0c, 0xa6, 0x8f, 0x19, 
  0x75, 0x32, 0xac, 0xf2, 0x61, 0xc1, 0xf5, 0x35, 0x20, 0x04, 0xfd, 0xa6, 
  0x6e, 0x28, 0x63, 0x7f, 0xef, 0x84, 0xfd, 0x7b, 0xd7, 0x49, 0x50, 0xf7, 
  0x54, 0x8d, 0x7e, 0x92, 0x62, 0x19, 0xa2, 0x22, 0xb9, 0x69, 0xe8, 0xdb, 
  0x52, 0x6f, 0x08, 0xf9, 0xa7, 0xb5, 0x77, 0x48, 0x64, 0xa4, 0xab, 0x35, 
  0x48, 0x74, 0xfd, 0xb9, 0x5d, 0x87, 0xf5, 0x05, 0xdc, 0x56, 0xe9, 0x7b, 
  0x52, 0xf9, 0x91, 0x8b, 0x93, 0x04, 0x45, 0x92, 0x1a, 0x35, 0x8f, 0x7e, 
  0x6e, 0x7f, 0xe2, 0xba, 0xe1, 0xb7, 0x94, 0x1a, 0xa2, 0x76, 0x6f, 0x56, 
  0xfc, 0xa9, 0xab, 0xaf, 0x1a, 0xf1, 0x6c, 0xf8, 0xed, 0xf7, 0x2b, 0x15, 
  0xd4, 0x48, 0x72, 0xd9, 0xbf, 0x52, 0x9e, 0xa8, 0x63, 0xca, 0xad, 0xe6, 
  0xde, 0x2e, 0xc2, 0xf6, 0x3e, 0xa6, 0x39, 0x3f, 0x23, 0x50, 0xb0, 0xdb, 
  0xb9, 0x61, 0xb0, 0x39, 0xa9, 0x84, 0x5a, 0xb9, 0x3a, 0x47, 0x35, 0xcc, 
  0x04, 0xf7, 0xaa, 0x23, 0xd9, 0xa1, 0xbc, 0xa1, 0xe2, 0x67, 0x89, 0xdc, 
  0x0a, 0x91, 0x14, 0xee, 0x72, 0x41, 0x33, 0xc7, 0xf3, 0x46, 0xd9, 0xad, 
  0xae, 0x98, 0x1a, 0xc3, 0xfe, 0xac, 0x17, 0x9c, 0x28, 0x77, 0xec, 0x1e, 
  0x9c, 0x9c, 0x0f, 0xb8, 0x76, 0x35, 0x05, 0x36, 0x5d, 0x00, 0x73, 0xd7, 
  0xa1, 0xf4, 0xcf, 0x21, 0xa6, 0x39, 0x28, 0x9b, 0xe7, 0xef, 0x22, 0xd4, 
  0x96, 0x30, 0x3c, 0xc8, 0x49, 0xbe, 0x64, 0xb8, 0xbd, 0x2d, 0x63, 0x62, 
  0xc3, 0x5f, 0xbb, 0x48, 0x22, 0x5c, 0x6d, 0x56, 0x2c, 0x58, 0x68, 0x7f, 
  0x16, 0xa6, 0xe6, 0xd4, 0x80, 0x68, 0x2b, 0x51, 0x91, 0x0c, 0x08, 0x9f, 
  0x8b, 0xa8, 0xd1, 0x65, 0x4b, 0x97, 0x47, 0x50, 0xba, 0xe4, 0x57, 0x1b, 
  0x1b, 0x17, 0x67, 0x87, 0x87, 0x2f, 0xa3, 0xe3, 0xa3, 0x37, 0x47, 0x97, 
  0x81, 0x48, 0xee, 0xee, 0x12, 0x61, 0x91, 0xb9, 0x80, 0x6d, 0xde, 0xb4, 
  0x96, 0xc3, 0x03, 0x02, 0x29, 0x14, 0xa6, 0xde, 0xe6, 0xc4, 0x4d, 0xc5, 
  0x3b, 0x37, 0x6b, 0xbe, 0x07, 0xe5, 0x1b, 0xc9, 0xc3, 0xa3, 0xe8, 0xcb, 
  0x20, 0x58, 0x2f, 0x2a, 0x49, 0xbe, 0x99, 0x70, 0x65, 0x0d, 0xb9, 0x26, 
  0xbe, 0xd7, 0xd0, 0x81, 0xba, 0xf0, 0xa4, 0xd0, 0x1a, 0xae, 0xaa, 0x86, 
  0xc6, 0x5b, 0x36, 0x46, 0xc5, 0x6b, 0x9b, 0x48, 0x00, 0x6e, 0x52, 0xab, 
  0x22, 0xc3, 0x50, 0xeb, 0x48, 0x5b, 0x9b, 0xa7, 0x92, 0x6b, 0x12, 0x37, 
  0x70, 0x91, 0xcc, 0xb3, 0x0d, 0x4e, 0x1e, 0xf6, 0x18, 0x9c, 0x0f, 0x17, 
  0xe4, 0x69, 0x7d, 0x85, 0xd5, 0x2a, 0x1e, 0xed, 0xb8, 0x18, 0x76, 0xa9, 
  0x6f, 0xa2, 0xc2, 0x3e, 0x77, 0xb6, 0x1b, 0x91, 0x48, 0xb2, 0x64, 0xb9, 
  0xbe, 0x58, 0x66, 0xad, 0x0b, 0xef, 0x7b, 0x79, 0x97, 0xe6, 0xff, 0xd9, 
  0x0e, 0x2e, 0xb8, 0xab, 0xb8, 0x18, 0x92, 0xf0, 0xb5, 0x1a, 0x9a, 0x5d, 
  0x55, 0x28, 0x02, 0x10, 0xce, 0x99, 0x44, 0x4e, 0x21, 0xf1, 0xda, 0xd7, 
  0xbf, 0x09, 0x05, 0x46, 0x9f, 0x88, 0x90, 0xc3, 0x59, 0x36, 0xd3, 0x23, 
  0xc0, 0x53, 0x1f, 0x44, 0x28, 0xc3, 0xe7, 0x62, 0x72, 0x45, 0xdc, 0xb1, 
  0x83, 0x47, 0xed, 0xd8, 0x36, 0x7a, 0x36, 0xc5, 0x71, 0xea, 0xe0, 0xac, 
  0xdc, 0x6c, 0xca, 0xf3, 0xd4, 0xc9, 0xb4, 0xc5, 0xeb, 0x79, 0xb4, 0xfb, 
  0x39, 0x4f, 0xe4, 0xe3, 0x26, 0xc4, 0x70, 0xe1, 0x16, 0x60, 0x25, 0x1a, 
  0x43, 0xee, 0xb7, 0x53, 0x82, 0xe7, 0x81, 0xef, 0x2a, 0xcb, 0x6b, 0x91, 
  0x9a, 0x08, 0x24, 0x63, 0x15, 0x45, 0xbd, 0xbc, 0x30, 0x4e, 0xc1, 0xed, 
  0x2a, 0x52, 0x12, 0xca, 0x39, 0xc9, 0xc2, 0x04, 0xa5, 0x6b, 0x0b, 0x9f, 
  0x3b, 0x84, 0x75, 0x00, 0x84, 0x5c, 0x36, 0xbd, 0x4f, 0xa7, 0x90, 0xac, 
  0xcd, 0x0e, 0x00, 0x02, 0x14, 0xea, 0x93, 0x00, 0x5e, 0x78, 0xd5, 0xe0, 
  0x8e, 0x73, 0x23, 0x53, 0x19, 0x06, 0x25, 0xaf, 0x60, 0x5f, 0xd8, 0x84, 
  0x08, 0xc1, 0x50, 0xf8, 0x75, 0xb7, 0x00, 0x73, 0xe7, 0x9e, 0xf4, 0x82, 
  0xfd, 0x28, 0xf2, 0xaa, 0x9a, 0x99, 0x65, 0xe1, 0x8d, 0x23, 0xec, 0xfa, 
  0x94, 0x39, 0xe5, 0x36, 0x98, 0xf5, 0xee, 0x0e, 0x89, 0xb0, 0xb3, 0xbc, 
  0x59, 0xe6, 0xa4, 0xad, 0x96, 0x62, 0x56, 0x43, 0x2c, 0xce, 0xee, 0xce, 
  0xd7, 0xeb, 0x17, 0x9d, 0x23, 0x7e, 0x1f, 0x7e, 0x79, 0xef, 0xf1, 0x03, 
  0x7b, 0x76, 0x5a, 0x74, 0x54, 0x1a, 0x70, 0x58, 0x68, 0xed, 0x5d, 0x23, 
  0xc2, 0x4f, 0xae, 0x63, 0xd4, 0xa0, 0x7c, 0x60, 0xf4, 0x96, 0x43, 0xd0, 
  0x18, 0xca, 0x1b, 0x8d, 0x14, 0x96, 0x2f, 0x4b, 0xb6, 0x91, 0x2d, 0x80, 
  0x07, 0xe1, 0x15, 0xd9, 0xa0, 0xb6, 0x72, 0x52, 0x7f, 0x5b, 0x38, 0xe7, 
  0xa0, 0xce, 0x24, 0x8c, 0x78, 0x8a, 0xe4, 0x1a, 0x6e, 0x5e, 0xf0, 0x60, 
  0x56, 0xfc, 0x69, 0x70, 0x43, 0x3d, 0xaf, 0xc4, 0x9b, 0x39, 0xa6, 0x45, 
  0xc8, 0x09, 0x8c, 0x77, 0x12, 0x9b, 0xd0, 0xaa, 0x75, 0x81, 0x1b, 0x17, 
  0x03, 0x5b, 0x68, 0x27, 0x9c, 0x86, 0x05, 0x6e, 0x20, 0xc7, 0x2b, 0x2c, 
  0x97, 0x22, 0xb5, 0x21, 0x46, 0x48, 0xd5, 0x12, 0x3a, 0x71, 0xcc, 0x5e, 
  0x2a, 0x83, 0x13, 0x91, 0x89, 0x8f, 0x00, 0x0d, 0x0c, 0x94, 0x68, 0xd1, 
  0x92, 0xeb, 0x8a, 0x39, 0x7e, 0x69, 0x69, 0x7c, 0x82, 0xdf, 0xc6, 0x96, 
  0xff, 0x83, 0xd3, 0x93, 0x57, 0x47, 0xaf, 0x5d, 0xfa, 0xb9, 0x30, 0xf1, 
  0x65, 0x95, 0xb3, 0x65, 0x53, 0xcc, 0x86, 0xae, 0xba, 0x89, 0x73, 0xc5, 
  0x2a, 0x14, 0xb8, 0x06, 0x84, 0x12, 0x7b, 0x7a, 0x17, 0x7e, 0x00, 0x06, 
  0x92, 0x3d, 0x62, 0x6b, 0xb9, 0x40, 0xf3, 0x95, 0x5b, 0xde, 0xf6, 0xd0, 
  0x80, 0x43, 0x90, 0xbc, 0x81, 0xb8, 0xa8, 0x96, 0x0b, 0x17, 0xd7, 0x16, 
  0x40, 0x89, 0x2b, 0xea, 0x0f, 0xdf, 0x0a, 0x24, 0xbd, 0xd0, 0x26, 0x0b, 
  0x6b, 0xd2, 0xf2, 0xe2, 0x35, 0xd3, 0xae, 0xdc, 0x01, 0x6c, 0x5b, 0xd0, 
  0x5c, 0x62, 0xbd, 0x00, 0x5a, 0xc1, 0x22, 0xb3, 0x9c, 0x7d, 0xd2, 0x41, 
  0x0c, 0xb7, 0x39, 0x73, 0xb8, 0xc8, 0x89, 0x4c, 0x14, 0x97, 0x46, 0x2a, 
  0x91, 0xc3, 0x1b, 0x02, 0x91, 0x25, 0x35, 0xdd, 0xbe, 0x77, 0x65, 0xef, 
  0x34, 0x20, 0xd5, 0x3b, 0x8b, 0x1c, 0xfc, 0xb3, 0x0f, 0x9a, 0x91, 0xc1, 
  0x22, 0xb8, 0xad, 0xe4, 0xc8, 0x05, 0x53, 0xc4, 0x5f, 0xb0, 0x8f, 0xe6, 
  0x19, 0x23, 0x7b, 0xcd, 0x05, 0x56, 0x40, 0x23, 0x5a, 0x5d, 0x92, 0x64, 
  0x1a, 0x80, 0x6f, 0x59, 0x7c, 0x85, 0xd8, 0xeb, 0xb4, 0xee, 0xb8, 0x12, 
  0x9d, 0x18, 0x8c, 0xd9, 0xda, 0xd2, 0xff, 0x75, 0xdf, 0x6a, 0x95, 0x6b, 
  0x32, 0x80, 0x4b, 0x4c, 0xb5, 0x87, 0x2a, 0x9a, 0x06, 0xa2, 0xd9, 0xa4, 
  0x0e, 0x14, 0xba, 0x0e, 0x6c, 0x94, 0x3e, 0x80, 0xc7, 0x8f, 0x5f, 0xb0, 
  0x82, 0xe1, 0x2b, 0xb2, 0x59, 0x20, 0x49, 0x9b, 0x59, 0x3c, 0x3b, 0xc6, 
  0x72, 0xa5, 0x6a, 0xce, 0x10, 0xc4, 0x4a, 0xd5, 0xa7, 0xce, 0x6e, 0x3f, 
  0x14, 0x31, 0x17, 0xa4, 0x4c, 0x12, 0x77, 0xd8, 0x3c, 0xfc, 0xad, 0x4d, 
  0x90, 0xdf, 0x96, 0x2f, 0x34, 0x50, 0xdc, 0x52, 0xbd, 0x37, 0x0c, 0x5a, 
  0x93, 0x86, 0xfa, 0x17, 0xb1, 0x2e, 0x8a, 0xf3, 0xef, 0x7b, 0xeb, 0xdc, 
  0x1e, 0x6d, 0x2c, 0x3d, 0xd1, 0x53, 0x5c, 0x5c, 0x2b, 0x56, 0x83, 0xba, 
  0xd5, 0xa0, 0x26, 0x3a, 0x74, 0x55, 0x67, 0xa5, 0x64, 0xa1, 0xc4, 0x05, 
  0x72, 0x40, 0x7c, 0x5a, 0x4a, 0xa2, 0x99, 0xe6, 0xe5, 0x88, 0x7d, 0xd2, 
  0x11, 0x62, 0xc0, 0x71, 0x7e, 0xed, 0x82, 0x25, 0x62, 0x7f, 0x95, 0x19, 
  0x64, 0xa2, 0x37, 0xd6, 0xea, 0x5d, 0x16, 0xbc, 0xc6, 0x16, 0x3d, 0xe8, 
  0xc2, 0x89, 0x9a, 0x51, 0xa4, 0x2b, 0xc8, 0x12, 0x0c, 0x82, 0x82, 0x84, 
  0x94, 0xa4, 0xf4, 0x4d, 0xc8, 0xf7, 0x2f, 0x34, 0x4d, 0x97, 0xce, 0xb3, 
  0x26, 0x5e, 0x2b, 0x88, 0xc4, 0xe7, 0x3b, 0x6a, 0x8b, 0xab, 0x34, 0x82, 
  0xb2, 0x8c, 0xf6, 0xcf, 0x0f, 0x81, 0x70, 0x85, 0xc4, 0x5a, 0x1e, 0x61, 
  0xa5, 0xfb, 0x03, 0xd1, 0x9a, 0x57, 0x41, 0xcf, 0x07, 0x77, 0x78, 0x1f, 
  0xbc, 0xc9, 0xc4, 0xa4, 0x10, 0x93, 0x74, 0xc8, 0x5c, 0x68, 0x14, 0x93, 
  0xdc, 0xe4, 0x26, 0xe6, 0x9c, 0x0d, 0xb8, 0x16, 0xaf, 0x22, 0x4e, 0x73, 
  0x15, 0x92, 0x02, 0xc2, 0xd1, 0x75, 0x96, 0x1b, 0x3e, 0xd6, 0x59, 0x8b, 
  0xad, 0x1b, 0x68, 0x65, 0x18, 0x34, 0x83, 0x53, 0xed, 0xa3, 0xe3, 0xff, 
  0x66, 0xd8, 0x2f, 0xda, 0x57, 0xcd, 0x07, 0xea, 0xc9, 0x69, 0xd0, 0x6d, 
  0x40, 0xfa, 0x1b, 0xee, 0x19, 0x96, 0x45, 0x9a, 0x62, 0x41, 0xe2, 0x82, 
  0xbe, 0xc5, 0x94, 0x3d, 0x0d, 0x84, 0x5f, 0x49, 0x19, 0xe3, 0xb0, 0x5f, 
  0xb1, 0x52, 0xb3, 0xf0, 0x13, 0x97, 0x9a, 0x96, 0xa3, 0x0a, 0xc1, 0x54, 
  0xcf, 0x2a, 0x53, 0x05, 0x47, 0xb0, 0xd2, 0x88, 0xe7, 0x02, 0xdf, 0x57, 
  0x23, 0x8b, 0x6e, 0x43, 0xef, 0xaf, 0xdd, 0x6c, 0xfd, 0x18, 0xdc, 0x97, 
  0xfc, 0xd1, 0x8b, 0xa8, 0xa7, 0x1e, 0x54, 0x1e, 0xc5, 0x88, 0x3b, 0x02, 
  0x4b, 0x85, 0x03, 0x95, 0x7f, 0xc1, 0xc7, 0x08, 0xc5, 0x32, 0x44, 0x9d, 
  0x49, 0x9c, 0x05, 0x58, 0x08, 0xb9, 0x3a, 0x58, 0xfd, 0x40, 0xc4, 0xcb, 
  0x07, 0x0e, 0x3d, 0x0e, 0x45, 0xe3, 0xe1, 0xd7, 0xdb, 0x28, 0xe6, 0x46, 
  0x0f, 0xb2, 0x35, 0x87, 0xb3, 0x4a, 0xed, 0xc0, 0x97, 0x49, 0xad, 0x6c, 
  0x83, 0xcb, 0x5e, 0xe9, 0x0d, 0x7b, 0xb4, 0x16, 0xfd, 0xd9, 0xcc, 0x33, 
  0x7c, 0x7b, 0x8c, 0x77, 0x15, 0x69, 0x5e, 0x5e, 0x5e, 0x52, 0xde, 0xc5, 
  0x08, 0x87, 0xab, 0x5a, 0xd4, 0x3d, 0xa3, 0x8b, 0x73, 0x52, 0x8a, 0x43, 
  0x68, 0x40, 0xe6, 0x02, 0x22, 0x05, 0xee, 0xd2, 0xd2, 0x3c, 0x91, 0x44, 
  0xdb, 0x13, 0x0d, 0x8b, 0x90, 0xe4, 0xde, 0xa4, 0x9a, 0x04, 0x4b, 0x99, 
  0x4c, 0x6e, 0x72, 0x09, 0xf4, 0xa4, 0x45, 0x0b, 0x32, 0x03, 0x7b, 0xd1, 
  0xff, 0x28, 0x0d, 0x7c, 0xed, 0xd3, 0xc8, 0x98, 0x10, 0x46, 0x74, 0x09, 
  0x17, 0x0c, 0x6f, 0xe4, 0x08, 0xe2, 0xf0, 0xbb, 0xcb, 0xf3, 0xfd, 0xe8, 
  0xab, 0xc3, 0xfd, 0x97, 0x87, 0xe7, 0x17, 0x8d, 0x4b, 0x5f, 0xb3, 0xe6, 
  0x44, 0x40, 0x63, 0x93, 0x30, 0x44, 0x63, 0x4b, 0x7e, 0xd6, 0x50, 0x72, 
  0xe3, 0x7a, 0x44, 0x3c, 0x7c, 0x90, 0xe8, 0x7c, 0xb0, 0x42, 0x24, 0xae, 
  0x83, 0x4a, 0x12, 0xd1, 0x99, 0xd9, 0xb8, 0x36, 0xb4, 0x60, 0xa3, 0xb3, 
  0x9f, 0x87, 0x49, 0x1c, 0x1e, 0x74, 0xc5, 0x5f, 0x26, 0xd3, 0xdc, 0x12, 
  0x80, 0xeb, 0x3b, 0xf7, 0x95, 0x4f, 0x02, 0x0e, 0xd8, 0x96, 0x5e, 0x32, 
  0x6a, 0x43, 0xec, 0x7d, 0x37, 0xa4, 0x7e, 0x87, 0xb4, 0xf8, 0xc3, 0x79, 
  0xf2, 0x2c, 0x5a, 0x25, 0x65, 0xaf, 0x61, 0x10, 0xac, 0x77, 0xbf, 0x21, 
  0x08, 0xc3, 0xad, 0x93, 0xf4, 0x55, 0x67, 0x4b, 0x7c, 0xba, 0x66, 0x8c, 
  0xfd, 0xdb, 0xd4, 0x20, 0x70, 0xa9, 0x06, 0x32, 0xb2, 0x9e, 0xa0, 0x56, 
  0xc6, 0x05, 0x86, 0x1b, 0x07, 0x6a, 0xa6, 0x06, 0x2c, 0x61, 0x20, 0x3a, 
  0x05, 0xc8, 0x3a, 0x69, 0xa5, 0x97, 0x3a, 0x2c, 0x23, 0x86, 0xd7, 0x45, 
  0xc3, 0xd2, 0x87, 0xc2, 0xfb, 0x01, 0xde, 0x10, 0x0d, 0x1d, 0x2f, 0x6b, 
  0xce, 0x52, 0x35, 0x8d, 0x2a, 0x52, 0xa0, 0x36, 0xc7, 0x63, 0x70, 0x34, 
  0x6f, 0x11, 0xe7, 0xdc, 0xa5, 0x41, 0xb2, 0xe9, 0xbb, 0x12, 0xa6, 0xc4, 
  0x4a, 0x3d, 0xac, 0x9d, 0x1c, 0x08, 0x25, 0x1b, 0x6f, 0xf2, 0x6a, 0x90, 
  0x9e, 0x12, 0x12, 0x33, 0x80, 0xc8, 0x11, 0xd2, 0xec, 0x9e, 0x4b, 0xa2, 
  0xaf, 0xf2, 0x12, 0x77, 0x41, 0xfb, 0x71, 0xbe, 0xe4, 0xbb, 0x96, 0x1f, 
  0x6f, 0xa8, 0xb3, 0xcb, 0x41, 0x05, 0x01, 0xc1, 0x0b, 0xec, 0xeb, 0x6c, 
  0xff, 0xf2, 0x2b, 0xb8, 0x5a, 0x41, 0xc2, 0x2f, 0x73, 0xd6, 0x77, 0xcc, 
  0xc1, 0xd6, 0xce, 0x12, 0x72, 0x0a, 0x9c, 0xc8, 0xbf, 0x86, 0xb0, 0xe3, 
  0x2a, 0x15, 0xb0, 0x2b, 0x0f, 0x46, 0xca, 0x22, 0x21, 0x29, 0x36, 0x55, 
  0xd3, 0xa3, 0x87, 0x78, 0x72, 0xf1, 0xd8, 0x2e, 0x05, 0xcc, 0x05, 0x04, 
  0xf6, 0x25, 0x3b, 0xba, 0x2f, 0x73, 0x02, 0xd1, 0xb3, 0x30, 0xc7, 0x0a, 
  0x4f, 0x88, 0x6e, 0x85, 0x2f, 0x2c, 0x07, 0x7a, 0x40, 0x7b, 0xda, 0x0d, 
  0x60, 0x13, 0x1c, 0xe9, 0x3f, 0xcf, 0x57, 0xa3, 0x36, 0x80, 0x42, 0xf4, 
  0xe5, 0xb2, 0xaa, 0xb3, 0x95, 0x06, 0xc6, 0x96, 0x93, 0x2c, 0x8b, 0x3c, 
  0xaf, 0xea, 0x28, 0x55, 0x58, 0x1d, 0x39, 0xd1, 0x82, 0x54, 0x24, 0x63, 
  0xe1, 0xa6, 0x32, 0x95, 0xbb, 0x43, 0xc1, 0x30, 0x1e, 0x97, 0xf9, 0x6c, 
  0x59, 0x05, 0x21, 0xc1, 0x3f, 0x6f, 0xcc, 0xc1, 0xa0, 0x37, 0x8f, 0x46, 
  0x89, 0x11, 0x14, 0xc7, 0xb4, 0x16, 0x31, 0x69, 0xfa, 0x5c, 0x43, 0x8f, 
  0x3d, 0x8f, 0x45, 0x9e, 0xd5, 0xa1, 0xd5, 0x11, 0x7d, 0xbc, 0xe5, 0xf7, 
  0x9a, 0xee, 0xc2, 0xe4, 0x9e, 0xa5, 0x75, 0x93, 0x88, 0x5f, 0x49, 0x95, 
  0x63, 0xa9, 0x48, 0xec, 0xf0, 0x22, 0x80, 0x38, 0x70, 0xe5, 0xac, 0x58, 
  0x5c, 0xf4, 0x01, 0x8e, 0x7f, 0x95, 0xd6, 0x81, 0xe1, 0x6a, 0x1e, 0x43, 
  0xc9, 0x32, 0x56, 0x24, 0x4f, 0xba, 0x72, 0xcb, 0x5c, 0x7e, 0x5a, 0xd2, 
  0x87, 0x86, 0x34, 0xe9, 0x5e, 0xab, 0xce, 0xa0, 0xd0, 0xbe, 0x85, 0xdc, 
  0xf5, 0x16, 0xfe, 0x27, 0xe1, 0x63, 0xe6, 0x88, 0xb3, 0x21, 0xda, 0x8d, 
  0xc7, 0x7e, 0x3a, 0x60, 0xf1, 0x68, 0xc9, 0x28, 0x57, 0x7b, 0xcd, 0x95, 
  0x09, 0x30, 0xa9, 0xdd, 0xae, 0x0f, 0x8b, 0xa3, 0xdf, 0x88, 0x82, 0x2a, 
  0x36, 0x32, 0x78, 0xbd, 0xe7, 0x90, 0x96, 0x0c, 0x9f, 0xd4, 0x7d, 0x9c, 
  0x56, 0xe1, 0xf5, 0x67, 0x5a, 0xb7, 0x2f, 0x13, 0x3d, 0x5e, 0xd5, 0x22, 
  0x31, 0x7c, 0xde, 0xd5, 0x35, 0x87, 0xd9, 0xab, 0xf9, 0x45, 0xc1, 0x1c, 
  0x60, 0xeb, 0xb9, 0x49, 0xc1, 0xa2, 0x6c, 0xcd, 0xcd, 0xf6, 0xc5, 0xba, 
  0x3b, 0x6c, 0x59, 0x1b, 0x51, 0xe8, 0x4d, 0x74, 0xfe, 0xfe, 0x51, 0x9b, 
  0x34, 0x46, 0x0e, 0x08, 0x4a, 0xd9, 0xe5, 0x51, 0x98, 0xd1, 0x8b, 0x55, 
  0x71, 0x51, 0xa7, 0x1f, 0xd5, 0x75, 0xd8, 0x1f, 0xa7, 0x87, 0x65, 0x91, 
  0x5f, 0x8f, 0x52, 0xf8, 0xe6, 0xde, 0x2e, 0xf4, 0x2f, 0x89, 0x53, 0x00, 
  0xae, 0x52, 0x13, 0xda, 0xa8, 0xb9, 0xee, 0xa8, 0xa0, 0x05, 0xd8, 0x2e, 
  0x4b, 0x76, 0x56, 0xbf, 0xaa, 0x88, 0x3f, 0x81, 0x83, 0xa5, 0x86, 0x8f, 
  0x2d, 0x09, 0xb4, 0x65, 0x55, 0x2c, 0x27, 0x35, 0x84, 0x1b, 0x10, 0x43, 
  0xa3, 0xe0, 0x81, 0x2e, 0x6f, 0x1e, 0xaa, 0xb0, 0x9b, 0x71, 0x2d, 0x9b, 
  0xc0, 0xea, 0x46, 0x04, 0x5d, 0x6c, 0x45, 0x47, 0x0c, 0x56, 0xa8, 0x75, 
  0x10, 0x21, 0x8a, 0xd3, 0xf8, 0x1d, 0x81, 0x0d, 0xcf, 0x5c, 0x32, 0x73, 
  0x0d, 0x28, 0x48, 0x22, 0xc3, 0x83, 0x2b, 0x46, 0xe5, 0x0d, 0xdc, 0xaf, 
  0x45, 0xa4, 0x90, 0x45, 0xb8, 0xbd, 0xd9, 0x32, 0xb7, 0xe1, 0x60, 0x85, 
  0xa8, 0xbb, 0xa1, 0x2f, 0x05, 0x46, 0xfd, 0x6d, 0xd3, 0x42, 0x1a, 0xa8, 
  0xa7, 0xc3, 0x6c, 0x2a, 0x3d, 0x34, 0x51, 0x23, 0x26, 0x33, 0x99, 0xd1, 
  0x94, 0x9d, 0x18, 0x24, 0x07, 0x71, 0xee, 0x8a, 0xac, 0x5b, 0x5d, 0x2c, 
  0x2b, 0x8c, 0xd6, 0xb8, 0x35, 0xdb, 0x57, 0xc0, 0x99, 0xc0, 0x42, 0xb4, 
  0x88, 0xe8, 0xa5, 0x99, 0x0e, 0xc1, 0x4e, 0xb0, 0x60, 0x2c, 0xc0, 0xdb, 
  0x26, 0x1d, 0x9d, 0xb9, 0x2e, 0x68, 0x08, 0x3c, 0xe3, 0xfe, 0x2c, 0xd9, 
  0xe9, 0x07, 0xa0, 0x53, 0x9b, 0x12, 0x7c, 0x9d, 0x43, 0xc8, 0x67, 0x2b, 
  0x19, 0x26, 0x28, 0x4a, 0x3a, 0x07, 0x74, 0x6d, 0x75, 0x0c, 0x85, 0x9a, 
  0xf8, 0xb9, 0x83, 0xd9, 0x7d, 0xba, 0x37, 0xda, 0xfd, 0xec, 0xf3, 0xd1, 
  0xce, 0x68, 0x77, 0x87, 0x39, 0x0b, 0x0f, 0x25, 0x18, 0x9c, 0xac, 0x4b, 
  0x47, 0x57, 0xb5, 0xf7, 0xda, 0x7d, 0x9e, 0x1c, 0x5e, 0x7e, 0x7b, 0x7a, 
  0xfe, 0x75, 0x74, 0x74, 0x72, 0x79, 0x78, 0xfe, 0x6a, 0xff, 0xe0, 0x63, 
  0xb1, 0x0f, 0x43, 0xeb, 0x6c, 0x50, 0xa9, 0x28, 0x40, 0xe3, 0xa2, 0xb1, 
  0xfc, 0x5f, 0x6a, 0xbe, 0xf2, 0x8b, 0x95, 0x54, 0x37, 0x3b, 0xcf, 0x76, 
  0x1f, 0xc4, 0xce, 0x63, 0xf3, 0x57, 0xfb, 0x45, 0x9b, 0xc6, 0x2e, 0x4f, 
  0x63, 0xfd, 0xeb, 0x0e, 0x28, 0xe9, 0x42, 0x22, 0x88, 0x5c, 0xf4, 0x29, 
  0x38, 0x3a, 0xa3, 0xb7, 0x0a, 0x8a, 0xb5, 0xf2, 0xf0, 0xb1, 0x14, 0x88, 
  0x95, 0x54, 0x46, 0x85, 0xd8, 0x98, 0x6a, 0x79, 0x74, 0x61, 0xb0, 0x1c, 
  0x7d, 0xbb, 0x4c, 0x67, 0x95, 0xda, 0x09, 0xa4, 0xd0, 0xea, 0x14, 0xb2, 
  0x4b, 0x67, 0xd5, 0x3e, 0x14, 0x95, 0x90, 0x4a, 0x86, 0x53, 0x17, 0xa1, 
  0xef, 0x32, 0xbe, 0x6b, 0x79, 0x0e, 0x18, 0x2b, 0x04, 0x74, 0xba, 0x79, 
  0x66, 0xad, 0x20, 0xd1, 0x06, 0x46, 0x59, 0x69, 0x51, 0xbb, 0x98, 0x58, 
  0xcd, 0xe6, 0x77, 0xa0, 0x03, 0x01, 0xfd, 0x07, 0xa3, 0x91, 0xae, 0x20, 
  0x29, 0x10, 0x03, 0x2f, 0xf3, 0xac, 0x0e, 0x79, 0x6b, 0x15, 0x75, 0x11, 
  0xb5, 0x2e, 0x82, 0x8d, 0x41, 0x82, 0x72, 0xeb, 0x65, 0x0d, 0x3e, 0x29, 
  0x12, 0xcc, 0xd9, 0xf0, 0x75, 0x91, 0x21, 0x11, 0x83, 0x38, 0x2d, 0xe2, 
  0x7b, 0x46, 0xe3, 0x96, 0x3c, 0x41, 0x1f, 0xad, 0x17, 0xe0, 0x1d, 0xb3, 
  0x44, 0xe0, 0xd7, 0x3c, 0x3a, 0x3b, 0x7c, 0x33, 0xb4, 0x3a, 0x35, 0xf4, 
  0xbb, 0x58, 0x59, 0x5c, 0x5d, 0xf8, 0x58, 0xe0, 0xcc, 0x33, 0x0b, 0x19, 
  0x01, 0x17, 0xd4, 0x10, 0x97, 0x70, 0x02, 0x7c, 0x4c, 0x44, 0xe1, 0x16, 
  0xee, 0xca, 0xc7, 0xcf, 0x22, 0x0b, 0x1d, 0xa6, 0x58, 0x0d, 0x24, 0x8b, 
  0xf7, 0x53, 0xc3, 0x72, 0xa3, 0x4d, 0x17, 0x8a, 0xca, 0xfd, 0x21, 0xde, 
  0x12, 0xee, 0x70, 0xe7, 0x01, 0xcf, 0x2d, 0xcb, 0xf5, 0xec, 0xeb, 0x83, 
  0x8b, 0x5f, 0xef, 0xee, 0xe9, 0x70, 0xb6, 0x4c, 0xdc, 0x65, 0xee, 0xd4, 
  0x4c, 0x80, 0x06, 0x83, 0x0e, 0xc7, 0x68, 0xe9, 0xac, 0x38, 0xd2, 0xd8, 
  0x8c, 0x4d, 0x97, 0x92, 0xb1, 0x55, 0xcb, 0xc9, 0x40, 0x7c, 0xd3, 0xca, 
  0xc9, 0x4e, 0xae, 0xaa, 0x0b, 0x9b, 0xfa, 0x59, 0x8e, 0x81, 0x6a, 0x4c, 
  0x47, 0xb0, 0x72, 0x01, 0x6d, 0x71, 0x66, 0x1f, 0x49, 0xcb, 0xda, 0x1a, 
  0xf2, 0x75, 0x7d, 0xd4, 0x46, 0x73, 0xcf, 0x79, 0xbd, 0xfd, 0xb7, 0x0c, 
  0xac, 0xa6, 0xd7, 0xb8, 0xe1, 0xa1, 0xf8, 0x6e, 0x70, 0x00, 0x34, 0x46, 
  0x7b, 0x6a, 0xf8, 0xcc, 0x99, 0xc7, 0x90, 0xe5, 0xa7, 0x4f, 0x69, 0xa3, 
  0xe8, 0x64, 0x49, 0x8e, 0x3c, 0xb3, 0x01, 0xa9, 0x43, 0xec, 0x1e, 0x79, 
  0x59, 0x30, 0x6a, 0xef, 0x42, 0xa2, 0x25, 0x4f, 0x46, 0xd1, 0x57, 0x49, 
  0xc6, 0x49, 0xca, 0x1c, 0x57, 0x66, 0x59, 0x2f, 0x88, 0x7e, 0x63, 0x54, 
  0x7a, 0x7a, 0x9b, 0x9a, 0x4a, 0x62, 0x05, 0x0b, 0x23, 0xee, 0x56, 0x8a, 
  0xea, 0x66, 0x30, 0xe9, 0x31, 0xc7, 0xa0, 0xe1, 0xee, 0x51, 0xfb, 0x23, 
  0x0a, 0x11, 0x71, 0x81, 0x34, 0x34, 0xb0, 0x59, 0x87, 0xfc, 0xa2, 0xef, 
  0xb5, 0x39, 0x3d, 0xe6, 0xf0, 0xbf, 0xa8, 0xb9, 0x94, 0xdf, 0x42, 0x70, 
  0x4e, 0x2c, 0xaa, 0x84, 0x67, 0x2a, 0xd3, 0xe2, 0x86, 0x75, 0xfa, 0x92, 
  0x2e, 0x98, 0x38, 0x9b, 0xac, 0x46, 0xd3, 0x84, 0x08, 0x88, 0x4e, 0xdb, 
  0x68, 0x79, 0xbb, 0x1d, 0x1c, 0x53, 0x66, 0xf2, 0x37, 0x92, 0x8f, 0x5d, 
  0xb7, 0xe8, 0x5a, 0x6d, 0x99, 0x36, 0x50, 0x52, 0x5c, 0xc7, 0x00, 0x4f, 
  0x51, 0x3d, 0x2b, 0xf6, 0xc7, 0x73, 0x2d, 0xc4, 0xd0, 0x61, 0xe4, 0x90, 
  0x00, 0xb9, 0x85, 0xd1, 0x22, 0x99, 0x3f, 0x73, 0xb9, 0x9f, 0xc6, 0x1f, 
  0x84, 0x37, 0x78, 0x89, 0x39, 0xb0, 0x3e, 0x66, 0xc9, 0xf5, 0x4c, 0x45, 
  0x88, 0x50, 0x26, 0x77, 0x4d, 0x74, 0x24, 0x38, 0x88, 0x24, 0xaf, 0x05, 
  0x82, 0x37, 0x60, 0x2e, 0x9b, 0xa3, 0x9e, 0x97, 0xb1, 0x7a, 0xad, 0x0a, 
  0xe6, 0x1b, 0x51, 0x94, 0x06, 0x80, 0x12, 0xb2, 0xe0, 0xab, 0xb6, 0x0b, 
  0x0b, 0xb8, 0x51, 0xbf, 0x0a, 0x7d, 0x2b, 0x14, 0x02, 0xa0, 0x49, 0x8d, 
  0xfd, 0x85, 0x57, 0xcf, 0xaa, 0xaf, 0xc8, 0x59, 0xa1, 0xaf, 0xef, 0x1e, 
  0xb1, 0x29, 0xf7, 0xf2, 0xf8, 0x62, 0x20, 0xf4, 0x20, 0x25, 0xa8, 0x03, 
  0x00, 0x63, 0x4f, 0x7e, 0x6c, 0xd8, 0x90, 0x00, 0x2d, 0x2b, 0xd6, 0x57, 
  0xc8, 0x68, 0x84, 0x33, 0x78, 0x17, 0x90, 0x0f, 0xf3, 0xb7, 0x85, 0xd0, 
  0x80, 0x59, 0x1e, 0x8e, 0x95, 0xc2, 0x15, 0x11, 0xc8, 0x21, 0x6b, 0xa0, 
  0xa4, 0x4d, 0x34, 0x7c, 0x34, 0x88, 0x86, 0x7b, 0x00, 0x2c, 0xd9, 0xad, 
  0x2f, 0x24, 0x0d, 0x8d, 0x44, 0xcf, 0x09, 0x00, 0xd2, 0x37, 0x5c, 0x11, 
  0x56, 0x63, 0x09, 0x9b, 0x4a, 0xd6, 0x77, 0xf4, 0x3e, 0xff, 0xd8, 0xd3, 
  0x49, 0xdd, 0xed, 0x22, 0x36, 0x99, 0x25, 0xd0, 0xbb, 0x64, 0xb6, 0x6a, 
  0x0b, 0x0a, 0x7b, 0x0f, 0xee, 0x2c, 0xb2, 0x00, 0xee, 0x53, 0x87, 0xba, 
  0x28, 0xd0, 0xae, 0xb0, 0xf3, 0xf1, 0xc9, 0xa6, 0xbd, 0xb2, 0x01, 0xd0, 
  0x32, 0xaa, 0x05, 0x37, 0x8b, 0xee, 0xf6, 0xcc, 0x91, 0xca, 0xdf, 0xd8, 
  0xe2, 0x89, 0x25, 0xda, 0x33, 0x92, 0x56, 0xd2, 0x18, 0x07, 0x74, 0x05, 
  0x94, 0x4b, 0x17, 0x33, 0x87, 0x23, 0x12, 0x27, 0xa9, 0x71, 0x1a, 0x57, 
  0x65, 0x5e, 0x92, 0x8c, 0xe3, 0x4c, 0x40, 0x21, 0x49, 0xfa, 0xf5, 0x51, 
  0x3c, 0x88, 0x71, 0xc6, 0x99, 0x26, 0x99, 0xb5, 0x5c, 0xce, 0x15, 0xeb, 
  0x1d, 0x8c, 0x78, 0x80, 0xeb, 0xb6, 0x8a, 0x88, 0x13, 0xa7, 0x12, 0xd4, 
  0x36, 0x83, 0xf8, 0x0c, 0x91, 0x4a, 0x6d, 0x81, 0x7e, 0xa1, 0xd8, 0xc0, 
  0x23, 0x08, 0x66, 0xa0, 0x97, 0x9b, 0x54, 0x54, 0x74, 0x84, 0x60, 0x62, 
  0xc1, 0x88, 0x55, 0xf4, 0x23, 0x3a, 0x7d, 0x4b, 0x6e, 0xb4, 0xca, 0x11, 
  0xe3, 0xe9, 0x04, 0x06, 0xcd, 0x60, 0xba, 0x80, 0x9c, 0x19, 0xf5, 0x43, 
  0x26, 0x39, 0xfc, 0x82, 0x17, 0xa1, 0xec, 0xfb, 0x55, 0x53, 0x14, 0xd1, 
  0xfa, 0x12, 0xa8, 0xf9, 0x9f, 0xd6, 0x5b, 0x9a, 0x3a, 0x2b, 0xac, 0xf8, 
  0x56, 0x3f, 0x79, 0xcf, 0x42, 0x51, 0xdf, 0xfa, 0x95, 0xef, 0x25, 0x03, 
  0x1b, 0xeb, 0x7b, 0x76, 0x74, 0x22, 0x25, 0x9e, 0xdc, 0x59, 0x4a, 0x58, 
  0xd6, 0x96, 0xe7, 0x44, 0xf4, 0x15, 0x03, 0x36, 0x3b, 0xe5, 0xc4, 0xa4, 
  0xc2, 0x04, 0xc7, 0x87, 0x24, 0xb5, 0xee, 0xce, 0x97, 0x32, 0x82, 0x3e, 
  0xdf, 0x94, 0x65, 0x39, 0xeb, 0xd7, 0xea, 0x60, 0x04, 0x3b, 0xda, 0xb8, 
  0x92, 0x9c, 0xb1, 0x66, 0x62, 0xc1, 0x6d, 0x1b, 0x5a, 0x48, 0x89, 0x5b, 
  0xa9, 0x71, 0xca, 0x41, 0x23, 0x4b, 0x2d, 0xb4, 0x12, 0xff, 0x3a, 0x1a, 
  0x6d, 0x53, 0x87, 0xe5, 0xb6, 0xbd, 0xb8, 0xb8, 0x9d, 0x94, 0x74, 0x47, 
  0x72, 0x4a, 0xe6, 0x0f, 0xd0, 0xbb, 0x61, 0x54, 0xa2, 0x21, 0x4f, 0x7f, 
  0x8c, 0x86, 0x93, 0x99, 0xcc, 0x10, 0xd5, 0x8d, 0x7e, 0x20, 0xba, 0xe1, 
  0x27, 0x7e, 0xdc, 0xe0, 0x24, 0xb0, 0x8b, 0xb7, 0x6f, 0x18, 0xd1, 0x17, 
  0x85, 0x53, 0x2e, 0xcf, 0xf7, 0x4f, 0x2e, 0x5e, 0x89, 0x21, 0xf1, 0x32, 
  0x0f, 0x4a, 0xb2, 0xa8, 0x15, 0xd6, 0xd5, 0x1a, 0x33, 0xa0, 0x27, 0xae, 
  0x22, 0x11, 0x84, 0x22, 0x6b, 0x79, 0x96, 0x41, 0x13, 0xec, 0x54, 0x8a, 
  0xbd, 0x80, 0x61, 0xd3, 0x89, 0xda, 0x2c, 0xb7, 0xdc, 0xed, 0x5a, 0x86, 
  0x28, 0xe9, 0x1e, 0x60, 0x4c, 0xf4, 0x12, 0xf7, 0x10, 0x9f, 0x99, 0x03, 
  0x1b, 0x8c, 0x7d, 0x2a, 0x0c, 0x7d, 0x2d, 0x9e, 0xdf, 0x01, 0x69, 0x1c, 
  0x43, 0x05, 0x68, 0x0e, 0xd0, 0xe1, 0x9d, 0xf1, 0x49, 0x18, 0xba, 0x42, 
  0x71, 0xb9, 0xc6, 0xbd, 0xaf, 0xd6, 0x37, 0xbd, 0xf9, 0xbb, 0xdd, 0xad, 
  0xee, 0xe6, 0x2f, 0x7f, 0x6e, 0xf3, 0xdd, 0x63, 0x37, 0x11, 0xdf, 0x67, 
  0x63, 0x6c, 0xfe, 0x6e, 0x6f, 0xeb, 0xc1, 0x19, 0x85, 0x89, 0x64, 0xbe, 
  0x4f, 0x7a, 0x83, 0x07, 0x1b, 0xbd, 0xb0, 0x62, 0x66, 0x7a, 0x11, 0xbb, 
  0x78, 0x86, 0x2b, 0x0f, 0x31, 0x56, 0xcb, 0xb9, 0xe7, 0x68, 0x47, 0x27, 
  0xfe, 0x79, 0x37, 0x85, 0x06, 0xe6, 0xa3, 0x3c, 0x92, 0x87, 0x66, 0x23, 
  0xfd, 0x3b, 0xe4, 0x79, 0x9c, 0xec, 0x5b, 0xe6, 0x23, 0xf4, 0xbd, 0xf7, 
  0x40, 0xdf, 0x7e, 0x76, 0x81, 0x76, 0xcb, 0x3e, 0x3f, 0x0e, 0x1a, 0x62, 
  0x69, 0x7c, 0x9b, 0x0b, 0xcb, 0x4b, 0x3f, 0xae, 0xef, 0x87, 0xfa, 0xbb, 
  0x3c, 0x7a, 0x73, 0xc8, 0xd5, 0x0a, 0x5e, 0x1e, 0x31, 0x7a, 0xd4, 0x85, 
  0xc2, 0xb7, 0x99, 0x22, 0xeb, 0x40, 0x2d, 0x43, 0x98, 0x65, 0x71, 0x86, 
  0xb9, 0xd8, 0x1c, 0x77, 0xfe, 0xdd, 0x4e, 0x70, 0xd7, 0x1a, 0x3f, 0x5a, 
  0x5a, 0x92, 0xda, 0xd1, 0xd5, 0xf0, 0x4d, 0x3e, 0x85, 0xb2, 0x35, 0x14, 
  0xd8, 0x5a, 0x7a, 0x8b, 0x3e, 0x7c, 0x9b, 0xcd, 0x6b, 0x1f, 0x87, 0xa9, 
  0x70, 0xaa, 0x47, 0x6f, 0xac, 0x83, 0xa2, 0xfe, 0x69, 0x7b, 0x38, 0x44, 
  0xb9, 0x31, 0x89, 0x81, 0x51, 0x4b, 0x78, 0x2d, 0xc3, 0xde, 0xce, 0x3e, 
  0xad, 0x4f, 0x3a, 0x5b, 0x89, 0xd7, 0x36, 0xf6, 0xb1, 0x36, 0x3e, 0xef, 
  0xed, 0x1a, 0x85, 0x92, 0x9d, 0x8d, 0x48, 0xac, 0x40, 0x1b, 0x35, 0x64, 
  0x40, 0x16, 0xce, 0x93, 0x7b, 0x1f, 0x2b, 0xa2, 0x05, 0x38, 0xf2, 0xc5, 
  0x0a, 0x93, 0xbc, 0xaf, 0xf9, 0xa1, 0x3b, 0x9d, 0x51, 0x3f, 0xc9, 0x3b, 
  0x35, 0xf0, 0x75, 0xe9, 0x21, 0x24, 0x40, 0xfd, 0x44, 0xb1, 0xca, 0x4f, 
  0x8b, 0x80, 0x81, 0xe9, 0xb0, 0x63, 0xf3, 0xa2, 0x7b, 0xac, 0xc0, 0x00, 
  0xe4, 0xb0, 0x3e, 0x4e, 0x8f, 0x6f, 0xb8, 0xc1, 0x77, 0xdb, 0x88, 0x0d, 
  0xc3, 0xe6, 0x49, 0x20, 0xae, 0x63, 0x00, 0x08, 0x9a, 0x17, 0x94, 0x68, 
  0x2e, 0x9e, 0x65, 0xe4, 0xf6, 0x87, 0x7d, 0x20, 0xef, 0xa6, 0x59, 0xc7, 
  0x64, 0x86, 0x3f, 0x7f, 0x36, 0x2d, 0x3f, 0x55, 0xd4, 0xbb, 0xe2, 0xb4, 
  0x76, 0x36, 0xfa, 0xf7, 0x64, 0x00, 0x82, 0xf4, 0x20, 0xb4, 0x45, 0x42, 
  0x3d, 0xb3, 0x35, 0x53, 0x4e, 0x44, 0x51, 0x73, 0x81, 0x84, 0xce, 0x3a, 
  0x2a, 0xb6, 0x2d, 0xe6, 0xa3, 0xcb, 0xc5, 0x14, 0x1e, 0x6c, 0x89, 0xde, 
  0x5b, 0x71, 0x39, 0xc4, 0x62, 0x1a, 0xaf, 0x3a, 0x06, 0xef, 0xbe, 0xfb, 
  0xd8, 0xa1, 0xfb, 0xf8, 0x6f, 0x5c, 0xa7, 0x9a, 0x28, 0x49, 0x0c, 0x87, 
  0x3d, 0x58, 0x52, 0x5c, 0x8c, 0xcb, 0x3e, 0x03, 0x83, 0x0a, 0xd2, 0x84, 
  0xd8, 0x97, 0xac, 0xd0, 0x85, 0x43, 0xc9, 0xe7, 0x27, 0x36, 0xa2, 0xc9, 
  0x4d, 0xa2, 0xa0, 0xd1, 0xde, 0xc8, 0x16, 0x17, 0xa8, 0xe7, 0x51, 0xdf, 
  0x98, 0xb4, 0xb2, 0xbd, 0xe0, 0xe0, 0x03, 0xde, 0x10, 0x22, 0xf2, 0x97, 
  0x47, 0x07, 0x97, 0x06, 0x52, 0x76, 0xc5, 0x77, 0x68, 0xb1, 0xfa, 0xb8, 
  0xa2, 0x05, 0x0f, 0x3e, 0x33, 0x7d, 0x76, 0x93, 0x90, 0x2c, 0x96, 0x8d, 
  0x97, 0xd7, 0xcf, 0xfe, 0x1a, 0x17, 0xd7, 0x41, 0x51, 0xb3, 0x35, 0xcf, 
  0x4f, 0x91, 0x7f, 0xf3, 0x8c, 0xb8, 0xd2, 0xee, 0xd3, 0xdd, 0x47, 0x12, 
  0xdc, 0x9d, 0x72, 0x31, 0x15, 0x30, 0x85, 0xfe, 0xbc, 0x2f, 0x39, 0xf2, 
  0x08, 0x2b, 0x77, 0x89, 0xf1, 0xd9, 0xb4, 0x2f, 0x8a, 0x56, 0x1c, 0x3e, 
  0x3b, 0xd5, 0x67, 0x25, 0x51, 0xb7, 0x0f, 0x68, 0x06, 0x7a, 0x9c, 0xb3, 
  0xda, 0x96, 0x8b, 0xfe, 0xa8, 0x76, 0xac, 0x3f, 0x30, 0x57, 0xee, 0xc2, 
  0xd5, 0x68, 0x38, 0x10, 0x46, 0xac, 0x3c, 0x74, 0x5c, 0x24, 0xf1, 0xad, 
  0x83, 0x6d, 0x0f, 0x12, 0xe8, 0xcd, 0x4c, 0xce, 0x35, 0xe5, 0x80, 0x3b, 
  0x68, 0xe9, 0x25, 0x58, 0xea, 0xc8, 0xd9, 0xd6, 0xb7, 0x78, 0x94, 0x1f, 
  0xe8, 0x9f, 0xe3, 0xbf, 0x9f, 0x4d, 0xc7, 0x1f, 0xf1, 0x10, 0x1d, 0x36, 
  0x41, 0x78, 0xda, 0xaf, 0x63, 0x9d, 0xb3, 0xb4, 0x5f, 0x31, 0xa9, 0xa1, 
  0xde, 0x0e, 0x51, 0xc1, 0xa6, 0xd4, 0x85, 0x11, 0x3b, 0xb5, 0xd4, 0xfe, 
  0xd4, 0x52, 0x64, 0x6a, 0x26, 0xa0, 0x71, 0x73, 0xa9, 0x95, 0x97, 0xfb, 
  0x67, 0x81, 0xc6, 0x04, 0x8d, 0xc4, 0x5b, 0x87, 0xf8, 0x39, 0x96, 0x96, 
  0xc3, 0x52, 0x68, 0x03, 0x2f, 0xe7, 0x56, 0x60, 0x8e, 0xd3, 0xbb, 0x58, 
  0x82, 0x88, 0x73, 0xbd, 0x43, 0x60, 0xc8, 0x00, 0x78, 0xf2, 0x6c, 0x1a, 
  0xc3, 0x55, 0xa4, 0x37, 0x0f, 0x84, 0x70, 0xb4, 0x95, 0x6a, 0xbc, 0x08, 
  0xed, 0xcd, 0xfb, 0x48, 0x03, 0xdd, 0x35, 0xa2, 0x5f, 0x7e, 0x97, 0xc7, 
  0x38, 0x89, 0x73, 0x65, 0x13, 0x10, 0xa6, 0x4c, 0x83, 0x8f, 0xcb, 0x5b, 
  0xe2, 0x9f, 0xe2, 0xe2, 0xa4, 0xde, 0xd3, 0x49, 0x62, 0xf6, 0xd3, 0x69, 
  0x2a, 0xa1, 0x06, 0xbe, 0xd4, 0x77, 0xb8, 0x61, 0x72, 0xed, 0xb0, 0xda, 
  0x32, 0x2b, 0x13, 0x81, 0x1a, 0x8b, 0x2e, 0xef, 0x73, 0x11, 0x35, 0x5d, 
  0x12, 0xbd, 0xc4, 0xea, 0x95, 0xcb, 0x54, 0xd0, 0x0a, 0xac, 0xd4, 0xf9, 
  0x89, 0x4f, 0xf2, 0xe8, 0x39, 0x13, 0xca, 0x4b, 0xe7, 0x19, 0xba, 0x78, 
  0xf9, 0x75, 0xc4, 0xe9, 0xc7, 0xdc, 0xc7, 0x01, 0x03, 0x96, 0xb3, 0x93, 
  0x77, 0x0e, 0x15, 0xe2, 0xf5, 0x92, 0xcf, 0xfb, 0xc1, 0x4d, 0xbc, 0x60, 
  0x49, 0x78, 0x77, 0x87, 0xf5, 0xee, 0x6f, 0x2d, 0x91, 0x89, 0x0f, 0xaa, 
  0xd5, 0x34, 0x2a, 0x7b, 0x81, 0x4a, 0x3e, 0x25, 0x55, 0x7a, 0xc6, 0x92, 
  0x70, 0xdd, 0xda, 0x47, 0x57, 0x66, 0xb9, 0x4d, 0xe4, 0xb9, 0x8c, 0x67, 
  0x25, 0x91, 0x46, 0x51, 0x4e, 0x6f, 0xb7, 0x27, 0xf4, 0xcf, 0xa3, 0x9d, 
  0x6d, 0xa0, 0xdf, 0x55, 0x30, 0x8e, 0x31, 0x4d, 0xee, 0xed, 0x3d, 0x79, 
  0x32, 0x88, 0x7a, 0xae, 0x92, 0x1d, 0x93, 0xef, 0x2b, 0xb0, 0x99, 0x5e, 
  0x28, 0xc7, 0x14, 0x57, 0x93, 0x61, 0x42, 0xbc, 0x33, 0x2f, 0x40, 0x64, 
  0xf4, 0x27, 0xff, 0x8f, 0x5f, 0xe6, 0xcc, 0x06, 0x43, 0x74, 0xb8, 0xd1, 
  0xbb, 0x15, 0x9e, 0x27, 0x07, 0x72, 0x61, 0xc4, 0x75, 0x4f, 0xbb, 0x61, 
  0x66, 0x09, 0xf6, 0x39, 0x2c, 0x92, 0x7c, 0x61, 0x5e, 0xb4, 0xf9, 0x4a, 
  0x6f, 0x1a, 0x50, 0x5a, 0x54, 0xcb, 0x4d, 0xbc, 0x91, 0xb0, 0x21, 0xcd, 
  0x1c, 0x2f, 0x97, 0xe3, 0xa1, 0xa6, 0x50, 0x8a, 0x9a, 0x91, 0xd2, 0xf9, 
  0x9d, 0x73, 0xa9, 0x57, 0xb5, 0xf7, 0xb6, 0x78, 0xf2, 0x97, 0x51, 0x4f, 
  0x29, 0x8c, 0x7f, 0x8c, 0xe0, 0x04, 0x4b, 0x26, 0x5c, 0x3e, 0x23, 0x7f, 
  0xa1, 0x7f, 0xfc, 0xe9, 0x4f, 0xd4, 0xec, 0x9f, 0xb8, 0x95, 0x17, 0xbf, 
  0x2b, 0xab, 0x9b, 0xe0, 0x99, 0x9e, 0x92, 0xfd, 0x91, 0x77, 0x01, 0x22, 
  0xac, 0x07, 0x08, 0x91, 0x48, 0xf5, 0x79, 0x73, 0xac, 0x7c, 0x79, 0x10, 
  0xcc, 0x2f, 0x45, 0x12, 0x96, 0xd8, 0xdc, 0x9c, 0x57, 0xfd, 0x4b, 0x76, 
  0xcf, 0x25, 0x9c, 0xbb, 0x4b, 0xb4, 0x08, 0x08, 0xb0, 0x2d, 0x93, 0x2e, 
  0x0e, 0x4f, 0xbe, 0x39, 0x3a, 0x3f, 0x3d, 0x79, 0x73, 0x78, 0x72, 0x19, 
  0x7d, 0xb3, 0x7f, 0x7e, 0xb4, 0xff, 0xe5, 0xb1, 0xa6, 0x08, 0xf3, 0x14, 
  0x38, 0x18, 0x42, 0xa4, 0xee, 0x06, 0x80, 0x63, 0x90, 0xb2, 0xd1, 0x89, 
  0x57, 0xde, 0xa8, 0x50, 0xf4, 0x4e, 0x01, 0x81, 0x61, 0x5e, 0x7d, 0x07, 
  0xa0, 0xfa, 0x01, 0x7b, 0xf8, 0xec, 0x57, 0x01, 0xbd, 0x7f, 0x67, 0x08, 
  0xf6, 0x6c, 0xc4, 0x5c, 0x05, 0x29, 0xa8, 0x1c, 0xb5, 0xc1, 0x94, 0x6b, 
  0x3c, 0xcb, 0x97, 0xc2, 0x50, 0x0c, 0xf7, 0x51, 0xf4, 0x5a, 0xb2, 0x98, 
  0x35, 0x7e, 0xc8, 0xbd, 0xaa, 0x19, 0x35, 0x6a, 0xd4, 0x91, 0xff, 0xdc, 
  0x2f, 0xfb, 0xc7, 0xc7, 0xbe, 0xcb, 0x7d, 0x91, 0x70, 0x87, 0x3e, 0x19, 
  0xd8, 0xea, 0x00, 0xa1, 0x6e, 0xb6, 0xa0, 0xab, 0x48, 0xf2, 0xcb, 0x8d, 
  0xd5, 0x21, 0xbb, 0xce, 0x3d, 0xe6, 0x71, 0xb6, 0x0a, 0xe1, 0x8d, 0xb9, 
  0x53, 0xda, 0xa4, 0x4d, 0x81, 0x20, 0x60, 0xb7, 0x23, 0x1d, 0xae, 0xb4, 
  0xbc, 0x1d, 0x44, 0xfd, 0xdf, 0xf5, 0x25, 0x2b, 0x29, 0x01, 0xfa, 0x27, 
  0x5a, 0x2f, 0x7d, 0xf5, 0xb1, 0xe8, 0xe4, 0xd4, 0x8f, 0xe9, 0x08, 0x21, 
  0xf0, 0x4c, 0x62, 0x88, 0x78, 0x2c, 0x1c, 0xb2, 0x4c, 0xa2, 0xc9, 0xbc, 
  0x43, 0x78, 0xb5, 0x25, 0x32, 0x1b, 0xc3, 0xb4, 0x96, 0xbd, 0x9f, 0xb4, 
  0x4c, 0x1c, 0x24, 0x1f, 0x00, 0x5f, 0x49, 0x59, 0x8b, 0x27, 0x01, 0x98, 
  0xab, 0xd8, 0x70, 0x58, 0xed, 0x85, 0x28, 0xa0, 0xc5, 0x06, 0x65, 0x5d, 
  0xd9, 0x3a, 0xa4, 0xae, 0xa8, 0x65, 0xa9, 0x2c, 0x14, 0x04, 0xf5, 0x7e, 
  0x5b, 0xd1, 0x94, 0xc5, 0x3f, 0xc5, 0x21, 0xd3, 0x45, 0x3a, 0x55, 0x6c, 
  0xb0, 0x4e, 0x82, 0x18, 0xc1, 0xad, 0x71, 0x7e, 0x00, 0x1c, 0xe5, 0x2c, 
  0x7d, 0x1f, 0xc0, 0xce, 0x4b, 0x78, 0x25, 0xb1, 0x91, 0x82, 0xb3, 0x96, 
  0x32, 0x95, 0x42, 0x10, 0xb2, 0x08, 0xc1, 0x3c, 0xbe, 0xce, 0x4d, 0xe8, 
  0x8e, 0x9d, 0xaf, 0x55, 0xb2, 0x91, 0x24, 0x1a, 0xc5, 0x64, 0x2f, 0x07, 
  0xfe, 0xe3, 0x8c, 0x5f, 0xf0, 0xca, 0x9a, 0xa9, 0x99, 0x23, 0x70, 0xaa, 
  0x00, 0xa5, 0xbc, 0x0c, 0x52, 0x59, 0x7d, 0x80, 0x37, 0xb3, 0x11, 0xf1, 
  0x47, 0x1a, 0x1a, 0x0f, 0x30, 0x8f, 0x2c, 0xf5, 0x15, 0xb1, 0x60, 0x18, 
  0x16, 0x3f, 0x88, 0x26, 0x35, 0xac, 0x0f, 0x4d, 0x9a, 0x15, 0x94, 0x0e, 
  0xce, 0x8c, 0xb3, 0x6c, 0x8c, 0x09, 0xc5, 0xd1, 0x38, 0xbd, 0x8e, 0xcc, 
  0x00, 0x12, 0x31, 0x29, 0x00, 0x99, 0x29, 0x9f, 0x27, 0xbc, 0x55, 0xc0, 
  0x5d, 0x82, 0xc4, 0x7e, 0xc3, 0x95, 0x32, 0x3d, 0x50, 0x90, 0xcd, 0xa4, 
  0xe4, 0x18, 0x74, 0x67, 0x40, 0x13, 0x1b, 0xfa, 0x92, 0x97, 0xd1, 0xe2, 
  0x75, 0x14, 0x53, 0x58, 0xa3, 0x97, 0xd8, 0x38, 0x0b, 0x84, 0xb3, 0x0c, 
  0xb9, 0x12, 0x96, 0x79, 0x8a, 0x65, 0xb0, 0xc8, 0x4e, 0xe6, 0x13, 0x30, 
  0xa9, 0x24, 0xb3, 0xab, 0x68, 0xd3, 0x81, 0x02, 0xa3, 0xea, 0xaa, 0xa0, 
  0x2a, 0x32, 0x61, 0x4b, 0xe0, 0x75, 0x0d, 0xba, 0xdf, 0xf6, 0x4a, 0xd1, 
  0x6f, 0xae, 0xa4, 0xba, 0x27, 0x0d, 0x6f, 0x33, 0x60, 0x39, 0x19, 0x51, 
  0x88, 0x3c, 0x26, 0x4a, 0xa3, 0xfe, 0x35, 0x14, 0x4f, 0x25, 0x1d, 0x54, 
  0x75, 0x59, 0x6e, 0x79, 0x6f, 0xb5, 0x48, 0x01, 0x4c, 0xaa, 0x92, 0x82, 
  0xa2, 0xe2, 0x31, 0x6d, 0x97, 0x99, 0xa0, 0x42, 0x0b, 0x56, 0x64, 0x29, 
  0x09, 0xb3, 0x59, 0x80, 0x0a, 0x2c, 0x36, 0x88, 0xb8, 0x25, 0x7c, 0xb8, 
  0xe2, 0x99, 0xfb, 0x1a, 0x1c, 0x21, 0x08, 0xa2, 0xc1, 0x4c, 0x34, 0xec, 
  0x96, 0xc5, 0xb3, 0x86, 0x61, 0x2c, 0xe0, 0x65, 0xe6, 0x59, 0x0d, 0xa1, 
  0x5c, 0x15, 0x96, 0x3e, 0x8d, 0xe7, 0x22, 0x3c, 0x7a, 0xea, 0x9b, 0xaf, 
  0x24, 0x30, 0x6b, 0x63, 0xe3, 0xe0, 0xed, 0xc5, 0xe5, 0xe9, 0x9b, 0xe8, 
  0xf4, 0xed, 0xe5, 0xd9, 0xdb, 0x4b, 0xbd, 0xb4, 0xc6, 0x12, 0xba, 0x2a, 
  0x8a, 0xa1, 0x48, 0x01, 0xb6, 0x9b, 0x73, 0x75, 0x17, 0x23, 0x30, 0x21, 
  0x07, 0x1a, 0x58, 0x00, 0xc0, 0xe2, 0xd2, 0x56, 0x00, 0xef, 0x28, 0x20, 
  0xa3, 0x58, 0xf3, 0x7b, 0x5a, 0x73, 0x24, 0x1d, 0xc2, 0xa0, 0x63, 0x59, 
  0x30, 0x50, 0x76, 0xba, 0x4b, 0x3c, 0xac, 0xea, 0xca, 0x0b, 0x1c, 0xbb, 
  0x75, 0xa0, 0x1b, 0x1f, 0x6a, 0x62, 0x06, 0x1d, 0x6f, 0xef, 0x09, 0xa3, 
  0xde, 0x10, 0xef, 0x31, 0xa9, 0xcc, 0x8c, 0x69, 0x81, 0x87, 0x08, 0x31, 
  0xa9, 0x67, 0x5f, 0x85, 0x49, 0x60, 0x55, 0x4e, 0x33, 0xbc, 0x71, 0x41, 
  0xc3, 0x1c, 0x1f, 0x8d, 0x60, 0x29, 0x71, 0xbe, 0x73, 0x54, 0x92, 0xd5, 
  0xa9, 0xbc, 0x67, 0xe3, 0x77, 0xeb, 0x82, 0xbd, 0x8f, 0xfa, 0xdf, 0x26, 
  0x61, 0x83, 0xbf, 0xf9, 0x3b, 0xe7, 0xb6, 0xbd, 0xb3, 0x4f, 0xfe, 0x21, 
  0x5d, 0xfe, 0x25, 0xeb, 0x23, 0xc6, 0xa8, 0xee, 0x65, 0xfd, 0xfa, 0xf0, 
  0xfc, 0xcb, 0xc3, 0xf3, 0xd3, 0x8b, 0xc7, 0x08, 0x35, 0x31, 0x23, 0x57, 
  0x9b, 0xda, 0x6f, 0x93, 0x62, 0x9c, 0x14, 0x79, 0xf9, 0xd8, 0x15, 0x73, 
  0xf0, 0x45, 0xa4, 0xa1, 0x0f, 0x65, 0x96, 0xe8, 0x64, 0x4f, 0x12, 0x05, 
  0x4c, 0x6e, 0x89, 0x5d, 0xc2, 0x4d, 0xd3, 0xf2, 0x64, 0x9a, 0x25, 0x96, 
  0x5d, 0x98, 0x9a, 0x68, 0xc5, 0x0d, 0x3b, 0x90, 0x1c, 0x47, 0xaa, 0xaf, 
  0xd8, 0x6c, 0x3c, 0x70, 0x91, 0x48, 0xb7, 0xc5, 0x78, 0x48, 0x24, 0x7d, 
  0x6b, 0x85, 0xc8, 0x24, 0x1e, 0x9c, 0xf8, 0xa1, 0x04, 0x8a, 0x7a, 0x33, 
  0xc2, 0x2d, 0x93, 0x3f, 0xd7, 0x1d, 0xb0, 0x42, 0x13, 0x52, 0x43, 0xca, 
  0xe2, 0xfe, 0x98, 0x83, 0x3e, 0x94, 0xab, 0x4f, 0xfd, 0x3c, 0x76, 0x15, 
  0x6b, 0xc4, 0x88, 0xc5, 0x1f, 0x39, 0xb4, 0x22, 0x2d, 0x57, 0x80, 0x58, 
  0xa1, 0x2b, 0x92, 0xb0, 0x17, 0xf7, 0x53, 0xbd, 0x24, 0x00, 0x1d, 0x9b, 
  0x89, 0x11, 0x5b, 0x78, 0x74, 0xd3, 0x95, 0xc1, 0x25, 0x76, 0x10, 0xb3, 
  0xae, 0x11, 0xb9, 0xd1, 0x78, 0x16, 0x67, 0xb7, 0xb8, 0xad, 0x70, 0xfb, 
  0xb0, 0x4e, 0x69, 0x43, 0xe5, 0x82, 0x44, 0xf0, 0x5c, 0x69, 0x7a, 0x3c, 
  0xe4, 0xbb, 0x19, 0x73, 0xaf, 0x95, 0xd5, 0xa8, 0x55, 0x5b, 0x40, 0xe0, 
  0xa3, 0xc1, 0x71, 0xd1, 0xaa, 0x42, 0x52, 0x3f, 0xd6, 0x45, 0xd8, 0x43, 
  0xe5, 0x96, 0x02, 0xb1, 0x16, 0x27, 0x22, 0x49, 0x65, 0x29, 0x78, 0x94, 
  0xf0, 0x05, 0xc3, 0x33, 0x86, 0x7f, 0x01, 0x74, 0x80, 0xec, 0xb9, 0xd2, 
  0x81, 0xfe, 0x2b, 0x4f, 0x16, 0xfe, 0x04, 0xb8, 0x3e, 0x5f, 0x03, 0x20, 
  0x2c, 0x10, 0xa1, 0xf0, 0xca, 0x07, 0x3e, 0x4a, 0x24, 0xb6, 0xef, 0x64, 
  0x10, 0x5e, 0xd6, 0x74, 0x5e, 0xa8, 0x5a, 0x68, 0xff, 0xda, 0x1d, 0x92, 
  0xd7, 0xbb, 0xf4, 0x7b, 0xf0, 0xb7, 0x4c, 0xeb, 0x00, 0x7b, 0x60, 0x14, 
  0x8b, 0xd7, 0xac, 0xc7, 0x48, 0xda, 0xc0, 0xb5, 0x96, 0x78, 0x52, 0x22, 
  0x92, 0x49, 0x1c, 0x4b, 0x88, 0xef, 0xd3, 0xbb, 0xb5, 0x9a, 0x82, 0x99, 
  0x14, 0x35, 0xec, 0xc8, 0x30, 0x34, 0x51, 0x92, 0xf7, 0x61, 0xea, 0x93, 
  0x60, 0x75, 0x28, 0x28, 0x4e, 0x68, 0x1d, 0x9e, 0xf0, 0x4d, 0x90, 0x0f, 
  0xc7, 0x4b, 0xa8, 0x5c, 0x1e, 0x65, 0x4a, 0x13, 0xd8, 0x48, 0x13, 0x13, 
  0x58, 0x29, 0x7c, 0xcf, 0xfe, 0x0a, 0x24, 0x07, 0x8b, 0x0b, 0x03, 0xb9, 
  0x62, 0x75, 0xc8, 0x11, 0x07, 0x34, 0x21, 0x01, 0xd8, 0x08, 0x44, 0xd5, 
  0x68, 0x5b, 0x1d, 0xa1, 0x6e, 0xb2, 0x0b, 0x1e, 0xcb, 0xb4, 0x62, 0x16, 
  0x6c, 0xe7, 0xf5, 0x70, 0x53, 0x57, 0x2b, 0x98, 0x98, 0x16, 0xcf, 0x37, 
  0x51, 0x54, 0x66, 0x8b, 0x23, 0xb5, 0xa8, 0xf5, 0xbb, 0x8a, 0x6b, 0xad, 
  0x48, 0x92, 0x7c, 0x3c, 0x13, 0xdc, 0xfc, 0xb5, 0x97, 0x84, 0x9c, 0xa3, 
  0xea, 0xf2, 0xf2, 0xfb, 0xb3, 0xc3, 0x17, 0xf6, 0xe6, 0x43, 0x7b, 0x26, 
  0xd0, 0x51, 0x88, 0xab, 0x48, 0x14, 0x3e, 0x30, 0xa8, 0xf0, 0x46, 0x44, 
  0x36, 0xac, 0xcc, 0xdf, 0x2b, 0xdd, 0x0c, 0xa3, 0xef, 0x5e, 0x1e, 0x5d, 
  0x9c, 0x1d, 0x9f, 0x1e, 0xbc, 0x78, 0xfe, 0x9d, 0x31, 0xdb, 0x2f, 0x18, 
  0x2b, 0x45, 0x24, 0x30, 0xf7, 0x99, 0xcf, 0x6d, 0xd7, 0xf7, 0x4e, 0x0e, 
  0xbf, 0x7d, 0x47, 0x22, 0xff, 0x0b, 0x86, 0x59, 0x1e, 0xdc, 0xc5, 0x33, 
  0x7d, 0x89, 0xf5, 0xa6, 0x0e, 0xa9, 0x2d, 0x48, 0x43, 0xe8, 0x5a, 0x58, 
  0x14, 0x85, 0xf3, 0x98, 0x97, 0x2b, 0x08, 0xc1, 0x1a, 0x5c, 0x15, 0xd4, 
  0x6a, 0x89, 0x6b, 0x39, 0x85, 0x1d, 0x85, 0xd9, 0x72, 0x77, 0xb1, 0xf7, 
  0x2b, 0x09, 0xb2, 0x63, 0x37, 0x73, 0xe8, 0xbd, 0x45, 0x48, 0xa6, 0x7e, 
  0xe3, 0x83, 0x19, 0x15, 0xd0, 0xb4, 0xe0, 0x20, 0x07, 0x83, 0xc5, 0xd1, 
  0x8e, 0xc5, 0x2f, 0x2a, 0x59, 0x4b, 0x86, 0x41, 0x93, 0x4d, 0x7d, 0x28, 
  0xb1, 0x71, 0x30, 0x95, 0x4e, 0xdc, 0x58, 0xe2, 0xc9, 0x84, 0x7e, 0x30, 
  0x6a, 0x1f, 0x57, 0xc8, 0x38, 0xe3, 0x0a, 0xaf, 0x17, 0x97, 0xfb, 0xa4, 
  0x1b, 0x1d, 0x9c, 0x9e, 0x9c, 0x1c, 0x1e, 0x98, 0x49, 0xd9, 0x6a, 0x42, 
  0x21, 0x65, 0xbd, 0x8e, 0x06, 0x18, 0x82, 0xf7, 0xd7, 0x4e, 0xb4, 0x63, 
  0x70, 0xf5, 0x0c, 0x36, 0x36, 0x12, 0x48, 0x56, 0x1c, 0x8b, 0x98, 0x82, 
  0x69, 0x19, 0x5f, 0xd9, 0x01, 0xce, 0x95, 0x34, 0x1a, 0x18, 0xf6, 0xbe, 
  0xe0, 0xf8, 0x2c, 0x1d, 0x7b, 0x23, 0x78, 0xc3, 0xc5, 0xc8, 0x1e, 0x6c, 
  0xc5, 0x2a, 0x08, 0x8f, 0x90, 0x99, 0xb7, 0x7d, 0x5a, 0x68, 0x99, 0x5b, 
  0xe9, 0x34, 0x21, 0x7e, 0x98, 0x9f, 0xc3, 0xdc, 0x3d, 0xa7, 0x7d, 0x42, 
  0xc9, 0x30, 0x09, 0xcc, 0x7d, 0x1a, 0x44, 0x25, 0x2a, 0xfc, 0x0d, 0xd0, 
  0x24, 0x95, 0x59, 0xa3, 0x3e, 0xa9, 0xa4, 0xe1, 0x64, 0x52, 0x62, 0x1c, 
  0x89, 0xc5, 0x88, 0x25, 0xd1, 0x99, 0xb5, 0x84, 0x0b, 0x95, 0x0a, 0xaf, 
  0x39, 0x7f, 0x07, 0x18, 0x43, 0x53, 0x96, 0xa4, 0x60, 0x5c, 0x0b, 0x3b, 
  0xb3, 0xcb, 0x93, 0x57, 0xd0, 0x0a, 0x0d, 0x8b, 0xb7, 0xd5, 0x8d, 0x5e, 
  0x8a, 0x04, 0x60, 0xe1, 0x11, 0x37, 0x17, 0x17, 0x00, 0xef, 0xab, 0x14, 
  0xbb, 0xd9, 0x54, 0x1a, 0x0d, 0x82, 0x1b, 0xd5, 0xf1, 0x4c, 0x8c, 0x2e, 
  0x35, 0x86, 0xe5, 0xc1, 0x15, 0x75, 0xab, 0x29, 0xe4, 0x5b, 0x24, 0x16, 
  0xdb, 0x22, 0xb6, 0x83, 0x92, 0xfd, 0x07, 0x99, 0x25, 0x69, 0x48, 0xc6, 
  0x05, 0xc7, 0x78, 0x14, 0x0a, 0x15, 0x43, 0xec, 0x8f, 0x2d, 0xc5, 0xa8, 
  0x1e, 0x88, 0xda, 0x77, 0xec, 0x44, 0x33, 0x18, 0x31, 0x07, 0xc0, 0xa1, 
  0xcb, 0x1d, 0x90, 0x95, 0x98, 0xcb, 0x57, 0xda, 0xa1, 0xcb, 0x0e, 0xb6, 
  0xcd, 0x1a, 0x48, 0xb2, 0x49, 0x8c, 0xdc, 0x06, 0x33, 0xd9, 0x06, 0x39, 
  0x72, 0xa5, 0x66, 0x1e, 0x3a, 0x07, 0xa4, 0x30, 0x3c, 0x14, 0x81, 0xf1, 
  0xb9, 0x3a, 0x35, 0x47, 0x1f, 0x09, 0x8e, 0x0b, 0x54, 0x34, 0x99, 0x60, 
  0x67, 0x10, 0xc5, 0xe9, 0x5a, 0xb3, 0x1b, 0xc4, 0xaf, 0x14, 0x2d, 0xe9, 
  0x9b, 0xfd, 0xa3, 0x63, 0x76, 0x27, 0x1e, 0xd3, 0x61, 0xba, 0x30, 0x33, 
  0x2f, 0x7c, 0xae, 0x70, 0x87, 0x92, 0xd4, 0x4c, 0x0b, 0x33, 0x70, 0xb8, 
  0xab, 0x16, 0xac, 0x08, 0x0a, 0x61, 0xdb, 0x88, 0x30, 0x59, 0x05, 0xa3, 
  0x20, 0xd6, 0x36, 0x59, 0x72, 0x74, 0x21, 0x0b, 0xbe, 0xc0, 0x7c, 0x62, 
  0x30, 0x44, 0x58, 0xa3, 0xc0, 0xbc, 0xc4, 0x3f, 0x0c, 0xa8, 0x67, 0xae, 
  0x84, 0x7d, 0xa7, 0x12, 0xaa, 0x40, 0xe8, 0xbc, 0x56, 0x13, 0x90, 0x94, 
  0x7a, 0xa9, 0x36, 0x3a, 0x0b, 0x28, 0x6f, 0x73, 0x9f, 0xdb, 0x72, 0x31, 
  0x4a, 0xb7, 0x1e, 0xe6, 0xd1, 0xec, 0x6d, 0xfc, 0xfc, 0x90, 0xb9, 0x48, 
  0x29, 0x8c, 0xff, 0x6d, 0xa9, 0xc9, 0x42, 0xcd, 0x88, 0x0d, 0x15, 0xc4, 
  0xb4, 0x46, 0x80, 0x28, 0x2e, 0x03, 0x03, 0xe4, 0x12, 0x75, 0x8b, 0x09, 
  0x6f, 0xc0, 0x42, 0x2e, 0x5a, 0xb2, 0x82, 0x7f, 0x03, 0x09, 0x54, 0x87, 
  0xa4, 0x41, 0xaa, 0xcd, 0x20, 0x82, 0xff, 0x89, 0xe9, 0x0d, 0xcf, 0x32, 
  0xa0, 0x50, 0xe0, 0x15, 0xa6, 0x3f, 0x25, 0x24, 0x49, 0xff, 0x42, 0x53, 
  0xc5, 0x12, 0xb8, 0x55, 0x03, 0x44, 0x03, 0xc2, 0x56, 0x23, 0x05, 0x42, 
  0x65, 0xf4, 0x6a, 0x30, 0x95, 0xf1, 0xbf, 0x34, 0x7b, 0x9e, 0xe1, 0x06, 
  0xe5, 0x85, 0xad, 0xaa, 0xac, 0xfe, 0x58, 0x4a, 0x3a, 0x7c, 0xb9, 0x64, 
  0x33, 0x82, 0x83, 0x2c, 0xe6, 0x51, 0xcc, 0xb9, 0x14, 0x4b, 0x22, 0xd5, 
  0x53, 0x5c, 0xe3, 0x7c, 0x66, 0x96, 0xb4, 0xab, 0xd2, 0xfa, 0x71, 0x7e, 
  0xcf, 0xb5, 0x5f, 0xae, 0xae, 0xb8, 0xec, 0xe4, 0xa9, 0xd8, 0x44, 0xe4, 
  0xfb, 0xb9, 0xc1, 0x4c, 0xd3, 0x94, 0xa2, 0xc5, 0x72, 0x3c, 0x23, 0x69, 
  0xcc, 0x62, 0x49, 0xc2, 0xd6, 0xa6, 0xc3, 0xb3, 0xaf, 0xce, 0x6c, 0xa9, 
  0x8d, 0xca, 0x25, 0x0a, 0x59, 0xa3, 0x90, 0xa0, 0xce, 0xd3, 0x43, 0xa3, 
  0xe8, 0x90, 0x45, 0x39, 0xb9, 0x9a, 0x95, 0x37, 0xe2, 0x16, 0xa2, 0xef, 
  0xa8, 0xdb, 0x6b, 0xce, 0x2f, 0x3c, 0x2d, 0xf8, 0x2f, 0xb4, 0xa6, 0x5f, 
  0x8a, 0xc8, 0x89, 0x6f, 0x5d, 0xaf, 0xbc, 0x8d, 0x44, 0x5d, 0xea, 0xd9, 
  0xb7, 0x0a, 0x40, 0xc4, 0x0b, 0xc4, 0x69, 0xaf, 0x10, 0x68, 0xa0, 0xa7, 
  0x83, 0x6f, 0x2e, 0x22, 0x7d, 0x5c, 0xaa, 0x5d, 0x58, 0x58, 0x30, 0x54, 
  0x09, 0x01, 0xf0, 0x9d, 0x93, 0x0a, 0xc6, 0xcd, 0x4b, 0x95, 0xf7, 0xd4, 
  0x52, 0x20, 0x91, 0x04, 0xfb, 0xb7, 0x25, 0x82, 0x9e, 0x22, 0x92, 0x6b, 
  0xae, 0x43, 0x95, 0x69, 0x8e, 0x4a, 0x3e, 0x9a, 0xc0, 0xca, 0x12, 0x02, 
  0x63, 0xe6, 0x05, 0xd4, 0x2e, 0xfb, 0x3c, 0x56, 0xd8, 0x21, 0xaf, 0x4b, 
  0x5f, 0x01, 0x33, 0x9a, 0x73, 0xd0, 0x45, 0x39, 0x80, 0xa1, 0x52, 0xeb, 
  0x28, 0x60, 0x6e, 0x0c, 0x1a, 0xf8, 0x9f, 0x9a, 0x1f, 0xb5, 0xa5, 0x93, 
  0x43, 0x4b, 0x9b, 0x90, 0xa9, 0x67, 0x2b, 0xef, 0xdf, 0xe5, 0xa8, 0xba, 
  0xd1, 0xcf, 0x9c, 0x34, 0x9a, 0x6a, 0x4c, 0x1c, 0x75, 0xe9, 0x41, 0xd0, 
  0x3f, 0x6f, 0xc6, 0x67, 0x48, 0x80, 0xd6, 0x44, 0x09, 0x19, 0x73, 0x70, 
  0x98, 0xf4, 0xc0, 0x39, 0x0f, 0xaf, 0x70, 0x90, 0x42, 0xb2, 0x38, 0x8b, 
  0x44, 0xfd, 0xe1, 0xb9, 0xda, 0xd4, 0xe4, 0x92, 0x2c, 0x93, 0x06, 0x63, 
  0x0a, 0x30, 0x9e, 0xed, 0x0b, 0xe6, 0xe4, 0x29, 0x29, 0xb0, 0x77, 0xe9, 
  0x74, 0x19, 0xcf, 0x46, 0x1b, 0xff, 0x2f, 0x65, 0x57, 0x8f, 0x9f, 0xf9, 
  0x78, 0x01, 0x00, 
};
/* Decompress and send to stdout a gzip-compressed buffer */
void hugehelp(void)
{
  unsigned char buf[0x10000];
  int status,headerlen;
  z_stream z;

  /* Make sure no gzip options are set */
  if (hugehelpgz[3] & 0xfe)
    return;

  headerlen = 10;
  z.avail_in = sizeof(hugehelpgz) - headerlen;
  z.next_in = (unsigned char *)hugehelpgz + headerlen;
  z.zalloc = (alloc_func)Z_NULL;
  z.zfree = (free_func)Z_NULL;
  z.opaque = 0;

  if (inflateInit2(&z, -MAX_WBITS) != Z_OK)
    return;

  while(1) {
    z.avail_out = (int)sizeof(buf);
    z.next_out = buf;
    status = inflate(&z, Z_SYNC_FLUSH);
    if (status == Z_OK || status == Z_STREAM_END) {
      fwrite(buf, sizeof(buf) - z.avail_out, 1, stdout);
      if (status == Z_STREAM_END)
         break;
    }
     else
      break;    /* Error */
  }
  inflateEnd(&z);
}
#endif /* USE_MANUAL */
#endif /* HAVE_LIBZ */
