/* $Id: curses.h,v 1.22 2003/09/11 02:47:44 onoe Exp $ */

/*-
 * Copyright (c) 1998-2001 Atsushi Onoe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/types.h>
#include <stdarg.h>

/* charset support */

#define	CS_SSX		0x80		/* cscode follows */
#define	CS_SS2		0x8e
#define	CS_SS3		0x8f

/* cscode for CS_SSX */
#define	CS_CODE		0x1f		/* charset code */
#define	CS_96SET	0x20		/* 96 charset flag */
#define	CS_DWIDTH	0x40		/* double byte/width 94x94 or 96x96 */

#define	CS_ASCII	('B' & CS_CODE)
#define	CS_KANA		('I' & CS_CODE)
#define	CS_KANJI	(CS_DWIDTH | ('B' & CS_CODE))
#define	CS_HOJO		(CS_DWIDTH | ('D' & CS_CODE))

/* Tiny Curses */

#define	TRUE		1
#define	FALSE		0
#define	OK		0
#define	ERR		-1	/* error input from getch() */
#define	A_CHARTEXT	0x000000ff
#define	A_ATTRIBUTES	0x00000f00
#define	A_NORMAL	0x00000000
#define	A_REVERSE	0x00000100
#define	A_BOLD		0x00000200
#define	A_STANDOUT	0x00000400
#define	A_UNDERLINE	0x00000800
#define	A_COLOR		0x00007000	/*XXX*/
#define	A_COLOR_SHIFT	12
#define	A_COLOR_BLACK	0x00000000
#define	A_COLOR_RED	0x00001000
#define	A_COLOR_GREEN	0x00002000
#define	A_COLOR_YELLOW	0x00003000
#define	A_COLOR_BLUE	0x00004000
#define	A_COLOR_MAGENTA	0x00005000
#define	A_COLOR_CYAN	0x00006000
#define	A_COLOR_WHITE	0x00007000
#define	A_CHARSET	0x007f0000	/* packed charset */
#define	A_CSCODE	(CS_CODE << 16)	/* charset code */
#define	A_CS96SET	(CS_96SET << 16)  /* 96 charset flag */
#define	A_DWIDTH	(CS_DWIDTH << 16) /* double byte/width 94x94 or 96x96 */
#define	a_cspack(c)	(((u_char)(c) << 16) & A_CSCODE)
#define	a_csunpack(a)	((((u_long)(a) & A_CSCODE) >> 16) | 0x40)
#define	A_ASCII		0
#define	A_JIS		(A_DWIDTH | a_cspack('B'))
#define	A_OLDJIS	(A_DWIDTH | a_cspack('@'))
#define	a_isascii(a)	(((a) & A_CHARSET) == A_ASCII || ((a) & A_CS96SET))

/* XXX */
typedef int WINDOW;
typedef int bool;

#define	move(y,x)	(((y) >= LINES || (x) >= COLS) ? ERR : (cury = (y), curx = (x), OK))
#define	getyx(scr,y,x)	((y) = cury, (x) = curx)
#define	addstr(str)	addnstr((str), -1)
#define instr(str)	innstr((str), -1)
#define	standout()	attron(A_STANDOUT)
#define	standend()	attrset(A_NORMAL)

int addnstr(char *str, int n);
int innstr(char *str, int n);
int getch(void);
int ungetch(int c);
int inch(void);
int refresh(void);
int endwin(void);
int nodelay(WINDOW *scr, bool bf);
int noecho(void);
int echo(void);
int cbreak(void);
int raw(void);
int nonl(void);
int halfdelay(int tenth);
int attron(int attr);
int attroff(int attr);
int attrset(int attr);
int addch(int ch);
int scrl(int n);
int insdelln(int n);
int beep(void);
int clear(void);
int erase(void);
int clrtoeol(void);
int clrtobot(void);
WINDOW *initscr(void);
int printw(char *fmt, ...);
int vwprintw(WINDOW *win, char *fmt, va_list ap);
int hline(int ch, int n);
int scrollok(WINDOW *win, bool bf);
int clearok(WINDOW *win, bool bf);
int idlok(WINDOW *win, bool bf);

/* XXX win is not supported for now */
int wmove(WINDOW *win, int y, int x);
int waddch(WINDOW *win, int ch);
int waddstr(WINDOW *win, char *str);
int waddnstr(WINDOW *win, char *str, int n);
int winch(WINDOW *win);
int winstr(WINDOW *win, char *str);
int winnstr(WINDOW *win, char *str, int n);
int wrefresh(WINDOW *win);
int wclrtoeol(WINDOW *win);
int wclear(WINDOW *win);
int wstandout(WINDOW *win);
int wstandend(WINDOW *win);
int wattrset(WINDOW *win, int attr);
int wattron(WINDOW *win, int attr);
int wattroff(WINDOW *win, int attr);
WINDOW *newwin(int nlines, int ncols, int begin_y, int begin_x);
int delwin(WINDOW *win);
int box(WINDOW *win, int verch, int horch);

#ifdef CUE
/* extensions */
int cangetch(int msec);
#endif

extern int LINES, COLS;
extern WINDOW *stdscr, *curscr;
extern int cury, curx;
