/* $Id: util.c,v 1.3 2003/04/17 06:41:56 itojun Exp $ */

/*-
 * Copyright (c) 1999 Atsushi Onoe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <stdlib.h>
#include <string.h>

#include "cue.h"

char *
copy_kbuf(struct kbuf **kbufp, char *buf, int len)
{
	struct kbuf *kbuf;
	char *ret;
	int size;

	for (kbuf = *kbufp; ; kbuf = kbuf->next) {
		if (kbuf == NULL) {
			size = sizeof(*kbuf);
			if (len > CHARBLOCK)
				size += (len - CHARBLOCK);
			kbuf = malloc(size);
			if (kbuf == NULL)
				return NULL;
			kbuf->inuse = 0;
			kbuf->next = *kbufp;
			*kbufp = kbuf;
			break;
		}
		if (kbuf->inuse + len <= CHARBLOCK)
			break;
	}
	ret = &kbuf->buf[kbuf->inuse];
	memcpy(ret, buf, len);
	kbuf->inuse += len;
	return ret;
}

	int	size;
	int	ptr;
	char	*buf;

char *
copy_abuf(struct abuf *abuf, char *buf, int len)
{
	char *ret;

	if (abuf->buf.len + len > abuf->size) {
		while (abuf->buf.len + len > abuf->size)
			abuf->size += CHARBLOCK;
		abuf->buf.ptr = realloc(abuf->buf.ptr, abuf->size);
	}
	ret = abuf->buf.ptr + abuf->buf.len;
	if (len > 0)
		memcpy(ret, buf, len);
	abuf->buf.len += len;
	return ret;
}

void
fname_expand(char *name, char *buf)
{
	char *p;
	int len, hlen;

	/* in place expansion: ..//.. -> /.. , ../~/.. -> ~/.. */
	len = strlen(name);
	for (p = name + len - 2; p >= name; p--) {
		if (*p != '/')
			continue;
		if (p[1] == '/' || (p[1] == '~' && p[2] == '/')) {
			memmove(name, p + 1, len - (p - name));
			break;
		}
	}
	if (buf == NULL)
		return;

	/* name and buf can be same buffer */
	len = strlen(name);
	if (name[0] != '~' || name[1] != '/') {
		memmove(buf, name, len);
		return;
	}
	p = getenv("HOME");
	if (p == NULL)
		p = "";
	hlen = strlen(p);
	memmove(buf + hlen, name + 1, len);	/* with '\0' */
	memcpy(buf, p, hlen);			/* without '\0' */
	return;
}

int
fname_completion(char *candidate, void (*callback)(void *arg, char *entry), void *arg)
{
	int nmatch = 0;
	int matchlen, len, nlen;
	int i, l;
	char *fname, *ep;
	char dname[MAXPATH], mname[MAXPATH];
	DIR *dirp;
	struct dirent *dp;
	struct stat stbuf;

	if ((fname = strrchr(candidate, '/')) != NULL) {
		fname_expand(candidate, dname);
		candidate = fname + 1;
		fname = strrchr(dname, '/');
		/* assert(fname != NULL); */
		*fname = '\0';
	} else {
		strlcpy(dname, ".", sizeof(dname));
		fname = dname + 1;
	}
	ep = dname + sizeof(dname);
	dirp = opendir(dname);
	if (dirp == NULL)
		return 0;
	*fname++ = '/';
	len = strlen(candidate);
	matchlen = 0;
	mname[0] = '\0';
	l = 0;
	while ((dp = readdir(dirp)) != NULL) {
		if (strcmp(dp->d_name, ".") == 0 || strcmp(dp->d_name, "..") == 0)
			continue;
		strlcpy(fname, dp->d_name, ep - fname);
#ifdef DT_REG
		if (dp->d_type != DT_REG)
#endif /* DT_REG */
		if (stat(dname, &stbuf) == 0 && S_ISDIR(stbuf.st_mode))
			strcat(fname, "/");
		nlen = strlen(fname);
		if (nlen >= len &&
		    memcmp(fname, candidate, len) == 0) {
			if (nmatch && mname[0]) {
				for (i = len; i < matchlen; i++) {
					if (i >= nlen
					||  fname[i] != mname[i]) {
						matchlen = i;
						break;
					}
				}
			} else {
				matchlen = nlen;
			}
			nmatch++;
			if (callback)
				callback(arg, fname);
			strlcpy(mname, fname, sizeof(mname));
		}
	}
	closedir(dirp);
	if (nmatch && matchlen > len) {
		memcpy(candidate + len, mname + len, matchlen - len);
		candidate[matchlen] = '\0';
	}
	return nmatch;
}
