/* $Id: decode.h,v 1.13 2001/10/10 01:51:47 onoe Exp $ */

/*-
 * Copyright (c) 1998-2000 Atsushi Onoe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

struct decode {
	char	*buf;
	int	bufsiz;
	int	cnt;
	void	(*flsbuf)(struct decode *dp);
	u_long	pend;
	u_int	esc:1,
		err:1,
		encoded:1,
		noconv:1,
		notext:1,
		sjis:2,
		lang:2,
		mode:3,
		bclen:2;
};

extern char hex[], b64[], rhex[], rb64[];

#define	DM_ASCII	0
#define	DM_KANJI	1
#define	DM_KANA		2
#define	DM_88591	3
#define	DM_KOREAN	4

#define	DL_JAPANESE	0
#define	DL_KOREAN	1
#define	DL_88591	2

static void
OFLUSH(struct decode *dp)
{
	if (dp->flsbuf != NULL) {
		(*dp->flsbuf)(dp);
	} else {
		dp->bufsiz += CHARBLOCK;
		dp->buf = realloc(dp->buf, dp->bufsiz);
	}
}

#define	OUTC(dp, c) do {						\
	if ((dp)->cnt >= (dp)->bufsiz)					\
		OFLUSH(dp);						\
	(dp)->buf[(dp)->cnt++] = (char)(c);				\
} while (0)

static void
BFLUSH(struct decode *dp)
{
	u_char x;
	int i;

	while (dp->bclen > 0) {
		for (i = 0; i < 4; i++) {
			if (6 * i < 8 * dp->bclen)
				x = b64[(dp->pend >> (6 * (3-i))) & 0x3f];
			else
				x = '=';
			OUTC(dp, x);
		}
		dp->pend = 0;
		dp->bclen = 0;
	}
}

#define	BOUTC(dp, c) do {						\
	(dp)->pend |= (u_char)(c) << (8 * (2 - (dp)->bclen));		\
	if (++(dp)->bclen == 3)						\
		BFLUSH(dp);						\
} while (0)
