module Main(main) where

import Codec.Encryption.Utils
import Codec.Encryption.SHA1
import Codec.Encryption.MGF
import Codec.Encryption.EMEOAEP
import Codec.Encryption.RSA
import Char

n :: [Octet]
n =
   [0xBF, 0x74, 0x80, 0x89, 0x59, 0x91, 0xC2, 0x32,
    0x56, 0xE2, 0xC5, 0x37, 0x90, 0x7F, 0xE1, 0xD3,
    0xB4, 0x8C, 0x5B, 0xAF, 0x78, 0xA3, 0xEA, 0x3D, 
    0xD2, 0x32, 0x8B, 0x44, 0x9D, 0x36, 0x64, 0x02, 
    0xFC, 0x00, 0xD5, 0x74, 0xAA, 0x67, 0x9C, 0x40,
    0x0E, 0x8C, 0xAD, 0xED, 0x90, 0x18, 0xC1, 0x87,
    0x66, 0x46, 0xBA, 0xAD, 0x8D, 0x33, 0x5B, 0xCC,
    0xBD, 0xF8, 0x19, 0x06, 0x60, 0x78, 0xCB, 0x61]
					     
d ::[Octet]
d = 
   [0x7F, 0xA3, 0x00, 0x5B, 0x91, 0x0B, 0xD6, 0xCC, 
    0x39, 0xEC, 0x83, 0x7A, 0x60, 0x55, 0x41, 0x37,
    0xCD, 0xB2, 0xE7, 0xCA, 0x50, 0x6D, 0x46, 0xD3,
    0xE1, 0x77, 0x07, 0x83, 0x13, 0x79, 0x98, 0x00,
    0xD5, 0xFA, 0x8A, 0x45, 0xD4, 0x54, 0xC4, 0xEE,
    0x69, 0x28, 0x66, 0x99, 0x8C, 0xF3, 0xE1, 0xAF,
    0x89, 0xA5, 0xA2, 0x70, 0x6C, 0xD9, 0x81, 0xF5,
    0xD7, 0x0D, 0x5E, 0xDC, 0xC7, 0xA0, 0x76, 0x83]


seed :: [Octet]
seed = [0xaa, 0xfd, 0x12, 0xf6, 0x59, 0xca, 0xe6, 0x34,
        0x89, 0xb4, 0x79, 0xe5, 0x07, 0x6d, 0xde, 0xc2, 
        0xf0, 0x6c, 0xb5, 0x8f]

e :: [Octet]
e = [0x11]

plaintext x =
   decode mgf hash [] $ 
   decrypt (n,d) $ 
   map (fromIntegral . ord) x

main = 
   do x <- readFile "ciphertext" 
      putStrLn $ show $ plaintext x
