module Main(main) where

import Codec.Encryption.Utils
import Codec.Encryption.Blowfish as Blowfish
import Codec.Encryption.Modes
import Codec.Encryption.Padding
import Codec.Encryption.DES as DES
import Data.Word
import Data.Bits
import Numeric
import Char

x = toOctets 257


-- Blowfish Tests.

-- Tests from http://www.counterpane.com/vectors.txt.

d = 0xFEDCBA9876543210 :: Word64
k = 0xF0 :: Word8
e = 0xF9AD597C49DB005E :: Word64
e' = Blowfish.encrypt k d
blowfish1 = e == e'

k2 = 0xF0E1 :: Word16
e2 = 0xE91D21C1D961A6D6 :: Word64
e2' = Blowfish.encrypt k2 d
blowfish2 = e2 == e2'

e8 = 0xE87A244E2CC85E82 :: Word64
k8 = 0xF0E1D2C3B4A59687 :: Word64
e8' = Blowfish.encrypt k8 d
blowfish3 = e8 == e8'

-- Defne a 128 bit word for use as a key.

data Word128 = W128 {lo,hi::Word64} deriving (Eq, Ord, Bounded)

w128ToInteger W128{lo=lo,hi=hi} = 
   toInteger lo + 0x10000000000000000 * toInteger hi
integerToW128 x = 
   case x `quotRem` 0x10000000000000000 of
      (h,l) -> W128{lo=fromInteger l, hi=fromInteger h}

instance Show Word128 where
   showsPrec p = showInt . w128ToInteger

instance Read Word128 where
   readsPrec p s = [ (integerToW128 x,r) | (x,r) <- readDec s ]

instance Num Word128 where
   W128{lo=lo_a,hi=hi_a} + W128{lo=lo_b,hi=hi_b} = W128{lo=lo', hi=hi'}
      where lo' = lo_a + lo_b
            hi' = hi_a + hi_b + if lo' < lo_a then 1 else 0
   fromInteger = integerToW128

instance Bits Word128 where
 W128{lo=lo_a,hi=hi_a} .&. W128{lo=lo_b,hi=hi_b} = W128{lo=lo', hi=hi'}
  where lo' = lo_a .&. lo_b
        hi' = hi_a .&. hi_b
 W128{lo=lo_a,hi=hi_a} .|. W128{lo=lo_b,hi=hi_b} = W128{lo=lo', hi=hi'}
  where lo' = lo_a .|. lo_b
        hi' = hi_a .|. hi_b
 shift w 0 = w
 shift W128{lo=lo,hi=hi} x
  | x > 127 = W128{lo=0,hi=0}
  | x > 63 = W128{lo = 0, hi = shift lo (x-64)}
  | x > 0 = W128{lo = shift lo x, hi = shift hi x .|. shift lo (x-64)}
 xor W128{lo=alo,hi=ahi} W128{lo=blo,hi=bhi} = 
   W128{lo=alo `xor` blo, hi=ahi `xor` bhi}

instance Integral Word128 where
 toInteger = w128ToInteger

instance Real Word128
instance Enum Word128

-- Blowfish test with 128 bit key.

e16 = 0x93142887EE3BE15C :: Word64
k16= 0xF0E1D2C3B4A5968778695A4B3C2D1E0F :: Word128
e16' = Blowfish.encrypt k16 d
blowfish4 = e16 == e16'

-- Blowfish test with Cipher Block Chaining.
-- Set up the published key, initialization vector and data.

key16 = 0x0123456789ABCDEFF0E1D2C3B4A59687 :: Word128
iv8     = 0xFEDCBA9876543210 :: Word64
data29  = "7654321 Now is the time for \NUL"

-- Pad with nulls as in the example.

e29' = 
   cbc Blowfish.encrypt iv8 key16 $ padNulls $ map (fromIntegral . ord) data29

e29 = [0x6B,0x77,0xB4,0xD6,0x30,0x06,0xDE,0xE6,
       0x05,0xB1,0x56,0xE2,0x74,0x03,0x97,0x93,
       0x58,0xDE,0xB9,0xE7,0x15,0x46,0x16,0xD9,
       0x59,0xF1,0x65,0x2B,0xD5,0xFF,0x92,0xCC] :: [Octet]

blowfish5 = (concat $ map toOctets e29') == e29

-- DES Tests

-- Test from http://www.itl.nist.gov/fipspubs/fip81.htm

key = 0x0123456789abcdef :: Word64
iv = 0x1234567890abcdef :: Word64
expectedDES = [0xe5c7cdde872bf27c,
               0x43e934008c389c0f,
               0x683788499a7c05f6] :: [Word64]
plainText = "Now is the time for all " 

-- Pad using PKCS#5 so only take the first 3 blocks of the ciphertext.

cipherText = 
   cbc DES.encrypt iv key $ pkcs5 $ map (fromIntegral . ord) plainText
des1 = expectedDES == (take 3 cipherText)

main = 
   do putStrLn "Testing DES..."
      if des1 then putStrLn "Passed" else putStrLn "Failed"
      putStrLn "Testing Blowfish..."
      if blowfish1 then putStrLn "Passed" else putStrLn "Failed"
