module Main(main) where

import IO
import Char
import Control.Monad.State
import Codec.ASN1.ASN1 as A
import Codec.Encryption.Utils
import Codec.Encryption.PKCS8
import Codec.Encryption.SHA1
import Codec.Encryption.MGF
import Codec.Encryption.EMEOAEP as E
import Codec.Encryption.RSA

plaintext n d x =
   E.decode mgf hash [] $ 
   decrypt (n,d) $ 
   map (fromIntegral . ord) x

main = 
   do ifh <- openFile "private.der" ReadMode
      (x,y) <- A.decode ifh
      let z = fromASN NoTag y 
      x <- readFile "ciphertext" 
      putStrLn $ show $ plaintext (toOctets $ modulus $ privateKey z) 
                                  (toOctets $ privateExponent $ privateKey z) x
