// CoMET - The Crimson Fields Map Editing Tool
// Copyright (C) 2002-2003 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// extwindow2.h - extended window classes for CoMET
///////////////////////////////////////////////////////////////

#ifndef _INCLUDE_ED_EXTWINDOW2_H
#define _INCLUDE_ED_EXTWINDOW2_H

#include "window.h"
#include "button.h"
#include "edwidget.h"
#include "misc.h"
#include "mission.h"
#include "mapview.h"

// non-private widget ID's for various windows
#define B_ID_NMW_CREATE  101
#define B_ID_SUW_OK      102

class ListExchangeWindow : public Window, public WidgetHook {
public:
  ListExchangeWindow( TLWList &l1, TLWList &l2, const char *label1,
                      const char *label2, View *view );
  void SetHook( WidgetHook *hook ) const { ok->SetHook(hook); }

private:
  GUI_Status WidgetActivated( Widget *widget, Window *win );

  static const short B_ID_OK;
  static const short B_ID_RIGHT;
  static const short B_ID_LEFT;

  ButtonWidget *ok;
  TextListWidget *wd_l1;
  TextListWidget *wd_l2;
  TLWList &list1;
  TLWList &list2;
};

class ListSelectWindow : public Window, public WidgetHook {
public:
  ListSelectWindow( const char *title, TLWList &list,
            short defid, bool nullok, WidgetHook *hook,
            short button, View *view );

  TLWNode *Selected( void ) const { return current; }

private:
  GUI_Status WidgetActivated( Widget *widget, Window *win );

  short button;
  bool nullok;
  TextListWidget *lw;
  const TLWList &list;
  WidgetHook *client;
  TLWNode *current;
};

// create a new mission
class NewMissionWindow : public Window, public WidgetHook {
public:
  NewMissionWindow( View *view );

  void SetHook( WidgetHook *hook ) const { ok->SetHook(hook); }

  Point GetMapSize( void ) const;
  const char *GetTileSet( void ) const { return tileset->String(); }
  const char *GetUnitSet( void ) const { return unitset->String(); }

private:
  GUI_Status WidgetActivated( Widget *button, Window *win );

  static const short B_ID_UNITSET;
  static const short B_ID_TILESET;
  static const short B_ID_UNITSET_OK;
  static const short B_ID_TILESET_OK;

  NumberWidget *m_width;
  NumberWidget *m_height;
  StringWidget *tileset;
  StringWidget *unitset;
  ButtonWidget *ok;
};

class EdMissionSetupWindow : public Window, public WidgetHook {
public:
  EdMissionSetupWindow( Mission &mission, View *view );

private:
  GUI_Status WidgetActivated( Widget *widget, Window *win );

  static const short S_ID_PLAYER1;
  static const short S_ID_PLAYER2;
  static const short B_ID_BRIEFING1;
  static const short B_ID_BRIEFING2;
  static const short B_ID_BRIEFING1_OK;
  static const short B_ID_BRIEFING2_OK;
  static const short B_ID_INFOMSG;
  static const short B_ID_INFOMSG_OK;
  static const short B_ID_SHOWMSG;
  static const short B_ID_NEXTMAP;
  static const short B_ID_NEXTMAP_OK;
  static const short S_ID_PASSWORD;
  static const short B_ID_PLAYERS;

  Mission &mission;

  StringWidget *nextmap;
  TextScrollWidget *msg;
  CycleWidget *showmsg;

  TLWList tlist;
};

class EdBuildingWindow : public Window, public WidgetHook {
public:
  EdBuildingWindow( Building &bld, Mission &mission, View *view );

private:
  GUI_Status WidgetActivated( Widget *widget, Window *win );

  static const short B_ID_PLAYER;
  static const short B_ID_WORKSHOP;
  static const short B_ID_FACTORY;
  static const short B_ID_CRYSTALS;
  static const short B_ID_MINING;
  static const short B_ID_OK;
  static const short B_ID_NAME;
  static const short B_ID_UNITS;
  static const short N_ID_MAXCRYSTALS;
  static const short B_ID_FACTORY_UNITS;

  Building &b;
  Mission &mission;

  StringWidget *b_name;
  CycleWidget *b_player;
  NumberWidget *b_crystals;
  NumberWidget *b_maxcrystals;
  NumberWidget *b_mining;
  ButtonWidget *b_factory_units;

  TLWList fact_list_ok;
  TLWList fact_list_na;
};


class EdUnitWindow : public Window, public WidgetHook {
public:
  EdUnitWindow( Unit &unit, Mission &mission, View *view );

  void SetMapView( MapView &mapview ) { mv = &mapview; }

private:
  GUI_Status WidgetActivated( Widget *button, Window *win );

  static const short B_ID_PLAYER;
  static const short B_ID_DIRECTION;
  static const short N_ID_CRYSTALS;
  static const short B_ID_UNITS;
  static const short B_ID_OK;

  Unit &u;
  Mission &mission;
  MapView *mv;           // we need this to update the map display
                         // if e.g. owner or direction changes
  CycleWidget *u_player;
};


class EdEventsWindow : public Window, public WidgetHook {
public:
  EdEventsWindow( Mission &mission, View *view );

private:
  GUI_Status WidgetActivated( Widget *button, Window *win );

  static const short B_ID_NEW;
  static const short B_ID_EDIT;
  static const short B_ID_DELETE;
  static const short B_ID_OK;

  TextListWidget *e_list;
  TLWList nodes;
  Mission &mission;
};


class SelectEventWindow : public Window, public WidgetHook {
public:
  SelectEventWindow( Mission &mission, View *view );

private:
  GUI_Status WidgetActivated( Widget *button, Window *win );
  void BuildTLWList( TLWList &list ) const;

  static const short B_ID_TRIGGER;
  static const short B_ID_OK;
  static const short B_ID_CANCEL;

  TextListWidget *e_list;
  CycleWidget *e_trigger;
  TLWList nodes;
  Mission &mission;
};


class EdUnitsWindow : public Window, public WidgetHook {
public:
  EdUnitsWindow( Mission &mission, MapObject &container,  View *view );

private:
  GUI_Status WidgetActivated( Widget *button, Window *win );
  void BuildTLWList( TLWList &list ) const;

  static const short B_ID_NEW;
  static const short B_ID_EDIT;
  static const short B_ID_DELETE;
  static const short B_ID_OK;

  TextListWidget *e_list;
  TLWList nodes;
  TLWList utypes;
  Mission &mission;
  MapObject &container;
};

class SelectUnitWindow : public Window, public WidgetHook {
public:
  SelectUnitWindow( Mission &mission, WidgetHook *hook, View *view );
  SelectUnitWindow( Mission &mission, TLWList &list,
                    WidgetHook *hook, View *view );

  const UnitType *Selected( void ) const;

private:
  GUI_Status WidgetActivated( Widget *button, Window *win );
  void Init( TLWList &list, WidgetHook *hook );

  static const short B_ID_CANCEL;

  TextListWidget *e_list;
  TLWList nodes;
  Mission &mission;
};

#endif	// _INCLUDE_ED_EXTWINDOW2_H

