// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000-2003 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// options.h 
// This is used as a persistent options container that holds
// relevant settings for longer than the actual Game object
// exists and can be used to properly reinitialize when a
// new game starts.
///////////////////////////////////////////////////////////////

#ifndef _INCLUDE_OPTIONS_H
#define _INCLUDE_OPTIONS_H


class Options {
public:
  Options( void ) : ai(true), pbem(false), show_damage(true),
                    replay(true) {}

  void SetComputerPlayer( bool cp ) { ai = cp; }
  void SetPBEM( bool mail ) { pbem = mail; }
  void SetDamageIndicator( bool di ) { show_damage = di; }
  void SetTurnReplay( bool rep ) { replay = rep; }

  bool GetComputerPlayer( void ) { return ai; }
  bool GetPBEM( void ) { return pbem; }
  bool GetDamageIndicator( void ) { return show_damage; }
  bool GetTurnReplay( void ) { return replay; }

private:
  bool ai;            // play against computer
  bool pbem;          // play by email
  bool show_damage;   // show damage indicator
  bool replay;        // show turn replays
};

#endif	/* _INCLUDE_OPTIONS_H */

