// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000-2003 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

////////////////////////////////////////////////////////////////////////
// game.h
////////////////////////////////////////////////////////////////////////

#ifndef _INCLUDE_GAME_H
#define _INCLUDE_GAME_H

#include <string>
using namespace std;

#include "lset.h"
#include "player.h"
#include "mapwindow.h"
#include "extwindow.h"
#include "list.h"
#include "path.h"
#include "globals.h"

#define PROGRAMNAME "Crimson Fields"

// global vars
extern class Game *Gam;
extern class Image *Images[];

#define ICON_WIDTH	32
#define ICON_HEIGHT	32
#define XP_ICON_WIDTH	12
#define XP_ICON_HEIGHT	14

#define ICON_XP_BASE	0	// XP icons are 0 through 6
#define NUM_IMAGES	7

#define DEFAULT_DELAY	(5 * ANIM_SPEED_UNIT)

class History;
class Event;

class Game : public WidgetHook {
public:
  Game( View *view );
  virtual ~Game( void );

  int Load( const char *file );
  int Save( const char *file );
  int SwitchMap( const char *mission );

  void Quit( void ) const;
  Unit *LoadUnit( SDL_RWops *file, bool force = false );

  void StartTurn( void );
  GUI_Status EndTurn( void );

  Building *GetBuildingByID( unsigned short id ) const;
  Unit *GetUnitByID( unsigned short id ) const;
  Event *GetEventByID( unsigned char id ) const;

  void SetCursor( const Point &cursor ) const;
  Unit *MoveUnit( Unit *u, const Point &dest );
  int MoveUnit( Unit *u, Direction dir );
  void SelectUnit( Unit *u );
  void SelectNextUnit( void );
  void DeselectUnit( bool update = true );
  void EnterSpecialMode( unsigned char mode );
  bool UnitTargets( Unit *u ) const;
  Unit *CreateUnit( const UnitType *type, const Point &hex, Player *player );
  void RegisterCombat( Unit *att, Unit *def );

  void MoveCommand( int key );
  void SelectCommand( void );

  Player *CurrentPlayer( void ) const { return player; }
  Player *NextPlayer( void ) const { return players[player->ID()^1]; }
  unsigned short Turn( void ) const { return turn; }
  List *UnitsList( void ) { return &units; }
  List *BuildingsList( void ) { return &buildings; }
  Player *GetPlayer( unsigned char id ) const { return players[id]; }
  void SetNextMap( signed char mapid ) { next_map = mapid; }

  bool HaveWinner( void );
  GUI_Status CheckEvents( void );
  History *GetHistory( void ) const { return history; }
  MapWindow *GetMapWindow( void ) const { return mwin; }
  const char *GetMessage( unsigned short id ) const { return messages[id]; }

  const UnitType *GetUnitType( unsigned short type ) const { return unit_set->GetUnitInfo(type); }
  void UnitInfo( Unit *unit );
  void ShowBriefing( void ) const;
  void ShowDebriefing( Player *player, bool restart );
  void ShowLevelInfo( void ) const;
  void ContainerContent( UnitContainer *c );
  void GameMenu( void );
  void UnitMenu( Unit *unit );
  void SetPlayerPassword( Player *player ) const;
  bool CheckPassword( const char *title, const char *msg, const char *pw, bool retry ) const;
  const char *GetLevelPassword( void ) const { return (password[0] != '\0') ? password : NULL; }

  GUI_Status HandleEvent( const SDL_Event &event );
  GUI_Status WidgetActivated( Widget *button, Window *win );

private:
  string CreateSaveFileName( const char *filename ) const;
  void ClearMine( Transport *sweeper, Unit *mine );

  MapWindow *mwin;

  unsigned short flags;
  unsigned short turn;
  unsigned short msg_num;
  unsigned long msg_len;

  List units;           // list of units
  List buildings;       // list of structures
  List events;          // list of events
  List combat;          // list of combat records

  Player *player;       // current player
  Unit *unit;		// selected unit

  Player *players[2];   // array of players
  char **messages;
  string last_file_name; // remember save file names

  unsigned char turn_phase;
  signed char level_info;
  signed char next_map;
  char password[8];

  Map *map;
  History *history;
  UnitSet *unit_set;
  TerrainSet *terrain_set;
  MoveShader *shader;
  View *view;

  Unit *g_tmp_prv_unit;
};

#endif	/* _INCLUDE_GAME_H */

