/* common.monoalphabetic.h - common monoalphabetic key routines header
 * 
 * This program is part of Crank, a cryptanalysis tool
 * Copyright (C) 2000 Matthew Russell
 *
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License (LICENSE) for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#define UPPER_KEY_BOUND ((int) ('Z' + 1))
typedef char key[UPPER_KEY_BOUND];

GtkWidget *make_key_display(key *global_key_ptr, GtkWidget **global_key_labels);
void update_key_labels(key *global_key_ptr, GtkWidget **global_key_labels);
char *apply_key_text(key *k, char *text);
void key_identity(key *k);
void key_copy(key *k1, key *k2);
void key_swap(key *k, int index1, int index2);
void key_shift_L(key *k);
void key_shift_R(key *k);
void key_reverse(key *k);  
void key_invert(key *k);
void key_clear (key *k);
void key_complete (key *k);
