/* preprocess.c - Source text processing
 * 
 * This program is part of Crank, a cryptanalysis tool
 * Copyright (C) 2000 Matthew Russell
 *
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License (LICENSE) for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#include "crank.h"

/* Global variables */
preprocess_options preprocess_opts; /* Options selected for preprocessing */

/* Removes punctuation, whitespace and numbers */
char *do_preprocess(char *text) {
    int length = strlen(text), copy_pos = 0, i;
    char *buf = malloc((length + 1) * sizeof(char)), c;
    for (i=0; i < length; i++) {
	c = text[i];
	if (!isprint(c) && !isspace(c))
	    continue;
	if (preprocess_opts.remove_punctuation && ispunct(c))
	    continue;
	if (preprocess_opts.remove_whitespace && isspace(c))
	    continue;
	if (preprocess_opts.remove_numbers && isalnum(c) && !isalpha(c))
	    continue;
	buf[copy_pos++] = c;
    }
    buf[copy_pos] = '\0';
    free(text);
    return buf;
}

/* Toggles the global preprocessing options */
void prepro_check_toggle(int option_number) {
    switch (option_number) {
    case PREPRO_WHITESPACE:
	TOGGLE(preprocess_opts.remove_whitespace); break;
    case PREPRO_PUNCTUATION:
	TOGGLE(preprocess_opts.remove_punctuation); break;
    case PREPRO_NUMBERS:
	TOGGLE(preprocess_opts.remove_numbers); break;
    default:
	g_print("ERROR: Unknown preprocessor toggle type - %d\n", option_number); break;
    }
}



