/*
** Copyright 1998 - 2002 Double Precision, Inc.
** See COPYING for distribution information.
*/

#if	HAVE_CONFIG_H
#include	"config.h"
#endif
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<errno.h>
#include	<ctype.h>
#include	<fcntl.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#if HAVE_DIRENT_H
#include <dirent.h>
#define NAMLEN(dirent) strlen((dirent)->d_name)
#else
#define dirent direct
#define NAMLEN(dirent) (dirent)->d_namlen
#if HAVE_SYS_NDIR_H
#include <sys/ndir.h>
#endif
#if HAVE_SYS_DIR_H
#include <sys/dir.h>
#endif
#if HAVE_NDIR_H
#include <ndir.h>
#endif
#endif
#if	HAVE_UTIME_H
#include	<utime.h>
#endif
#if TIME_WITH_SYS_TIME
#include	<sys/time.h>
#include	<time.h>
#else
#if HAVE_SYS_TIME_H
#include	<sys/time.h>
#else
#include	<time.h>
#endif
#endif

#include	<sys/types.h>
#include	<sys/stat.h>

#include	"imaptoken.h"
#include	"imapwrite.h"
#include	"imapscanclient.h"

#include	"mysignal.h"
#include	"imapd.h"
#include	"fetchinfo.h"
#include	"searchinfo.h"
#include	"storeinfo.h"
#include	"mailboxlist.h"

#include	"maildir/config.h"
#include	"maildir/maildirmisc.h"

static const char rcsid[]="$Id: mailboxlist.c,v 1.13 2002/07/02 20:01:37 mrsam Exp $";

static const char hierchs[]={HIERCH, 0};

extern char *set_namespace_options(char *);
extern char *valid_mailbox_name(const char *, int);
extern char *decode_valid_mailbox(const char *, int);
/*
		LIST MAILBOXES
*/

static void do_mailbox_list(const char *, char *, int, const char *);

extern int flat_folders;

/*
**	IMAP sucks.  Here's why.
*/

int mailbox_list(const char *tag, const char *reference, const char *name,
	const char *cmd)
{
char	*pattern, *p;
int	nullname= *name == 0;

	if (strchr(reference, '*') || strchr(reference, '%'))
		return (0);	/* Cannot have wildcards in reference */

	pattern=malloc(strlen(reference)+strlen(name)+2);

	strcpy(pattern, reference);

	p=strrchr(pattern, HIERCH);
	if (p && p[1] == 0)	*p=0; /* Strip trailing . for now */
	if (*pattern)
	{
	char	*q, *r;

		/* need to run set_namespace_options in order to flip some
		** magic switches.  For that, put the HIERCH back.
		*/

		q=malloc(strlen(pattern)+2);
		if (!q)	write_error_exit(0);
		strcat(strcpy(q, pattern), hierchs);
		r=q;

		if (r)
		{
		char	*s=strrchr(r, HIERCH);

			/*
			** Remove trailing period to check for valid mailbox
			** name!!.
			*/
			if (s && s[1] == 0)	*s=0;

			r=valid_mailbox_name(r, 1);
		}
		if (!r)
		{
			free(q);
			free(pattern);
			return (0);
		}
		free(q);
		free(r);
	}

	/* Combine reference and name. */
	if (*pattern)
		strcat(pattern, hierchs);
	strcat(pattern, name);

	if (name && *name)
	{
	char *s=strrchr(pattern, HIERCH);

		if (s && s[1] == 0)	*s=0;	/* strip trailing . */

	}

	/* Now, do the list */

	do_mailbox_list(tag, pattern, nullname, cmd);
	free(pattern);
	return (0);
}

static int match_mailbox(char *, char *);

/* Check if a folder has any new messages */

static int hasnewmsgs2(const char *dir)
{
DIR	*dirp=opendir(dir);
struct	dirent *de;

	while (dirp && (de=readdir(dirp)) != 0)
	{
	char	*p;

		if (de->d_name[0] == '.')	continue;
		p=strrchr(de->d_name, MDIRSEP[0]);
		if (p == 0 || strncmp(p, MDIRSEP "2,", 3) ||
			strchr(p, 'S') == 0)
		{
			closedir(dirp);
			return (1);
		}
	}
	if (dirp)	closedir(dirp);
	return (0);
}

static int hasnewmsgs(const char *folder)
{
char *dir=decode_valid_mailbox(folder, 0);
char *subdir;

	if (!dir)	return (0);

	if (is_sharedsubdir(dir))
		maildir_shared_sync(dir);

	subdir=malloc(strlen(dir)+sizeof("/cur"));
	if (!subdir)	write_error_exit(0);
	strcat(strcpy(subdir, dir), "/new");
	if (hasnewmsgs2(subdir))
	{
		free(subdir);
		free(dir);
		return (1);
	}

	strcat(strcpy(subdir, dir), "/cur");
	if (hasnewmsgs2(subdir))
	{
		free(subdir);
		free(dir);
		return (1);
	}

	free(subdir);
	free(dir);
	return (0);
}

/* Each folder is listed with the \Noinferiors tag.  Then, for every subfolder
** we've seen, we need to output a listing for all the higher-level hierarchies
** with a \Noselect tag.  Therefore, we need to keep track of all the
** hierarchies we've seen so far.
*/

struct hierlist {
	struct hierlist *next;
	int flag;
	char *hier;
	} ;

static int add_hier(struct hierlist **h, const char *s)
{
struct hierlist *p;

	for (p= *h; p; p=p->next)
		if (strcmp(p->hier, s) == 0)	return (1);
			/* Seen this one already */

	if ((p=(struct hierlist *)
		malloc( sizeof(struct hierlist)+1+strlen(s))) == 0)
			/* HACK!!!! */
		write_error_exit(0);
	p->flag=0;
	p->hier=(char *)(p+1);
	strcpy(p->hier, s);
	p->next= *h;
	*h=p;
	return (0);
}

static struct hierlist *search_hier(struct hierlist *h, const char *s)
{
struct hierlist *p;

	for (p= h; p; p=p->next)
		if (strcmp(p->hier, s) == 0)	return (p);
	return (0);
}

static void folder_entry(char *folder, char *hier,
	int *found_hier, struct hierlist **folders,
	struct hierlist **hierarchies)
{
unsigned i;

	if (match_mailbox(folder, hier) == 0)
	{
		if (found_hier)
		{
			*found_hier=1;
			return;
		}
		(void) add_hier(folders, folder);
	}

	for (i=0; folder[i]; i++)
	{
		if (folder[i] != HIERCH)	continue;
		folder[i]=0;
		(void)add_hier(hierarchies, folder);
		folder[i]=HIERCH;
	}
}

struct list_sharable_info {
	char *hier;
	int *found_hier;
	struct hierlist **folders, **hierarchies;
	} ;

static void list_sharable(const char *n,
	void *voidp)
{
struct list_sharable_info *ip=(struct list_sharable_info *)voidp;
char	*p=malloc(strlen(n)+sizeof("shared."));

	if (!p)	write_error_exit(0);

	strcat(strcpy(p, "shared."), n);

	folder_entry(p, ip->hier, ip->found_hier,
		ip->folders, ip->hierarchies);

	free(p);
}

static void list_subscribed(char *hier,
	int *found_hier, struct hierlist **folders,
	struct hierlist **hierarchies)
{
char	buf[BUFSIZ];
FILE	*fp;

	fp=fopen(SUBSCRIBEFILE, "r");
	if (fp)
	{
		while (fgets(buf, sizeof(buf), fp) != 0)
		{
		char *q=strchr(buf, '\n');

			if (q)	*q=0;
			folder_entry(buf, hier, found_hier,
				folders, hierarchies);
		}
		fclose(fp);
	}
}

static void do_mailbox_list(const char *tag, char *qq, int isnullname,
	const char *cmd)
{
DIR	*dirp;
struct	dirent *de;
int	found_hier=0;
int	is_interesting;
int	i,j,bad_pattern;
struct	hierlist *hierarchies, *folders, *hp;
char	*namesp=0;
struct list_sharable_info shared_info;

const char *obsolete;
int check_all_folders=0;

int do_lsub=strcmp(cmd, "LIST") != 0;

	obsolete=getenv("IMAP_CHECK_ALL_FOLDERS");
	if (obsolete && atoi(obsolete))
		check_all_folders=1;

	obsolete=getenv("IMAP_OBSOLETE_CLIENT");

	if (obsolete && atoi(obsolete) == 0)
		obsolete=0;

	if (*qq == '#')
	{
	char	*p=qq;

		qq=strchr(qq, '.');
		if (!qq)	return;
		*qq=0;
		namesp=my_strdup(p);
		*qq='.';
		if ((qq=set_namespace_options(p)) == 0)
		{
			free(namesp);
			return;
		}
	}

	/* Allow up to ten wildcards */

	for (i=j=0; qq[i]; i++)
		if (qq[i] == '*' || qq[i] == '%')	++j;
	bad_pattern= j > 10;

	hierarchies=0;
	folders=0;
	/* Scan maildir, looking for .subdirectories */

	dirp=opendir(".");
	while (dirp && (de=readdir(dirp)) != 0)
	{
	char	*p;

		if (de->d_name[0] != '.' ||
			strcmp(de->d_name, "..") == 0)
			continue;

		if (do_lsub)
			continue;	/* Skip this whole thing for LSUBs */

		if ((p=malloc(strlen(de->d_name)+sizeof("INBOX."))) == 0)
					/* A bit too much, that's OK */
			write_error_exit(0);

		strcat(strcpy(p, de->d_name), "/cur");
		if (access(p, 0))
		{
			free(p);
			continue;
		}
		strcpy(p, "INBOX");

		if (strcmp(de->d_name, "."))
			strcat(p, de->d_name);

		if (bad_pattern)
		{
			free(p);
			continue;
		}

		folder_entry(p, qq, isnullname ? &found_hier:0,
			&folders, &hierarchies);
		free(p);
	}

	if (dirp)	closedir(dirp);

	shared_info.hier=qq;
	shared_info.found_hier=isnullname ? &found_hier:0;
	shared_info.folders= &folders;
	shared_info.hierarchies= &hierarchies;

	if (!do_lsub)
	{
		/* List sharable maildirs */

		maildir_list_sharable( NULL, &list_sharable, &shared_info );
	}
	else
	{
		list_subscribed(qq, isnullname ? &found_hier:0,
			&folders, &hierarchies);

		/* List shared folders */

		maildir_list_shared( NULL, &list_sharable, &shared_info );
	}

	while ((hp=folders) != 0)
	{
	struct hierlist *d;
	char	*sep;

		folders=hp->next;

		is_interesting= -1;

		if (strcmp(hp->hier, "INBOX") == 0 || check_all_folders)
			is_interesting=hasnewmsgs(hp->hier);

		writes("* ");
		writes(cmd);
		writes(" (");
		sep="";
		if (is_interesting == 0)
		{
			writes("\\Unmarked");
			sep=" ";
		}
		if (is_interesting > 0)
		{
			writes("\\Marked");
			sep=" ";
		}
		if ((flat_folders && strcmp(hp->hier, "INBOX")) ||
			(d=search_hier(hierarchies, hp->hier)) == 0)
		{
			writes(sep);

			if (obsolete)
				writes("\\Noinferiors");
			else
				writes("\\HasNoChildren");
		}
		else
		{
			d->flag=1;
			if (!obsolete)
			{
				writes(sep);
				writes("\\HasChildren");
			}
		}

		writes(") ");

		if (flat_folders && strchr(hp->hier, HIERCH))
			writes("NIL");
		else
		{
			writes("\"");
			writes(hierchs);
			writes("\"");
		}
		writes(" \"");
		if (namesp)
		{
			writeqs(namesp);
			writes(".");
		}
		writeqs(hp->hier);
		writes("\"\r\n");

		free(hp);
	}

	while ((hp=hierarchies) != 0)
	{
		hierarchies=hp->next;

		if (match_mailbox(hp->hier, qq) == 0 && hp->flag == 0
			&& !flat_folders)
		{
			if (isnullname)
				found_hier=1;
			else 
			{
				writes("* ");
				writes(cmd);

				if (obsolete)
				{
					writes(" (\\Noselect) ");
				}
				else
				{
					writes(" (\\Noselect \\HasChildren) ");
				}

				if (flat_folders && strchr(hp->hier, HIERCH))
					writes("NIL");
				else
				{
					writes("\"");
					writes(hierchs);
					writes("\"");
				}
				writes(" \"");
				if (namesp)
				{
					writeqs(namesp);
					writes(".");
				}
				writeqs(hp->hier);
				writes("\"\r\n");
			}
		}
		free(hp);
	}

	if (isnullname)
	{
		writes("* ");
		writes(cmd);
		writes(" (");
		if (!found_hier)
			writes("\\Noselect");
		writes(") ");

		if (flat_folders && strchr(qq, HIERCH))
			writes("NIL");
		else
		{
			writes("\"");
			writes(hierchs);
			writes("\"");
		}
		writes(" \"\"\r\n");
	}
	if (namesp)	free(namesp);
	return;
}

static int match_recursive(char *, char *, int);

static int match_mailbox(char *name, char *pattern)
{
size_t	i;

	/* First component, INBOX, is case insensitive */

	for (i=0; name[i] && name[i] != HIERCH; i++)
		name[i]=toupper( (int)(unsigned char)name[i] );

	for (i=0; pattern[i] && pattern[i] != HIERCH; i++)
		pattern[i]=toupper( (int)(unsigned char)pattern[i] );

	/* ... except that "shared" should be lowercase ... */

	if (memcmp(name, "SHARED", 6) == 0)
		memcpy(name, "shared", 6);

	if (memcmp(pattern, "SHARED", 6) == 0)
		memcpy(pattern, "shared", 6);

	return (match_recursive(name, pattern, HIERCH));
}

static int match_recursive(char *name, char *pattern, int hierch)
{
	for (;;)
	{
		if (*pattern == '*')
		{
			do
			{
				if (match_recursive(name, pattern+1,
					hierch) == 0)
					return (0);
				if (flat_folders && *name == hierch)
					hierch=0;
			} while (*name++);
			return (-1);
		}
		if (*pattern == '%')
		{
			do
			{
				if (match_recursive(name, pattern+1, hierch)
					== 0) return (0);
				if (*name == hierch)	break;
			} while (*name++);
			return (-1);
		}
		if (*name == 0 && *pattern == 0)	break;
		if (*name == 0 || *pattern == 0)	return (-1);
		if (*name != *pattern)	return (-1);
		if (flat_folders && *name == hierch)
			hierch=0;
		++name;
		++pattern;
	}
	return (0);
}
