#
#  Need to version-upgrade RH builds due to different directory locations.
#

%define courier_release %(release="`rpm -q --queryformat='.%{VERSION}' redhat-release 2>/dev/null`" ; echo "$release")
Summary: Courier-IMAP 1.3.8.2 IMAP server
Name: courier-imap
Version: 1.3.8.2
Release: 1%{courier_release}
Copyright: GPL
Group: Applications/Mail
Source: courier-imap-1.3.8.2.tar.gz
Packager: %{PACKAGER}
BuildRoot: /var/tmp/courier-imap-install
Requires: /sbin/chkconfig fileutils textutils sh-utils sed
BuildPreReq: textutils openssl-devel fileutils rpm >= 4.0.2 sed perl gdbm-devel

#  RH 7.0 resets sysconfdir & mandir, put them back where they belong

%define _sysconfdir %{_prefix}/etc
%define	_mandir %{_prefix}/man

%define	_prefix	/usr/lib/courier-imap

%define _localstatedir /var/run

%define initdir %(if test -d /etc/init.d/. ; then echo /etc/init.d ; else echo /etc/rc.d/init.d ; fi)

%define	authdaemondir	%{_localstatedir}/authdaemon.courier-imap

%description
Courier-IMAP is an IMAP server for Maildir mailboxes.  This package contains
the standalone version of the IMAP server that's included in the Courier
mail server package.  This package is a standalone version for use with
other mail servers.  Do not install this package if you intend to install the
full Courier mail server.  Install the Courier package instead.

%package ldap
Summary: Courier-IMAP LDAP authentication driver.
Group: Applications/Mail
Requires: courier-imap = 1.3.8.2

%description ldap
This package contains the necessary files to allow Courier-IMAP to
authenticate from an LDAP directory.  Install this package if you need
the ability to use an LDAP directory for authentication.

%package mysql
Summary: Courier-IMAP MySQL authentication driver.
Group: Applications/Mail
Requires: courier-imap = 1.3.8.2

%description mysql
This package contains the necessary files to allow Courier-IMAP to
authenticate using a MySQL database table.  Install this package if you need
the ability to use a MySQL database table for authentication.


%prep
%setup -q

%configure --localstatedir=%{_localstatedir} \
	--with-authdaemonvar=%{authdaemondir} \
	%{?xflags: %{xflags}}

%build
%{__make}
%{__make} check
%install

%{__rm} -rf $RPM_BUILD_ROOT
%{__mkdir_p} $RPM_BUILD_ROOT/etc/pam.d
%{__make} install-strip DESTDIR=$RPM_BUILD_ROOT

#
# Red Hat init.d file
#

%{__mkdir_p} $RPM_BUILD_ROOT%{initdir}
%{__cp} courier-imap.sysvinit $RPM_BUILD_ROOT%{initdir}/courier-imap

#
# Fix imapd.dist
#

%{__sed} 's/^IMAPDSTART=.*/IMAPDSTART=YES/' \
	<$RPM_BUILD_ROOT%{_sysconfdir}/imapd.dist \
	>$RPM_BUILD_ROOT%{_sysconfdir}/imapd.dist.tmp

%{__mv} $RPM_BUILD_ROOT%{_sysconfdir}/imapd.dist.tmp \
	$RPM_BUILD_ROOT%{_sysconfdir}/imapd.dist

%{__sed} 's/^IMAPDSSLSTART=.*/IMAPDSSLSTART=YES/' \
	<$RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.dist \
	>$RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.dist.tmp

%{__mv} $RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.dist.tmp \
	$RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.dist

%{__chmod} 600 $RPM_BUILD_ROOT%{_sysconfdir}/imapd.dist
%{__chmod} 600 $RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.dist

%{__sed} 's/^POP3DSTART=.*/POP3DSTART=YES/' \
	<$RPM_BUILD_ROOT%{_sysconfdir}/pop3d.dist \
	>$RPM_BUILD_ROOT%{_sysconfdir}/pop3d.dist.tmp

%{__mv} $RPM_BUILD_ROOT%{_sysconfdir}/pop3d.dist.tmp \
	$RPM_BUILD_ROOT%{_sysconfdir}/pop3d.dist

%{__sed} 's/^POP3DSSLSTART=.*/POP3DSSLSTART=YES/' \
	<$RPM_BUILD_ROOT%{_sysconfdir}/pop3d-ssl.dist \
	>$RPM_BUILD_ROOT%{_sysconfdir}/pop3d-ssl.dist.tmp

%{__mv} $RPM_BUILD_ROOT%{_sysconfdir}/pop3d-ssl.dist.tmp \
	$RPM_BUILD_ROOT%{_sysconfdir}/pop3d-ssl.dist

%{__chmod} 600 $RPM_BUILD_ROOT%{_sysconfdir}/pop3d.dist
%{__chmod} 600 $RPM_BUILD_ROOT%{_sysconfdir}/pop3d-ssl.dist

#
# Red Hat /etc/profile.d scripts
#

%{__mkdir_p} $RPM_BUILD_ROOT/etc/profile.d
%{__cat} >$RPM_BUILD_ROOT/etc/profile.d/courier-imap.sh <<EOF
if echo "\$MANPATH" | tr ':' '\012' | fgrep -qx %{_mandir}
then
	:
else
	MANPATH="%{_mandir}:\$MANPATH"
	export MANPATH
	PATH="%{_bindir}:\$PATH"
	if test -w /etc
	then
		PATH="%{_sbindir}:\$PATH"
	fi
	export PATH
fi
EOF

%{__cat} >$RPM_BUILD_ROOT/etc/profile.d/courier-imap.csh <<EOF

if ( \$?MANPATH ) then
	true
else
	setenv MANPATH ""
endif

echo "\$MANPATH" | tr ':' '\012' | fgrep -qx %{_mandir}

if ( \$? ) then
	true
else
	setenv MANPATH "%{_mandir}:\$MANPATH"
	setenv PATH "%{_bindir}:\$PATH"
	test -w /etc
	if ( \$? ) then
		true
	else
		setenv PATH "%{_sbindir}:\$PATH"
	endif
endif
EOF

#
# Compress everything in man
#

find $RPM_BUILD_ROOT%{_mandir} ! -type d -print | %{__perl} -e '

	while (<>)
	{
		chop if /\n$/;
		next if /\.gz$/;
		$file=$_;
		if ( -l $file)
		{
                        symlink readlink("$file")
                                . ".gz", "$file.gz";
			unlink($file);
                }
                else
                {
                        system("gzip <$file >$file.gz");
			unlink($file);
		}
	}
'

%{__cp} imap/README README.imap
%{__cp} maildir/README.maildirquota.txt README.maildirquota
%{__cp} maildir/README.sharedfolders.txt README.sharedfolders

####
## Create config files for sysconftool-rpmupgrade (see below)

%{__mkdir_p} $RPM_BUILD_ROOT%{_datadir}
%{__cp} sysconftool $RPM_BUILD_ROOT%{_datadir}/sysconftool
%{__chmod} 555 $RPM_BUILD_ROOT%{_datadir}/sysconftool
%{__cat} >$RPM_BUILD_ROOT%{_datadir}/configlist <<EOF
%{_sysconfdir}/imapd.dist
%{_sysconfdir}/imapd-ssl.dist
%{_sysconfdir}/pop3d.dist
%{_sysconfdir}/pop3d-ssl.dist
EOF

%{__cp} /dev/null $RPM_BUILD_ROOT%{_datadir}/configlist.ldap
%{__cp} /dev/null $RPM_BUILD_ROOT%{_datadir}/configlist.mysql

%{__chmod} 644 $RPM_BUILD_ROOT%{_datadir}/configlist*

######
##
## Ok, upgrades are going to get ugly.  Because we install $filename.dist
## instead of $filename, and the old package has $filename listed as a config,
## RPM will back up $filename to $filename.rpmsave.  This will happen AFTER
## we will run the post scripts, effectively blowing away our configurations.
## PUT THEM BACK BY RUNNING THE FOLLOWING SCRIPT FROM A TRIGGER.

%{__cat} >$RPM_BUILD_ROOT%{_datadir}/sysconftool-rpmupgrade <<EOF
#!/bin/sh

for f in \$* "."
do
	if test \$f = "."
	then
		continue
	fi

	base=\`echo \$f | sed 's/\\.dist\$//'\`
	if test -f \$base.dist -a ! -f \$base
	then
		%{__cp} -pr \$base.dist \$base
	fi
done
EOF

%{__chmod} 555 $RPM_BUILD_ROOT%{_datadir}/sysconftool-rpmupgrade

#
#  Check if authdaemond was installed, make sure to include authdaemon
#  directory
#

%{__cp} /dev/null authdaemon.files

. authlib/authdaemonrc

if test "$authdaemonvar" != ""
then
	echo "%{_sysconfdir}/authdaemonrc.dist" >>$RPM_BUILD_ROOT%{_datadir}/configlist
	echo "%{_sysconfdir}/authdaemonrc.dist" >>authdaemon.files
	echo '%dir %attr(700, root, root) ' $authdaemonvar >>authdaemon.files
	touch $RPM_BUILD_ROOT/$authdaemonvar/lock || exit 1
	touch $RPM_BUILD_ROOT/$authdaemonvar/pid || exit 1
	authlib/authmksock $RPM_BUILD_ROOT/$authdaemonvar/socket || exit 1
	%{__chmod} 777 $RPM_BUILD_ROOT/$authdaemonvar/socket || exit 1
	echo '%ghost %attr(600, root, root) ' $authdaemonvar/lock >>authdaemon.files
	echo '%ghost %attr(644, root, root) ' $authdaemonvar/pid >>authdaemon.files
	echo '%ghost %attr(-, root, root) ' $authdaemonvar/socket >>authdaemon.files
fi

(cd $RPM_BUILD_ROOT ; find .%{_libexecdir} -type f ! -name authdaemond.ldap ! -name authdaemond.mysql -print ) | cut -c2- >>authdaemon.files

%{__cp} /dev/null authdaemon.files.ldap
%{__cp} /dev/null authdaemon.files.mysql

test ! -f $RPM_BUILD_ROOT%{_libexecdir}/authlib/authdaemond.mysql ||
	echo %{_libexecdir}/authlib/authdaemond.mysql >>authdaemon.files.mysql

test ! -f $RPM_BUILD_ROOT%{_libexecdir}/authlib/authdaemond.ldap || \
	echo %{_libexecdir}/authlib/authdaemond.ldap >>authdaemon.files.ldap

if test -f $RPM_BUILD_ROOT%{_libexecdir}/authlib/authdaemond.mysql
then
	echo %{_sysconfdir}/authmysqlrc.dist >>$RPM_BUILD_ROOT%{_datadir}/configlist.mysql
	echo %{_sysconfdir}/authmysqlrc.dist >>authdaemon.files.mysql
fi

if test -f $RPM_BUILD_ROOT%{_libexecdir}/authlib/authdaemond.ldap
then
	echo %{_sysconfdir}/authldaprc.dist >>$RPM_BUILD_ROOT%{_datadir}/configlist.ldap
	echo %{_sysconfdir}/authldaprc.dist >>authdaemon.files.ldap
fi

%{__mkdir_p} $RPM_BUILD_ROOT%{_localstatedir}
touch $RPM_BUILD_ROOT%{_localstatedir}/imapd.pid
touch $RPM_BUILD_ROOT%{_localstatedir}/imapd-ssl.pid
touch $RPM_BUILD_ROOT%{_localstatedir}/imapd.pid.lock
touch $RPM_BUILD_ROOT%{_localstatedir}/imapd-ssl.pid.lock

touch $RPM_BUILD_ROOT%{_localstatedir}/pop3d.pid
touch $RPM_BUILD_ROOT%{_localstatedir}/pop3d-ssl.pid
touch $RPM_BUILD_ROOT%{_localstatedir}/pop3d.pid.lock
touch $RPM_BUILD_ROOT%{_localstatedir}/pop3d-ssl.pid.lock

%post
/sbin/chkconfig --del courier-imap
/sbin/chkconfig --add courier-imap
%{_datadir}/sysconftool `%{__cat} %{_datadir}/configlist` >/dev/null

%post ldap
%{_datadir}/sysconftool `%{__cat} %{_datadir}/configlist.ldap` >/dev/null

%post mysql
%{_datadir}/sysconftool `%{__cat} %{_datadir}/configlist.mysql` >/dev/null

%preun ldap
%{_libexecdir}/imapd.rc stop
%{_libexecdir}/imapd-ssl.rc stop
%{_libexecdir}/pop3d.rc stop
%{_libexecdir}/pop3d-ssl.rc stop

%preun mysql
%{_libexecdir}/imapd.rc stop
%{_libexecdir}/imapd-ssl.rc stop
%{_libexecdir}/pop3d.rc stop
%{_libexecdir}/pop3d-ssl.rc stop

%preun

if test "$1" = "0"
then
	/sbin/chkconfig --del courier-imap
fi

%{_libexecdir}/imapd.rc stop
%{_libexecdir}/imapd-ssl.rc stop
%{_libexecdir}/pop3d.rc stop
%{_libexecdir}/pop3d-ssl.rc stop

%triggerpostun -- courier-imap

test ! -f %{_datadir}/configlist || %{_datadir}/sysconftool-rpmupgrade `%{__cat} %{_datadir}/configlist` >/dev/null

%triggerpostun ldap -- courier-imap-ldap

test ! -f %{_datadir}/configlist.ldap || %{_datadir}/sysconftool-rpmupgrade `%{__cat} %{_datadir}/configlist.ldap` >/dev/null

%triggerpostun mysql -- courier-imap-mysql

test ! -f %{_datadir}/configlist.mysql || %{_datadir}/sysconftool-rpmupgrade `%{__cat} %{_datadir}/configlist.mysql` >/dev/null

%files -f authdaemon.files
%defattr(-, bin, bin)
%config /etc/pam.d/imap
%config /etc/pam.d/pop3

%attr(755, bin, bin) %config /etc/profile.d/courier-imap.csh
%attr(755, bin, bin) %config /etc/profile.d/courier-imap.sh
%attr(755, bin, bin) %{initdir}/courier-imap
%dir %{_prefix}

%if "%{_prefix}" != "%{_exec_prefix}"
%dir %{_exec_prefix}
%endif

%dir %{_libexecdir}
%dir %{_libexecdir}/authlib
%dir %{_sysconfdir}
%config %{_sysconfdir}/imap*
%config %{_sysconfdir}/pop3*
%config %{_sysconfdir}/quotawarnmsg.example
%{_bindir}
%{_sbindir}
%{_mandir}
%{_datadir}

%doc AUTHORS COPYING imap/BUGS README README.imap README.maildirquota
%doc imap/FAQ imap/FAQ.html README.sharedfolders authlib/README.*

%ghost %attr(600, root, root) %{_localstatedir}/imapd.pid
%ghost %attr(600, root, root) %{_localstatedir}/imapd-ssl.pid
%ghost %attr(600, root, root) %{_localstatedir}/imapd.pid.lock
%ghost %attr(600, root, root) %{_localstatedir}/imapd-ssl.pid.lock

%ghost %attr(600, root, root) %{_localstatedir}/pop3d.pid
%ghost %attr(600, root, root) %{_localstatedir}/pop3d-ssl.pid
%ghost %attr(600, root, root) %{_localstatedir}/pop3d.pid.lock
%ghost %attr(600, root, root) %{_localstatedir}/pop3d-ssl.pid.lock

%files ldap -f authdaemon.files.ldap

%files mysql -f authdaemon.files.mysql

%clean
rm -rf $RPM_BUILD_ROOT
