#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<unistd.h>
#include	<ctype.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<mysql/mysql.h>

#include	"authmysql.h"
#include	"authmysqlrc.h"


static const char *read_env(const char *env)
{
static char *mysqlauth=0;
static size_t mysqlauth_size=0;
size_t	i;
char	*p=0;
int	l=strlen(env);

	if (!mysqlauth)
	{
	FILE	*f=fopen(AUTHMYSQLRC, "r");
	struct	stat	buf;

		if (!f)	return (0);
		if (fstat(fileno(f), &buf) ||
			(mysqlauth=malloc(buf.st_size+2)) == 0)
		{
			fclose(f);
			return (0);
		}
		if (fread(mysqlauth, buf.st_size, 1, f) != 1)
		{
			free(mysqlauth);
			mysqlauth=0;
			fclose(f);
			return (0);
		}
		mysqlauth[mysqlauth_size=buf.st_size]=0;

		for (i=0; i<mysqlauth_size; i++)
			if (mysqlauth[i] == '\n')
				mysqlauth[i]=0;
		fclose(f);
	}

	for (i=0; i<mysqlauth_size; )
	{
		p=mysqlauth+i;
		if (memcmp(p, env, l) == 0 &&
			isspace((int)(unsigned char)p[l]))
		{
			p += l;
			while (*p && *p != '\n' &&
				isspace((int)(unsigned char)*p))
				++p;
			break;
		}

		while (i < mysqlauth_size)
			if (mysqlauth[i++] == 0)	break;
	}

	if (i < mysqlauth_size)
		return (p);
	return (0);
}

static MYSQL mysql_buf;

static MYSQL *mysql=0;

static int do_connect()
{
const	char *server;
const	char *userid;
const	char *password;
const	char *database;

	if (mysql)	return (0);

	server=read_env("MYSQL_SERVER");
	userid=read_env("MYSQL_USERNAME");
	password=read_env("MYSQL_PASSWORD");
	database=read_env("MYSQL_DATABASE");

	if (!server)
	{
		fprintf(stderr, "authmysql: MYSQL_SERVER not set in "
			AUTHMYSQLRC ".\n");
		return (-1);
	}

	if (!userid)
	{
		fprintf(stderr, "authmysql: MYSQL_USERNAME not set in "
			AUTHMYSQLRC ".\n");
		return (-1);
	}

	if (!database)
	{
		fprintf(stderr, "authmysql: MYSQL_DATABASE not set in "
			AUTHMYSQLRC ".\n");
		return (-1);
	}

	mysql=mysql_connect(&mysql_buf, server, userid, password);
	if (!mysql)	return (-1);

	if (mysql_select_db(mysql, database))
	{
		fprintf(stderr, "authmysql: mysql_select_db(%s) error: %s\n",
			database, mysql_error(mysql));
		mysql_close(mysql);
		mysql=0;
		return (-1);
	}
	return (0);
}

void auth_mysql_cleanup()
{
	if (mysql)
	{
		mysql_close(mysql);
		mysql=0;
	}
}

static struct authmysqluserinfo ui={0, 0, 0, 0, 0};

struct authmysqluserinfo *auth_mysql_getuserinfo(const char *username)
{
const char *user_table;
const char *defdomain;
char	*querybuf, *p;
MYSQL_ROW	row;
MYSQL_RES	*result;

const char *crypt_field, *clear_field, *maildir_field;

static const char query[]=
	"SELECT id, %s, %s, uid, gid, home, %s FROM %s WHERE id=\"";

	if (do_connect())	return (0);

	if (ui.username)
		free(ui.username);
	if (ui.cryptpw)
		free(ui.cryptpw);
	if (ui.clearpw)
		free(ui.clearpw);
	if (ui.home)
		free(ui.home);
	if (ui.maildir)
		free(ui.maildir);

	memset(&ui, 0, sizeof(ui));

	user_table=read_env("MYSQL_USER_TABLE");
	defdomain=read_env("DEFAULT_DOMAIN");

	if (!user_table)
	{
		fprintf(stderr, "authmysql: MYSQL_USER_TABLE not set in "
			AUTHMYSQLRC ".\n");
		return (0);
	}

	crypt_field=read_env("MYSQL_CRYPT_PWFIELD");
	clear_field=read_env("MYSQL_CLEAR_PWFIELD");

	if (!crypt_field && !clear_field)
	{
		fprintf(stderr,
			"authmysql: MYSQL_CRYPT_PWFIELD and "
			"MYSQL_CLEAR_PWFIELD not set in " AUTHMYSQLRC ".\n");
		return (0);
	}


	maildir_field=read_env("MYSQL_MAILDIR_FIELD");

	if (!crypt_field)	crypt_field="\"\"";
	if (!clear_field)	clear_field="\"\"";
	if (!maildir_field)	maildir_field="\"\"";

	if (!defdomain)	defdomain="";

	querybuf=malloc(sizeof(query)+100+strlen(user_table)+strlen(defdomain)
			+strlen(crypt_field)
			+strlen(clear_field)
			+strlen(maildir_field));
	if (!querybuf)
	{
		perror("malloc");
		return (0);
	}

	sprintf(querybuf, query, crypt_field, clear_field, maildir_field,
		user_table);
	p=querybuf+strlen(querybuf);
	for (strcpy(p, username); *p; p++)
		if (*p == '"')	*p=' ';	/* No funny business */
	if (strchr(username, '@') == 0 && *defdomain)
		strcat(strcpy(p, "@"), defdomain);
	strcat(p, "\"");

	if (mysql_query (mysql, querybuf))
	{
		free(querybuf);
		auth_mysql_cleanup();	/* Server went down, that's OK,
					** try again next time.
					*/
		return (0);
	}
	free(querybuf);

	result = mysql_store_result (mysql);       
	if (result)
	{
		if (mysql_num_rows(result))
		{
			row = mysql_fetch_row (result);
			ui.username=strdup(row[0]);
			ui.cryptpw=strdup(row[1]);
			ui.clearpw=strdup(row[2]);
			ui.uid=atol(row[3]);
			ui.gid=atol(row[4]);
			ui.home=strdup(row[5]);
			ui.maildir=strdup(row[6]);
			if (!ui.username || !ui.cryptpw ||
				!ui.home || !ui.maildir)
			{
				mysql_free_result(result);
				return (0);
			}

			if (!ui.cryptpw[0])
			{
				free(ui.cryptpw);
				ui.cryptpw=0;
			}

			if (!ui.clearpw[0])
			{
				free(ui.clearpw);
				ui.clearpw=0;
			}
		}
		mysql_free_result(result);
	}
	return (&ui);
}
