/*
** Copyright 1999 TiTaNiC.  
** GNU/GPL
*/

#if	HAVE_CONFIG_H
#include	"config.h"
#endif
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<errno.h>
#include	<pwd.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif

#include	"auth.h"
#include	"authmod.h"
#include	"authmysql.h"

static const char rcsid[]="$Id: authmysql.c,v 1.6 2000/04/30 01:04:09 mrsam Exp $";

char *auth_mysql(const char *service, const char *authtype, char *authdata,
	int issession,
	void (*callback_func)(struct authinfo *, void *), void *callback_arg)
{

char *user, *pass;

static auth_mysql_user *user_data=0;
static auth_mysql_config *config_data=0;

	if (strcmp(authtype, AUTHTYPE_LOGIN) ||
		(user=strtok(authdata, "\n")) == 0 ||
		(pass=strtok(0, "\n")) == 0)
	{
		errno=EPERM;
		return (0);
	}

        /* Init */

   if (config_data == 0)
   {
        if( (config_data = auth_mysql_init()) == NULL) {
	    errno = EPERM;
	    
	    return (0);
	}

	if (auth_mysql_connect(config_data))
	{
		free(config_data);
		errno=EPERM;
		return (0);
	}

	mysql_select_db(&auth_mysql_server, config_data->database);

	if(mysql_errno(&auth_mysql_server) != 0) {
		auth_mysql_disconnect(config_data);
		free(config_data);
		config_data=0;
		errno=EPERM;
#if AUTHMYSQL_DEBUG
                syslog(LOG_ERR,"Error during MySQL selectdb(): %s",mysql_error(&auth_mysql_server));
#endif
		return 0;
	}
   }

	/* Get the user from mysql */
        if( (user_data = auth_mysql_getuser(user, config_data)) == NULL) {

	    auth_mysql_disconnect(config_data);
	    free(config_data);
	    config_data=0;
	    errno=EPERM;

	    return (0);
	}

    if (callback_func == 0)
    {
	auth_mysql_disconnect(config_data);
	free(config_data);
	config_data=0;
    }
	if (user_data->crypt == 0 || authcheckpassword(pass,user_data->crypt))
	{
	int	fatal=0;

		if (user_data->crypt)
		{
			fatal=1;
		}
		errno=EPERM;
		if (fatal)	errno=EACCES;
		
		free(user_data);
		return (0);
	}
	
	if (callback_func == 0)
		authsuccess(user_data->mailbox, 0, &user_data->uid,
			&user_data->gid, user, "Virtual User");

	user=strdup(user);
	if (!user)
		perror("malloc");

	if (user && callback_func)
	{
	struct	authinfo	aa;

		memset(&aa, 0, sizeof(aa));

		/*aa.sysusername=user;*/
		aa.sysuserid= &user_data->uid;
		aa.sysgroupid= user_data->gid;
		aa.homedir=user_data->mailbox;
		aa.address=user;
		(*callback_func)(&aa, callback_arg);
	}

	free(user_data);
	return (user);
}
