/*  $Id: UserController.h,v 1.4 2007/06/19 23:26:46 sarrazip Exp $
    UserController.h - Keyboard-based game controller

    cosmosmash - A space rock shooting video game.
    Copyright (C) 2007 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

#ifndef _H_UserController
#define _H_UserController

#include "Controller.h"

#include <flatzebra/KeyState.h>

using namespace flatzebra;


class UserController : public Controller
{
public:
    UserController()
      : leftKS(SDLK_LEFT),
	rightKS(SDLK_RIGHT),
	startKS(SDLK_SPACE),
	hyperspaceKS(SDLK_DOWN),
	extendedKS(SDLK_e),
	pauseKS(SDLK_p),
	noshootKS(SDLK_LCTRL, SDLK_RCTRL)
    {
    }

    void processKey(SDLKey keysym, bool pressed)
    {
	leftKS.check(keysym, pressed);
	rightKS.check(keysym, pressed);
	hyperspaceKS.check(keysym, pressed);
	startKS.check(keysym, pressed);
	extendedKS.check(keysym, pressed);
	pauseKS.check(keysym, pressed);
	noshootKS.check(keysym, pressed);
    }

    /** Indicates if the player has just asked to start a game.
	Returns true if yes, and then 'isExtendedMode' indicates
	if the non-Intellivision extensions must be activated.
	Otherwise, returns false and 'isExtendedMode' is false.
    */
    virtual bool isStartRequested(bool &isExtendedMode)
    {
	bool ext = extendedKS.justPressed();
	bool start = (startKS.justPressed() || ext);
	isExtendedMode = start && ext;
	return start;
    }

    virtual bool isPauseRequested()
    {
	return pauseKS.justPressed();
    }

    virtual bool isResumeRequested()
    {
	return pauseKS.justPressed();
    }

    virtual bool isShootingActive()
    {
	return !noshootKS.isPressed();
    }

    virtual bool isHyperspaceRequested()
    {
	return hyperspaceKS.justPressed();
    }

    virtual bool isLeftMoveRequested()
    {
	return leftKS.isPressed();
    }

    virtual bool isRightMoveRequested()
    {
	return rightKS.isPressed();
    }

    /** Do any processing that needs to be done at the end of
	a tick.  In this case, we remember the state of some
	keys (pressed or not), so that justPressed() will work
	in the next tick.
    */
    virtual void endOfTick()
    {
	startKS.remember();
	hyperspaceKS.remember();
	extendedKS.remember();
	pauseKS.remember();
    }

private:
    KeyState leftKS;
    KeyState rightKS;
    KeyState startKS;
    KeyState hyperspaceKS;
    KeyState extendedKS;
    KeyState pauseKS;
    KeyState noshootKS;
};


#endif  /* _H_UserController */
