/*  $Id: Controller.h,v 1.3 2007/06/19 23:26:46 sarrazip Exp $
    Controller.h - Abstract game controller

    cosmosmash - A space rock shooting video game.
    Copyright (C) 2007 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

#ifndef _H_Controller
#define _H_Controller

#include <flatzebra/Couple.h>

#include <vector>


class Controller
{
public:

    Controller()
    {
    }

    virtual ~Controller()
    {
    }

    /** Indicates if the player has just asked to start a game.
	Returns true if yes, and then 'isExtendedMode' indicates
	if the non-Intellivision extensions must be activated.
	Otherwise, returns false and 'isExtendedMode' is false.
    */
    virtual bool isStartRequested(bool &isExtendedMode) = 0;

    virtual bool isPauseRequested() = 0;

    virtual bool isResumeRequested() = 0;

    virtual bool isShootingActive() = 0;

    virtual bool isHyperspaceRequested() = 0;

    virtual bool isLeftMoveRequested() = 0;

    virtual bool isRightMoveRequested() = 0;

    /** Do any processing that needs to be done at the end of a tick.
    */
    virtual void endOfTick() = 0;

};


#endif  /* _H_Controller */
