#ifndef _MAD_H
#define _MAD_H

#define SEGVNOW() {""[0] = '\0';}

#ifdef DEBUG_MALLOC
/* debug internal mallocs only */
#define DEBUG_MALLOC_EXCLUDE_EXTERNAL
/* #define DEBUG_MALLOC_EXCLUDE_EXTERNAL */
#endif

#ifdef DEBUG_MALLOC

#if !(defined(__linux__) && defined(__GNUC__))
#error You have defined DEBUG_MALLOC, but memory allocation debugging is only supported on Linux with gcc
#endif

#ifdef DEBUG_MALLOC_EXCLUDE_EXTERNAL

void mad_exit (int status);
char *mad_strdup (char *s);
void *mad_malloc (unsigned desiredsize);
void mad_free (void *p);
void *mad_realloc (void *old, unsigned desiredsize);
void *mad_calloc (unsigned num, unsigned size);

#define malloc mad_malloc
#define calloc mad_calloc
#define strdup mad_strdup
#define free mad_free
#define realloc mad_realloc
#define exit mad_exit

#endif
#endif

extern int option_debug_malloc;

#endif

