/************************************************************************/
/*	Copyright 1987-1994 by Chuck Musciano and Harris Corporation 	*/
/*									*/
/*	Full ownership of this software, and all rights pertaining to 	*/
/*	the for-profit distribution of this software, are retained by 	*/
/*	Chuck Musciano and Harris Corporation.  You are permitted to 	*/
/*	use this software without fee.  This software is provided "as 	*/
/*	is" without express or implied warranty.  You may redistribute 	*/
/*	this software, provided that this copyright notice is retained,	*/
/*	and that the software is not distributed for profit.  If you 	*/
/*	wish to use this software in a profit-making venture, you must 	*/
/*	first license this code and its underlying technology from 	*/
/*	Harris Corporation. 						*/
/*									*/
/*	Bottom line: you can have this software, you can use it, you 	*/
/*	can give it away.  You just can't sell any or all parts of it 	*/
/*	without prior permission from Harris Corporation. 		*/
/************************************************************************/

/************************************************************************/
/*									*/
/*	store.c		contool store dialog manager			*/
/*									*/
/************************************************************************/

#include	<stdio.h>
#include	<ctype.h>
#include	<unistd.h>

#include	<sys/file.h>

#include	<xview/xview.h>
#include	<xview/panel.h>
#include	<xview/notice.h>
#include	<xview/xv_xrect.h>

#include	"manifest.h"
#include	"contool.h"
#include	"contool_ui.h"

#define		yes_no(x)		((x)? "yes" : "no")

PUBLIC	contool_base_objects	*contool_base;

PRIVATE	contool_store_objects	*contool_store = NULL;

/************************************************************************/
EXPORT	Menu_item	popup_save_config(item, op)

Menu_item	item;
Menu_generate	op;

{	contool_base_objects * ip = (contool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	if (op == MENU_NOTIFY) {
	   if (contool_store == NULL) {
	      contool_store = contool_store_objects_initialize(NULL, ip->base);
	      xv_set(contool_store->store_file,
	      	        PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
	      	        PANEL_NOTIFY_STRING, "\n\r ",
	      	     NULL);
	      xv_set(contool_store->store_type, PANEL_VALUE, 3, NULL);
	      place_dialog(ip->base, contool_store->store);
	      }
	   xv_set(contool_store->store_file, PANEL_VALUE, filter_file, NULL);
	   xv_set(contool_store->store, XV_SHOW, TRUE, NULL);
	   }
	return item;
}

/************************************************************************/
EXPORT	int	store_filters_to_file(path, save_filters, save_props)

char		*path;
int		save_filters;
int		save_props;

{	char	buf[1024];
	int	answer;
	FILE	*f;
	Filter	*filt;

	if (access(path, W_OK) == 0) {
	   sprintf(buf, "File \"%s\" exists.  You can:", path);
	   answer = notice_prompt(contool_base->base, NULL,
	   			     NOTICE_MESSAGE_STRINGS, buf, NULL,
	   			     NOTICE_BUTTON_YES, "Overwrite",
	   			     NOTICE_BUTTON_NO, "Cancel",
	   			  NULL);
	   if (answer == 0)
	      return(FALSE);
	   }
	if ((f = fopen(path, "w")) == NULL) {
	   error("Cannot write to %s: %s", path, sys_errlist[errno]);
	   return(FALSE);
	   }
	fprintf(f, "version %d\n", FILTER_VERSION);
	if (save_props) {
	   fprintf(f, "defaults {\n");
	   fprintf(f, "   beep                 %d\n", defaults.beep);
	   fprintf(f, "   command              \"%s\"\n", check_escapes(is_null(defaults.command)));
	   fprintf(f, "   flash                %s\n", yes_no(defaults.flash));
	   fprintf(f, "   log                  %s\n", yes_no(defaults.log));
	   fprintf(f, "   open                 %s\n", yes_no(defaults.open));
	   fprintf(f, "   stamp                %s\n", yes_no(defaults.stamp));
	   fprintf(f, "   archive              %d\n", defaults.archive_style);
	   fprintf(f, "   good_icon            \"%s\"\n", is_null(defaults.good_icon));
	   fprintf(f, "   good_icon_mask       \"%s\"\n", is_null(defaults.good_icon_mask));
	   fprintf(f, "   check_icon           \"%s\"\n", is_null(defaults.bad_icon));
	   fprintf(f, "   check_icon_mask      \"%s\"\n", is_null(defaults.bad_icon_mask));
	   fprintf(f, "   flash_icon           \"%s\"\n", is_null(defaults.flash_icon));
	   fprintf(f, "   flash_icon_mask      \"%s\"\n", is_null(defaults.flash_icon_mask));
	   fprintf(f, "   print                \"%s\"\n", defaults.print_filter);
	   fprintf(f, "   log_file             \"%s\"\n", is_null(defaults.log_file));
	   fprintf(f, "   log_before_filtering %s\n", yes_no(!defaults.log_after));
	   fprintf(f, "   timestamp            %d\n", defaults.stamp_resolution);
	   fprintf(f, "   display              %d\n", defaults.max_size);
	   fprintf(f, "   delete               %d\n", defaults.delete_amount);
	   fprintf(f, "}\n");
	   }
	if (save_filters) {
	   fprintf(f, "filters {\n");
	   for (filt = filters; filt; filt = filt->next) {
	      fprintf(f, "   {\n");
	      fprintf(f, "      match   \"%s\"\n", check_escapes(filt->start));
	      if (filt->stop) {
	         fprintf(f, "      to      \"%s\"\n", check_escapes(filt->stop));
	         fprintf(f, "      timeout %d\n", filt->timeout);
	         }
	      if (filt->comment)
	         fprintf(f, "      comment \"%s\"\n", check_escapes(filt->comment));
	      if (filt->save) {
	         fprintf(f, "      ignore  no\n");
	         fprintf(f, "      beep    %d\n", filt->beep);
	         fprintf(f, "      command \"%s\"\n", check_escapes(is_null(filt->command)));
	         fprintf(f, "      flash   %s\n", yes_no(filt->flash));
	         fprintf(f, "      log     %s\n", yes_no(filt->log));
	         fprintf(f, "      open    %s\n", yes_no(filt->open));
	         fprintf(f, "      stamp   %s\n", yes_no(filt->stamp));
	         }
	      else
	         fprintf(f, "      ignore  yes\n");
	      fprintf(f, "   }\n");
	      }
	   fprintf(f, "}\n");
	   }
	fclose(f);
	return(TRUE);
}

/************************************************************************/
EXPORT	void	store_filters(item, event)

Panel_item	item;
Event		*event;

{	contool_store_objects	*ip = (contool_store_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char	*path;
	int	kind;

	path = expand_tilde(xv_get(ip->store_file, PANEL_VALUE));
	kind = (int) xv_get(ip->store_type, PANEL_VALUE);
	if (store_filters_to_file(path, kind & 2, kind & 1)) {
	   xv_set(item, PANEL_NOTIFY_STATUS, XV_OK, NULL);
	   filter_file = path;
	   }
	else {
	   free(path);
	   xv_set(item, PANEL_NOTIFY_STATUS, XV_ERROR, NULL);
	   }
}
